// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-

var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;
var Cm = Components.manager;

Cu.import("resource://gre/modules/Services.jsm");

var observerService = Cc["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
var resource = Services.io.getProtocolHandler("resource").QueryInterface(Ci.nsIResProtocolHandler);
var styleSheetService = Cc["@mozilla.org/content/style-sheet-service;1"].getService(Components.interfaces.nsIStyleSheetService);
var ios = Cc["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
var wm = Cc["@mozilla.org/appshell/window-mediator;1"].getService(Ci.nsIWindowMediator);

var observer = null;
var consoleService = Cc["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);

var windowListener = {
    onOpenWindow: function(aWindow) {
        if (!(aWindow.chromeFlags & Ci.nsIWebBrowserChrome.CHROME_PERSONAL_TOOLBAR)) {
            let domWindow = aWindow.QueryInterface(Ci.nsIInterfaceRequestor).getInterface(Ci.nsIDOMWindowInternal || Ci.nsIDOMWindow);
            domWindow.addEventListener("load", function() {
                domWindow.removeEventListener("load", arguments.callee, false);

                new UnityPrefs(domWindow);
            }, false);
        }
    },

    onCloseWindow: function(aWindow) {},
    onWindowTitleChange: function(aWindow, aTitle) {}
};

function startup(params, reason) {
try {
    var commandLineHandlerPath = params.installPath.clone();
    commandLineHandlerPath.append('content');
    commandLineHandlerPath.append('command-line-handler.manifest');

    Cm.addBootstrappedManifestLocation(params.installPath);

    var uri = ios.newURI("chrome://unity/skin/browser.css", null, null);
    styleSheetService.loadAndRegisterSheet(uri, styleSheetService.USER_SHEET);

    var path = params.installPath.clone();
    path.append('content');
    let alias = Services.io.newFileURI(path);

    resource.setSubstitution("unity", alias);

    var chromelessUrlpolicyPath = params.installPath.clone();
    chromelessUrlpolicyPath.append('content');
    chromelessUrlpolicyPath.append('chromeless-urlpolicy.manifest');
    Cm.QueryInterface(Ci.nsIComponentRegistrar).autoRegister(chromelessUrlpolicyPath);
    Cm.QueryInterface(Ci.nsIComponentRegistrar).autoRegister(commandLineHandlerPath);

    Cu.import("resource://unity/observer.js");

    observer = new Observer();

    observerService.addObserver(observer, 'content-document-global-created', false);

    Cu.import("resource://unity/prefs.js");
    Cu.import("resource://unity/chromeless.js");

    wm.addListener(windowListener);
} catch (x) {dump(x);}
}

function shutdown(params, reason) {
    Chromeless.deactivate();

    wm.removeListener(windowListener);

    Cu.unload("resource://unity/chromeless.js");
    Cu.unload("resource://unity/prefs.js");

    var manifest = params.installPath.clone();
    manifest.append('content');
    manifest.append('command-line-handler.manifest');

    observerService.removeObserver(observer, 'content-document-global-created');
    observer = null;

    Cu.unload("resource://unity/observer.js");

    Cm.QueryInterface(Ci.nsIComponentRegistrar).autoUnregister(manifest);

    var chromelessUrlpolicyPath = params.installPath.clone();
    chromelessUrlpolicyPath.append('content');
    chromelessUrlpolicyPath.append('chromeless-urlpolicy.manifest');
    Cm.QueryInterface(Ci.nsIComponentRegistrar).autoUnregister(chromelessUrlpolicyPath);

    resource.setSubstitution("unity", null);

    var uri = ios.newURI("chrome://unity/skin/browser.css", null, null);
    styleSheetService.unregisterSheet(uri, sss.USER_SHEET);
    Cm.removeBootstrappedManifestLocation(params.installPath);
}
