# -*- coding: utf-8 -*-
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Tests for the GUI of the Ubuntu One Installer."""

from gi.repository import Gtk
from twisted.internet.defer import inlineCallbacks
from ubuntuone.devtools.testcases.dbus import DBusTestCase
from ubuntuone.installer import gui


class GUITestCase(DBusTestCase):
    """Main class tests."""

    @inlineCallbacks
    def setUp(self):
        yield super(GUITestCase, self).setUp()
        gui.Gtk.main_quit = lambda: None
        gui.Gtk.main = lambda: None
        self.dlg = gui.Window()
        self.addCleanup(self.dlg.destroy)

    def test_response_cancel(self):
        """Test the response callback."""
        self.dlg.response(Gtk.ResponseType.CANCEL)

    def test_page_switched(self):
        """Test the page switching."""
        #self.assertEquals(self.dlg.active_page, 0)
        self.dlg.response(Gtk.ResponseType.OK)
        self.assertEquals(self.dlg.active_page, 1)

    def test_initial_page(self):
        """Test the initial info page."""
        self.assertEquals(self.dlg.active_page, 0)

    def test_progress_page(self):
        """Test the install progresss page."""
        self.dlg.response(Gtk.ResponseType.OK)
        self.assertEquals(self.dlg.active_page, 1)
