#!/usr/bin/python
#
# Copyright 2010-2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# In addition, as a special exception, the copyright holders give
# permission to link the code of portions of this program with the
# OpenSSL library under certain conditions as described in each
# individual source file, and distribute linked combinations
# including the two.
# You must obey the GNU General Public License in all respects
# for all of the code used other than OpenSSL.  If you modify
# file(s) with this exception, you may extend this exception to your
# version of the file(s), but you are not obligated to do so.  If you
# do not wish to do so, delete this exception statement from your
# version.  If you delete this exception statement from all source
# files in the program, then also delete it here.
"""setup.py"""

import os
import subprocess
import sys

from distutils.core import setup, Command
from dirspec import basedir

PACKAGE = 'ubuntuone-dev-tools'
VERSION = '4.1.91'

U1LINT = 'bin/u1lint'


class Lint(Command):
    """Command to run the lint checks."""
    description = 'run python lint checks'

    user_options = []

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        """Run u1lint to check the code."""
        retcode = subprocess.call([U1LINT])
        if retcode != 0:
            sys.exit(retcode)

# pylint: disable=C0103
scripts = ['bin/u1lint',
           'bin/u1trial']
# pylint: enable=C0103

if sys.platform == 'win32':
    # lets add the .bat so that windows users are happy
    scripts.extend(['bin/u1lint.bat', 'bin/u1trial.bat'])
    DATA_FILES = [(os.path.join(basedir.default_data_path, PACKAGE),
                  ['pylintrc',
                   'data/dbus-session.conf.in',
                   'data/squid.conf.in']),
                  ]
else:
    DATA_FILES = [('share/%s' % PACKAGE,
                  ['pylintrc',
                   'data/dbus-session.conf.in',
                   'data/squid.conf.in']),
                  ('share/man/man1',
                   ['man/u1lint.1',
                    'man/u1trial.1']),
                  ]

setup(name=PACKAGE,
      version=VERSION,
      description='Ubuntu One development tools and utilities',
      url='http://launchpad.net/ubuntuone-dev-tools',
      packages=['ubuntuone',
                'ubuntuone.devtools',
                'ubuntuone.devtools.reactors',
                'ubuntuone.devtools.runners',
                'ubuntuone.devtools.services',
                'ubuntuone.devtools.testing',
                'ubuntuone.devtools.testcases'],
      extra_path='ubuntuone-dev-tools',
      scripts=scripts,
      data_files=DATA_FILES,
      cmdclass={'lint': Lint,
                },
      )
