# -*- coding: utf-8 -*-
#
# Copyright 2011-2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tests for the Qt UI."""

from PyQt4 import QtGui

from ubuntuone.controlpanel.gui.qt.tests import BaseTestCase
from ubuntuone.controlpanel.gui.qt.side_widget import SideWidget


class SideWidgetTestCase(BaseTestCase):

    """Test the qt main window."""

    class_ui = SideWidget

    def test_stage_0(self):
        """Check that each stage in the widget enables the right labels."""
        self.ui.stage = 0
        self.assertTrue(self.ui.ui.install_icon.isEnabled())
        self.assertFalse(self.ui.ui.signin_icon.isEnabled())
        self.assertFalse(self.ui.ui.folders_icon.isEnabled())
        self.assertFalse(self.ui.ui.sync_icon.isEnabled())
        self.check_state_pixmap()

    def test_stage_1(self):
        """Check that each stage in the widget enables the right labels."""
        self.ui.stage = 1
        self.assertTrue(self.ui.ui.install_icon.isEnabled())
        self.assertTrue(self.ui.ui.signin_icon.isEnabled())
        self.assertFalse(self.ui.ui.folders_icon.isEnabled())
        self.assertFalse(self.ui.ui.sync_icon.isEnabled())
        self.check_state_pixmap()

    def test_stage_2(self):
        """Check that each stage in the widget enables the right labels."""
        self.ui.stage = 2
        self.assertTrue(self.ui.ui.install_icon.isEnabled())
        self.assertTrue(self.ui.ui.signin_icon.isEnabled())
        self.assertTrue(self.ui.ui.folders_icon.isEnabled())
        self.assertFalse(self.ui.ui.sync_icon.isEnabled())
        self.check_state_pixmap()

    def test_stage_3(self):
        """Check that each stage in the widget enables the right labels."""
        self.ui.stage = 3
        self.assertTrue(self.ui.ui.install_icon.isEnabled())
        self.assertTrue(self.ui.ui.signin_icon.isEnabled())
        self.assertTrue(self.ui.ui.folders_icon.isEnabled())
        self.assertTrue(self.ui.ui.sync_icon.isEnabled())
        self.check_state_pixmap()

    def check_state_pixmap(self):
        """Check if each label has the proper pixmap depending on the state."""
        stage = self.ui.stage

        active_pixmap = QtGui.QPixmap(":/progress_arrow_orange.png")
        no_active_pixmap = QtGui.QPixmap(":/progress_arrow_grey.png")
        complete_pixmap = QtGui.QPixmap(":/progress_tick.png")
        sync_active_pixmap = QtGui.QPixmap(":/progress_finish_orange.png")
        sync_no_active_pixmap = QtGui.QPixmap(":/progress_finish_grey.png")

        labels = (self.ui.ui.install_icon, self.ui.ui.signin_icon,
                  self.ui.ui.folders_icon, self.ui.ui.sync_icon)
        for item in labels[:stage]:
            self.assertEqualPixmaps(complete_pixmap, item.pixmap())

        if stage != 3:
            self.assertEqualPixmaps(active_pixmap, labels[stage].pixmap())
        else:
            self.assertEqualPixmaps(sync_active_pixmap, labels[3].pixmap())

        if stage < 3:
            for item in labels[stage + 1:len(labels) - 1]:
                self.assertEqualPixmaps(no_active_pixmap, item.pixmap())
            self.assertEqualPixmaps(sync_no_active_pixmap, labels[3].pixmap())
