# -*- coding: utf-8 -*-

# Authors: Manuel de la Pena <manuel@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Reactor installation for windows."""

import sys

from PyQt4 import Qt, QtGui, QtCore

# Module used to include the resources into this file
# pylint: disable=W0611
from ubuntuone.controlpanel.gui.qt.ui import images_rc
# pylint: enable=W0611


def main(switch_to='', alert=False, minimized=False, with_icon=False):
    """Start the Qt reactor and open the main window."""

    # The following cannot be imported outside this function
    # because u1trial already provides a reactor.
    # pylint: disable=F0401, W0404
    import qtreactor.qt4reactor
    qtreactor.qt4reactor.install()
    from twisted.internet import reactor
    from ubuntuone.controlpanel.gui.qt.gui import start

    # The main loop MUST be initialized before importing the reactor
    # pylint: disable=W0612
    app = Qt.QApplication(sys.argv)
    # Apply font to the entire application
    QtGui.QFontDatabase.addApplicationFont(':/Ubuntu-R.ttf')
    QtGui.QFontDatabase.addApplicationFont(':/Ubuntu-B.ttf')
    # Apply Style Sheet
    qss_file = QtCore.QFile(":/ubuntuone.qss")
    qss_file.open(QtCore.QFile.ReadOnly)
    stylesheet = QtCore.QLatin1String(qss_file.readAll())
    app.setStyleSheet(stylesheet)

    icon, window = start(reactor.stop,
        minimized=minimized, with_icon=with_icon)
    # pylint: disable=E1101
    reactor.run()
