# -*- coding: utf-8 -*-

# Authors: Alejandro J. Cura <alecu@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""The user interface for the control panel for Ubuntu One."""


from PyQt4 import QtGui

from ubuntuone.controlpanel.gui.qt.systray import TrayIcon
from ubuntuone.controlpanel.gui.qt.ui import mainwindow_ui


class MainWindow(QtGui.QMainWindow):
    """The Main Window of the Control Panel."""

    def __init__(self, close_callback=None):
        """Initialize this instance with the UI layout."""
        super(MainWindow, self).__init__()
        self.ui = mainwindow_ui.Ui_MainWindow()
        self.ui.setupUi(self)
        self.close_callback = close_callback
        self._setup()

    def _setup(self):
        """Do some extra setupping for the UI."""
        self.ui.control_panel.ui.signin.signinCanceled.connect(self.close)

    # Invalid name "closeEvent"
    # pylint: disable=C0103

    def closeEvent(self, event):
        """The main window is being closed, call any custom callback."""
        if self.close_callback is not None:
            self.close_callback()
        event.accept()

    # pylint: enable=C0103


def start(stop, minimized=False, with_icon=False):
    """Show the UI elements."""
    # pylint: disable=W0404, F0401
    if not minimized:
        if with_icon or minimized:
            window = MainWindow()
        else:
            window = MainWindow(close_callback=stop)
        window.show()
    else:
        window = None
    if with_icon or minimized:
        QtGui.QApplication.instance().setQuitOnLastWindowClosed(False)
        icon = TrayIcon(window=window)
    else:
        icon = None
    return icon, window
