/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010-2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 *
 */

#ifndef __SYNCDAEMON_FILE_INFO_H__
#define __SYNCDAEMON_FILE_INFO_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_FILE_INFO                (syncdaemon_file_info_get_type ())
#define SYNCDAEMON_FILE_INFO(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_FILE_INFO, SyncdaemonFileInfo))
#define SYNCDAEMON_IS_FILE_INFO(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_FILE_INFO))
#define SYNCDAEMON_FILE_INFO_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_FILE_INFO, SyncdaemonFileInfoClass))
#define SYNCDAEMON_IS_FILE_INFO_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_FILE_INFO))
#define SYNCDAEMON_FILE_INFO_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_FILE_INFO, SyncdaemonFileInfoClass))

typedef struct _SyncdaemonFileInfoPrivate SyncdaemonFileInfoPrivate;

typedef struct {
	GObject parent;
	SyncdaemonFileInfoPrivate *priv;
} SyncdaemonFileInfo;

typedef struct {
	GObjectClass parent_class;
} SyncdaemonFileInfoClass;

GType               syncdaemon_file_info_get_type (void);
SyncdaemonFileInfo *syncdaemon_file_info_new (void);
SyncdaemonFileInfo *syncdaemon_file_info_new_from_hash_table (GHashTable *hash);

const gchar        *syncdaemon_file_info_get_volume_id (SyncdaemonFileInfo *finfo);
void                syncdaemon_file_info_set_volume_id (SyncdaemonFileInfo *finfo, const gchar *volume_id);
const gchar        *syncdaemon_file_info_get_node_id (SyncdaemonFileInfo *finfo);
void                syncdaemon_file_info_set_node_id (SyncdaemonFileInfo *finfo, const gchar *node_id);
const gchar        *syncdaemon_file_info_get_path (SyncdaemonFileInfo *finfo);
void                syncdaemon_file_info_set_path (SyncdaemonFileInfo *finfo, const gchar *path);

gboolean            syncdaemon_file_info_get_is_public (SyncdaemonFileInfo *finfo);
void                syncdaemon_file_info_set_is_public (SyncdaemonFileInfo *finfo, gboolean is_public);
const gchar        *syncdaemon_file_info_get_public_url (SyncdaemonFileInfo *finfo);
void                syncdaemon_file_info_set_public_url (SyncdaemonFileInfo *finfo, const gchar *public_url);

G_END_DECLS

#endif
