#!/usr/bin/python

import sys
import fontforge

def class2pair(data, font):
    """Looks for any kerning classes in the font and converts it to kerning pairs"""
    kern_pairs = 0
    kern_class = 0
    for lookup in font.gpos_lookups:
        if font.getLookupInfo(lookup)[0] == "gpos_pair":
            for subtable in font.getLookupSubtables(lookup):
                if font.isKerningClass(subtable):
                    kern_class += 1
                    font.addLookupSubtable(lookup, subtable+" pairs")
                    kclass   = font.getKerningClass(subtable)
                    klasses1 = kclass[0]
                    klasses2 = kclass[1]
                    offsets  = kclass[2]

                    for klass1 in klasses1:
                        if klass1 != None:
                            for name in klass1:
                                glyph = font.createChar(-1, name)
                                for klass2 in klasses2:
                                    if klass2 != None:
                                        kern = offsets[klasses1.index(klass1)*len(klasses2)+klasses2.index(klass2)]
                                        for glyph2 in klass2:
                                            glyph.addPosSub(subtable+" pairs",glyph2,kern,0,kern,0,0,0,0,0)
					    font.changed = True
                                            kern_pairs  += 1
                    font.removeLookupSubtable(subtable)
    if kern_class == 0:
        fontforge.postNotice("No kern classes", "No kerning classes found")
    else:
        fontforge.postNotice("Kern classes converted", "%s kern classes found\n%s kern pairs generated" %(kern_class, kern_pairs))

def main(infile, outfile):
	font = fontforge.open(infile)
	class2pair(None,font)
	font.generate(outfile)

if fontforge.hasUserInterface():
    fontforge.registerMenuItem(class2pair,None,None,"Font",None,"Convert Kern classes to pairs")
elif __name__ == '__main__':
    if len(sys.argv) < 3:
        sys.exit("Usage: %s file.sfd file.ttf" % sys.argv[0])
    main(sys.argv[1], sys.argv[2])
