.TH TEXDOCTK 1
.SH NAME
texdoctk \- GUI for easier access of TeX package and program documentations
.SH SYNOPSIS
.B texdoctk
-[aq]
.SH "DESCRIPTION"
.B texdoctk
is a GUI for easier access to a large part of the vast amount
of package and program documentations and tutorials for TeX and its
different derivates (mainly LaTeX). It is optimized and included in
the teTeX and fpTeX distributions and also available with TeXLive.
.PP
The documentation is grouped into 17 categories; the 18th button of the main
panel is inactive by default and intended for use with local additions (see
section
.B CONFIGURATION
below).
.PP
In the settings window you see a checkbox in the html->ps and text->ps
converter menus for switching on/off output redirect. This is due to the fact
that some converters do not write their output into a file but to stdout by
default, so a redirect is needed, e.g.
.PP
a2ps myfile.txt >myfile.ps
.SH "OPTIONS"
.TP
.I "\-v"
verbose: enable some viewer messages which are otherwise sent to stderr,
as well as some warning popup windows. This can also be set in a
configuration file.
.TP
.I "\-a"
autoview: autostart viewer if a listbox contains only one item (this will
frequently happen in search results). This can also be set in a configuration
file.
.SH "CONFIGURATION"
.PP
The configuration is controlled by the system default concfiguration file
($TEXMFMAIN)/texdoctk/texdocrc.defaults, most of whose entries can though be
overridden by the users' own optional ~/.texdocrc files and/or command line
options.
.SS The Settings menu and configuration files
.PP
The Settings menu is used to change the user-definable settings of \fBtexdoctk\fP
for the duration of the programm call or as new defaults. The latter case is
the purpose of the Save button, which generates or rewrites the user's own
~/.texdocrc file. The system defaults cannot be edited with the Settings
menu.
.TP
Paths
The TEXMF-type paths on the system are reported, and the user can specify the
name of the subdirectory of $HOMETEXMF, where the personal documentation is
stored.
.TP
General viewer behaviour

.I Suppress error messages
toggle verbose mode (see option -v); default is off.

.I Autostart viewer for one-item listboxes
if a listbox contains only one item (see option -a)

.I Use text viewer for unknown file format
i.e. treat the file as plain text. \fBtexdoctk\fP should recognize the usual file
formats and also relate names like README to plain text, but some docs may have
freely invented names. Default is on; if switched off, trying to view such
files will raise an error. The switch does not influence printing: unrecognized
formats cannot be printed.

.I Change viewer colours
using either RGB triplets in the format #rrggbb or the standardized names.
.TP
DVI/PostScript/PDF/HTML/Plain text
For text files, \fBtexdoctk\fP provides an own viewer. If this viewer is disabled,
but no alternative viewer is specified, \fBtexdoctk\fP tries to read the content
of the environment variable $PAGER.

If you want to print the documentations, you will need converters to turn
non-PS files into PostScript. Here are some suggestions:

\& dvi->ps:
dvips (is part of teTeX) (http://www.radicaleye.com/dvips.html)

\& pdf->ps:
pdf2ps (http://www.cs.wisc.edu/~ghost) or
Acrobat Reader (http://www.adobe.com)

\& html->ps: html2ps (http://user.it.uu.se/~jan/html2ps.html)

\& plain text->ps: a2ps (http://www-inf.enst.fr/~demaille/a2ps/)

The html->ps and text->ps converter menus for switching on/off output redirect.
This is due to the fact that some converters do not write their output into a
file but to stdout by default, so a redirect is needed, e.g.
.B a2ps myfile.txt >myfile.ps
.PP
The system-wide configuration file is ($TEXMFMAIN)/texdoctk/texdocrc.defaults
and should only be writeable by the administrator of the installation using any
text editor. The optional user configuration file is ~/.texdocrc and can
override all but those system settings which affect the installation as a
whole. The preferred way of changing it is through the Settings menu.
.SS The databases
\fBtexdoctk\fP comes with a default database file ($TEXMFMAIN)/texdoctk/texdoctk.dat
with a special format. It is divided into 17 sections corresponding to the
17 buttons that are active by default. Each section begins with a line

@\fIsection_name\fP

where 
.I section_name
is the text as it appears in the button. This title is
followed by the descriptive entries for each documentation, which have this
format:

\fIpackage-label\fP;Short description for listbox (opt. \fIpackage-name\fP);path in doc directory;optional keywords

(without breaking the line!). Comments (initiated with a #) and empty lines
are ignored by the program. The second field is the text displayed in the
selection listboxes of \fBtexdoctk\fP, and you will usually want to mention the name
of the package in parens along with it; the first field is a \fBunique\fP label
for the package for internal use of the program which will usually be chosen
identical to the package name, but can be different if there is more than one
documentation file coming with a package.
.PP
The administrator will probably install additional packages in the local texmf
tree. The corresponding documentation can be made accessible by an additional
database $TEXMFLOCAL/texdoctk/texdoctk-local.dat. Furthermore, individual
users possibly install additional packages in an texmf subdirectory of their
$HOME, for which they can make an individual database themselves as
$TEXMFHOME/texdoctk/texdoctk-pers.dat. After creating such files, texhash
must be executed.
.PP
Both types of databases must have the same structure as the system database,
although they need (and should) not include all its sections if there are no
additional entries. For example, if the the package
.I foo
is added to the local tree such that its documentation file is
($TEXMFLOCAL)/doc/latex/foo/foo.dvi and it is decided that it fits best into
the existing category Graphics, texdoctk-local.dat would look like this:

@Graphics
.br
foo;Create bells and whistles (foo);latex/foo/foo.dvi;decoration

The entry for
.I foo
will then be appended to the list of entries in the Graphics category. The 18th
button can be activated in the same way, but using a new category name;
possible entries at the beginning of the database which have not been assigned
to a category will be assigned to the default Miscellaneous, making the 18th
button active with that label. Note that you cannot have more than 18
categories; if there are more, only the one defined last will appear and be
used.
.PP
If the documentation is included in the .sty file instead of a proper
documentation file, the optional keywords should start with
-?- directly after the semicolon, where ? is 0, 1, 2 or 3; these are flags
which indicate in which part of the .sty the instructions are placed and
should help \fBtexdoctk\fP to extract the documentation from the style and present
it without the code, which would normally be of little use.
.TP
0
no specific place, scattered between the code
.TP
1
at end, behind \\endinput; some .sty files have well-organized documentation
behind the end of the actual code, where TeX doesn't see it upon compilation
.TP
2
at beginning, terminated by %%%%%%; in some other cases, some usage information
is at the beginning of the .sty as a comment terminated by a line full of %
.TP
3
as 2, but with a blank line as termination
.PP
See the system database for plenty of examples.

.SH "FILES"
.PP
\& $TEXMFMAIN/texdoctk/texdocrc.defaults
system-wide configuration file
.PP
\& ~/.texdocrc
(optional) personal configuration file; can also be created with the Settings menu
.PP
\& $TEXMFMAIN/texdoctk/texdoctk.dat
default database file for documentation files of the distribution
.PP
\& $TEXMFLOCAL/texdoctk/texdoctk-local.dat
(optional) local database file for documentation files
.PP
\& $TEXMFHOME/texdoctk/texdoctk-pers.dat
(optional) personal database file of individual users for documentation files
.SH BUGS
Widget placement in topic toplevels becomes ugly when the toplevel is stretched
or shrunk.
.PP
The font in the frame labels of the Settings menu are not forced to the default
font; this will become visible e.g. at hi-res screens, where the label font is
not scaled up.
.PP
Netscape and Mozilla error output will be written to stderr even if the quiet
mode was set.
.SH AUTHOR
.B texdoctk
was written by Thomas Ruedas <tr@geol.ku.dk>.
.PP
This manual page was originally written by Adrian Bunk <bunk@fs.tum.de> for
the Debian GNU/Linux system (but may be used by others). It is now maintained
by Thomas Ruedas.

.SH COPYRIGHT
Copyright (C) 2000-2004 Thomas Ruedas
.br
This is free software; see the source for copying conditions. There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
