#ifndef TAGIDX_OPTIONS_H
#define TAGIDX_OPTIONS_H

/*
 * Commandline parser for tagcoll
 *
 * Copyright (C) 2003,2004,2005,2006  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <wibble/commandline/parser.h>

namespace wibble {
namespace commandline {

struct TagidxParser : public StandardParserWithMandatoryCommand
{
public:
	// Index
	ExistingFileOption* idx_index;

	// Output
	BoolOption* out_group;
	BoolOption* out_quiet;

	// Misc
	BoolOption* misc_force;

	// Commands
	Engine* cmd_create;
	Engine* cmd_remove;
	Engine* cmd_addpatch;
	Engine* cmd_compact;
	Engine* cmd_cat;

protected:
	OptionGroup* indexOptions()
	{
		OptionGroup* group = createGroup("Options used to identify the index");
		idx_index = group->add<ExistingFileOption>("index", 'I', "index", "<dir>",
					"directory where the index files are stored");
		return group;
	}

	OptionGroup* outputOptions()
	{
		OptionGroup* group = createGroup("Options controlling transformations of output data");
		out_group = group->add<BoolOption>("group", 'g', "group", "",
					"group items with the same tagset in the output collection");
		out_group->addAlias("group-items");
		out_quiet = group->add<BoolOption>("quiet", 'q', "quiet", "",
					"produce no output");
		return group;
	}

public:
	TagidxParser()
		: StandardParserWithMandatoryCommand("tagidx", VERSION, 1, "enrico@enricozini.org")
	{
		usage = "<command> [options and arguments]";
		description = "Access an indexed tagged collection";
	
		OptionGroup* indexOpts = indexOptions();
		OptionGroup* outputOpts = outputOptions();

		// 'create' command
		cmd_create = addEngine("create", "[files...]",
					"create the index from a tagged collection");
		cmd_create->add(indexOpts);

		// 'remove' command
		cmd_remove = addEngine("remove", "",
					"deletes the disk index");
		cmd_remove->add(indexOpts);

		// 'addpatch' command
		cmd_addpatch = addEngine("addpatch", "[files...]",
					"installs the given files as patches to the collection");
		misc_force = cmd_addpatch->add<BoolOption>("force", 'f', "force", "",
					"force overwrite");
		cmd_addpatch->add(indexOpts);

		// 'compact' command
		cmd_compact = addEngine("compact", "",
				"merge the patches into the index (can cause "
				"race conditions if invoked concurrently with other "
				"tagidx accessing the same index)");
		cmd_compact->add(indexOpts);

		// 'cat' command
		cmd_cat = addEngine("cat", "", "output the collection");
		cmd_cat->add(indexOpts);
		cmd_cat->add(outputOpts);
	}
};

}
}

// vim:set ts=4 sw=4:
#endif
