/*
 * Fast index for tag data, based on integer indexes
 *
 * Copyright (C) 2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <tests/test-utils.h>
#include <tagcoll/diskindex/string.h>

namespace tut {
using namespace std;
using namespace tagcoll::tests;
using namespace tagcoll::diskindex;

static const char* fname = "tagcoll_stringindex.tmp";

struct tagcoll_diskindex_string_shar {
	tagcoll_diskindex_string_shar() {
		// Create the index
		MasterMMapIndexer master(fname);

		StringIndexer indexer;
		indexer.map("pizza");
		indexer.map("spaghetti");
		indexer.map("tortellini");
		indexer.map("lasagne");
		indexer.map("polpettone");
		indexer.map("friggione");
		indexer.map("arrosto");
		indexer.map("pizza");
		indexer.map("lasagne");
		master.append(indexer);
		master.commit();
	}
	~tagcoll_diskindex_string_shar() {
		// Delete the test index
		unlink(fname);
	}
};
TESTGRP(tagcoll_diskindex_string);

template<> template<>
void to::test<1>()
{
	MasterMMap master(fname);

	// Read the index
	String index(master, 0);

	// Check the number of mapped items
	ensure_equals(index.size(), 7u);

	// Check that the arrays have the right size
	ensure_equals(string(index.data(0)), string("arrosto"));
	ensure_equals(string(index.data(1)), string("friggione"));
	ensure_equals(string(index.data(2)), string("lasagne"));
	ensure_equals(string(index.data(3)), string("pizza"));
	ensure_equals(string(index.data(4)), string("polpettone"));
	ensure_equals(string(index.data(5)), string("spaghetti"));
	ensure_equals(string(index.data(6)), string("tortellini"));

	// Check that the arrays are sorted and contain the right data
	ensure_equals(index.data("arrosto"),    0);
	ensure_equals(index.data("friggione"),  1);
	ensure_equals(index.data("lasagne"),    2);
	ensure_equals(index.data("pizza"),      3);
	ensure_equals(index.data("polpettone"), 4);
	ensure_equals(index.data("spaghetti"),  5);
	ensure_equals(index.data("tortellini"), 6);
}

}

// vim:set ts=4 sw=4:
