# This data is based on Suomi-malaga 0.7 by Hannu Väisänen, and includes
# modifications from Harri Pitkänen, Teemu Likonen and others.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

# Seikkasanat.

# Jatko-kentässä sallittuja ovat ainoastaan seuraavat: <loppu>, <liitesana>,
# <omistusliite> ja sijapäätteet (sekä <sivumpana>). Huomaa, että
# sijapäätteiden (esim. sisäolento_ssA) jälkeen hyväksytään automaattisesti
# myös omistusliite tai liitepartikkeli. Tästä syystä sijapäätteet sopivat
# vain sanoille, joita voi käyttää substantiivien tavoin.
#
# Seikkasanojen perusmuodot:
#
# Jos sanalla on useampi kuin yksi taivutusmuoto (esim. "vieraisilla,
# vieraisille, vieraisilta"), perusmuodoksi laitetaan joko ulko_olento_llA
# (jos se on olemassa) tai sisäolento_ssA. Omistusliitteen perusmuoto on
# kolmannen persoonan -Vn.
#
# Substantiiveista johdetuille sti-päätteisille seikkasanoille asetetaan
# perusmuodoksi nominatiivi/nimentö (esim. "hitosti", perusmuoto: "hitto").
# Adjektiiveista johdetut sti-päätteiset seikkasanat tunnistetaan
# automattisesti eli niitä ei tarvitse lisätä sanastoon.
#
# Seikkasanoja ei hyväksytä Voikossa yhdyssanan osina. Niille voidaan
# kuitenkin asettaa lippu ys_perusosa, jolloin sana sallitaan yhdyssanan
# perusosana samoissa tilanteissa, joissa yleisnimen käyttö yhdyssanan
# perusosana on sallittu.

[perusmuoto: "aamupäivisin", alku: "aamupäivisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppppp"];
[perusmuoto: "aamusella", alku: "aamusella", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "aamutuimaan", alku: "aamutuimaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppppp"];
[perusmuoto: "aamuvarhain", alku: "aamuvarhain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppppp"];
[perusmuoto: "aiemmin", alku: "aiemmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "aika-ajoin", alku: "aika-ajoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "aikaisemmin", alku: "aikaisemmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "aikaisin", alku: "aikaisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "aimo", alku: "aimo", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "aina", alku: "aina", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ainiaaksi", alku: "ainiaaksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ainiaan", alku: "ainiaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ainoastaan", alku: "ainoastaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ainut", alku: "ainut", luokka: seikkasana, jatko: <liitesana, loppu, osanto_tA>, äs: a];
[perusmuoto: "aivan", alku: "aivan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ajoittain", alku: "ajoittain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "alakkain", alku: "alakkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "alas", alku: "alas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "alassuin", alku: "alassuin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppp"];
[perusmuoto: "alasti", alku: "alasti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "alati", alku: "alati", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "alatusten", alku: "alatusten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "alekkain", alku: "alekkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "alemmas", alku: "alemmas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "alhaalla", alku: "alhaa", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "alias", alku: "alias", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "alimmas", alku: "alimmas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "alinomaa", alku: "alinomaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppp"];
[perusmuoto: "alinomaan", alku: "alinomaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppp=ppppp"];
[perusmuoto: "allekkain", alku: "allekkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "alunperin", alku: "alunperin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=pppp=ppppp"];
[perusmuoto: "alvariinsa", alku: "alvariinsa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ammoin", alku: "ammoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ani", alku: "ani", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "anteeksi", alku: "anteeksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "apposen", alku: "apposen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "arkipäivisin", alku: "arkipäivisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppppp"];
[perusmuoto: "arkittain", alku: "arkittain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "auki", alku: "auki", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "avoinna", alku: "avoinna", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "edeltäkäsin", alku: "edeltäkäsin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=pppppp=ppppp"]; # sanaliitto Kotuksen nettisivujen mukaan mutta yhdyssana kielitoimiston MOT-sanakirjassa
[perusmuoto: "edemmäs", alku: "edemmäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lännemmäs", alku: "lännemmäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "edes", alku: "edes", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "edessä", alku: "etee", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "edessä", alku: "eteen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "edessä", alku: "ede", luokka: seikkasana, jatko: @heikkoasteiset_paikallissijat, äs: ä];
[perusmuoto: "editse", alku: "editse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "edusteilla", alku: "edusteilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "eestaas", alku: "eestaas", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=ppp=pppp"];
[perusmuoto: "ehken", alku: "ehken", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ehkä", alku: "ehkä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "eilen", alku: "eilen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "eittämättä", alku: "eittämättä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "eksyksissä", alku: "eksyksi", luokka: seikkasana, jatko: @sisäpaikallissijat_Vn, äs: ä];
[perusmuoto: "enemmälti", alku: "enemmälti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "enemmän", alku: "enemmän", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "enimmäkseen", alku: "enimmäkseen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "enimmälti", alku: "enimmälti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "enintään", alku: "enintään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "eniten", alku: "eniten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ennallaan", alku: "ennalla", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "ennallaan", alku: "ennalle", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "ennalta", alku: "ennalta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ennemmin", alku: "ennemmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ennen", alku: "ennen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ennenkun", alku: "ennenkun", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=ppppp=ppp"];
[perusmuoto: "ennestään", alku: "ennestään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ensi", alku: "ensiksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ensi", alku: "ensi", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "ensin", alku: "ensin", luokka: seikkasana, jatko: <olento_nA, liitesana, loppu>, äs: ä];
[perusmuoto: "ensin", alku: "ensinkään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "entisellään", alku: "entiselleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "entisellään", alku: "entisellään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "entisestään", alku: "entisestään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "entuudelta", alku: "entuudelta", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "entuudelta", alku: "entuudesta", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "entä", alku: "entä", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "entä", alku: "entäpä", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "entä", alku: "entäpäs", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "entä", alku: "entäs", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "enää", alku: "enää", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "enää", alku: "enään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "erillään", alku: "erikseen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "erillään", alku: "erilleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "erillään", alku: "erillään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "eritoten", alku: "eritoten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "erittäin", alku: "erittäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "esillä", alku: "esiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "esillä", alku: "esille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "esillä", alku: "esillen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>];  # Murteellinen sijapääte -llen.
[perusmuoto: "esillä", alku: "esillä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "etelämpi", alku: "etelämmäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "etenkin", alku: "etenkin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "etenkin", alku: "etenkään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "etäällä", alku: "etää", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: ä];
[perusmuoto: "etäämpänä", alku: "etääm", luokka: seikkasana, jatko: <sivumpana>, äs: ä];
[perusmuoto: "hahmotteilla", alku: "hahmotteilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "haiskin", alku: "haiskin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hajalla", alku: "haja", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "hajalla", alku: "hajan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hakoteillä", alku: "hakoteillä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppp"];
[perusmuoto: "hakoteillä", alku: "hakoteille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppp"];
[perusmuoto: "halki", alku: "halki", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hallussa", alku: "hallu", luokka: seikkasana, jatko: @sisä_ssA_stA, äs: a];
[perusmuoto: "hallussa", alku: "haltu", luokka: seikkasana, jatko: <sisätulento_Vn>, äs: a];
[perusmuoto: "haltioissa", alku: "haltioihi", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "haltioissa", alku: "haltioissa", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "hamassa", alku: "hamaan", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "hamassa", alku: "hamassa", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "hamassa", alku: "hamasta", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "harvaan", alku: "harvaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "harvakseen", alku: "harvakseen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "harvakseltaan", alku: "harvakseltaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "harvassa", alku: "harvassa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "harvoin", alku: "harvoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "helkkari", alku: "helkkaristi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hellävaroen", alku: "hellävaroen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppp"];
[perusmuoto: "hellävaroin", alku: "hellävaroin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppp"];
[perusmuoto: "helpoiten", alku: "helpoiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "helvetti", alku: "helvetisti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "henkihieverissä", alku: "henkihieveri", luokka: seikkasana, jatko: @sisäpaikallissijat_Vn, äs: ä, rakenne: "=ppppp=pppppppppp"];
[perusmuoto: "hereillä", alku: "here", luokka: seikkasana, jatko: @ulkopaikallissijat_monikko, äs: ä];
[perusmuoto: "heti", alku: "heti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "hetimmiten", alku: "hetimmiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "hevillä", alku: "hevillä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "hevin", alku: "hevin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "hieman", alku: "hieman", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hienokseltaan", alku: "hienokseltaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hiirenhiljaa", alku: "hiirenhiljaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppppp=pppppp"];
[perusmuoto: "hiljaa", alku: "hiljaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hiljaa", alku: "hiljemmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "hiljaa", alku: "hiljempaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hiljaa", alku: "hiljempää", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "hiljakkoin", alku: "hiljakkoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hiljakseen", alku: "hiljakse", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "hiljalleen", alku: "hiljalleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hiljan", alku: "hiljan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hiljattain", alku: "hiljattain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hilkulla", alku: "hilkulla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "himpun", alku: "himpun", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hippasilla", alku: "hippasilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hippasilla", alku: "hippasille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hissukseen", alku: "hissukseen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hissuksiin", alku: "hissuksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hissun", alku: "hissun", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "hissunkissun", alku: "hissunkissun", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppppp=pppppp"];
[perusmuoto: "hitto", alku: "hitosti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hollilla", alku: "hollilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hollilla", alku: "hollille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hoteissa", alku: "hoteisiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hoteissa", alku: "hoteissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hoteissa", alku: "hoteista", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "housusilla", alku: "housusilla", luokka: seikkasana, jatko: <omistusliite>, äs: a, tiedot: <ys_perusosa>]; # Myös uimahoususillaan
[perusmuoto: "housusilla", alku: "housusille", luokka: seikkasana, jatko: <omistusliite>, äs: a, tiedot: <ys_perusosa>]; # Myös uimahoususilleen
[perusmuoto: "housusilla", alku: "housus", luokka: seikkasana, jatko: @ulkopaikallissijat_monikko, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "huiskin", alku: "huiskin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hujakassa", alku: "hujaka", luokka: seikkasana, jatko: <sisäolento_ssA>, äs: a];
[perusmuoto: "hujakoilla", alku: "hujakoilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hujakoilla", alku: "hujakoille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hujakoilla", alku: "hujakoilta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hujan", alku: "hujan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hukassa", alku: "hukassa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hukassa", alku: "hukkaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hukuksissa", alku: "hukuksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hukuksissa", alku: "hukuksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hukuksissa", alku: "hukuksista", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "huoleti", alku: "huoleti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "huomenna", alku: "huomenna", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "huonoiten", alku: "huonoiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "huorin", alku: "huorin", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "huosta", alku: "huosta", luokka: seikkasana, jatko: @sisäpaikallissijat_Vn + <loppu>, äs: a];
[perusmuoto: "huutia", alku: "huutia", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "hyvillään", alku: "hyville", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "hyvillään", alku: "hyvillä", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "hyvin", alku: "hyvin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "hyvineen", alku: "hyvine", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "hyväksi", alku: "hyväkse", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "hyvänen", alku: "hyvänen", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "hyvänsä", alku: "hyvänsä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "hyvänään", alku: "hyvänä", luokka: seikkasana, jatko: <omistusliite>, äs: ä]; # "Pidä hyvänäsi."
[perusmuoto: "hämillä", alku: "hämille", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "hämillä", alku: "hämillä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "häthätää", alku: "häthätää", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppp=ppppp"];
[perusmuoto: "hätäpikaa", alku: "hätäpikaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppp=ppppp"];
[perusmuoto: "höplästä", alku: "höplästä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "hörö", alku: "hörö", luokka: seikkasana, jatko: @sisäpaikallissijat_Vn + @ulkopaikallissijat, äs: ä]; # Vain -Vn-omistusliite käy
[perusmuoto: "iankaiken", alku: "iankaiken", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppp=pppppp"];
[perusmuoto: "idempi", alku: "idemmäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ihan", alku: "ihan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ihka", alku: "ihka", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ihkasen", alku: "ihkasen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "iki", alku: "iki", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "ikinä", alku: "ikinä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ikäänkuin", alku: "ikäänkuin", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=ppppp=pppp"];
[perusmuoto: "ilkialasti", alku: "ilkialasti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppppp"];
[perusmuoto: "ilki", alku: "ilki", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ilkosen", alku: "ilkosen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ilkosilla", alku: "ilkosi", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "illemmalla", alku: "illemmaksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "illemmalla", alku: "illemma", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "illemmalla", alku: "illempana", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ilma", alku: "ilmoitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "iltapäivisin", alku: "iltapäivisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppppp"];
[perusmuoto: "infra", alku: "infra", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "irrallaan", alku: "irrallaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "irrallaan", alku: "irralleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "irti", alku: "irti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "irvessä", alku: "irveen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "irvessä", alku: "irvessä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "irvessä", alku: "irviin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "irvessä", alku: "irvissä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "istualla", alku: "istua", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "itsekseen", alku: "itsekseen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "itsessään", alku: "itsessään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "itsestään", alku: "itsestään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "itsetykönä", alku: "itsetykönä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppp"];
[perusmuoto: "itsevaltias", alku: "itsevaltiaasti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppppppppp"];
[perusmuoto: "iäti", alku: "iäti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "jahka", alku: "jahka", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "jaksain", alku: "jaksain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "jalkaisin", alku: "jalkaisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "jalkeilla", alku: "jalke", luokka: seikkasana, jatko: @ulkopaikallissijat_monikko, äs: a];
[perusmuoto: "jamassa", alku: "jamaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a]; # Huonoon jamaan
[perusmuoto: "jamassa", alku: "jamassa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a]; # Huonossa jamassa
[perusmuoto: "jamassa", alku: "jamasta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a]; # Huonosta jamasta.
[perusmuoto: "jo", alku: "jo", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "jokatapauksessa", alku: "jokatapauksessa", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppp=ppppppppppp"];
[perusmuoto: "joki", alku: "joitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "jokseenkin", alku: "jokseenkin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "jolloin", alku: "jolloin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "joltinenkin", alku: "joltiseltaankin", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_sukija>];
[perusmuoto: "jonkajälkeen", alku: "jonkajälkeen", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=ppppp=ppppppp"];
[perusmuoto: "jonkatähden", alku: "jonkatähden", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=ppppp=pppppp"];
[perusmuoto: "jonkavuoksi", alku: "jonkavuoksi", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=ppppp=pppppp"];
[perusmuoto: "jopa", alku: "jopa", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "joskus", alku: "joskus", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "jotakuinkin", alku: "jotakuinkin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppppp"];
[perusmuoto: "jotapaitsi", alku: "jotapaitsi", luokka: seikkasana, jatko: <loppu>, äs: a, rakenne: "=pppp=pppppp"];
[perusmuoto: "jotavastoin", alku: "jotavastoin", luokka: seikkasana, jatko: <loppu>, äs: a, rakenne: "=pppp=ppppppp"];
[perusmuoto: "jotenkin", alku: "jotenkin", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "jotenkuten", alku: "jotenkuten", luokka: seikkasana, jatko: <loppu>, äs: a, rakenne: "=ppppp=ppppp"];
[perusmuoto: "jotensakin", alku: "jotensakin", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "jouten", alku: "jouten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "joutessa", alku: "joutessa", luokka: seikkasana, jatko: <liitesana, omistusliite, loppu>, äs: a];
[perusmuoto: "joutuin", alku: "joutuin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "jukra", alku: "jukra", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "julki", alku: "julki", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "juovuksissa", alku: "juovuksi", luokka: seikkasana, jatko: @sisäpaikallissijat_Vn, äs: a];
[perusmuoto: "juovuspäissä", alku: "juovuspäissä", luokka: seikkasana, jatko: <liitesana, omistusliite, loppu>, äs: ä, rakenne: "=pppppp=pppppp"];
[perusmuoto: "justiin", alku: "justiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "justiin", alku: "justiinsa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "juttusilla", alku: "juttusilla", luokka: seikkasana, jatko: <liitesana, omistusliite, loppu>, äs: a];
[perusmuoto: "juttusilla", alku: "juttusille", luokka: seikkasana, jatko: <liitesana, omistusliite, loppu>, äs: a];
[perusmuoto: "juttusilla", alku: "juttusilta", luokka: seikkasana, jatko: <liitesana, omistusliite, loppu>, äs: a];
[perusmuoto: "juuri", alku: "juuri", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "jäljekkäin", alku: "jälekkäin", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "jäljekkäin", alku: "jäljekkäin", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "jäljemmäs", alku: "jäljemmäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "jälkeen", alku: "jälkee", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "jälkeen", alku: "jälkeen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "jälleen", alku: "jälleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "jären", alku: "jären", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "järin", alku: "järin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "järjesteillä", alku: "järjesteillä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "jää", alku: "jäitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kadoksissa", alku: "kadoksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kadoksissa", alku: "kadoksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kahareisin", alku: "kahareisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kahtaalla", alku: "kahtaalla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kahtaalla", alku: "kahtaalle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kahtaalla", alku: "kahtaalta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kahtaalla", alku: "kahtaanne", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kahtapuolin", alku: "kahtapuolin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppp"];
[perusmuoto: "kahtia", alku: "kahtia", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kai", alku: "kai", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kai", alku: "kaipa", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kaiketi", alku: "kaiketi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kaikinpuolin", alku: "kaikinpuolin", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppppp=pppppp"];
[perusmuoto: "kaikitenkin", alku: "kaikitenkin", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kaikkialla", alku: "kaikkiaalla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "kaikkialla", alku: "kaikkiaalle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "kaikkialla", alku: "kaikkiaalta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "kaikkialla", alku: "kaikkialla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kaikkialla", alku: "kaikkialle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kaikkialla", alku: "kaikkialta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kaksin", alku: "kaksin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kaksittain", alku: "kaksittain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kallellaan", alku: "kallellaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kallellaan", alku: "kallelleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kalpaten", alku: "kalpaten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kalsareisillaan", alku: "kalsareisillaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kalsareisillaan", alku: "kalsareisilleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kalsarisillaan", alku: "kalsarisillaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kalsarisillaan", alku: "kalsarisilleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kaltoin", alku: "kaltoin", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kapealti", alku: "kapealti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "karku", alku: "karku", luokka: seikkasana, jatko: <osanto_A, sisätulento_Vn>, äs: a]; # Omistusliitteet hyvin harvinaisia.
[perusmuoto: "karku", alku: "karu", luokka: seikkasana, jatko: <sisäolento_ssA>, äs: a]; # Omistusliitteet hyvin harvinaisia.
[perusmuoto: "kasvokkain", alku: "kasvokkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kasvotuksin", alku: "kasvotuksin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kasvotusten", alku: "kasvotusten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "katki", alku: "katki", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "katumapäällä", alku: "katumapäällä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppppp"];
[perusmuoto: "katumapäällä", alku: "katumapäälle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppppp"];
[perusmuoto: "kauas", alku: "kaukaa",  luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kaukana", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauaksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauaa",   luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauan",   luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauas",   luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauempaa",   luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauempana",  luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauemmaksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauemmin",   luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauemmas",   luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauimpaa",   luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauimpana",  luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauimmaksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauimmin",   luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauas", alku: "kauimmas",   luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kaulakkain", alku: "kaulakkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kaulatusten", alku: "kaulatusten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kauttaalta", alku: "kauttaalta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "kauttaalta", alku: "kauttaalta", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "kelteisillä", alku: "kelteisi", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: ä];
[perusmuoto: "kenties", alku: "kenties", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kertaalleen", alku: "kertaalleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kesemmällä", alku: "kesemmäksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kesemmällä", alku: "kesemmälle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kesemmällä", alku: "kesemmällä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kesemmällä", alku: "kesempänä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "keskellä", alku: "keske", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: ä];
[perusmuoto: "keskellä", alku: "keskemmäksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "keskellä", alku: "keskemmälle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "keskellä", alku: "keskemmällä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "keskellä", alku: "keskemmältä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "keskellä", alku: "keskemmä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "keskellä", alku: "keskemmäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "keskellä", alku: "keskempänä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "keskellä", alku: "keskempää", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kesken", alku: "kesken", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "keskenään", alku: "keskenä", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "keskessä", alku: "keske", luokka: seikkasana, jatko: @sisäpaikallissijat_Vn, äs: ä];
[perusmuoto: "keskimäärin", alku: "keskimäärin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppppp"];
[perusmuoto: "keskipaikkeilla", alku: "keskipaikkeilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppppppp"];
[perusmuoto: "keskipaikkeilla", alku: "keskipaikkeille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppppppp"];
[perusmuoto: "keskipaikkeilla", alku: "keskipaikkeilta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppppppp"];
[perusmuoto: "keskitse", alku: "keskitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "keskiviikkoisin", alku: "keskiviikkoisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppppppp"];
[perusmuoto: "keulilla", alku: "keulilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "keulilla", alku: "keulille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "keulilla", alku: "keulilta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "keväämmällä", alku: "kevääm", luokka: seikkasana, jatko: <keväämmällä>, äs: ä];
[perusmuoto: "kieppeillä", alku: "kieppeille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kieppeillä", alku: "kieppeillä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kierryksissä", alku: "kierryksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kierryksissä", alku: "kierryksissä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kierryksissä", alku: "kierryksistä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kiihdyksissä", alku: "kiihdyksiin", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "kiihdyksissä", alku: "kiihdyksissä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "kiikissä", alku: "kiikissä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kiikissä", alku: "kiikistä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kiikissä", alku: "kiikkiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kiinni", alku: "kiinni", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kiireimmiten", alku: "kiireimmiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kiiru", alku: "kiiruusti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "kirje", alku: "kirjeitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kirkkoreilassa", alku: "kirkkoreilaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=ppppp=ppppppp"];
[perusmuoto: "kirkkoreilassa", alku: "kirkkoreilassa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=ppppp=pppppppp"];
[perusmuoto: "kissun", alku: "kissun", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kiukuspäissä", alku: "kiukuspäissä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppppp"];
[perusmuoto: "kiusanpäiten", alku: "kiusanpäiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppppp"];
[perusmuoto: "kohdakkain", alku: "kohdakkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kohdakkoin", alku: "kohdakkoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "koetteilla", alku: "koettei", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "kohdatusten", alku: "kohdatusten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kohme", alku: "kohmee", luokka: seikkasana, jatko: <sisäolento_ssA, sisätulento_seen>, äs: a];
[perusmuoto: "kohta", alku: "kohta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kolme", alku: "kolmasti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kolmin", alku: "kolmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kolminkerroin", alku: "kolminkerroin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "kolmittain", alku: "kolmittain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kolmisin", alku: "kolmisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kolmissa", alku: "kolmissa", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "kolmista", alku: "kolmista", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "konsa", alku: "konsaan", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "konsa", alku: "konsa", luokka: seikkasana, jatko: <loppu>, äs: a]; # Ala: vanhaa kieltä.
[perusmuoto: "konsa", alku: "konsana", luokka: seikkasana, jatko: <omistusliite, loppu>, äs: a];
[perusmuoto: "kontalla", alku: "konta", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "koommin", alku: "koommin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "koskaan", alku: "koskaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kosolti", alku: "kosolti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kotoisin", alku: "kotoisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kotosalla", alku: "kotosa", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "kuitenkaan", alku: "kuitenkaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kuitenkaan", alku: "kuitenkin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kukaties", alku: "kukaties", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppp"];
[perusmuoto: "kukkua", alku: "kukkua", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kulkusalla", alku: "kulkusa", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "kulloin", alku: "kulloin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kulmatusten", alku: "kulmatusten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kumminkaan", alku: "kumminkaan", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kumminkaan", alku: "kumminkin", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kumollaan", alku: "kumollaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kumollaan", alku: "kumolleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kumossa", alku: "kumoon", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kumossa", alku: "kumossa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kumossa", alku: "kumosta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kunne", alku: "kunne", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kunneka", alku: "kunneka", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kuohuksissa", alku: "kuohuksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kuohuksissa", alku: "kuohuksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kuoliaaksi", alku: "kuoliaaksi", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kuoliaaksi", alku: "kuoliaana", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kuoliaaksi", alku: "kuoliaiksi", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kuoliaaksi", alku: "kuoliaina", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kutakuinkin", alku: "kutakuinkin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppppp"];
[perusmuoto: "kuten", alku: "kuten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kuulemiin", alku: "kuulemiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "kuulemma", alku: "kuulemma", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "kyljekkäin", alku: "kyljekkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kylliksi", alku: "kyllikse", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "kylliksi", alku: "kylliksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kyllin", alku: "kyllin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kyllä", alku: "kyl", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <murre>];
[perusmuoto: "kyllä", alku: "kyllä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kyllälti", alku: "kyllälti", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "kyse", alku: "kyseen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kyse", alku: "kyseenä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kyse", alku: "kyseeseen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kyse", alku: "kyseessä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kyse", alku: "kyse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kyykkysillään", alku: "kyykkysilleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kyykkysillään", alku: "kyykkysillään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kyykkysillään", alku: "kyykkysiltään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "kyyry", alku: "kyyrysillä", luokka: seikkasana, jatko: <liitesana, omistusliite, loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "kyyry", alku: "kyyrysissä", luokka: seikkasana, jatko: <liitesana, omistusliite, loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "käsikkäin", alku: "käsikkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "käsikopelolla", alku: "käsikopelolla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppppppp"];
[perusmuoto: "käsikopelolla", alku: "käsikopelolta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppppppp"];
[perusmuoto: "käymäseltä", alku: "käymäseltä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "köpelösti", alku: "köpelösti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "köykky", alku: "köykkyyn", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "köykky", alku: "köykyssä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "köykky", alku: "köykystä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "laajalti", alku: "laajalti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "laajemmalti", alku: "laajemmalti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "laimin", alku: "laimin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lainkaan", alku: "lainkaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "laisinkaan", alku: "laisinkaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lauantaisin", alku: "lauantaisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "leikinpäiten", alku: "leikinpäiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppppp"];
[perusmuoto: "leikki", alku: "leikisti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "leikki", alku: "leikiten", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "lerpalla", alku: "lerpalla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lerpalla", alku: "lerpallaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lerpalla", alku: "lerpalle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lerpalla", alku: "lerpalleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "leveälti", alku: "leveälti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "liialti", alku: "liialti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "liian", alku: "liian", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "liian", alku: "liijan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "liian", alku: "liijoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "liian", alku: "liioin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "liiemmälti", alku: "liiemmälti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "liiskana", alku: "liiskaksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "liiskana", alku: "liiskana", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "likellä", alku: "like", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: ä];
[perusmuoto: "likemmäs", alku: "likemmäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "likimain", alku: "likimain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppp"];
[perusmuoto: "likimmäs", alku: "likimmäksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "likimmäs", alku: "likimmäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "likimmäs", alku: "likimpänä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "likimmäs", alku: "likimpää", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "likimäärin", alku: "likimäärin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppp"];
[perusmuoto: "likinnä", alku: "likinnä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "likipitäen", alku: "likipitäen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppp"];
[perusmuoto: "limikkäin", alku: "limikkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "limittäin", alku: "limittäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lintalla", alku: "lintallaan", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "lintalla", alku: "lintalleen", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "lintalla", alku: "lintassa", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "lintalla", alku: "linttaan", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "liossa", alku: "likoon", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "liossa", alku: "liossa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "liossa", alku: "liosta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lipettiin", alku: "lipettiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "loitolla", alku: "loito", luokka: seikkasana, jatko: <loitolla>, äs: a]; # Hyväksytään on myös tulosija "loitos"
[perusmuoto: "lomitse", alku: "lomitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lopen", alku: "lopen", luokka: seikkasana, jatko: <loppu>, äs: a]; # 'perin pohjin'
[perusmuoto: "luimussa", alku: "luimussa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "luimussa", alku: "luimuun", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lukuunottamatta", alku: "lukuunottamatta", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppppp=ppppppppp"];
[perusmuoto: "luo", alku: "luo", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "luokse", alku: "luokse", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "luokse", alku: "luona", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "lurpalla", alku: "lurpalla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lurpalla", alku: "lurpallaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lurpalla", alku: "lurpalle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lurpalla", alku: "lurpalleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lurpalla", alku: "lurpassa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lurpalla", alku: "lurppaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "lyhyelti", alku: "lyhyelti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lysyssä", alku: "lysyssä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lysyssä", alku: "lysyyn", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lytyssä", alku: "lyttyyn", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lytyssä", alku: "lytyssä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lähekkäin", alku: "lähekkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lähellä", alku: "lähe", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: ä];
[perusmuoto: "lähemmäs", alku: "lähemmä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lähemmäs", alku: "lähemmäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lähes", alku: "lähes", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lähestulkoon", alku: "lähestulkoon", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=ppppppp"];
[perusmuoto: "lähettyvillä", alku: "lähettyvi", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: ä];
[perusmuoto: "lähi", alku: "lähi", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "lähimmäs", alku: "lähimmäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lähiseutuvilla", alku: "lähiseutuvilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppppppppp"];
[perusmuoto: "lähiseutuvilla", alku: "lähiseutuvilta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppppppppp"];
[perusmuoto: "lähiseutuvilla", alku: "lähiseutuville", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppppppppp"];
[perusmuoto: "lähtöisin", alku: "lähtöisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "läkähdyksissä", alku: "läkähdyksissä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "läkähdyksissä", alku: "läkähdyksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "länsimaisittain", alku: "länsimaisittain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "läpi", alku: "lävitse", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "läpikotaisin", alku: "läpikotaisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppppppp"];
[perusmuoto: "läsnä", alku: "läsnä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "lääpällä", alku: "lääpällä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "maanantaisin", alku: "maanantaisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "maastoitse", alku: "maastoitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "maestoso", alku: "maestoso", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "maa", alku: "maitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "melkein", alku: "melkein", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "meneillä", alku: "meneille", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "meneillä", alku: "meneillä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "meri", alku: "meritse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "mieluimmin", alku: "mieluimmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "mieluiten", alku: "mieluiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "mieluummin", alku: "mieluummin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "mieluusti", alku: "mieluusti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "mikäli", alku: "mikäli", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "miljoonittain", alku: "miljoonittain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "milloin", alku: "milloinka", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "milloin", alku: "milloinkas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "milloin", alku: "milloin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "millänsäkään", alku: "millänikään",  luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "millänsäkään", alku: "milläsikään",  luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "millänsäkään", alku: "millänsäkään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "millänsäkään", alku: "millämmekään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "millänsäkään", alku: "millättekään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>]; # Onko sana?
[perusmuoto: "miltei", alku: "milt'ei", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "miltei", alku: "miltei", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "minkätähden", alku: "minkätähden", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=ppppp=pppppp"];
[perusmuoto: "minkävuoksi", alku: "minkävuoksi", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=ppppp=pppppp"];
[perusmuoto: "miten", alku: "miten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "miten", alku: "mitenkä", luokka: seikkasana, jatko: <liitesana, liitesana_s, loppu>, äs: ä];
[perusmuoto: "miten", alku: "mites", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "moderato", alku: "moderato", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "moksis", alku: "moksiskaan", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "molempi", alku: "molempi", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_ys>]; # "molempi parempi"
[perusmuoto: "moniaalla", alku: "moniaa", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "moni", alku: "monasti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "moni", alku: "monesti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "muassa", alku: "muassa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "muinoin", alku: "muinoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "muka", alku: "mukaa", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "muka", alku: "muka", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "mukaan", alku: "mukaa", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "mukaan", alku: "mukaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "mukamas", alku: "mukamas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "mukaan", alku: "mukana", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "muualla", alku: "muua", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "muuanne", alku: "muuanne", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "muulloin", alku: "muulloin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "muuten", alku: "muuten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "muutoin", alku: "muutoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "mynkään", alku: "mynkään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "myöden", alku: "myöden", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä]; # KS: paremmin "myöten".
[perusmuoto: "myöhemmin", alku: "myöhemmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "myös", alku: "myös", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "myöten", alku: "myöten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "myötä", alku: "myötä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "myötäänsä", alku: "myötäänsä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "määrälti", alku: "määrälti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "mönkään", alku: "mönkään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "naukin", alku: "naukin", luokka: seikkasana, jatko: <loppu>, äs: a]; # Niukin naukin.
[perusmuoto: "nelisin", alku: "nelisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "nelittäin", alku: "nelittäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "nenäkkäin", alku: "nenäkkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "nenätysten", alku: "nenätysten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "neuvotteilla", alku: "neuvotteilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "niikseen", alku: "niikseen", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "niin", alku: "niin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "nilellä", alku: "nile", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: ä];
[perusmuoto: "nimenomaan", alku: "nimenomaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=ppppp"];
[perusmuoto: "nimittäin", alku: "nimittäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "nipin", alku: "nipin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "niukalti", alku: "niukalti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "no", alku: "no", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "no", alku: "no", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_sukija>];
[perusmuoto: "noin", alku: "noin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "nokakkain", alku: "nokakkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "nokatusten", alku: "nokatusten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "nokikkain", alku: "nokikkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "noloissaan", alku: "noloissa", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "nonstop", alku: "nonstop", luokka: seikkasana, jatko: <kalsium>, äs: a, rakenne: "=ppp=pppp"];
[perusmuoto: "nopeiten", alku: "nopeiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a]; # OK Kotuksen mukaan.
[perusmuoto: "nukuksissa", alku: "nukuksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "nukuksissa", alku: "nukuksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "nuokuksissa", alku: "nuokuksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "nuokuksissa", alku: "nuokuksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "nurin", alku: "nurin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "nurkakkain", alku: "nurkakkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "nurkakkain", alku: "nurkikkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "nuuduksissa", alku: "nuuduksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "nykyisellään", alku: "nykyiselleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "nykyisellään", alku: "nykyisellään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "nykyä", alku: "nykyä", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "nykyään", alku: "nykyään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "nyreissään", alku: "nyreissä", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "nyrpeissään", alku: "nyrpeissään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "nyt", alku: "nyt", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "nyttemmin", alku: "nyttemmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näemmä", alku: "näemmä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näes", alku: "näes", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "nähden", alku: "nähden", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näin", alku: "näin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näinollen", alku: "näinollen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppp=ppppp"];
[perusmuoto: "näkemiin", alku: "näkemiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näköjään", alku: "näköjään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näkösällä", alku: "näkösälle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näkösällä", alku: "näkösällä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näkösällä", alku: "näkösältä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näytillä", alku: "näytille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näytillä", alku: "näytillä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näännyksissä", alku: "näännyksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "näännyksissä", alku: "näännyksissä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "nääs", alku: "nääs", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <murre>];
[perusmuoto: "ohimennen", alku: "ohimennen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppp=pppppp"];
[perusmuoto: "ohitse", alku: "ohitse", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "ohuelti", alku: "ohuelti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "oikeammin", alku: "oikeammin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "oikein", alku: "oikein", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "oikosenaan", alku: "oikosenaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "oitis", alku: "oitis", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ojossa", alku: "ojolla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ojossa", alku: "ojollaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ojossa", alku: "ojolle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ojossa", alku: "ojolleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ojossa", alku: "ojoon", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ojossa", alku: "ojossa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "olleti", alku: "olleti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ominvalloin", alku: "ominvalloin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppppp"];
[perusmuoto: "pahiten", alku: "pahiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pahitteeksi", alku: "pahitteeksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pahoin", alku: "pahoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "paikkeilla", alku: "paikkeilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "paikkeilla", alku: "paikkeille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "paikkeilla", alku: "paikkeilta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "paikoin", alku: "paikoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "painuksissa", alku: "painuksi", luokka: seikkasana, jatko: @sisäpaikallissijat_Vn, äs: a];
[perusmuoto: "paitahihasillaan", alku: "paitahihasillaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=ppppppppppp"];
[perusmuoto: "paitahihasillaan", alku: "paitahihasilleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=ppppppppppp"];
[perusmuoto: "paitasilla", alku: "paitasilla", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "paitasilla", alku: "paitasilla", luokka: seikkasana, jatko: <omistusliite>, äs: a, tiedot: <ys_perusosa>];
[perusmuoto: "paitasilla", alku: "paitasille", luokka: seikkasana, jatko: <omistusliite>, äs: a, tiedot: <ys_perusosa>];
[perusmuoto: "paitsi", alku: "paitsi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pakosalla", alku: "pakosalla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pakosalla", alku: "pakosalle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pakosalla", alku: "pakosalta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "paksulti", alku: "paksulti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "paljaaltaan", alku: "paljaalta", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "paljolti", alku: "paljolti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "parahiksi", alku: "parahiksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "paraikaa", alku: "paraikaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppp=ppppp"];
[perusmuoto: "paraillaan", alku: "paraillaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "parhaillaan", alku: "parhailla", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "parhaimmillaan", alku: "parhaimmilla", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "parhaiten", alku: "parhaiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "parittain", alku: "parittain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "paska", alku: "paskasti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pelkästään", alku: "pelkästään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "peremmällä", alku: "peremmällä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "perempänä", alku: "perem", luokka: seikkasana, jatko: <sivumpana>, äs: ä];
[perusmuoto: "perillä", alku: "perille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "perillä", alku: "perillä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "perillä", alku: "periltä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "perjantaisin", alku: "perjantaisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "perkele", alku: "perkeleesti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "perä", alku: "peräitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "peräisin", alku: "peräisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "peräkkäin", alku: "peräkkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "peräti", alku: "peräti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "perättäin", alku: "perättäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "perätysten", alku: "perätysten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "piakkoin", alku: "piakkoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pian", alku: "pian", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "piilosilla", alku: "piilosilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "piilosilla", alku: "piilosille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "piilosilla", alku: "piilosilta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "piip", alku: "piip", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pika", alku: "pika", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "pika", alku: "pikaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pika", alku: "pikana", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pika", alku: "pikapikaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppp"];
[perusmuoto: "pikaiseltaan", alku: "pikaiseltaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pikemmin", alku: "pikemmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pikimmin", alku: "pikimmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pikimmiten", alku: "pikimmiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pikkuhiljaa", alku: "pikkuhiljaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppp"];
[perusmuoto: "pikkutakkisillaan", alku: "pikkutakkisillaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppppppppp"];
[perusmuoto: "pilanpäiten", alku: "pilanpäiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppppp"];
[perusmuoto: "pinnempana", alku: "pinnem", luokka: seikkasana, jatko: <sivumpana>, äs: a];
[perusmuoto: "pitkin", alku: "pitkin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pitkälti", alku: "pitkälti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pizzicato", alku: "pizzicato", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pohjempana", alku: "pohjem", luokka: seikkasana, jatko: <sivumpana>, äs: a];
[perusmuoto: "pohjimpana", alku: "pohjim", luokka: seikkasana, jatko: <sivumpana>, äs: a];
[perusmuoto: "pohjimmiltaan", alku: "pohjimmiltaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "poikessa", alku: "poikessa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "poikessa", alku: "poikkeen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "poikin", alku: "poikin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "poikittain", alku: "poikittain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "poikki", alku: "poikki", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "poikkipuolin", alku: "poikkipuolin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppppp=pppppp"];
[perusmuoto: "poikkiteloin", alku: "poikkiteloin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppppp=pppppp"];
[perusmuoto: "pois", alku: "pois", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "poissa", alku: "poissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "posti", alku: "postitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ys_perusosa>];
[perusmuoto: "puhelin", alku: "puhelimitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "radiopuhelin", alku: "radiopuhelimitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=ppppppppppp"];
[perusmuoto: "matkapuhelin", alku: "matkapuhelimitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=ppppppppppp"];
[perusmuoto: "lankapuhelin", alku: "lankapuhelimitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=ppppppppppp"];
[perusmuoto: "puhki", alku: "puhki", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "puolinukuksissa", alku: "puolinukuksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppppp"];
[perusmuoto: "puolinukuksissa", alku: "puolinukuksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppppppp"];
[perusmuoto: "puolitse", alku: "puolitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ys_perusosa>];
[perusmuoto: "puolivakavissaan", alku: "puolivakavissa", luokka: seikkasana, jatko: <omistusliite>, äs: a, rakenne: "=ppppp=ppppppppppp"];
[perusmuoto: "puseroisilla", alku: "puseroisi", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "puuduksissa", alku: "puuduksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "puuduksissa", alku: "puuduksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pyhisin", alku: "pyhisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pyjamaisillaan", alku: "pyjamaisillaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "pyörryksissä", alku: "pyörryksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pyörryksissä", alku: "pyörryksissä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pyörryksissä", alku: "pyörryksistä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "päihdyksissä", alku: "päihdyksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "päihdyksissä", alku: "päihdyksissä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "päinsä", alku: "päinsä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "päinvastoin", alku: "päinvastoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppppp"];
[perusmuoto: "päistikkaa", alku: "päistikkaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "päiten", alku: "päiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "päivemmällä", alku: "päivem", luokka: seikkasana, jatko: <keväämmällä>, äs: ä];
[perusmuoto: "päivisin", alku: "päivisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "päiväsaikaan", alku: "päiväsaikaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppppp=pppppp"];
[perusmuoto: "päiväselti", alku: "päiväselti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "päiväseltään", alku: "päiväseltään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pälkähästä", alku: "pälkähästä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pääksytysten", alku: "pääksytysten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "päällekkäin", alku: "päällekkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "päälletysten", alku: "päälletysten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "päällitse", alku: "päällitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pääty", alku: "päädyitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pökerryksissä", alku: "pökerryksi", luokka: seikkasana, jatko: @sisäpaikallissijat_Vn, äs: ä];
[perusmuoto: "pöpperössä", alku: "pöpperössä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pöpperössä", alku: "pöpperöstä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pörhössä", alku: "pörhölle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pörhössä", alku: "pörhölleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pörhössä", alku: "pörhöllä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pörhössä", alku: "pörhöllään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pörhössä", alku: "pörhössä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "pörhössä", alku: "pörhöön", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "radio", alku: "radioitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "rannempana", alku: "rannem", luokka: seikkasana, jatko: <sivumpana>, äs: a];
[perusmuoto: "rannimpana", alku: "rannim", luokka: seikkasana, jatko: <sivumpana>, äs: a];
[perusmuoto: "ratki", alku: "ratki", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ratsailla", alku: "ratsai", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "ratsain", alku: "ratsain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "reilassa", alku: "reilaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "reilassa", alku: "reilassa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "rempallaan", alku: "rempallaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "rempallaan", alku: "rempalleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "retuperällä", alku: "retuperälle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=ppppppp"];
[perusmuoto: "retuperällä", alku: "retuperällä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=ppppppp"];
[perusmuoto: "reunempana", alku: "reunem", luokka: seikkasana, jatko: <sivumpana>, äs: a];
[perusmuoto: "reunimpana", alku: "reunim", luokka: seikkasana, jatko: <sivumpana>, äs: a];
[perusmuoto: "rikki", alku: "rikki", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "rillumarei", alku: "rillumarei", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a]; # Voinee taivuttaa täydellisesti
[perusmuoto: "rinnakkain", alku: "rinnakkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ristikkäin", alku: "ristikkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "rivittäin", alku: "rivittäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "rohduksissa", alku: "rohduksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "roppakaupalla", alku: "roppakaupalla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppppp"];
[perusmuoto: "ruikulilla", alku: "ruikulilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <murre>];
[perusmuoto: "ruikulilla", alku: "ruikulille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <murre>];
[perusmuoto: "runsaiten", alku: "runsaiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ruti", alku: "ruti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "rutiini", alku: "rutiinisti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "rutto", alku: "rutosti", luokka: nimi_laatusana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "saakeli", alku: "saakelisti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "saakka", alku: "saakka", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "saakuri", alku: "saakuristi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "saamari", alku: "saamaristi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "saatana", alku: "saatanasti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "saati", alku: "saatikka", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "saati", alku: "saati", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "saatille", alku: "saatille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "sadoittain", alku: "sadoittain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "sakeanaan", alku: "sakeanaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "salaa", alku: "salaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "salavihkaa", alku: "salavihkaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppppp"];
[perusmuoto: "samaten", alku: "samaten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "sammuksissa", alku: "sammuksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "sammuksissa", alku: "sammuksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "samoin", alku: "samoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "samoinkuin", alku: "samoinkuin", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppppp=pppp"];
[perusmuoto: "samperi", alku: "samperisti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "sangen", alku: "sangen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "satamäärin", alku: "satamäärin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppp"];
[perusmuoto: "sattumoisin", alku: "sattumoisin", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "seassa", alku: "sea", luokka: seikkasana, jatko: @sisä_ssA_stA, äs: a];
[perusmuoto: "seassa", alku: "seka", luokka: seikkasana, jatko: <sisätulento_Vn>, äs: a];
[perusmuoto: "seinempänä", alku: "seinem", luokka: seikkasana, jatko: <sivumpana>, äs: ä];
[perusmuoto: "seisaalla", alku: "seisaa", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "seisoalla", alku: "seisoa", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "selin", alku: "selin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "selvillä", alku: "selville", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "selvillä", alku: "selvillä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "semminkin", alku: "semminkin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "semminkin", alku: "semminkään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "senjälkeen", alku: "senjälkeen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "sentään", alku: "sentään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "seutuvilla", alku: "seutuvilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "seutuvilla", alku: "seutuvilta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "seutuvilla", alku: "seutuville", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "siellä", alku: "siellä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "siellä", alku: "sieltä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "siellä", alku: "sinne", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "siis", alku: "siis", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sikin", alku: "sikin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sikäläisittäin", alku: "sikäläisittäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sikseen", alku: "sikseen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sikseen", alku: "siksensä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "siksi", alku: "siksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sikäli", alku: "sikäli", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "silleen", alku: "silleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "silleen", alku: "sillensä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "silloin", alku: "silloin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "sillään", alku: "sillänsä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sillään", alku: "sillään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "silmäkkäin", alku: "silmäkkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "silmätyksin", alku: "silmätyksin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "silmätysten", alku: "silmätysten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "siltään", alku: "siltänsä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "siltään", alku: "siltään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sinnempänä", alku: "sinnem", luokka: seikkasana, jatko: <sivumpana>, äs: ä];
[perusmuoto: "sinällään", alku: "sinällään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sinänsä", alku: "sinänsä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sisäkkäin", alku: "sisäkkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "siten", alku: "siten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sittemmin", alku: "sittemmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sitten", alku: "sitten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sittenkuin", alku: "sittenkuin", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppppp=pppp"];
[perusmuoto: "sittenkun", alku: "sittenkun", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppppp=ppp"];
[perusmuoto: "sitäpaitsi", alku: "sitäpaitsi", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppp=pppppp"];
[perusmuoto: "sitävastoin", alku: "sitävastoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppp=ppppppp"];
[perusmuoto: "sivu", alku: "sivuitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "sivumennen", alku: "sivumen", luokka: seikkasana, jatko: <nainen>, äs: a, rakenne: "=pppp=pppppp"];
[perusmuoto: "sivumpana", alku: "sivum", luokka: seikkasana, jatko: <sivumpana>, äs: a];
[perusmuoto: "sivuttain", alku: "sivuttain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "sokin", alku: "sokin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "soopa", alku: "soopa", luokka: seikkasana, jatko: <liitesana, loppu, osanto_A>, äs: a];
[perusmuoto: "suinkin", alku: "suinkaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "suinkin", alku: "suinkin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "suitsait", alku: "suitsait", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <murre>];
[perusmuoto: "sujut", alku: "sujut", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "sukkasillaan", alku: "sukkasillaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "sukkasillaan", alku: "sukkasilleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "summamutikassa", alku: "summamutikassa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=ppppppppp"];
[perusmuoto: "summanmutikassa", alku: "summanmutikassa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppppp=ppppppppp"];
[perusmuoto: "sunnuntaisin", alku: "sunnuntaisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "suotta", alku: "suotta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "suppu", alku: "suppu", luokka: seikkasana, jatko: <sisätulento_Vn>, äs: a];
[perusmuoto: "suppu", alku: "supu", luokka: seikkasana, jatko: @sisä_ssA_stA + @ulkopaikallissijat, äs: a];
[perusmuoto: "surku", alku: "surku", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "suurelti", alku: "suurelti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "suutuksissa", alku: "suutuksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "suutuksissa", alku: "suutuksissa", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "suutuspäissä", alku: "suutuspäissä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppppp"];
[perusmuoto: "sydän", alku: "sydännä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "syksympänä", alku: "syksym", luokka: seikkasana, jatko: <sivumpana>, äs: ä];
[perusmuoto: "sylikkäin", alku: "sylikkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "synnyinpaikkeilla", alku: "synnyinpaikkei", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a, tiedot: <ei_voikko>, rakenne: "=ppppppp=pppppppppp"];
[perusmuoto: "syrjempänä", alku: "syrjem", luokka: seikkasana, jatko: <sivumpana>, äs: ä];
[perusmuoto: "syvälti", alku: "syvälti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "sähke", alku: "sähkeitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "taa", alku: "taa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "taaemmas", alku: "taaemmas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taaimmaksi", alku: "taaimmaksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taaimpaa", alku: "taaimpaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taaimpana", alku: "taaimpana", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taammas", alku: "taammas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "taannoin", alku: "taannoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taas", alku: "taas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taasen", alku: "taasen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taemmas", alku: "taemmas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tahallaan", alku: "tahalla", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "tahansa", alku: "tahansa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taimmaksi", alku: "taimmaksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taimpaa", alku: "taimpaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taimpana", alku: "taimpana", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tainnoksissa", alku: "tainnoksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tainnoksissa", alku: "tainnoksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tainnoksissa", alku: "tainnoksissa", luokka: seikkasana, jatko: <omistusliite>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "tainnoksissa", alku: "tainnoksista", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tainnoksissa", alku: "tainnoksista", luokka: seikkasana, jatko: <omistusliite>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "tainnuksissa", alku: "tainnuksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tainnuksissa", alku: "tainnuksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tainnuksissa", alku: "tainnuksissa", luokka: seikkasana, jatko: <omistusliite>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "tainnuksissa", alku: "tainnuksista", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tainnuksissa", alku: "tainnuksista", luokka: seikkasana, jatko: <omistusliite>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "taiten", alku: "taiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taitse", alku: "taitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "taivasalla", alku: "taivasa", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "takana", alku: "takaa", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "takana", alku: "takana", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "takana", alku: "taakse", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "takaperin", alku: "takaperin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppp"];
[perusmuoto: "takia", alku: "takia", luokka: seikkasana, jatko: <liitesana, omistusliite, loppu>, äs: a];
[perusmuoto: "tallessa", alku: "tallella", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tallessa", alku: "tallelle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tallessa", alku: "tallessa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tallessa", alku: "tallesta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tallessa", alku: "talteen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tanassa", alku: "tanaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tanassa", alku: "tanassa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tarjolla", alku: "tarjolla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tarjolla", alku: "tarjolle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tarjolla", alku: "tarjona", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tarkalleen", alku: "tarkalleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tarkimmin", alku: "tarkimmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tarkoin", alku: "tarkoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tasa", alku: "tasa", luokka: seikkasana, jatko: @sisäpaikallissijat_Vn + @ulkopaikallissijat, äs: a];
[perusmuoto: "tasa", alku: "tasoihin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a]; # Tunnistuu myös sanasta "taso" mutta se on eri sana
[perusmuoto: "tasa", alku: "tasoissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a]; # Tunnistuu myös sanasta "taso" mutta se on eri sana
[perusmuoto: "tasan", alku: "tasan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tie", alku: "teitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ys_perusosa>];
[perusmuoto: "tekeillä", alku: "teke", luokka: seikkasana, jatko: @ulkopaikallissijat_monikko, äs: ä];
[perusmuoto: "tenä", alku: "tenä", luokka: seikkasana, jatko: <loppu, nimentö_t, osanto_A, omanto_n, sisäolento_ssA>, äs: ä];
[perusmuoto: "ties", alku: "ties", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "tieten", alku: "tieten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "tiettäväksi", alku: "tiettäväksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "tiettävästi", alku: "tiettävästi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "tiistaisin", alku: "tiistaisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tipotiehen", alku: "tipotie", luokka: seikkasana, jatko: <sisätulento_hVn>, äs: ä, rakenne: "=pppp=pppppppp"];
[perusmuoto: "tipotiessään", alku: "tipotiessään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppppp"];
[perusmuoto: "tismalleen", alku: "tismalleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tiukilla", alku: "tiukilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a]; # ark. "rahat tiukilla"
[perusmuoto: "tiukilla", alku: "tiukille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tohjona", alku: "tohjoksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tohjona", alku: "tohjona", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tohkeissa", alku: "tohkeissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "tohkeissa", alku: "tohkeissa", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "toisaalla", alku: "toisaa", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "toisaalla", alku: "toisaha", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "toisaalla", alku: "toisaanne", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "toisinaan", alku: "toisinaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "toisin", alku: "toisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "toissa", alku: "toissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "toistaiseksi", alku: "toistaiseksi", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "toiste", alku: "toiste", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "toki", alku: "toki", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tokko", alku: "tokko", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "torkuksissa", alku: "torkuksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "torstaisin", alku: "torstaisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tuhansittain", alku: "tuhansittain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tuhatkunta", alku: "tuhatkunta", luokka: seikkasana, jatko: <loppu>, äs: a, rakenne: "=ppppp=ppppp"]; # Oikeastaan lukusana, mutta taipumaton.
[perusmuoto: "tuhatmäärin", alku: "tuhatmäärin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppp"];
[perusmuoto: "tuiki", alku: "tuiki", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "tukahduksissa", alku: "tukahduksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tukahduksissa", alku: "tukahduksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tukehduksissa", alku: "tukehduksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tukehduksissa", alku: "tukehduksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tukkanuottasilla", alku: "tukkanuottas", luokka: seikkasana, jatko: @ulkopaikallissijat_monikko, äs: a, rakenne: "=ppppp=ppppppppppp"];
[perusmuoto: "tuohduksissa", alku: "tuohduksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tuohduksissa", alku: "tuohduksissa", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "tuolloin", alku: "tuolloin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tuonnemma", alku: "tuonnemma", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "tuonnemma", alku: "tuonnemmas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tuonnoin", alku: "tuonnoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tuonpuolitse", alku: "tuonpuolitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>, rakenne: "=pppp=pppppppp"];
[perusmuoto: "tuoreeltaan", alku: "tuoreeltaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "turhanpäiten", alku: "turhanpäiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppppp"];
[perusmuoto: "turkanen", alku: "turkasesti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "turruksissa", alku: "turruksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "turruksissa", alku: "turruksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "turvoksissa", alku: "turvoksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "turvoksissa", alku: "turvoksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tuskin", alku: "tuskin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tuuperruksissa", alku: "tuuperruksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tuuperruksissa", alku: "tuuperruksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tuuperruksissa", alku: "tuuperruksista", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "tuusan", alku: "tuusan", luokka: seikkasana, jatko: <loppu>, äs: a];
[perusmuoto: "tykkänään", alku: "tykkänään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "tykö", alku: "tykö", luokka: seikkasana, jatko: <omistusliite, loppu>, äs: ä];
[perusmuoto: "tykö", alku: "tyköä", luokka: seikkasana, jatko: <omistusliite, loppu>, äs: ä];
[perusmuoto: "tykö", alku: "tykönä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "typö", alku: "typö", luokka: seikkasana, jatko: <loppu>, äs: ä]; # "typö tyhjä"
[perusmuoto: "tyynni", alku: "tyynni", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "tyystin", alku: "tyystin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "tyyten", alku: "tyyten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "täkäläisittäin", alku: "täkäläisittäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "tällöin", alku: "tällöin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "tännempänä", alku: "tännem", luokka: seikkasana, jatko: <sivumpana>, äs: ä];
[perusmuoto: "tänäpäivänä", alku: "tänäpäivänä", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=pppp=ppppppp"];
[perusmuoto: "tänään", alku: "tänään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "täpö", alku: "täpö", luokka: seikkasana, jatko: <loppu>, äs: ä]; # "täpö täysi"
[perusmuoto: "täpösen", alku: "täpösen", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "täpötäysi", alku: "täpötäynnä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppp"];
[perusmuoto: "täsmälleen", alku: "täsmälleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "tästedes", alku: "tästedes", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppp"];
[perusmuoto: "tästälähin", alku: "tästälähin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=ppppp=ppppp"];
[perusmuoto: "täten", alku: "täten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "täydelleen", alku: "täydelleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "täysi", alku: "täynnä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "täytäntöön", alku: "täytäntöön", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "täällä", alku: "täällä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "täällä", alku: "täältä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "täällä", alku: "tänne", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "uimapukusillaan", alku: "uimapukusillaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppppppppp"];
[perusmuoto: "uimapukusillaan", alku: "uimapukusilleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppppppppp"];
[perusmuoto: "uimasillaan", alku: "uimasillaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "uimasillaan", alku: "uimasilleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ulkosalla", alku: "ulkosa", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "ulko", alku: "ulolta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "uloimmas", alku: "uloimmas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ulommas", alku: "ulommas", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ulos", alku: "ulkoa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ulos", alku: "ulkona", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "ulos", alku: "ulos", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "umpimähkään", alku: "umpimähkään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=ppppppp"];
[perusmuoto: "unenpöpperössä", alku: "unenpöpperössä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppppppp"];
[perusmuoto: "unenpöpperössä", alku: "unen-pöpperössä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=pppp-=pppppppppp"];
[perusmuoto: "uppeluksissa", alku: "uppeluksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <murre>];
[perusmuoto: "uppeluksissa", alku: "uppeluksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <murre>];
[perusmuoto: "uppeluksissa", alku: "uppeluksista", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <murre>];
[perusmuoto: "upoksissa", alku: "upoksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "upoksissa", alku: "upoksii", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "upoksissa", alku: "upoksissa", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "upoksissa", alku: "upoksista", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a];
[perusmuoto: "uppo", alku: "uppo", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "useimmiten", alku: "useimmiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "uudelleen", alku: "uudelleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "uudestaan", alku: "uudestaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "uuvuksissa", alku: "uuvuksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "uuvuksissa", alku: "uuvuksissa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vahvalti", alku: "vahvalti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vailla", alku: "vailla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vailla", alku: "vaille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vain", alku: "vain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vaiti", alku: "vaiti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vaivihkaa", alku: "vaivihkaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vakavissaan", alku: "vakavissa", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "valtoimena", alku: "valtoimena", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: a]; # Ei Kotuksen sanastossa.
[perusmuoto: "vanhemmiten", alku: "vanhemmiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vankkumatta", alku: "vankkumatta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "varhain", alku: "varhain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "varhemmin", alku: "varhemmin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "varpaisilla", alku: "varpaisi", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: a];
[perusmuoto: "varuilla", alku: "varuilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "varuilla", alku: "varuilla", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "varuilla", alku: "varuille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "varuilla", alku: "varuille", luokka: seikkasana, jatko: <omistusliite>, äs: a];
[perusmuoto: "vasta", alku: "vasta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vastaan", alku: "vastaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vastakkain", alku: "vastakkain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vastapäätä", alku: "vastapäätä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=ppppp"];
[perusmuoto: "vastatusten", alku: "vastatusten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=pppppp"];
[perusmuoto: "vast'edes", alku: "vast'edes", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vastedes", alku: "vastedes", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=pppp"];
[perusmuoto: "vasten", alku: "vasten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vastikään", alku: "vastikään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=ppppp"];
[perusmuoto: "vastoin", alku: "vastoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "verekseltään", alku: "verekseltä", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "vereslihalla", alku: "vereslihalla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=ppppppp"];
[perusmuoto: "vereslihalla", alku: "vereslihalle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=ppppppp"];
[perusmuoto: "verkalleen", alku: "verkalleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "verkkaan", alku: "verkkaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "verkko", alku: "verkoitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "verraten", alku: "verraten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "verrattain", alku: "verrattain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vesi", alku: "vesitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "via", alku: "via", luokka: seikkasana, jatko: <loppu>, äs: a, tiedot: <ei_ys>];
[perusmuoto: "vielä", alku: "vielä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "vieraisilla", alku: "vieraisilla", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vieraisilla", alku: "vieraisille", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vieraisilla", alku: "vieraisilta", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vierekkäin", alku: "vierekkäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "vieretysten", alku: "vieretysten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "vieri", alku: "vieritse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "vihdoin", alku: "vihdoin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "viimein", alku: "viimein", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "viimeisteillä", alku: "viimeisteillä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "viimeistään", alku: "viimeistään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "viimeksi", alku: "viimeksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "viljalti", alku: "viljalti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vilkkaan", alku: "vilkkaan", luokka: seikkasana, jatko: <loppu>, äs: a]; # kiireen vilkkaa
[perusmuoto: "vinottain", alku: "vinottain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vinottain", alku: "vinoittain", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, tiedot: <ei_voikko>];
[perusmuoto: "vitkaan", alku: "vitkaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vittu", alku: "vitusti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vuoksi", alku: "vuoksi", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a];
[perusmuoto: "vähintäin", alku: "vähintäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "vähintään", alku: "vähintään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "vähitellen", alku: "vähitellen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "vähiten", alku: "vähiten", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "vähittäin", alku: "vähittäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "vähän", alku: "vähän", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "vähäsen", alku: "vähäsen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "väijyksissä", alku: "väijyksi", luokka: seikkasana, jatko: @sisäpaikallissijat_Vn, äs: ä];
[perusmuoto: "väkisin", alku: "väkisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "väli", alku: "välitse", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "vängällä", alku: "vängällä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä]; # Väen vängällä.
[perusmuoto: "väsyksissä", alku: "väsyksiin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "väsyksissä", alku: "väsyksissä", luokka: seikkasana, jatko: <omistusliite, liitesana, loppu>, äs: ä];
[perusmuoto: "vääjäämättä", alku: "vääjäämä", luokka: seikkasana, jatko: <vajanto_ttA>, äs: ä];
[perusmuoto: "väärin", alku: "väärin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhdessä", alku: "yhdessä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhtaikaa", alku: "yhtaikaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppp=ppppp"];
[perusmuoto: "yhteensä", alku: "yhteensä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhtenä", alku: "yhtenä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhtenään", alku: "yhtenään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhtikäs", alku: "yhtikäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhtä", alku: "yhtä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhtäkkiä", alku: "yht'äkkiä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhtäkkiä", alku: "yhtäkkiä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppp=ppppp"];
[perusmuoto: "yhtäällä", alku: "yhtäälle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhtäällä", alku: "yhtäällä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhtäällä", alku: "yhtäältä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhtään", alku: "yhtään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhä", alku: "yhä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yhäti", alku: "yhäti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yksin", alku: "yksin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yksinomaan", alku: "yksinomaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppppp=ppppp"];
[perusmuoto: "yksinään", alku: "yksinä", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "yksitellen", alku: "yksitellen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "yksittäin", alku: "yksittäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ykskaks", alku: "ykskaks", luokka: seikkasana, jatko: <loppu>, äs: a, rakenne: "=ppp=pppp"];
[perusmuoto: "ykskantaan", alku: "ykskantaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppp=ppppppp"];
[perusmuoto: "yleensä", alku: "yleensä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ylemmäs", alku: "ylemmäs", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ylen", alku: "ylen", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "ylhäällä", alku: "ylhää", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: ä];
[perusmuoto: "ylihuomenna", alku: "ylihuomenna", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppp=pppppppp"];
[perusmuoto: "ylimalkaan", alku: "ylimalkaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=ppp=ppppppp"];
[perusmuoto: "ylle", alku: "ylle", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_sukija>];
[perusmuoto: "yllin", alku: "yllin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä]; #Yllin kyllin.
[perusmuoto: "yllä", alku: "y", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: ä];
[perusmuoto: "yltympäri", alku: "yltympäri", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppp=pppppp"];
[perusmuoto: "yltympäri", alku: "yltympäriinsä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppp=pppppppppp"];
[perusmuoto: "yltäkyllin", alku: "yltäkyllin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppppp"];
[perusmuoto: "yltäpäätä", alku: "yltäpäältä", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "yltäpäätä", alku: "yltäpäätä", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "ylösalaisin", alku: "ylösalaisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppppp"];
[perusmuoto: "ylös", alku: "ylös", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ymmällä", alku: "ymmä", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: ä];
[perusmuoto: "ympäri", alku: "ympäri", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ympäri", alku: "ympäriinsä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ympärillä", alku: "ympäri", luokka: seikkasana, jatko: @ulkopaikallissijat, äs: ä];
[perusmuoto: "ynnä", alku: "ynnä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ypö", alku: "ypö", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "ypöyksin", alku: "ypöyksin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppp=ppppp"];
[perusmuoto: "yöpukusillaan", alku: "yöpukusillaan", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pp=ppppppppppp"];
[perusmuoto: "yöpukusillaan", alku: "yöpukusilleen", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pp=ppppppppppp"];
[perusmuoto: "äkkipikaa", alku: "äkkipikaa", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppp=ppppp"];
[perusmuoto: "äkkiseltä", alku: "äkkiseltä", luokka: seikkasana, jatko: <liitesana, omistusliite, loppu>, äs: ä];
[perusmuoto: "äkkiä", alku: "äkisti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "äkkiä", alku: "äkkiä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "äkkiä", alku: "äkkiänsä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "äkkiä", alku: "äkkiään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>];
[perusmuoto: "äkämyksissään", alku: "äkämyksissään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ällikällä", alku: "ällikällä", luokka: seikkasana, jatko: <loppu>, äs: ä];
[perusmuoto: "äreissään", alku: "äreissään", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "äsken", alku: "äsken", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "äskettäin", alku: "äskettäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "ääneti", alku: "ääneti", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "äärimmillään", alku: "äärimmille", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "äärimmillään", alku: "äärimmillä", luokka: seikkasana, jatko: <omistusliite>, äs: ä];
[perusmuoto: "öisin", alku: "öisin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];

# "-päin"
[perusmuoto: "alaspäin", alku: "alaskaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "alaspäin", alku: "alaskinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "alaspäin", alku: "alaspäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppp"];
[perusmuoto: "allapäin", alku: "allakaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"]; # OK kielitoimiston sanakirjan mukaan
[perusmuoto: "allapäin", alku: "allakinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppp=pppp"]; # OK kielitoimiston sanakirjan mukaan
[perusmuoto: "allapäin", alku: "allapäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppp"]; # OK kielitoimiston sanakirjan mukaan
[perusmuoto: "allapäin", alku: "altakaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"]; # OK kielitoimiston sanakirjan mukaan
[perusmuoto: "allapäin", alku: "altakinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppp=pppp"]; # OK kielitoimiston sanakirjan mukaan
[perusmuoto: "allapäin", alku: "altapäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppp"]; # OK kielitoimiston sanakirjan mukaan
[perusmuoto: "edespäin", alku: "edeskinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "edespäin", alku: "edeskäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "edespäin", alku: "edespäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppp"];
[perusmuoto: "eespäin", alku: "eeskinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=pppppp=pppp"];
[perusmuoto: "eespäin", alku: "eeskäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=ppppppp=pppp"];
[perusmuoto: "eespäin", alku: "eespäin", luokka: seikkasana, jatko: <loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=ppp=pppp"];
[perusmuoto: "eteenpäin", alku: "edeltäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "eteenpäin", alku: "edeltäkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "eteenpäin", alku: "edeltäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "eteenpäin", alku: "edessäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "eteenpäin", alku: "edessäkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "eteenpäin", alku: "edessäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "eteenpäin", alku: "edestäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "eteenpäin", alku: "edestäkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "eteenpäin", alku: "edestäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "eteenpäin", alku: "eteenkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "eteenpäin", alku: "eteenkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "eteenpäin", alku: "eteenpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppp"];
[perusmuoto: "jäljestäpäin", alku: "jäljestäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppppp=pppp"];
[perusmuoto: "jäljestäpäin", alku: "jäljestäkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppppp=pppp"];
[perusmuoto: "jäljestäpäin", alku: "jäljestäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "jälkeenpäin", alku: "jälkeenkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "jälkeenpäin", alku: "jälkeenkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppppp=pppp"];
[perusmuoto: "jälkeenpäin", alku: "jälkeenpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "kotiinpäin", alku: "kotiinkaanpäin", luokka: seikkasana, jatko: <loppu>, äs: a, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "kotiinpäin", alku: "kotiinkinpäin", luokka: seikkasana, jatko: <loppu>, äs: a, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "kotiinpäin", alku: "kotiinpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppppp=pppp"];
[perusmuoto: "kotonapäin", alku: "kotonakinpäin", luokka: seikkasana, jatko: <loppu>, äs: a, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "kotonapäin", alku: "kotonakaanpäin", luokka: seikkasana, jatko: <loppu>, äs: a, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "kotonapäin", alku: "kotonapäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: a, rakenne: "=pppppp=pppp"];
[perusmuoto: "mihinpäin", alku: "mihinkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "mihinpäin", alku: "mihinkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "mihinpäin", alku: "mihinpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppp"];
[perusmuoto: "minnepäin", alku: "minnekinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "minnepäin", alku: "minnekäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "minnepäin", alku: "minnepäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppp"];
[perusmuoto: "missäpäin", alku: "missäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "missäpäin", alku: "missäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "missäpäin", alku: "missäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppp"];
[perusmuoto: "missäpäin", alku: "mistäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "missäpäin", alku: "mistäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "missäpäin", alku: "mistäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppp"];
[perusmuoto: "niinpäin", alku: "niinkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "niinpäin", alku: "niinkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "niinpäin", alku: "niinpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppp"];
[perusmuoto: "nurinpäin", alku: "nurinkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "nurinpäin", alku: "nurinkaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "nurinpäin", alku: "nurinpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppp"];
[perusmuoto: "näinpäin", alku: "näinkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "näinpäin", alku: "näinkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "näinpäin", alku: "näinpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppp"];
[perusmuoto: "oikeinpäin", alku: "oikeinkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "oikeinpäin", alku: "oikeinkaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "oikeinpäin", alku: "oikeinpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "perässäpäin", alku: "perässäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "perässäpäin", alku: "perässäkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppppp=pppp"];
[perusmuoto: "perässäpäin", alku: "perässäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "perässäpäin", alku: "perästäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "perässäpäin", alku: "perästäkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppppp=pppp"];
[perusmuoto: "perässäpäin", alku: "perästäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "perässäpäin", alku: "peräänpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppppp=pppp", tiedot: <ei_voikko>];
[perusmuoto: "poispäin", alku: "poiskaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "poispäin", alku: "poiskinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "poispäin", alku: "poispäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppp"];
[perusmuoto: "päin", alku: "päin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä];
[perusmuoto: "päällepäin", alku: "päällekinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "päällepäin", alku: "päällekäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "päällepäin", alku: "päällepäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "päällepäin", alku: "päältäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "päällepäin", alku: "päältäkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "päällepäin", alku: "päältäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "sielläpäin", alku: "sielläkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "sielläpäin", alku: "sielläkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "sielläpäin", alku: "sielläpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "sielläpäin", alku: "sieltäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "sielläpäin", alku: "sieltäkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "sielläpäin", alku: "sieltäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "sinnepäin", alku: "sinnekinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "sinnepäin", alku: "sinnekäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "sinnepäin", alku: "sinnepäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppp"];
[perusmuoto: "sisäänpäin", alku: "sisäänkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "sisäänpäin", alku: "sisäänkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "sisäänpäin", alku: "sisäänpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "sivullepäin", alku: "sivullekaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppppp=pppp"];
[perusmuoto: "sivullepäin", alku: "sivullekinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "sivullepäin", alku: "sivullepäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "sivullepäin", alku: "sivultakaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppppp=pppp"];
[perusmuoto: "sivullepäin", alku: "sivultakinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "sivullepäin", alku: "sivultapäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "taaksepäin", alku: "taaksekaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "taaksepäin", alku: "taaksekinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "taaksepäin", alku: "taaksepäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "takaapäin", alku: "takaakaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "takaapäin", alku: "takaakinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "takaapäin", alku: "takaapäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppp"];
[perusmuoto: "takaisinpäin", alku: "takaisinkaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppppp=pppp"];
[perusmuoto: "takaisinpäin", alku: "takaisinkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppppp=pppp"];
[perusmuoto: "takaisinpäin", alku: "takaisinpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "takanapäin", alku: "takanakaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "takanapäin", alku: "takanakinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "takanapäin", alku: "takanapäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "toisinpäin", alku: "toisinkaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "toisinpäin", alku: "toisinkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "toisinpäin", alku: "toisinpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "tuollapäin", alku: "tuollakaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "tuollapäin", alku: "tuollakinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "tuollapäin", alku: "tuollapäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "tuollapäin", alku: "tuoltakaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "tuollapäin", alku: "tuoltakinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "tuollapäin", alku: "tuoltapäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "tuonnepäin", alku: "tuonnekaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "tuonnepäin", alku: "tuonnekinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "tuonnepäin", alku: "tuonnepäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "tännepäin", alku: "tännekinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "tännepäin", alku: "tännekäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "tännepäin", alku: "tännepäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppp"];
[perusmuoto: "täälläpäin", alku: "täälläkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "täälläpäin", alku: "täälläkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "täälläpäin", alku: "täälläpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "täälläpäin", alku: "täältäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "täälläpäin", alku: "täältäkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "täälläpäin", alku: "täältäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "ulkoapäin", alku: "ulkoakaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "ulkoapäin", alku: "ulkoakinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "ulkoapäin", alku: "ulkoapäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=ppppp=pppp"];
[perusmuoto: "ulospäin", alku: "uloskaanpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "ulospäin", alku: "uloskinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "ulospäin", alku: "ulospäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppp"];
[perusmuoto: "väärinpäin", alku: "väärinkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppp=pppp"];
[perusmuoto: "väärinpäin", alku: "väärinkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppp=pppp"];
[perusmuoto: "väärinpäin", alku: "väärinpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppp=pppp"];
[perusmuoto: "ylöspäin", alku: "ylöskinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppp=pppp"];
[perusmuoto: "ylöspäin", alku: "ylöskäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppp=pppp"];
[perusmuoto: "ylöspäin", alku: "ylöspäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppp=pppp"];
[perusmuoto: "ylöspäin", alku: "ylhäältäkinpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=ppppppppppp=pppp"];
[perusmuoto: "ylöspäin", alku: "ylhäältäkäänpäin", luokka: seikkasana, jatko: <loppu>, äs: ä, rakenne: "=pppppppppppp=pppp"];
[perusmuoto: "ylöspäin", alku: "ylhäältäpäin", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, rakenne: "=pppppppp=pppp"];

# Nykyään "sydännä" on seikkasana, eikä sydän-nimisanan taivutusmuoto, siksi nämä pitää laittaa erikseen.
[perusmuoto: "kesäsydän", alku: "kesäsydännä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=pppp=ppppppp"];
[perusmuoto: "päiväsydän", alku: "päiväsydännä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=ppppp=ppppppp"];
[perusmuoto: "päiväsydän", alku: "päivä-sydännä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=ppppp-=ppppppp"];
[perusmuoto: "suvisydän", alku: "suvisydännä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=pppp=ppppppp"];
[perusmuoto: "suvisydän", alku: "suvi-sydännä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=pppp-=ppppppp"];
[perusmuoto: "talvisydän", alku: "talvisydännä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=ppppp=ppppppp"];
[perusmuoto: "yösydän", alku: "yösydännä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=pp=ppppppp"];
[perusmuoto: "yösydän", alku: "yö-sydännä", luokka: seikkasana, jatko: <liitesana, loppu>, äs: ä, tiedot: <ei_voikko>, rakenne: "=pp-=ppppppp"];
