/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2007 Canonical Ltd
 * Author: Jonathan Riddell <jriddell @ ubuntu.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <qpixmap.h>
#include <qlayout.h>
#include <qtimer.h>

#include <kanimwidget.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kuniqueapplication.h>

#include "trayicon.h"
#include "strigilineedit.h"

static KCmdLineOptions options[] =
{
    KCmdLineLastOption
};

/*
 A systray applet to search with Strigi
 As with the kicker applet, this searches filesnames only
 It could do with more feedback on the state of the daemon and more control for the user to turn on or off
 This function does the usual KDE app setup, then makes the systray widget and gives it a strigi line edit
*/
int main(int argc, char *argv[])
{

    QString description = i18n("Strigi Desktop Search");

    KAboutData aboutData( "strigiapplet",
                          I18N_NOOP("Strigi Desktop Search"),
                          "0.1",
                          description.latin1(),
                          KAboutData::License_BSD,
                          I18N_NOOP("Copyright (c) 2006 Jos van den Oever, (c) 2007 Canonical Ltd"),
                          0,
                          "http://www.vandenoever.info/software/strigi/");

    aboutData.addAuthor ( "Jos van den Oever",
                          I18N_NOOP("developer"),
                          "jos @ vandenoever.info",
                          "http://www.vandenoever.info/");

    aboutData.addAuthor ( "Jonathan Riddell",
                          I18N_NOOP("developer"),
                          "jriddell @ ubuntu.com",
                          "http://www.kubuntu.org/");

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options );

    KUniqueApplication app;

    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();

    QWidget* widget = new QWidget(0, 0, Qt::WType_Popup);

    TrayIcon* systray = new TrayIcon(widget, 0);
    systray->setPixmap(systray->loadIcon("strigiapplet"));
    systray->show();

    QBoxLayout* layout = new QHBoxLayout(widget);
    KAnimWidget* animatedWidget = new KAnimWidget("kde", 0, widget);

    StrigiLineEdit* strigiLineEdit = new StrigiLineEdit(widget);
    strigiLineEdit->setAnimatedWidget(animatedWidget);
    strigiLineEdit->setAnimatedWidget(animatedWidget);
    widget->resize(strigiLineEdit->sizeHint());
    layout->addWidget(strigiLineEdit);

    layout->addWidget(animatedWidget);
    animatedWidget->hide();

    systray->moveParent();

    return app.exec();
}
