.TH saned 8 "20 Apr 2009" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX saned
.SH NAME
saned \- SANE network daemon
.SH SYNOPSIS
.B saned
.B [ \-a 
.I [ username ]
.B | \-d 
.I [ n ]
.B  | \-s
.I [ n ]
.B ]
.SH DESCRIPTION
.B saned
is the SANE (Scanner Access Now Easy) daemon that allows remote clients
to access image acquisition devices available on the local host.
.SH OPTIONS
.PP
The
.B \-a
flag requests that
.B saned
run in standalone daemon mode. In this mode, 
.B saned
will detach from the console and run in the background, listening for incoming
client connections; 
.B inetd
is not required for
.B saned
operations in this mode. If the optional
.B username
is given after
.B \-a
,
.B saned
will drop root privileges and run as this user (and group).
.PP
The
.B \-d
and
.B \-s
flags request that
.B saned
run in debug mode (as opposed to
.BR inetd (8)
mode).  In this mode,
.B saned
explicitly waits for a connection request.  When compiled with
debugging enabled, these flags may be followed by a number to request
debug info. The larger the number, the more verbose the debug output.
E.g.,
.B \-d128
will request printing of all debug info. Debug level 0 means no debug output
at all. The default value is 2. If flag
.B \-d
is used, the debug messages will be printed to stderr while
.B \-s
requests using syslog.
.PP
If 
.B saned
is run from inetd or xinetd, no option can be given.
.SH CONFIGURATION
First and foremost: 
.B saned
is not intended to be exposed to the internet or other non-trusted
networks. Make sure that access is limited by tcpwrappers and/or a firewall
setup. Don't depend only on 
.BR saned 's
own authentification. Don't run
.B saned
as root if it's not necessary. And do
.B not
install
.B saned
as setuid root.
.PP
The 
.I saned.conf
configuration file contains both options for the daemon and the access
list.
.TP
\fBdata_portrange\fP = \fImin_port\fP - \fImax_port\fP
Specify the port range to use for the data connection. Pick a port
range between 1024 and 65535; don't pick a too large port range, as it
may have performance issues. Use this option if your \fBsaned\fP
server is sitting behind a firewall. If that firewall is a Linux
machine, we strongly recommend using the Netfilter
\fInf_conntrack_sane\fP module instead.
.PP
The access list is a list of host names, IP addresses or IP subnets
(CIDR notation) that are permitted to use local SANE devices. IPv6
addresses must be enclosed in brackets, and should always be specified
in their compressed form. Connections from localhost are always
permitted. Empty lines and lines starting with a hash mark (#) are
ignored. A line containing the single character ``+'' is interpreted
to match any hostname. This allows any remote machine to use your
scanner and may present a security risk, so this shouldn't be used
unless you know what you're doing.
.PP
A sample configuration file is shown below:
.PP
.RS
# Daemon options
.br
data_portrange = 10000 - 10100
.br
# Access list
.br
scan\-client.somedomain.firm
.br
# this is a comment
.br
192.168.0.1
.br
192.168.2.12/29
.br
[::1]
.br
[2001:7a8:185e::42:12]/64
.RE
.PP
The case of the host names does not matter, so AHost.COM is considered
identical to ahost.com.
.SH INETD CONFIGURATION
For
.B saned
to work properly in its default mode of operation, it is also necessary to add
a configuration line to
.IR /etc/inetd.conf .
Note that your inetd must support IPv6 if you
want to connect to saned over IPv6 ; xinetd and openbsd-inetd are known to
support IPv6, check the documentation for your inetd daemon.
.PP
The configuration line normally looks like this:
.PP
.RS
sane\-port stream tcp nowait saned.saned @SBINDIR@/saned saned
.RE
.PP
However, if your system uses
.BR tcpd (8)
for additional security screening, you may want to disable saned
access control by putting ``+'' in
.IR saned.conf
and use a line of the following form in
.IR /etc/inetd.conf
instead:
.PP
.RS
sane\-port stream tcp nowait saned.saned /usr/sbin/tcpd @SBINDIR@/saned
.RE
.PP
Note that both examples assume that there is a
.B saned
group and a
.B saned
user.  If you follow this example, please make sure that the 
access permissions on the special device are set such that
.B saned
can access the scanner (the program generally needs read and
write access to scanner devices).
.PP
If xinetd is installed on your system instead of inetd the following example
for xinetd.conf may be helpful:
.PP
.RS
.ft CR
.nf
# default: off
# description: The sane server accepts requests 
# for network access to a local scanner via the
# network.
service sane\-port
{
   port        = 6566
   socket_type = stream
   wait        = no
   user        = saned
   group       = saned
   server      = @SBINDIR@/saned
}
.fi
.ft R
.RE
.PP
Finally, it is also necessary to add a line of the following form to
.IR /etc/services :
.PP
.RS
sane\-port 6566/tcp # SANE network scanner daemon
.RE
.PP
The official IANA short name for port 6566 is "sane\-port". The older name "sane"
is now deprecated.

.SH FILES
.TP
.I /etc/hosts.equiv
The hosts listed in this file are permitted to access all local SANE
devices.  Caveat: this file imposes serious security risks and its use
is not recommended.
.TP
.I @CONFIGDIR@/saned.conf
Contains a list of hosts permitted to access local SANE devices (see
also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @CONFIGDIR@/saned.users
If this file contains lines of the form

user:password:backend

access to the listed backends is restricted. A backend may be listed multiple
times for different user/password combinations. The server uses MD5 hashing
if supported by the client.
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).

.SH "SEE ALSO"
.BR sane (7),
.BR scanimage (1),
.BR xscanimage (1),
.BR xcam (1),
.BR sane\-dll (5),
.BR sane\-net (5),
.BR sane\-"backendname" (5)
.br
.I http://www.penguin-breeder.org/?page=sane\-net
.SH AUTHOR
David Mosberger
