#! /bin/sh

PATH=/sbin:/bin/:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/readahead
NAME=readahead
FILES=/etc/readahead/readahead

test -x $DAEMON || exit 0

. /lib/lsb/init-functions

set -e

case "$1" in
        start|restart|force-reload)
                log_begin_msg "Reading desktop files..."
                $DAEMON `cat $FILES` &
                log_end_msg 0
                ;;
        stop)
                /usr/sbin/readahead-fileordering < /etc/readahead/readahead > /etc/readahead/readahead.new
                cp -f /etc/readahead/readahead.new /etc/readahead/readahead
                ;;
        *)
                log_success_msg "Usage: $0 {start|stop|restart|force-reload}" >&2
                ;;
esac

exit 0
