/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

#include <QtTest/QtTest>
#include <QStringList>
#include <QLocale>
#include <sqldb.h>

#include "ut_cntsqlsearch.h"
#include "cntsqlsearch.h"
#include "cqwertykeymap.h"
#include "c12keykeymap.h"

#define WRITE_LOGS
#define SQL_QT_TEST

#if defined(WRITE_LOGS)
#include <e32debug.h> // RDebug

#define LOG(a)              WriteLog(a, "")
#define LOG2(a, b)          WriteLog(a, b)
#define TEST_BEGIN_LOG(a)   LOG(a##" begins")
#define TEST_PASSED_LOG(a)  LOG(a##" passed")

void WriteLog(const QString a, const QString b);
void WritePart(const TDesC& s);
#else
#define LOG(a)
#define LOG2(a, b)
#define TEST_BEGIN_LOG(a)
#define TEST_PASSED_LOG(a)
#endif


void UT_CntSqlSearch::initTestCase()
{
}

void UT_CntSqlSearch::cleanupTestCase()
{
}


void UT_CntSqlSearch::init()
{   
    m12KeyKeyMap = C12keyKeyMap::NewL();
    mQwertyKeyMap = CQwertyKeyMap::NewL();
    mCntSqlSearch = new CntSqlSearch( *m12KeyKeyMap, *mQwertyKeyMap );
}

void UT_CntSqlSearch::cleanup()
{
    delete m12KeyKeyMap;
    delete mQwertyKeyMap;
    delete mCntSqlSearch;
    
}
void UT_CntSqlSearch::testPredictiveSearch()
{
    TEST_BEGIN_LOG("testPredictiveSearch");
    
    QString pattern = QString("205");
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>145522562959409151 AND nbr<145804037936119808) AND NOT(nbr2>145522562959409151 AND nbr2<145804037936119808) AND NOT(nbr3>145522562959409151 AND nbr3<145804037936119808) AND NOT(nbr4>145522562959409151 AND nbr4<145804037936119808))) AND NOT(NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>360287970189639679 AND nbr3<432345564227567616)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch2 WHERE \
((nbr>145522562959409151 AND nbr<145804037936119808) OR (nbr2>145522562959409151 AND nbr2<145804037936119808) \
OR (nbr3>145522562959409151 AND nbr3<145804037936119808) OR (nbr4>145522562959409151 AND nbr4<145804037936119808)) OR \
(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>144115188075855871 AND nbr3<216172782113783808) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>360287970189639679 AND nbr3<432345564227567616) \
ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#endif // #if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE) 
    QString reference("SELECT predictivesearch2.contact_id FROM predictivesearch2 WHERE EXISTS (SELECT contact_id FROM predictivesearch5 WHERE predictivesearch2.contact_id = predictivesearch5.contact_id) OR (SELECT contact_id FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>145522562959409151 AND predictivesearch2.nbr<145804037936119808) AND NOT(predictivesearch2.nbr2>145522562959409151 AND predictivesearch2.nbr2<145804037936119808) AND NOT(predictivesearch2.nbr3>145522562959409151 AND predictivesearch2.nbr3<145804037936119808) AND NOT(predictivesearch2.nbr4>145522562959409151 AND predictivesearch2.nbr4<145804037936119808)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    QString result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << "-> result" << result;
    LOG2(pattern, result);
    LOG2(QString("Reference"), reference);
    QVERIFY(!result.compare(reference));
    
    pattern = QString("101");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch1 WHERE NOT(NOT(NOT(NOT(nbr>72339069014638591 AND nbr<72620543991349248) AND NOT(nbr2>72339069014638591 AND nbr2<72620543991349248) AND NOT(nbr3>72339069014638591 AND nbr3<72620543991349248) AND NOT(nbr4>72339069014638591 AND nbr4<72620543991349248))) AND NOT(NOT(NOT(nbr2>72057594037927935 AND nbr2<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr3>72057594037927935 AND nbr3<144115188075855872)))) ORDER BY predictivesearch1.first_name, predictivesearch1.last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch1 WHERE ((nbr>72339069014638591 AND nbr<72620543991349248) OR (nbr2>72339069014638591 AND nbr2<72620543991349248) OR (nbr3>72339069014638591 AND nbr3<72620543991349248) OR (nbr4>72339069014638591 AND nbr4<72620543991349248)) OR (nbr2>72057594037927935 AND nbr2<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) OR (nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) OR (nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr2>72057594037927935 AND nbr2<144115188075855872) OR (nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) OR (nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr2>72057594037927935 AND nbr2<144115188075855872) OR (nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr3>72057594037927935 AND nbr3<144115188075855872) ORDER BY predictivesearch1.first_name, predictivesearch1.last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString("202");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144678138029277183 AND nbr<144959613005987840) AND NOT(nbr2>144678138029277183 AND nbr2<144959613005987840) AND NOT(nbr3>144678138029277183 AND nbr3<144959613005987840) AND NOT(nbr4>144678138029277183 AND nbr4<144959613005987840))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>144115188075855871 AND nbr3<216172782113783808)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else
    reference = QString("TODO");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);    
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    //QVERIFY(!result.compare(reference));
        
    pattern = QString("25");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE (NOT(NOT(nbr>166633186212708351 AND nbr<171136785840078848) AND NOT(nbr2>166633186212708351 AND nbr2<171136785840078848) AND NOT(nbr3>166633186212708351 AND nbr3<171136785840078848) AND NOT(nbr4>166633186212708351 AND nbr4<171136785840078848))) ORDER BY first_name, last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE (NOT(NOT(nbr>166633186212708351 AND nbr<171136785840078848) AND NOT(nbr2>166633186212708351 AND nbr2<171136785840078848) AND NOT(nbr3>166633186212708351 AND nbr3<171136785840078848) AND NOT(nbr4>166633186212708351 AND nbr4<171136785840078848))) ORDER BY first_name, last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare( reference));


    pattern = QString("56606");
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch5 WHERE NOT(NOT(NOT(NOT(nbr>389005014883893247 AND nbr<389006114395521024) AND NOT(nbr2>389005014883893247 AND nbr2<389006114395521024) AND NOT(nbr3>389005014883893247 AND nbr3<389006114395521024) AND NOT(nbr4>389005014883893247 AND nbr4<389006114395521024))) AND NOT(NOT(NOT(nbr2>432345564227567615 AND nbr2<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) AND NOT(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) AND NOT(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr2>388998417814126591 AND nbr2<389279892790837248) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr2>388998417814126591 AND nbr2<389279892790837248) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr3>388998417814126591 AND nbr3<389279892790837248))) AND NOT(NOT(NOT(nbr2>388998417814126591 AND nbr2<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr3>388998417814126591 AND nbr3<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr3>388998417814126591 AND nbr3<389279892790837248 AND nbr2>432345564227567615 AND nbr2<504403158265495552) AND NOT(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr2>432345564227567615 AND nbr2<504403158265495552) AND NOT(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr3>432345564227567615 AND nbr3<504403158265495552)))) ORDER BY predictivesearch5.first_name, predictivesearch5.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch5 WHERE \
((nbr>389005014883893247 AND nbr<389006114395521024) OR (nbr2>389005014883893247 AND nbr2<389006114395521024) OR \
(nbr3>389005014883893247 AND nbr3<389006114395521024) OR (nbr4>389005014883893247 AND nbr4<389006114395521024)) OR \
(nbr2>432345564227567615 AND nbr2<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) OR \
(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) OR \
(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr2>388998417814126591 AND nbr2<389279892790837248) OR \
(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) OR \
(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr2>388998417814126591 AND nbr2<389279892790837248) OR \
(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr3>388998417814126591 AND nbr3<389279892790837248) OR \
(nbr2>388998417814126591 AND nbr2<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) OR \
(nbr3>388998417814126591 AND nbr3<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) OR \
(nbr3>388998417814126591 AND nbr3<389279892790837248 AND nbr2>432345564227567615 AND nbr2<504403158265495552) OR \
(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) OR \
(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr2>432345564227567615 AND nbr2<504403158265495552) OR \
(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr3>432345564227567615 AND nbr3<504403158265495552) \
ORDER BY predictivesearch5.first_name, predictivesearch5.last_name ASC;");
#endif //#if defined(USE_DEMORGAN) 
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE (NOT(NOT(predictivesearch5.nbr>389005014883893247 AND predictivesearch5.nbr<389006114395521024) AND NOT(predictivesearch5.nbr2>389005014883893247 AND predictivesearch5.nbr2<389006114395521024) AND NOT(predictivesearch5.nbr3>389005014883893247 AND predictivesearch5.nbr3<389006114395521024) AND NOT(predictivesearch5.nbr4>389005014883893247 AND predictivesearch5.nbr4<389006114395521024))) UNION SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 JOIN predictivesearch6 ON predictivesearch5.contact_id = predictivesearch6.contact_id WHERE(NOT(NOT(predictivesearch5.nbr>388998417814126591 AND predictivesearch5.nbr<389279892790837248) AND NOT(predictivesearch5.nbr2>388998417814126591 AND predictivesearch5.nbr2<389279892790837248) AND NOT(predictivesearch5.nbr3>388998417814126591 AND predictivesearch5.nbr3<389279892790837248) AND NOT(predictivesearch5.nbr4>388998417814126591 AND predictivesearch5.nbr4<389279892790837248)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );

    pattern = QString("3");
    reference = QString ("SELECT contact_id FROM predictivesearch3 ORDER BY first_name, last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    
    pattern = QString("0");
    reference = QString ("SELECT contact_id FROM predictivesearch0 ORDER BY first_name, last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare( reference));

    // TODO: Test this case on HW and verify leading zeros.
    pattern.clear();
    pattern = "0705";
    #if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch7.contact_id, predictivesearch7.first_name, predictivesearch7.last_name FROM predictivesearch7 WHERE ((NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>504403158265495551 AND nbr3<576460752303423488))) OR(NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>360287970189639679 AND nbr3<432345564227567616)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>31613158321815551 AND predictivesearch0.nbr<31630750507859968) AND NOT(predictivesearch0.nbr2>31613158321815551 AND predictivesearch0.nbr2<31630750507859968) AND NOT(predictivesearch0.nbr3>31613158321815551 AND predictivesearch0.nbr3<31630750507859968) AND NOT(predictivesearch0.nbr4>31613158321815551 AND predictivesearch0.nbr4<31630750507859968)))) OR(NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>31525197391593471 AND nbr<36028797018963968) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>31525197391593471 AND nbr<36028797018963968) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>31525197391593471 AND nbr2<36028797018963968) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>31525197391593471 AND nbr<36028797018963968) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>31525197391593471 AND nbr2<36028797018963968) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>31525197391593471 AND nbr3<36028797018963968))) OR(NOT(NOT(nbr2>31525197391593471 AND nbr2<36028797018963968 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>31525197391593471 AND nbr3<36028797018963968 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>31525197391593471 AND nbr3<36028797018963968 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>31525197391593471 AND nbr4<36028797018963968 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>31525197391593471 AND nbr4<36028797018963968 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>31525197391593471 AND nbr4<36028797018963968 AND nbr3>360287970189639679 AND nbr3<432345564227567616)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else // #if defined(USE_DEMORGAN)

#endif //#if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE (NOT(NOT(predictivesearch0.nbr>31613158321815551 AND predictivesearch0.nbr<31630750507859968) AND NOT(predictivesearch0.nbr2>31613158321815551 AND predictivesearch0.nbr2<31630750507859968) AND NOT(predictivesearch0.nbr3>31613158321815551 AND predictivesearch0.nbr3<31630750507859968) AND NOT(predictivesearch0.nbr4>31613158321815551 AND predictivesearch0.nbr4<31630750507859968))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 JOIN predictivesearch5 ON predictivesearch0.contact_id = predictivesearch5.contact_id WHERE(NOT(NOT(predictivesearch0.nbr>31525197391593471 AND predictivesearch0.nbr<36028797018963968) AND NOT(predictivesearch0.nbr2>31525197391593471 AND predictivesearch0.nbr2<36028797018963968) AND NOT(predictivesearch0.nbr3>31525197391593471 AND predictivesearch0.nbr3<36028797018963968) AND NOT(predictivesearch0.nbr4>31525197391593471 AND predictivesearch0.nbr4<36028797018963968)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)

    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    LOG2(pattern, result);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY(!result.compare(reference));
    
    pattern.clear();
    pattern = "4301";  
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch4 WHERE NOT(NOT(NOT(NOT(nbr>301758767219867647 AND nbr<301776359405912064) AND NOT(nbr2>301758767219867647 AND nbr2<301776359405912064) AND NOT(nbr3>301758767219867647 AND nbr3<301776359405912064) AND NOT(nbr4>301758767219867647 AND nbr4<301776359405912064))) AND NOT(NOT(NOT(nbr2>72057594037927935 AND nbr2<144115188075855872 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr3>301741175033823231 AND nbr3<306244774661193728))) AND NOT(NOT(NOT(nbr2>301741175033823231 AND nbr2<306244774661193728 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr3>72057594037927935 AND nbr3<144115188075855872)))) ORDER BY predictivesearch4.first_name, predictivesearch4.last_name ASC;");
#else // #if defined(USE_DEMORGAN)

#endif //#if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch4.contact_id, predictivesearch4.first_name, predictivesearch4.last_name FROM predictivesearch4 WHERE (NOT(NOT(predictivesearch4.nbr>301758767219867647 AND predictivesearch4.nbr<301776359405912064) AND NOT(predictivesearch4.nbr2>301758767219867647 AND predictivesearch4.nbr2<301776359405912064) AND NOT(predictivesearch4.nbr3>301758767219867647 AND predictivesearch4.nbr3<301776359405912064) AND NOT(predictivesearch4.nbr4>301758767219867647 AND predictivesearch4.nbr4<301776359405912064))) UNION SELECT predictivesearch4.contact_id, predictivesearch4.first_name, predictivesearch4.last_name FROM predictivesearch4 JOIN predictivesearch1 ON predictivesearch4.contact_id = predictivesearch1.contact_id WHERE(NOT(NOT(predictivesearch4.nbr>301741175033823231 AND predictivesearch4.nbr<306244774661193728) AND NOT(predictivesearch4.nbr2>301741175033823231 AND predictivesearch4.nbr2<306244774661193728) AND NOT(predictivesearch4.nbr3>301741175033823231 AND predictivesearch4.nbr3<306244774661193728) AND NOT(predictivesearch4.nbr4>301741175033823231 AND predictivesearch4.nbr4<306244774661193728)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern.clear();
    pattern = "4304";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch4 WHERE NOT(NOT(NOT(NOT(nbr>301811543778000895 AND nbr<301829135964045312) AND NOT(nbr2>301811543778000895 AND nbr2<301829135964045312) AND NOT(nbr3>301811543778000895 AND nbr3<301829135964045312) AND NOT(nbr4>301811543778000895 AND nbr4<301829135964045312))) AND NOT(NOT(NOT(nbr2>288230376151711743 AND nbr2<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>288230376151711743 AND nbr3<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>288230376151711743 AND nbr3<360287970189639680 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr3>301741175033823231 AND nbr3<306244774661193728))) AND NOT(NOT(NOT(nbr2>301741175033823231 AND nbr2<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr2>288230376151711743 AND nbr2<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr2>288230376151711743 AND nbr2<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr3>288230376151711743 AND nbr3<360287970189639680)))) ORDER BY predictivesearch4.first_name, predictivesearch4.last_name ASC;");
#else
	//TODO:
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

	pattern.clear();
    pattern = "4043";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch4 WHERE NOT(NOT(NOT(NOT(nbr>289409052616687615 AND nbr<289426644802732032) AND NOT(nbr2>289409052616687615 AND nbr2<289426644802732032) AND NOT(nbr3>289409052616687615 AND nbr3<289426644802732032) AND NOT(nbr4>289409052616687615 AND nbr4<289426644802732032))) AND NOT(NOT(NOT(nbr2>301741175033823231 AND nbr2<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr2>288230376151711743 AND nbr2<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr2>288230376151711743 AND nbr2<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr3>288230376151711743 AND nbr3<360287970189639680))) AND NOT(NOT(NOT(nbr2>288230376151711743 AND nbr2<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>288230376151711743 AND nbr3<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>288230376151711743 AND nbr3<360287970189639680 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr3>301741175033823231 AND nbr3<306244774661193728)))) ORDER BY predictivesearch4.first_name, predictivesearch4.last_name ASC;");
#else
	//TODO:
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString("03");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch3.contact_id, predictivesearch3.first_name, predictivesearch3.last_name FROM predictivesearch3 UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>13510798882111487 AND predictivesearch0.nbr<18014398509481984) AND NOT(predictivesearch0.nbr2>13510798882111487 AND predictivesearch0.nbr2<18014398509481984) AND NOT(predictivesearch0.nbr3>13510798882111487 AND predictivesearch0.nbr3<18014398509481984) AND NOT(predictivesearch0.nbr4>13510798882111487 AND predictivesearch0.nbr4<18014398509481984))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE (nbr>13510798882111487 AND nbr<18014398509481984) OR (nbr2>13510798882111487 AND nbr2<18014398509481984) OR (nbr3>13510798882111487 AND nbr3<18014398509481984) OR (nbr4>13510798882111487 AND nbr4<18014398509481984) ORDER BY first_name, last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    LOG2(pattern, result);
    QVERIFY(!result.compare( reference));

    // Empty pattern
    pattern = QString("");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result.length() == 0);
        
    // Too long pattern (16 digits)
    pattern = QString("0123456789012345");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result.length() == 0);

    pattern = QString("0000000000000000"); // 16 zeros
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result.length() == 0);
    
    // Full of zeros
    pattern = QString("000000000000000"); // 15 zeros
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE (NOT(NOT(nbr>-1 AND nbr<1) AND NOT(nbr2>-1 AND nbr2<1) AND NOT(nbr3>-1 AND nbr3<1) AND NOT(nbr4>-1 AND nbr4<1))) ORDER BY first_name, last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE (nbr>-1 AND nbr<1) OR (nbr2>-1 AND nbr2<1) OR (nbr3>-1 AND nbr3<1) OR (nbr4>-1 AND nbr4<1) ORDER BY first_name, last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));
    
    // Full of nines
    pattern = QString("999999999999999"); // 15 nines
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch9 WHERE (NOT(NOT(nbr>691752902764108184 AND nbr<691752902764108186) AND NOT(nbr2>691752902764108184 AND nbr2<691752902764108186) AND NOT(nbr3>691752902764108184 AND nbr3<691752902764108186) AND NOT(nbr4>691752902764108184 AND nbr4<691752902764108186))) ORDER BY first_name, last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch9 WHERE (nbr>691752902764108184 AND nbr<691752902764108186) OR (nbr2>691752902764108184 AND nbr2<691752902764108186) OR (nbr3>691752902764108184 AND nbr3<691752902764108186) OR (nbr4>691752902764108184 AND nbr4<691752902764108186) ORDER BY first_name, last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    // Leading zeros
    pattern = QString("001100");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch1.contact_id, predictivesearch1.first_name, predictivesearch1.last_name FROM predictivesearch1 WHERE ((NOT(NOT(predictivesearch1.nbr>76561193665298431 AND predictivesearch1.nbr<81064793292668928) AND NOT(predictivesearch1.nbr2>76561193665298431 AND predictivesearch1.nbr2<81064793292668928) AND NOT(predictivesearch1.nbr3>76561193665298431 AND predictivesearch1.nbr3<81064793292668928) AND NOT(predictivesearch1.nbr4>76561193665298431 AND predictivesearch1.nbr4<81064793292668928)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>299067162755071 AND predictivesearch0.nbr<316659348799488) AND NOT(predictivesearch0.nbr2>299067162755071 AND predictivesearch0.nbr2<316659348799488) AND NOT(predictivesearch0.nbr3>299067162755071 AND predictivesearch0.nbr3<316659348799488) AND NOT(predictivesearch0.nbr4>299067162755071 AND predictivesearch0.nbr4<316659348799488))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE (nbr>299067162755071 AND nbr<299135882231808) OR (nbr2>299067162755071 AND nbr2<299135882231808) OR (nbr3>299067162755071 AND nbr3<299135882231808) OR (nbr4>299067162755071 AND nbr4<299135882231808) ORDER BY first_name, last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    LOG2(pattern, result);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY(!result.compare(reference));
    
    pattern = QString("43043");
    reference = QString("SELECT contact_id FROM predictivesearch4 WHERE NOT(NOT(NOT(NOT(nbr>301814842312884223 AND nbr<301815941824512000) AND NOT(nbr2>301814842312884223 AND nbr2<301815941824512000) AND NOT(nbr3>301814842312884223 AND nbr3<301815941824512000) AND NOT(nbr4>301814842312884223 AND nbr4<301815941824512000))) AND NOT(NOT(NOT(nbr2>301741175033823231 AND nbr2<306244774661193728 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr3>301741175033823231 AND nbr3<306244774661193728)))) ORDER BY predictivesearch4.first_name, predictivesearch4.last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString("0020030");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE ((NOT(NOT(nbr2>216172782113783807 AND nbr2<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>216172782113783807 AND nbr3<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>216172782113783807 AND nbr3<288230376151711744 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) OR(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>216172782113783807 AND nbr2<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>216172782113783807 AND nbr2<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>216172782113783807 AND nbr3<288230376151711744)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>563156111851519 AND predictivesearch0.nbr<563224831328256) AND NOT(predictivesearch0.nbr2>563156111851519 AND predictivesearch0.nbr2<563224831328256) AND NOT(predictivesearch0.nbr3>563156111851519 AND predictivesearch0.nbr3<563224831328256) AND NOT(predictivesearch0.nbr4>563156111851519 AND predictivesearch0.nbr4<563224831328256)))) OR(NOT(NOT(nbr2>216172782113783807 AND nbr2<220676381741154304 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>216172782113783807 AND nbr3<220676381741154304 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>216172782113783807 AND nbr3<220676381741154304 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>216172782113783807 AND nbr4<220676381741154304 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr4>216172782113783807 AND nbr4<220676381741154304 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>216172782113783807 AND nbr4<220676381741154304 AND nbr3>562949953421311 AND nbr3<844424930131968))) OR(NOT(NOT(nbr2>562949953421311 AND nbr2<844424930131968 AND nbr>216172782113783807 AND nbr<220676381741154304) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr>216172782113783807 AND nbr<220676381741154304) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr2>216172782113783807 AND nbr2<220676381741154304) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr>216172782113783807 AND nbr<220676381741154304) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr2>216172782113783807 AND nbr2<220676381741154304) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr3>216172782113783807 AND nbr3<220676381741154304)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    //LOG2(pattern, result);
    QVERIFY(!result.compare(reference));
    
    pattern = QString("00430001020");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch4.contact_id, predictivesearch4.first_name, predictivesearch4.last_name FROM predictivesearch4 WHERE ((NOT(NOT(nbr2>72620543991349247 AND nbr2<72902018968059904 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>72620543991349247 AND nbr3<72902018968059904 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>72620543991349247 AND nbr3<72902018968059904 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>72620543991349247 AND nbr4<72902018968059904 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr4>72620543991349247 AND nbr4<72902018968059904 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>72620543991349247 AND nbr4<72902018968059904 AND nbr3>301741175033823231 AND nbr3<306244774661193728))) OR(NOT(NOT(nbr2>301741175033823231 AND nbr2<306244774661193728 AND nbr>72620543991349247 AND nbr<72902018968059904) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr>72620543991349247 AND nbr<72902018968059904) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr2>72620543991349247 AND nbr2<72902018968059904) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr>72620543991349247 AND nbr<72902018968059904) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr2>72620543991349247 AND nbr2<72902018968059904) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr3>72620543991349247 AND nbr3<72902018968059904)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>1178676735508479 AND predictivesearch0.nbr<1178676736557056) AND NOT(predictivesearch0.nbr2>1178676735508479 AND predictivesearch0.nbr2<1178676736557056) AND NOT(predictivesearch0.nbr3>1178676735508479 AND predictivesearch0.nbr3<1178676736557056) AND NOT(predictivesearch0.nbr4>1178676735508479 AND predictivesearch0.nbr4<1178676736557056)))) OR(NOT(NOT(nbr2>72620543991349247 AND nbr2<72638136177393664 AND nbr>1178676464975871 AND nbr<1196268651020288) AND NOT(nbr3>72620543991349247 AND nbr3<72638136177393664 AND nbr>1178676464975871 AND nbr<1196268651020288) AND NOT(nbr3>72620543991349247 AND nbr3<72638136177393664 AND nbr2>1178676464975871 AND nbr2<1196268651020288) AND NOT(nbr4>72620543991349247 AND nbr4<72638136177393664 AND nbr>1178676464975871 AND nbr<1196268651020288) AND NOT(nbr4>72620543991349247 AND nbr4<72638136177393664 AND nbr2>1178676464975871 AND nbr2<1196268651020288) AND NOT(nbr4>72620543991349247 AND nbr4<72638136177393664 AND nbr3>1178676464975871 AND nbr3<1196268651020288))) OR(NOT(NOT(nbr2>1178676464975871 AND nbr2<1196268651020288 AND nbr>72620543991349247 AND nbr<72638136177393664) AND NOT(nbr3>1178676464975871 AND nbr3<1196268651020288 AND nbr>72620543991349247 AND nbr<72638136177393664) AND NOT(nbr3>1178676464975871 AND nbr3<1196268651020288 AND nbr2>72620543991349247 AND nbr2<72638136177393664) AND NOT(nbr4>1178676464975871 AND nbr4<1196268651020288 AND nbr>72620543991349247 AND nbr<72638136177393664) AND NOT(nbr4>1178676464975871 AND nbr4<1196268651020288 AND nbr2>72620543991349247 AND nbr2<72638136177393664) AND NOT(nbr4>1178676464975871 AND nbr4<1196268651020288 AND nbr3>72620543991349247 AND nbr3<72638136177393664)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //LOG2(pattern, result);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY(!result.compare(reference));
    
    pattern = QString("227264583788306"); // 15 digits
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>155134792167883525 AND nbr<155134792167883527) AND NOT(nbr2>155134792167883525 AND nbr2<155134792167883527) AND NOT(nbr3>155134792167883525 AND nbr3<155134792167883527) AND NOT(nbr4>155134792167883525 AND nbr4<155134792167883527))) AND NOT(NOT(NOT(nbr2>432345564227567615 AND nbr2<504403158265495552 AND nbr>155134792167883519 AND nbr<155134792167883776) AND NOT(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr>155134792167883519 AND nbr<155134792167883776) AND NOT(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr2>155134792167883519 AND nbr2<155134792167883776) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr>155134792167883519 AND nbr<155134792167883776) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr2>155134792167883519 AND nbr2<155134792167883776) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr3>155134792167883519 AND nbr3<155134792167883776))) AND NOT(NOT(NOT(nbr2>155134792167883519 AND nbr2<155134792167883776 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr3>155134792167883519 AND nbr3<155134792167883776 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr3>155134792167883519 AND nbr3<155134792167883776 AND nbr2>432345564227567615 AND nbr2<504403158265495552) AND NOT(nbr4>155134792167883519 AND nbr4<155134792167883776 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr4>155134792167883519 AND nbr4<155134792167883776 AND nbr2>432345564227567615 AND nbr2<504403158265495552) AND NOT(nbr4>155134792167883519 AND nbr4<155134792167883776 AND nbr3>432345564227567615 AND nbr3<504403158265495552)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));
 
    pattern = QString("34096");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch3 WHERE NOT(NOT(NOT(NOT(nbr>234352107367432191 AND nbr<234353206879059968) AND NOT(nbr2>234352107367432191 AND nbr2<234353206879059968) AND NOT(nbr3>234352107367432191 AND nbr3<234353206879059968) AND NOT(nbr4>234352107367432191 AND nbr4<234353206879059968))) AND NOT(NOT(NOT(nbr2>675539944105574399 AND nbr2<680043543732944896 AND nbr>234187180623265791 AND nbr<238690780250636288) AND NOT(nbr3>675539944105574399 AND nbr3<680043543732944896 AND nbr>234187180623265791 AND nbr<238690780250636288) AND NOT(nbr3>675539944105574399 AND nbr3<680043543732944896 AND nbr2>234187180623265791 AND nbr2<238690780250636288) AND NOT(nbr4>675539944105574399 AND nbr4<680043543732944896 AND nbr>234187180623265791 AND nbr<238690780250636288) AND NOT(nbr4>675539944105574399 AND nbr4<680043543732944896 AND nbr2>234187180623265791 AND nbr2<238690780250636288) AND NOT(nbr4>675539944105574399 AND nbr4<680043543732944896 AND nbr3>234187180623265791 AND nbr3<238690780250636288))) AND NOT(NOT(NOT(nbr2>234187180623265791 AND nbr2<238690780250636288 AND nbr>675539944105574399 AND nbr<680043543732944896) AND NOT(nbr3>234187180623265791 AND nbr3<238690780250636288 AND nbr>675539944105574399 AND nbr<680043543732944896) AND NOT(nbr3>234187180623265791 AND nbr3<238690780250636288 AND nbr2>675539944105574399 AND nbr2<680043543732944896) AND NOT(nbr4>234187180623265791 AND nbr4<238690780250636288 AND nbr>675539944105574399 AND nbr<680043543732944896) AND NOT(nbr4>234187180623265791 AND nbr4<238690780250636288 AND nbr2>675539944105574399 AND nbr2<680043543732944896) AND NOT(nbr4>234187180623265791 AND nbr4<238690780250636288 AND nbr3>675539944105574399 AND nbr3<680043543732944896)))) ORDER BY predictivesearch3.first_name, predictivesearch3.last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

	pattern = QString("522000000000007"); // 15 digits
#if defined(USE_DEMORGAN)
	reference = QString("SELECT contact_id FROM predictivesearch5 WHERE NOT(NOT(NOT(NOT(nbr>369858119397801990 AND nbr<369858119397801992) AND NOT(nbr2>369858119397801990 AND nbr2<369858119397801992) AND NOT(nbr3>369858119397801990 AND nbr3<369858119397801992) AND NOT(nbr4>369858119397801990 AND nbr4<369858119397801992))) AND NOT(NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>369858119397801983 AND nbr3<370139594374512640))) AND NOT(NOT(NOT(nbr2>369858119397801983 AND nbr2<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) ORDER BY predictivesearch5.first_name, predictivesearch5.last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString("20");
#if defined(USE_DEMORGAN)
        reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808))) AND NOT(NOT(NOT(nbr>144115188075855871 AND nbr<148618787703226368) AND NOT(nbr2>144115188075855871 AND nbr2<148618787703226368) AND NOT(nbr3>144115188075855871 AND nbr3<148618787703226368) AND NOT(nbr4>144115188075855871 AND nbr4<148618787703226368)))) ORDER BY first_name, last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString("200");
#if defined(USE_DEMORGAN)
        reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808))) AND NOT(NOT(NOT(nbr>144115188075855871 AND nbr<144396663052566528) AND NOT(nbr2>144115188075855871 AND nbr2<144396663052566528) AND NOT(nbr3>144115188075855871 AND nbr3<144396663052566528) AND NOT(nbr4>144115188075855871 AND nbr4<144396663052566528)))) ORDER BY first_name, last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

     pattern = QString("#");
#if defined(USE_DEMORGAN)
        reference = QString("SELECT contact_id FROM predictivesearch11 ORDER BY first_name, last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString("#22");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch11 WHERE (NOT(NOT(nbr>802203683625369599 AND nbr<802485158602080256) AND NOT(nbr2>802203683625369599 AND nbr2<802485158602080256) AND NOT(nbr3>802203683625369599 AND nbr3<802485158602080256) AND NOT(nbr4>802203683625369599 AND nbr4<802485158602080256))) ORDER BY first_name, last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

     pattern = QString("#0*");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch11 WHERE NOT(NOT(NOT(NOT(nbr>795448284184313855 AND nbr<795729759161024512) AND NOT(nbr2>795448284184313855 AND nbr2<795729759161024512) AND NOT(nbr3>795448284184313855 AND nbr3<795729759161024512) AND NOT(nbr4>795448284184313855 AND nbr4<795729759161024512))) AND NOT(NOT(NOT(nbr2>720575940379279359 AND nbr2<792633534417207296 AND nbr>792633534417207295 AND nbr<864691128455135232) AND NOT(nbr3>720575940379279359 AND nbr3<792633534417207296 AND nbr>792633534417207295 AND nbr<864691128455135232) AND NOT(nbr3>720575940379279359 AND nbr3<792633534417207296 AND nbr2>792633534417207295 AND nbr2<864691128455135232) AND NOT(nbr4>720575940379279359 AND nbr4<792633534417207296 AND nbr>792633534417207295 AND nbr<864691128455135232) AND NOT(nbr4>720575940379279359 AND nbr4<792633534417207296 AND nbr2>792633534417207295 AND nbr2<864691128455135232) AND NOT(nbr4>720575940379279359 AND nbr4<792633534417207296 AND nbr3>792633534417207295 AND nbr3<864691128455135232))) AND NOT(NOT(NOT(nbr2>792633534417207295 AND nbr2<864691128455135232 AND nbr>720575940379279359 AND nbr<792633534417207296) AND NOT(nbr3>792633534417207295 AND nbr3<864691128455135232 AND nbr>720575940379279359 AND nbr<792633534417207296) AND NOT(nbr3>792633534417207295 AND nbr3<864691128455135232 AND nbr2>720575940379279359 AND nbr2<792633534417207296) AND NOT(nbr4>792633534417207295 AND nbr4<864691128455135232 AND nbr>720575940379279359 AND nbr<792633534417207296) AND NOT(nbr4>792633534417207295 AND nbr4<864691128455135232 AND nbr2>720575940379279359 AND nbr2<792633534417207296) AND NOT(nbr4>792633534417207295 AND nbr4<864691128455135232 AND nbr3>720575940379279359 AND nbr3<792633534417207296)))) ORDER BY predictivesearch11.first_name, predictivesearch11.last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));
    
    pattern = QString("qz") + QChar(30) + QString("vqwerty");
    reference = QString("SELECT contact_id FROM qm0 WHERE (NOT(NOT(n>5348024557502463 AND n<5629499534213120) AND NOT(n2>5348024557502463 AND n2<5629499534213120) AND NOT(n3>5348024557502463 AND n3<5629499534213120) AND NOT(n4>5348024557502463 AND n4<5629499534213120) AND NOT(n5>5348024557502463 AND n5<5629499534213120) AND NOT(n6>5348024557502463 AND n6<5629499534213120) AND NOT(n7>5348024557502463 AND n7<5629499534213120))) ORDER BY first_name, last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);   
    LOG2(pattern, result);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY(!result.compare(reference));
    
    pattern = QString("s ya") + QChar(30) + QString("vqwerty");
    reference = QString("SELECT contact_id FROM qm11 WHERE NOT(NOT(NOT(NOT(n>215914052579233922 AND n<215914052579233924) AND NOT(n2>215914052579233922 AND n2<215914052579233924) AND NOT(n3>215914052579233922 AND n3<215914052579233924) AND NOT(n4>215914052579233922 AND n4<215914052579233924) AND NOT(n5>215914052579233922 AND n5<215914052579233924) AND NOT(n6>215914052579233922 AND n6<215914052579233924) AND NOT(n7>215914052579233922 AND n7<215914052579233924))) AND NOT(NOT(NOT(n2>92886742314516479 AND n2<93168217291227136 AND n>198158383604301823 AND n<216172782113783808) AND NOT(n3>92886742314516479 AND n3<93168217291227136 AND n>198158383604301823 AND n<216172782113783808) AND NOT(n3>92886742314516479 AND n3<93168217291227136 AND n2>198158383604301823 AND n2<216172782113783808) AND NOT(n4>92886742314516479 AND n4<93168217291227136 AND n>198158383604301823 AND n<216172782113783808) AND NOT(n4>92886742314516479 AND n4<93168217291227136 AND n2>198158383604301823 AND n2<216172782113783808) AND NOT(n4>92886742314516479 AND n4<93168217291227136 AND n3>198158383604301823 AND n3<216172782113783808))) AND NOT(NOT(NOT(n2>198158383604301823 AND n2<216172782113783808 AND n>92886742314516479 AND n<93168217291227136) AND NOT(n3>198158383604301823 AND n3<216172782113783808 AND n>92886742314516479 AND n<93168217291227136) AND NOT(n3>198158383604301823 AND n3<216172782113783808 AND n2>92886742314516479 AND n2<93168217291227136) AND NOT(n4>198158383604301823 AND n4<216172782113783808 AND n>92886742314516479 AND n<93168217291227136) AND NOT(n4>198158383604301823 AND n4<216172782113783808 AND n2>92886742314516479 AND n2<93168217291227136) AND NOT(n4>198158383604301823 AND n4<216172782113783808 AND n3>92886742314516479 AND n3<93168217291227136)))) ORDER BY qm11.first_name, qm11.last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);   
    LOG2(pattern, result);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY(!result.compare(reference));
    
    
    pattern = QString("055");
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(predictivesearch5.nbr>382805968326492159 AND predictivesearch5.nbr<387309567953862656) AND NOT(predictivesearch5.nbr2>382805968326492159 AND predictivesearch5.nbr2<387309567953862656) AND NOT(predictivesearch5.nbr3>382805968326492159 AND predictivesearch5.nbr3<387309567953862656) AND NOT(predictivesearch5.nbr4>382805968326492159 AND predictivesearch5.nbr4<387309567953862656)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>23925373020405759 AND predictivesearch0.nbr<24206847997116416) AND NOT(predictivesearch0.nbr2>23925373020405759 AND predictivesearch0.nbr2<24206847997116416) AND NOT(predictivesearch0.nbr3>23925373020405759 AND predictivesearch0.nbr3<24206847997116416) AND NOT(predictivesearch0.nbr4>23925373020405759 AND predictivesearch0.nbr4<24206847997116416))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);   
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
   
    QVERIFY(!result.compare(reference));
    
    pattern = QString ("052207");
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>369858119397801983 AND nbr3<370139594374512640))) OR(NOT(NOT(nbr2>369858119397801983 AND nbr2<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>23116613498699775 AND predictivesearch0.nbr<23116682218176512) AND NOT(predictivesearch0.nbr2>23116613498699775 AND predictivesearch0.nbr2<23116682218176512) AND NOT(predictivesearch0.nbr3>23116613498699775 AND predictivesearch0.nbr3<23116682218176512) AND NOT(predictivesearch0.nbr4>23116613498699775 AND predictivesearch0.nbr4<23116682218176512)))) OR(NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>23116132462362623 AND nbr<23133724648407040) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>23116132462362623 AND nbr<23133724648407040) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>23116132462362623 AND nbr2<23133724648407040) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>23116132462362623 AND nbr<23133724648407040) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>23116132462362623 AND nbr2<23133724648407040) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>23116132462362623 AND nbr3<23133724648407040))) OR(NOT(NOT(nbr2>23116132462362623 AND nbr2<23133724648407040 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>23116132462362623 AND nbr3<23133724648407040 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>23116132462362623 AND nbr3<23133724648407040 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>23116132462362623 AND nbr4<23133724648407040 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>23116132462362623 AND nbr4<23133724648407040 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>23116132462362623 AND nbr4<23133724648407040 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern); 
    QVERIFY( !result.compare( reference) );
        
    pattern = QString ("20300");
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144959613005987839 AND nbr<144960712517615616) AND NOT(nbr2>144959613005987839 AND nbr2<144960712517615616) AND NOT(nbr3>144959613005987839 AND nbr3<144960712517615616) AND NOT(nbr4>144959613005987839 AND nbr4<144960712517615616))) AND NOT(NOT(NOT(nbr2>216172782113783807 AND nbr2<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>216172782113783807 AND nbr3<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>216172782113783807 AND nbr3<288230376151711744 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>216172782113783807 AND nbr2<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>216172782113783807 AND nbr2<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>216172782113783807 AND nbr3<288230376151711744)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern); 
    QVERIFY( !result.compare( reference) );
    
    pattern = QString ("2030");
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144959613005987839 AND nbr<144977205192032256) AND NOT(nbr2>144959613005987839 AND nbr2<144977205192032256) AND NOT(nbr3>144959613005987839 AND nbr3<144977205192032256) AND NOT(nbr4>144959613005987839 AND nbr4<144977205192032256))) AND NOT(NOT(NOT(nbr2>216172782113783807 AND nbr2<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>216172782113783807 AND nbr3<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>216172782113783807 AND nbr3<288230376151711744 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>216172782113783807 AND nbr2<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>216172782113783807 AND nbr2<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>216172782113783807 AND nbr3<288230376151711744)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern); 
    QVERIFY( !result.compare( reference) );
    
    pattern = QString ("203");
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144959613005987839 AND nbr<145241087982698496) AND NOT(nbr2>144959613005987839 AND nbr2<145241087982698496) AND NOT(nbr3>144959613005987839 AND nbr3<145241087982698496) AND NOT(nbr4>144959613005987839 AND nbr4<145241087982698496))) AND NOT(NOT(NOT(nbr2>216172782113783807 AND nbr2<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>216172782113783807 AND nbr3<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>216172782113783807 AND nbr3<288230376151711744 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>216172782113783807 AND nbr2<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>216172782113783807 AND nbr2<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>216172782113783807 AND nbr3<288230376151711744)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern); 
    QVERIFY( !result.compare( reference) );

    TEST_PASSED_LOG("testPredictiveSearch");
    
    
}

void UT_CntSqlSearch::testSelectQweryTable()
    {
    TEST_BEGIN_LOG("testSelectQweryTable");
    QString pattern("q");
    QString result = mCntSqlSearch->selectQweryTable(pattern);
    QVERIFY(result == "qm0" );
    
    pattern = QString("000");
    result = mCntSqlSearch->selectQweryTable(pattern);
    //This case is ignore untli qwerty key map supports numbers
    //QVERIFY(result == "" );
    
    pattern = QString("9");
    result = mCntSqlSearch->selectQweryTable(pattern);
    //QVERIFY(result == "qm9" );
    //This case is ignore untli qwerty key map supports numbers
    TEST_PASSED_LOG("testSelectQweryTable");
    }

void UT_CntSqlSearch::testSelectTableView()
{
    TEST_BEGIN_LOG("testSelectTableView");
    
    QString pattern = QString("0");
    QString reference = QString("predictivesearch0");
    QString result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("1");
    reference = QString("predictivesearch1");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("2");
    reference = QString("predictivesearch2");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("3");
    reference = QString("predictivesearch3");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("4");
    reference = QString("predictivesearch4");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("5");
    reference = QString("predictivesearch5");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("6");
    reference = QString("predictivesearch6");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("7");
    reference = QString("predictivesearch7");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("8");
    reference = QString("predictivesearch8");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("9");
    reference = QString("predictivesearch9");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("09");
    reference = QString("predictivesearch0");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("090");
    reference = QString("predictivesearch0");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("909");
    reference = QString("predictivesearch9");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("99");
    reference = QString("predictivesearch9");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("000");
    reference = QString("predictivesearch0");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("B");
    reference = QString("predictivesearch11");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("A");
    reference = QString("predictivesearch10");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("A0");
    reference = QString("predictivesearch10");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

     pattern = QString("A10");
    reference = QString("predictivesearch10");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("0A");
    reference = QString("predictivesearch0");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );
    
    TEST_PASSED_LOG("testSelectTableView");
}

void UT_CntSqlSearch::testCreateQuery()
{   
    TEST_BEGIN_LOG("testCreateQuery");
    QString pattern = QString("102");

#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch1 WHERE NOT(NOT(NOT(NOT(nbr>72620543991349247 AND nbr<72902018968059904) AND NOT(nbr2>72620543991349247 AND nbr2<72902018968059904) AND NOT(nbr3>72620543991349247 AND nbr3<72902018968059904) AND NOT(nbr4>72620543991349247 AND nbr4<72902018968059904))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>72057594037927935 AND nbr3<144115188075855872))) AND NOT(NOT(NOT(nbr2>72057594037927935 AND nbr2<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr3>144115188075855871 AND nbr3<216172782113783808)))) ORDER BY predictivesearch1.first_name, predictivesearch1.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch1 WHERE \
((nbr>72620543991349247 AND nbr<72902018968059904) OR \
(nbr2>72620543991349247 AND nbr2<72902018968059904) OR \
(nbr3>72620543991349247 AND nbr3<72902018968059904) OR \
(nbr4>72620543991349247 AND nbr4<72902018968059904)) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>72057594037927935 AND nbr2<144115188075855872) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>72057594037927935 AND nbr2<144115188075855872) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>72057594037927935 AND nbr3<144115188075855872) OR \
(nbr2>72057594037927935 AND nbr2<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr3>144115188075855871 AND nbr3<216172782113783808) \
ORDER BY predictivesearch1.first_name, predictivesearch1.last_name ASC;");
#endif // #if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    QString reference("SELECT predictivesearch1.contact_id FROM predictivesearch1 WHERE EXISTS (SELECT contact_id FROM predictivesearch2 WHERE predictivesearch1.contact_id = predictivesearch2.contact_id) OR (SELECT contact_id FROM predictivesearch1 WHERE (NOT(NOT(predictivesearch1.nbr>72620543991349247 AND predictivesearch1.nbr<72902018968059904) AND NOT(predictivesearch1.nbr2>72620543991349247 AND predictivesearch1.nbr2<72902018968059904) AND NOT(predictivesearch1.nbr3>72620543991349247 AND predictivesearch1.nbr3<72902018968059904) AND NOT(predictivesearch1.nbr4>72620543991349247 AND predictivesearch1.nbr4<72902018968059904)))) ORDER BY predictivesearch1.first_name, predictivesearch1.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    QString result = mCntSqlSearch->CreateQuery(pattern);
    //qDebug() << pattern << " -> result" << result;
	//TODO: Fix test result
    LOG2(pattern, result);
    //qDebug() << pattern << " -> result" << result << " -> reference" << reference;
    QVERIFY(!result.compare(reference));
    
    pattern = QString("00202");
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE ((NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) OR(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>144115188075855871 AND nbr3<216172782113783808)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>565148976676863 AND predictivesearch0.nbr<566248488304640) AND NOT(predictivesearch0.nbr2>565148976676863 AND predictivesearch0.nbr2<566248488304640) AND NOT(predictivesearch0.nbr3>565148976676863 AND predictivesearch0.nbr3<566248488304640) AND NOT(predictivesearch0.nbr4>565148976676863 AND predictivesearch0.nbr4<566248488304640)))) OR(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>562949953421311 AND nbr3<844424930131968))) OR(NOT(NOT(nbr2>562949953421311 AND nbr2<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr3>144115188075855871 AND nbr3<216172782113783808)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE \
((nbr>565148976676863 AND nbr<566248488304640) OR \
(nbr2>565148976676863 AND nbr2<566248488304640) OR \
(nbr3>565148976676863 AND nbr3<566248488304640) OR \
(nbr4>565148976676863 AND nbr4<566248488304640)) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>562949953421311 AND nbr2<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>562949953421311 AND nbr2<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>562949953421311 AND nbr3<844424930131968) OR \
(nbr2>562949953421311 AND nbr2<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr3>144115188075855871 AND nbr3<216172782113783808) \
ORDER BY predictivesearch0.first_name, predictivesearch0.last_name ASC;");
#endif // #if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    // TODO: Test this case on HW and verify leading zeros.
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE (NOT(NOT(predictivesearch0.nbr>565148976676863 AND predictivesearch0.nbr<566248488304640) AND NOT(predictivesearch0.nbr2>565148976676863 AND predictivesearch0.nbr2<566248488304640) AND NOT(predictivesearch0.nbr3>565148976676863 AND predictivesearch0.nbr3<566248488304640) AND NOT(predictivesearch0.nbr4>565148976676863 AND predictivesearch0.nbr4<566248488304640))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 JOIN predictivesearch2 ON predictivesearch0.contact_id = predictivesearch2.contact_id WHERE(NOT(NOT(predictivesearch0.nbr>562949953421311 AND predictivesearch0.nbr<844424930131968) AND NOT(predictivesearch0.nbr2>562949953421311 AND predictivesearch0.nbr2<844424930131968) AND NOT(predictivesearch0.nbr3>562949953421311 AND predictivesearch0.nbr3<844424930131968) AND NOT(predictivesearch0.nbr4>562949953421311 AND predictivesearch0.nbr4<844424930131968)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    result = mCntSqlSearch->CreateQuery(pattern);
    //LOG2(pattern, result);
    //qDebug() << pattern << " -> result" << result << " -> reference" << reference;
    QVERIFY( !result.compare( reference) );

    pattern = QString("202000");
#if defined(USE_DEMORGAN)
    // TODO: Test this case on HW and verify trailing zeros.
	reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144678138029277183 AND nbr<144678206748753920) AND NOT(nbr2>144678138029277183 AND nbr2<144678206748753920) AND NOT(nbr3>144678138029277183 AND nbr3<144678206748753920) AND NOT(nbr4>144678138029277183 AND nbr4<144678206748753920))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<144132780261900288 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>144115188075855871 AND nbr2<144132780261900288) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>144115188075855871 AND nbr2<144132780261900288) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>144115188075855871 AND nbr3<144132780261900288)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else
	// TODO: add non-De Morgan version
#endif    

    /*reference = QString("SELECT contact_id FROM predictivesearch2 WHERE \
((nbr>144678138029277183 AND nbr<144678206748753920) OR (nbr2>144678138029277183 AND nbr2<144678206748753920) OR \
(nbr3>144678138029277183 AND nbr3<144678206748753920) OR (nbr4>144678138029277183 AND nbr4<144678206748753920)) OR \
(nbr2>144115188075855871 AND nbr2<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>144115188075855871 AND nbr3<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>144115188075855871 AND nbr3<144132780261900288 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr3>144115188075855871 AND nbr3<216172782113783808) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>144115188075855871 AND nbr2<144132780261900288) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>144115188075855871 AND nbr2<144132780261900288) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>144115188075855871 AND nbr3<144132780261900288) \
ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");*/

    result = mCntSqlSearch->CreateQuery(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    //QVERIFY( !result.compare( reference) );

    pattern = QString("0020200");
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE ((NOT(NOT(nbr2>144115188075855871 AND nbr2<144396663052566528 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<144396663052566528 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<144396663052566528 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) OR(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>144115188075855871 AND nbr<144396663052566528) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>144115188075855871 AND nbr<144396663052566528) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>144115188075855871 AND nbr2<144396663052566528) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>144115188075855871 AND nbr<144396663052566528) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>144115188075855871 AND nbr2<144396663052566528) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>144115188075855871 AND nbr3<144396663052566528)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>565148976676863 AND predictivesearch0.nbr<565153271644160) AND NOT(predictivesearch0.nbr2>565148976676863 AND predictivesearch0.nbr2<565153271644160) AND NOT(predictivesearch0.nbr3>565148976676863 AND predictivesearch0.nbr3<565153271644160) AND NOT(predictivesearch0.nbr4>565148976676863 AND predictivesearch0.nbr4<565153271644160)))) OR(NOT(NOT(nbr2>144115188075855871 AND nbr2<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>144115188075855871 AND nbr3<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>144115188075855871 AND nbr3<144396663052566528 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr3>562949953421311 AND nbr3<844424930131968))) OR(NOT(NOT(nbr2>562949953421311 AND nbr2<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr2>144115188075855871 AND nbr2<144396663052566528) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr2>144115188075855871 AND nbr2<144396663052566528) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr3>144115188075855871 AND nbr3<144396663052566528)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE \
((nbr>565148976676863 AND nbr<565153271644160) OR (nbr2>565148976676863 AND nbr2<565153271644160) OR \
(nbr3>565148976676863 AND nbr3<565153271644160) OR (nbr4>565148976676863 AND nbr4<565153271644160)) OR \
(nbr2>144115188075855871 AND nbr2<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr3>144115188075855871 AND nbr3<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr3>144115188075855871 AND nbr3<144396663052566528 AND nbr2>562949953421311 AND nbr2<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr2>562949953421311 AND nbr2<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr3>562949953421311 AND nbr3<844424930131968) OR \
(nbr2>562949953421311 AND nbr2<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) OR \
(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) OR \
(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr2>144115188075855871 AND nbr2<144396663052566528) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr2>144115188075855871 AND nbr2<144396663052566528) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr3>144115188075855871 AND nbr3<144396663052566528) \
ORDER BY predictivesearch0.first_name, predictivesearch0.last_name ASC;");
#endif // #if defined(USE_DEMORGAN)
#else // #if defin20300ed(SEARCH_FROM_ONE_TABLE)
    // TODO: Test this case on HW and verify leading zeros.
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE (NOT(NOT(predictivesearch0.nbr>565148976676863 AND predictivesearch0.nbr<565153271644160) AND NOT(predictivesearch0.nbr2>565148976676863 AND predictivesearch0.nbr2<565153271644160) AND NOT(predictivesearch0.nbr3>565148976676863 AND predictivesearch0.nbr3<565153271644160) AND NOT(predictivesearch0.nbr4>565148976676863 AND predictivesearch0.nbr4<565153271644160))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 JOIN predictivesearch2 ON predictivesearch0.contact_id = predictivesearch2.contact_id WHERE((NOT(NOT(predictivesearch0.nbr>562949953421311 AND predictivesearch0.nbr<844424930131968) AND NOT(predictivesearch0.nbr2>562949953421311 AND predictivesearch0.nbr2<844424930131968) AND NOT(predictivesearch0.nbr3>562949953421311 AND predictivesearch0.nbr3<844424930131968) AND NOT(predictivesearch0.nbr4>562949953421311 AND predictivesearch0.nbr4<844424930131968))) AND (NOT(NOT(predictivesearch2.nbr>144115188075855871 AND predictivesearch2.nbr<144396663052566528) AND NOT(predictivesearch2.nbr2>144115188075855871 AND predictivesearch2.nbr2<144396663052566528) AND NOT(predictivesearch2.nbr3>144115188075855871 AND predictivesearch2.nbr3<144396663052566528) AND NOT(predictivesearch2.nbr4>144115188075855871 AND predictivesearch2.nbr4<144396663052566528))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif //#if defined(SEARCH_FROM_ONE_TABLE) 
    result = mCntSqlSearch->CreateQuery(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    //QVERIFY( !result.compare( reference) );

    pattern = QString("20322");
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144996996401332223 AND nbr<144998095912960000) AND NOT(nbr2>144996996401332223 AND nbr2<144998095912960000) AND NOT(nbr3>144996996401332223 AND nbr3<144998095912960000) AND NOT(nbr4>144996996401332223 AND nbr4<144998095912960000))) AND NOT(NOT(NOT(nbr2>225742931321946111 AND nbr2<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>225742931321946111 AND nbr3<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>225742931321946111 AND nbr3<226024406298656768 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>225742931321946111 AND nbr2<226024406298656768) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>225742931321946111 AND nbr2<226024406298656768) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>225742931321946111 AND nbr3<226024406298656768)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE \
((nbr>144996996401332223 AND nbr<144998095912960000) OR (nbr2>144996996401332223 AND nbr2<144998095912960000) OR \
(nbr3>144996996401332223 AND nbr3<144998095912960000) OR (nbr4>144996996401332223 AND nbr4<144998095912960000)) OR \
(nbr2>225742931321946111 AND nbr2<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>225742931321946111 AND nbr3<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>225742931321946111 AND nbr3<226024406298656768 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr3>144115188075855871 AND nbr3<216172782113783808) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>225742931321946111 AND nbr2<226024406298656768) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>225742931321946111 AND nbr2<226024406298656768) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>225742931321946111 AND nbr3<226024406298656768) \
ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;"); 
#endif // #if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>144996996401332223 AND predictivesearch2.nbr<144998095912960000) AND NOT(predictivesearch2.nbr2>144996996401332223 AND predictivesearch2.nbr2<144998095912960000) AND NOT(predictivesearch2.nbr3>144996996401332223 AND predictivesearch2.nbr3<144998095912960000) AND NOT(predictivesearch2.nbr4>144996996401332223 AND predictivesearch2.nbr4<144998095912960000))) UNION SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 JOIN predictivesearch3 ON predictivesearch2.contact_id = predictivesearch3.contact_id WHERE(NOT(NOT(predictivesearch3.nbr>225742931321946111 AND predictivesearch3.nbr<226024406298656768) AND NOT(predictivesearch3.nbr2>225742931321946111 AND predictivesearch3.nbr2<226024406298656768) AND NOT(predictivesearch3.nbr3>225742931321946111 AND predictivesearch3.nbr3<226024406298656768) AND NOT(predictivesearch3.nbr4>225742931321946111 AND predictivesearch3.nbr4<226024406298656768)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    result = mCntSqlSearch->CreateQuery(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    
    TEST_PASSED_LOG("testCreateQuery");
}

void UT_CntSqlSearch::testCreateQwertyQuery()
    {
    TEST_BEGIN_LOG("testCreateQwertyQuery");
    QString pattern = QString("s") + QChar(30) + QString("vqwerty");
    QString reference("SELECT contact_id FROM qm11 ORDER BY first_name, last_name ASC;");
    QString result = mCntSqlSearch->CreateQwertyQuery(pattern);
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    pattern = QString("s ya") + QChar(30) + QString("vqwerty");
    reference = QString("SELECT contact_id FROM qm11 WHERE NOT(NOT(NOT(NOT(n>215914052579233922 AND n<215914052579233924) AND NOT(n2>215914052579233922 AND n2<215914052579233924) AND NOT(n3>215914052579233922 AND n3<215914052579233924) AND NOT(n4>215914052579233922 AND n4<215914052579233924) AND NOT(n5>215914052579233922 AND n5<215914052579233924) AND NOT(n6>215914052579233922 AND n6<215914052579233924) AND NOT(n7>215914052579233922 AND n7<215914052579233924))) AND NOT(NOT(NOT(n2>92886742314516479 AND n2<93168217291227136 AND n>198158383604301823 AND n<216172782113783808) AND NOT(n3>92886742314516479 AND n3<93168217291227136 AND n>198158383604301823 AND n<216172782113783808) AND NOT(n3>92886742314516479 AND n3<93168217291227136 AND n2>198158383604301823 AND n2<216172782113783808) AND NOT(n4>92886742314516479 AND n4<93168217291227136 AND n>198158383604301823 AND n<216172782113783808) AND NOT(n4>92886742314516479 AND n4<93168217291227136 AND n2>198158383604301823 AND n2<216172782113783808) AND NOT(n4>92886742314516479 AND n4<93168217291227136 AND n3>198158383604301823 AND n3<216172782113783808))) AND NOT(NOT(NOT(n2>198158383604301823 AND n2<216172782113783808 AND n>92886742314516479 AND n<93168217291227136) AND NOT(n3>198158383604301823 AND n3<216172782113783808 AND n>92886742314516479 AND n<93168217291227136) AND NOT(n3>198158383604301823 AND n3<216172782113783808 AND n2>92886742314516479 AND n2<93168217291227136) AND NOT(n4>198158383604301823 AND n4<216172782113783808 AND n>92886742314516479 AND n<93168217291227136) AND NOT(n4>198158383604301823 AND n4<216172782113783808 AND n2>92886742314516479 AND n2<93168217291227136) AND NOT(n4>198158383604301823 AND n4<216172782113783808 AND n3>92886742314516479 AND n3<93168217291227136)))) ORDER BY qm11.first_name, qm11.last_name ASC;");
    result = mCntSqlSearch->CreateQwertyQuery(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    pattern = QString("syadira") + QChar(30) + QString("vqwerty");
    reference = QString("SELECT contact_id FROM qm11 WHERE (NOT(NOT(n>199610571155832831 AND n<199610571156094976) AND NOT(n2>199610571155832831 AND n2<199610571156094976) AND NOT(n3>199610571155832831 AND n3<199610571156094976) AND NOT(n4>199610571155832831 AND n4<199610571156094976) AND NOT(n5>199610571155832831 AND n5<199610571156094976) AND NOT(n6>199610571155832831 AND n6<199610571156094976) AND NOT(n7>199610571155832831 AND n7<199610571156094976))) ORDER BY first_name, last_name ASC;");
    result = mCntSqlSearch->CreateQwertyQuery(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    pattern = QString("qz") + QChar(30) + QString("vqwerty");
    reference = QString("SELECT contact_id FROM qm0 WHERE (NOT(NOT(n>5348024557502463 AND n<5629499534213120) AND NOT(n2>5348024557502463 AND n2<5629499534213120) AND NOT(n3>5348024557502463 AND n3<5629499534213120) AND NOT(n4>5348024557502463 AND n4<5629499534213120) AND NOT(n5>5348024557502463 AND n5<5629499534213120) AND NOT(n6>5348024557502463 AND n6<5629499534213120) AND NOT(n7>5348024557502463 AND n7<5629499534213120))) ORDER BY first_name, last_name ASC;");
    result = mCntSqlSearch->CreateQwertyQuery(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    pattern = QString("qz df") + QChar(30) + QString("vqwerty");
    reference = QString("SELECT contact_id FROM qm0 WHERE NOT(NOT(NOT(NOT(n>5625941142798401 AND n<5625941142798403) AND NOT(n2>5625941142798401 AND n2<5625941142798403) AND NOT(n3>5625941142798401 AND n3<5625941142798403) AND NOT(n4>5625941142798401 AND n4<5625941142798403) AND NOT(n5>5625941142798401 AND n5<5625941142798403) AND NOT(n6>5625941142798401 AND n6<5625941142798403) AND NOT(n7>5625941142798401 AND n7<5625941142798403))) AND NOT(NOT(NOT(n2>219831956811022335 AND n2<220113431787732992 AND n>5348024557502463 AND n<5629499534213120) AND NOT(n3>219831956811022335 AND n3<220113431787732992 AND n>5348024557502463 AND n<5629499534213120) AND NOT(n3>219831956811022335 AND n3<220113431787732992 AND n2>5348024557502463 AND n2<5629499534213120) AND NOT(n4>219831956811022335 AND n4<220113431787732992 AND n>5348024557502463 AND n<5629499534213120) AND NOT(n4>219831956811022335 AND n4<220113431787732992 AND n2>5348024557502463 AND n2<5629499534213120) AND NOT(n4>219831956811022335 AND n4<220113431787732992 AND n3>5348024557502463 AND n3<5629499534213120))) AND NOT(NOT(NOT(n2>5348024557502463 AND n2<5629499534213120 AND n>219831956811022335 AND n<220113431787732992) AND NOT(n3>5348024557502463 AND n3<5629499534213120 AND n>219831956811022335 AND n<220113431787732992) AND NOT(n3>5348024557502463 AND n3<5629499534213120 AND n2>219831956811022335 AND n2<220113431787732992) AND NOT(n4>5348024557502463 AND n4<5629499534213120 AND n>219831956811022335 AND n<220113431787732992) AND NOT(n4>5348024557502463 AND n4<5629499534213120 AND n2>219831956811022335 AND n2<220113431787732992) AND NOT(n4>5348024557502463 AND n4<5629499534213120 AND n3>219831956811022335 AND n3<220113431787732992)))) ORDER BY qm0.first_name, qm0.last_name ASC;");
    result = mCntSqlSearch->CreateQwertyQuery(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    pattern = QString("") + QChar(30) + QString("vqwerty");
    reference = QString("");
    result = mCntSqlSearch->CreateQwertyQuery(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    pattern = QString("levis.augu_whatever") + QChar(30) + QString("vqwerty");
    reference = QString("SELECT contact_id FROM qm18 WHERE (NOT(NOT(n>324919373450470277 AND n<324919373450470279) AND NOT(n2>324919373450470277 AND n2<324919373450470279) AND NOT(n3>324919373450470277 AND n3<324919373450470279) AND NOT(n4>324919373450470277 AND n4<324919373450470279) AND NOT(n5>324919373450470277 AND n5<324919373450470279) AND NOT(n6>324919373450470277 AND n6<324919373450470279) AND NOT(n7>324919373450470277 AND n7<324919373450470279))) ORDER BY first_name, last_name ASC;");
    result = mCntSqlSearch->CreateQwertyQuery(pattern);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    TEST_PASSED_LOG("testCreateQwertyQuery");
    }

void UT_CntSqlSearch::testExactMatchSearch()
{
    TEST_BEGIN_LOG("testExactMatchSearch");

    QString pattern("120");
#if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch1 WHERE (NOT(NOT(nbr>81064793292668927 AND nbr<81346268269379584) AND NOT(nbr2>81064793292668927 AND nbr2<81346268269379584) AND NOT(nbr3>81064793292668927 AND nbr3<81346268269379584) AND NOT(nbr4>81064793292668927 AND nbr4<81346268269379584)))");
#else // #if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch1 WHERE (nbr>81064793292668927 AND nbr<81346268269379584) OR (nbr2>81064793292668927 AND nbr2<81346268269379584) OR (nbr3>81064793292668927 AND nbr3<81346268269379584) OR (nbr4>81064793292668927 AND nbr4<81346268269379584)");
#endif // #if defined(USE_DEMORGAN)
    QString result = mCntSqlSearch->ExactMatchSearch(pattern);
//    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result == reference);
    

    pattern = QString("5");
#if defined(USE_DEMORGAN)
    reference = "SELECT contact_id FROM predictivesearch5 WHERE (NOT(NOT(nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616)))";
#else // #if defined(USE_DEMORGAN)
    reference = "SELECT contact_id FROM predictivesearch5 WHERE (nbr>360287970189639679 AND nbr<432345564227567616) OR (nbr2>360287970189639679 AND nbr2<432345564227567616) OR (nbr3>360287970189639679 AND nbr3<432345564227567616) OR (nbr4>360287970189639679 AND nbr4<432345564227567616)";
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->ExactMatchSearch(pattern);
//    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result == reference);

    
    pattern = QString("25");
#if defined(USE_DEMORGAN)
    reference = "SELECT contact_id FROM predictivesearch2 WHERE (NOT(NOT(nbr>166633186212708351 AND nbr<171136785840078848) AND NOT(nbr2>166633186212708351 AND nbr2<171136785840078848) AND NOT(nbr3>166633186212708351 AND nbr3<171136785840078848) AND NOT(nbr4>166633186212708351 AND nbr4<171136785840078848)))";
#else // #if defined(USE_DEMORGAN)
    reference = "SELECT contact_id FROM predictivesearch2 WHERE (nbr>166633186212708351 AND nbr<171136785840078848) OR (nbr2>166633186212708351 AND nbr2<171136785840078848) OR (nbr3>166633186212708351 AND nbr3<171136785840078848) OR (nbr4>166633186212708351 AND nbr4<171136785840078848)";
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->ExactMatchSearch(pattern);
//    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result == reference);
    
    TEST_PASSED_LOG("testExactMatchSearch");
}
void UT_CntSqlSearch::testExactMatchSearchQwerty()
    {
    TEST_BEGIN_LOG("testExactMatchSearchQwerty");

        QString pattern("wt");
    #if defined(USE_DEMORGAN)
        QString reference("(NOT(NOT(n>19140298416324607 AND n<19421773393035264) AND NOT(n2>19140298416324607 AND n2<19421773393035264) AND NOT(n3>19140298416324607 AND n3<19421773393035264) AND NOT(n4>19140298416324607 AND n4<19421773393035264) AND NOT(n5>19140298416324607 AND n5<19421773393035264) AND NOT(n6>19140298416324607 AND n6<19421773393035264) AND NOT(n7>19140298416324607 AND n7<19421773393035264)))");
    #else // #if defined(USE_DEMORGAN)
        QString reference("(NOT(NOT(n>19140298416324607 AND n<19421773393035264) AND NOT(n2>19140298416324607 AND n2<19421773393035264) AND NOT(n3>19140298416324607 AND n3<19421773393035264) AND NOT(n4>19140298416324607 AND n4<19421773393035264) AND NOT(n5>19140298416324607 AND n5<19421773393035264) AND NOT(n6>19140298416324607 AND n6<19421773393035264) AND NOT(n7>19140298416324607 AND n7<19421773393035264)))");
    #endif // #if defined(USE_DEMORGAN)
        QString result = mCntSqlSearch->ExactMatchQwerty(pattern);
        LOG2(pattern, result);
        QVERIFY(result == reference);
    TEST_PASSED_LOG("testExactMatchSearchQwerty");
    }
        
void UT_CntSqlSearch::testIntersectionSearch()
{
    TEST_BEGIN_LOG("testIntersectionSearch");

    QString pattern("205");
    QStringList tokens;
    tokens << "2" << "5";
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>145522562959409151 AND nbr<145804037936119808) AND NOT(nbr2>145522562959409151 AND nbr2<145804037936119808) AND NOT(nbr3>145522562959409151 AND nbr3<145804037936119808) AND NOT(nbr4>145522562959409151 AND nbr4<145804037936119808))) AND NOT(NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>360287970189639679 AND nbr3<432345564227567616)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch2 WHERE \
((nbr>145522562959409151 AND nbr<145804037936119808) OR (nbr2>145522562959409151 AND nbr2<145804037936119808) OR \
(nbr3>145522562959409151 AND nbr3<145804037936119808) OR (nbr4>145522562959409151 AND nbr4<145804037936119808)) OR \
(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>144115188075855871 AND nbr3<216172782113783808) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>360287970189639679 AND nbr3<432345564227567616) \
ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#endif // #if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    QString reference("SELECT predictivesearch2.contact_id FROM predictivesearch2 WHERE EXISTS (SELECT contact_id FROM predictivesearch5 WHERE predictivesearch2.contact_id = predictivesearch5.contact_id) OR (SELECT contact_id FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>145522562959409151 AND predictivesearch2.nbr<145804037936119808) AND NOT(predictivesearch2.nbr2>145522562959409151 AND predictivesearch2.nbr2<145804037936119808) AND NOT(predictivesearch2.nbr3>145522562959409151 AND predictivesearch2.nbr3<145804037936119808) AND NOT(predictivesearch2.nbr4>145522562959409151 AND predictivesearch2.nbr4<145804037936119808)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    QString result = mCntSqlSearch->IntersectionSearch(pattern, tokens);
//    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    LOG2("result", result);
    QVERIFY( !result.compare( reference) );
    
    TEST_PASSED_LOG("testIntersectionSearch");
}
void UT_CntSqlSearch::testSearchTokensFromOneTable()
    {
    TEST_BEGIN_LOG("testSearchTokensFromOneTable");
    QString pattern("205");
    QStringList tokens;
    tokens << "2" << "5";
    QString reference("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>145522562959409151 AND nbr<145804037936119808) AND NOT(nbr2>145522562959409151 AND nbr2<145804037936119808) AND NOT(nbr3>145522562959409151 AND nbr3<145804037936119808) AND NOT(nbr4>145522562959409151 AND nbr4<145804037936119808))) AND NOT(NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>360287970189639679 AND nbr3<432345564227567616)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
    QString result = mCntSqlSearch->SearchTokensFromOneTable(pattern, tokens);  
    QVERIFY( !result.compare( reference) );
    
    
    tokens.clear();
    pattern = QString ("20300");
    tokens << "2" << "300";
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144959613005987839 AND nbr<144960712517615616) AND NOT(nbr2>144959613005987839 AND nbr2<144960712517615616) AND NOT(nbr3>144959613005987839 AND nbr3<144960712517615616) AND NOT(nbr4>144959613005987839 AND nbr4<144960712517615616))) AND NOT(NOT(NOT(nbr2>216172782113783807 AND nbr2<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>216172782113783807 AND nbr3<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>216172782113783807 AND nbr3<288230376151711744 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>216172782113783807 AND nbr4<288230376151711744 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>216172782113783807 AND nbr2<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>216172782113783807 AND nbr<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>216172782113783807 AND nbr2<288230376151711744) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>216172782113783807 AND nbr3<288230376151711744)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
    result = mCntSqlSearch->SearchTokensFromOneTable(pattern, tokens);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( !result.compare( reference) );
   
    pattern = QString("e p");
    tokens.clear();
    tokens << "e" << "p";
    reference = QString("SELECT contact_id FROM qm2 WHERE NOT(NOT(NOT(NOT(n>53801302970335231 AND n<53805701016846336) AND NOT(n2>53801302970335231 AND n2<53805701016846336) AND NOT(n3>53801302970335231 AND n3<53805701016846336) AND NOT(n4>53801302970335231 AND n4<53805701016846336) AND NOT(n5>53801302970335231 AND n5<53805701016846336) AND NOT(n6>53801302970335231 AND n6<53805701016846336) AND NOT(n7>53801302970335231 AND n7<53805701016846336))) AND NOT(NOT(NOT(n2>162129586585337855 AND n2<180143985094819840 AND n>36028797018963967 AND n<54043195528445952) AND NOT(n3>162129586585337855 AND n3<180143985094819840 AND n>36028797018963967 AND n<54043195528445952) AND NOT(n3>162129586585337855 AND n3<180143985094819840 AND n2>36028797018963967 AND n2<54043195528445952) AND NOT(n4>162129586585337855 AND n4<180143985094819840 AND n>36028797018963967 AND n<54043195528445952) AND NOT(n4>162129586585337855 AND n4<180143985094819840 AND n2>36028797018963967 AND n2<54043195528445952) AND NOT(n4>162129586585337855 AND n4<180143985094819840 AND n3>36028797018963967 AND n3<54043195528445952))) AND NOT(NOT(NOT(n2>36028797018963967 AND n2<54043195528445952 AND n>162129586585337855 AND n<180143985094819840) AND NOT(n3>36028797018963967 AND n3<54043195528445952 AND n>162129586585337855 AND n<180143985094819840) AND NOT(n3>36028797018963967 AND n3<54043195528445952 AND n2>162129586585337855 AND n2<180143985094819840) AND NOT(n4>36028797018963967 AND n4<54043195528445952 AND n>162129586585337855 AND n<180143985094819840) AND NOT(n4>36028797018963967 AND n4<54043195528445952 AND n2>162129586585337855 AND n2<180143985094819840) AND NOT(n4>36028797018963967 AND n4<54043195528445952 AND n3>162129586585337855 AND n3<180143985094819840)))) ORDER BY qm2.first_name, qm2.last_name ASC;");
    result = mCntSqlSearch->SearchTokensFromOneTable(pattern, tokens, CntSqlSearch::QwertyEmail);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( !result.compare( reference) );
    TEST_PASSED_LOG("testSearchTokensFromOneTable");
    }

void UT_CntSqlSearch::testCompareTwoColumnsWithModifiedPattern()
    {
    TEST_BEGIN_LOG("testCompareTwoColumnsWithModifiedPattern");
    QString pattern("05");
    QStringList tokens;
    tokens << "5";
    QString reference("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>22517998136852479 AND predictivesearch0.nbr<27021597764222976) AND NOT(predictivesearch0.nbr2>22517998136852479 AND predictivesearch0.nbr2<27021597764222976) AND NOT(predictivesearch0.nbr3>22517998136852479 AND predictivesearch0.nbr3<27021597764222976) AND NOT(predictivesearch0.nbr4>22517998136852479 AND predictivesearch0.nbr4<27021597764222976))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    QString result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);
    QVERIFY( !result.compare( reference) );
    
    tokens.clear();
    pattern = QString ("055");
    tokens << "55";
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(predictivesearch5.nbr>382805968326492159 AND predictivesearch5.nbr<387309567953862656) AND NOT(predictivesearch5.nbr2>382805968326492159 AND predictivesearch5.nbr2<387309567953862656) AND NOT(predictivesearch5.nbr3>382805968326492159 AND predictivesearch5.nbr3<387309567953862656) AND NOT(predictivesearch5.nbr4>382805968326492159 AND predictivesearch5.nbr4<387309567953862656)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>23925373020405759 AND predictivesearch0.nbr<24206847997116416) AND NOT(predictivesearch0.nbr2>23925373020405759 AND predictivesearch0.nbr2<24206847997116416) AND NOT(predictivesearch0.nbr3>23925373020405759 AND predictivesearch0.nbr3<24206847997116416) AND NOT(predictivesearch0.nbr4>23925373020405759 AND predictivesearch0.nbr4<24206847997116416))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);  
    QVERIFY( !result.compare( reference) );
    
    tokens.clear();
    pattern = QString ("05505");
    tokens << "055" << "5";
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>382805968326492159 AND nbr<387309567953862656) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>382805968326492159 AND nbr<387309567953862656) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>382805968326492159 AND nbr2<387309567953862656) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>382805968326492159 AND nbr<387309567953862656) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>382805968326492159 AND nbr2<387309567953862656) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>382805968326492159 AND nbr3<387309567953862656))) OR(NOT(NOT(nbr2>382805968326492159 AND nbr2<387309567953862656 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>382805968326492159 AND nbr3<387309567953862656 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>382805968326492159 AND nbr3<387309567953862656 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>382805968326492159 AND nbr4<387309567953862656 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>382805968326492159 AND nbr4<387309567953862656 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>382805968326492159 AND nbr4<387309567953862656 AND nbr3>360287970189639679 AND nbr3<432345564227567616)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>23930870578544639 AND predictivesearch0.nbr<23931970090172416) AND NOT(predictivesearch0.nbr2>23930870578544639 AND predictivesearch0.nbr2<23931970090172416) AND NOT(predictivesearch0.nbr3>23930870578544639 AND predictivesearch0.nbr3<23931970090172416) AND NOT(predictivesearch0.nbr4>23930870578544639 AND predictivesearch0.nbr4<23931970090172416)))) OR(NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>23925373020405759 AND nbr<24206847997116416) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>23925373020405759 AND nbr<24206847997116416) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>23925373020405759 AND nbr2<24206847997116416) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>23925373020405759 AND nbr<24206847997116416) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>23925373020405759 AND nbr2<24206847997116416) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>23925373020405759 AND nbr3<24206847997116416))) OR(NOT(NOT(nbr2>23925373020405759 AND nbr2<24206847997116416 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>23925373020405759 AND nbr3<24206847997116416 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>23925373020405759 AND nbr3<24206847997116416 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>23925373020405759 AND nbr4<24206847997116416 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>23925373020405759 AND nbr4<24206847997116416 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>23925373020405759 AND nbr4<24206847997116416 AND nbr3>360287970189639679 AND nbr3<432345564227567616)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);
    QVERIFY( !result.compare( reference) );
    
    tokens.clear();
    pattern = QString ("0550");
    tokens << "055";
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(predictivesearch5.nbr>382805968326492159 AND predictivesearch5.nbr<387309567953862656) AND NOT(predictivesearch5.nbr2>382805968326492159 AND predictivesearch5.nbr2<387309567953862656) AND NOT(predictivesearch5.nbr3>382805968326492159 AND predictivesearch5.nbr3<387309567953862656) AND NOT(predictivesearch5.nbr4>382805968326492159 AND predictivesearch5.nbr4<387309567953862656)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>23925373020405759 AND predictivesearch0.nbr<24206847997116416) AND NOT(predictivesearch0.nbr2>23925373020405759 AND predictivesearch0.nbr2<24206847997116416) AND NOT(predictivesearch0.nbr3>23925373020405759 AND predictivesearch0.nbr3<24206847997116416) AND NOT(predictivesearch0.nbr4>23925373020405759 AND predictivesearch0.nbr4<24206847997116416))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( !result.compare( reference) );
    
    tokens.clear();
    pattern = QString ("000550");
    tokens << "00055";
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(predictivesearch5.nbr>382805968326492159 AND predictivesearch5.nbr<387309567953862656) AND NOT(predictivesearch5.nbr2>382805968326492159 AND predictivesearch5.nbr2<387309567953862656) AND NOT(predictivesearch5.nbr3>382805968326492159 AND predictivesearch5.nbr3<387309567953862656) AND NOT(predictivesearch5.nbr4>382805968326492159 AND predictivesearch5.nbr4<387309567953862656)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>93458488360959 AND predictivesearch0.nbr<94557999988736) AND NOT(predictivesearch0.nbr2>93458488360959 AND predictivesearch0.nbr2<94557999988736) AND NOT(predictivesearch0.nbr3>93458488360959 AND predictivesearch0.nbr3<94557999988736) AND NOT(predictivesearch0.nbr4>93458488360959 AND predictivesearch0.nbr4<94557999988736))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);  
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( !result.compare( reference) );
    
    tokens.clear();
    pattern = QString ("055000");
    tokens << "055";
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(predictivesearch5.nbr>382805968326492159 AND predictivesearch5.nbr<387309567953862656) AND NOT(predictivesearch5.nbr2>382805968326492159 AND predictivesearch5.nbr2<387309567953862656) AND NOT(predictivesearch5.nbr3>382805968326492159 AND predictivesearch5.nbr3<387309567953862656) AND NOT(predictivesearch5.nbr4>382805968326492159 AND predictivesearch5.nbr4<387309567953862656)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>23925373020405759 AND predictivesearch0.nbr<24206847997116416) AND NOT(predictivesearch0.nbr2>23925373020405759 AND predictivesearch0.nbr2<24206847997116416) AND NOT(predictivesearch0.nbr3>23925373020405759 AND predictivesearch0.nbr3<24206847997116416) AND NOT(predictivesearch0.nbr4>23925373020405759 AND predictivesearch0.nbr4<24206847997116416))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( !result.compare( reference) );
    
    tokens.clear();
    pattern = QString ("0500050");
    tokens << "05" << "50";
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>360287970189639679 AND nbr3<432345564227567616))) OR(NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>360287970189639679 AND nbr3<432345564227567616)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>22518341734236159 AND predictivesearch0.nbr<22518410453712896) AND NOT(predictivesearch0.nbr2>22518341734236159 AND predictivesearch0.nbr2<22518410453712896) AND NOT(predictivesearch0.nbr3>22518341734236159 AND predictivesearch0.nbr3<22518410453712896) AND NOT(predictivesearch0.nbr4>22518341734236159 AND predictivesearch0.nbr4<22518410453712896)))) OR(NOT(NOT(nbr2>360287970189639679 AND nbr2<364791569817010176 AND nbr>22517998136852479 AND nbr<27021597764222976) AND NOT(nbr3>360287970189639679 AND nbr3<364791569817010176 AND nbr>22517998136852479 AND nbr<27021597764222976) AND NOT(nbr3>360287970189639679 AND nbr3<364791569817010176 AND nbr2>22517998136852479 AND nbr2<27021597764222976) AND NOT(nbr4>360287970189639679 AND nbr4<364791569817010176 AND nbr>22517998136852479 AND nbr<27021597764222976) AND NOT(nbr4>360287970189639679 AND nbr4<364791569817010176 AND nbr2>22517998136852479 AND nbr2<27021597764222976) AND NOT(nbr4>360287970189639679 AND nbr4<364791569817010176 AND nbr3>22517998136852479 AND nbr3<27021597764222976))) OR(NOT(NOT(nbr2>22517998136852479 AND nbr2<27021597764222976 AND nbr>360287970189639679 AND nbr<364791569817010176) AND NOT(nbr3>22517998136852479 AND nbr3<27021597764222976 AND nbr>360287970189639679 AND nbr<364791569817010176) AND NOT(nbr3>22517998136852479 AND nbr3<27021597764222976 AND nbr2>360287970189639679 AND nbr2<364791569817010176) AND NOT(nbr4>22517998136852479 AND nbr4<27021597764222976 AND nbr>360287970189639679 AND nbr<364791569817010176) AND NOT(nbr4>22517998136852479 AND nbr4<27021597764222976 AND nbr2>360287970189639679 AND nbr2<364791569817010176) AND NOT(nbr4>22517998136852479 AND nbr4<27021597764222976 AND nbr3>360287970189639679 AND nbr3<364791569817010176)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( !result.compare( reference) );
    
    tokens.clear();
    pattern = QString ("052207");
    tokens << "0522" << "7";
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>369858119397801983 AND nbr3<370139594374512640))) OR(NOT(NOT(nbr2>369858119397801983 AND nbr2<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>23116613498699775 AND predictivesearch0.nbr<23116682218176512) AND NOT(predictivesearch0.nbr2>23116613498699775 AND predictivesearch0.nbr2<23116682218176512) AND NOT(predictivesearch0.nbr3>23116613498699775 AND predictivesearch0.nbr3<23116682218176512) AND NOT(predictivesearch0.nbr4>23116613498699775 AND predictivesearch0.nbr4<23116682218176512)))) OR(NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>23116132462362623 AND nbr<23133724648407040) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>23116132462362623 AND nbr<23133724648407040) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>23116132462362623 AND nbr2<23133724648407040) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>23116132462362623 AND nbr<23133724648407040) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>23116132462362623 AND nbr2<23133724648407040) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>23116132462362623 AND nbr3<23133724648407040))) OR(NOT(NOT(nbr2>23116132462362623 AND nbr2<23133724648407040 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>23116132462362623 AND nbr3<23133724648407040 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>23116132462362623 AND nbr3<23133724648407040 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>23116132462362623 AND nbr4<23133724648407040 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>23116132462362623 AND nbr4<23133724648407040 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>23116132462362623 AND nbr4<23133724648407040 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);
    QVERIFY( !result.compare( reference) );
    
    tokens.clear();
    pattern = QString ("052200007");
    tokens << "0522" << "7";
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>369858119397801983 AND nbr3<370139594374512640))) OR(NOT(NOT(nbr2>369858119397801983 AND nbr2<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>23116132579803135 AND predictivesearch0.nbr<23116132596580352) AND NOT(predictivesearch0.nbr2>23116132579803135 AND predictivesearch0.nbr2<23116132596580352) AND NOT(predictivesearch0.nbr3>23116132579803135 AND predictivesearch0.nbr3<23116132596580352) AND NOT(predictivesearch0.nbr4>23116132579803135 AND predictivesearch0.nbr4<23116132596580352)))) OR(NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>23116132462362623 AND nbr<23133724648407040) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>23116132462362623 AND nbr<23133724648407040) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>23116132462362623 AND nbr2<23133724648407040) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>23116132462362623 AND nbr<23133724648407040) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>23116132462362623 AND nbr2<23133724648407040) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>23116132462362623 AND nbr3<23133724648407040))) OR(NOT(NOT(nbr2>23116132462362623 AND nbr2<23133724648407040 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>23116132462362623 AND nbr3<23133724648407040 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>23116132462362623 AND nbr3<23133724648407040 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>23116132462362623 AND nbr4<23133724648407040 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>23116132462362623 AND nbr4<23133724648407040 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>23116132462362623 AND nbr4<23133724648407040 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);
    QVERIFY( !result.compare( reference) );
    
    tokens.clear();
    pattern = QString ("0709");
    tokens << "07" << "9";
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch7.contact_id, predictivesearch7.first_name, predictivesearch7.last_name FROM predictivesearch7 WHERE ((NOT(NOT(nbr2>648518346341351423 AND nbr2<720575940379279360 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>648518346341351423 AND nbr3<720575940379279360 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>648518346341351423 AND nbr3<720575940379279360 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>648518346341351423 AND nbr4<720575940379279360 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>648518346341351423 AND nbr4<720575940379279360 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>648518346341351423 AND nbr4<720575940379279360 AND nbr3>504403158265495551 AND nbr3<576460752303423488))) OR(NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>648518346341351423 AND nbr<720575940379279360) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>648518346341351423 AND nbr<720575940379279360) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>648518346341351423 AND nbr2<720575940379279360) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>648518346341351423 AND nbr<720575940379279360) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>648518346341351423 AND nbr2<720575940379279360) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>648518346341351423 AND nbr3<720575940379279360)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>31683527065993215 AND predictivesearch0.nbr<31701119252037632) AND NOT(predictivesearch0.nbr2>31683527065993215 AND predictivesearch0.nbr2<31701119252037632) AND NOT(predictivesearch0.nbr3>31683527065993215 AND predictivesearch0.nbr3<31701119252037632) AND NOT(predictivesearch0.nbr4>31683527065993215 AND predictivesearch0.nbr4<31701119252037632)))) OR(NOT(NOT(nbr2>648518346341351423 AND nbr2<720575940379279360 AND nbr>31525197391593471 AND nbr<36028797018963968) AND NOT(nbr3>648518346341351423 AND nbr3<720575940379279360 AND nbr>31525197391593471 AND nbr<36028797018963968) AND NOT(nbr3>648518346341351423 AND nbr3<720575940379279360 AND nbr2>31525197391593471 AND nbr2<36028797018963968) AND NOT(nbr4>648518346341351423 AND nbr4<720575940379279360 AND nbr>31525197391593471 AND nbr<36028797018963968) AND NOT(nbr4>648518346341351423 AND nbr4<720575940379279360 AND nbr2>31525197391593471 AND nbr2<36028797018963968) AND NOT(nbr4>648518346341351423 AND nbr4<720575940379279360 AND nbr3>31525197391593471 AND nbr3<36028797018963968))) OR(NOT(NOT(nbr2>31525197391593471 AND nbr2<36028797018963968 AND nbr>648518346341351423 AND nbr<720575940379279360) AND NOT(nbr3>31525197391593471 AND nbr3<36028797018963968 AND nbr>648518346341351423 AND nbr<720575940379279360) AND NOT(nbr3>31525197391593471 AND nbr3<36028797018963968 AND nbr2>648518346341351423 AND nbr2<720575940379279360) AND NOT(nbr4>31525197391593471 AND nbr4<36028797018963968 AND nbr>648518346341351423 AND nbr<720575940379279360) AND NOT(nbr4>31525197391593471 AND nbr4<36028797018963968 AND nbr2>648518346341351423 AND nbr2<720575940379279360) AND NOT(nbr4>31525197391593471 AND nbr4<36028797018963968 AND nbr3>648518346341351423 AND nbr3<720575940379279360)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);
    QVERIFY( !result.compare( reference) );
    
    tokens.clear();
    pattern = QString ("00052200007");
    tokens << "000522" << "7";
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>369858119397801983 AND nbr3<370139594374512640))) OR(NOT(NOT(nbr2>369858119397801983 AND nbr2<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>90297392889855 AND predictivesearch0.nbr<90297392955392) AND NOT(predictivesearch0.nbr2>90297392889855 AND predictivesearch0.nbr2<90297392955392) AND NOT(predictivesearch0.nbr3>90297392889855 AND predictivesearch0.nbr3<90297392955392) AND NOT(predictivesearch0.nbr4>90297392889855 AND predictivesearch0.nbr4<90297392955392)))) OR(NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>90297392431103 AND nbr<90366111907840) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>90297392431103 AND nbr<90366111907840) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>90297392431103 AND nbr2<90366111907840) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>90297392431103 AND nbr<90366111907840) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>90297392431103 AND nbr2<90366111907840) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>90297392431103 AND nbr3<90366111907840))) OR(NOT(NOT(nbr2>90297392431103 AND nbr2<90366111907840 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>90297392431103 AND nbr3<90366111907840 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>90297392431103 AND nbr3<90366111907840 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>90297392431103 AND nbr4<90366111907840 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>90297392431103 AND nbr4<90366111907840 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>90297392431103 AND nbr4<90366111907840 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);
    QVERIFY( !result.compare( reference) );
    
    tokens.clear();
    pattern = QString ("00052200007");
    tokens << "000522" << "7";
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE ((NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>369858119397801983 AND nbr3<370139594374512640))) OR(NOT(NOT(nbr2>369858119397801983 AND nbr2<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE ((NOT(NOT(predictivesearch0.nbr>90297392889855 AND predictivesearch0.nbr<90297392955392) AND NOT(predictivesearch0.nbr2>90297392889855 AND predictivesearch0.nbr2<90297392955392) AND NOT(predictivesearch0.nbr3>90297392889855 AND predictivesearch0.nbr3<90297392955392) AND NOT(predictivesearch0.nbr4>90297392889855 AND predictivesearch0.nbr4<90297392955392)))) OR(NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>90297392431103 AND nbr<90366111907840) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>90297392431103 AND nbr<90366111907840) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>90297392431103 AND nbr2<90366111907840) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>90297392431103 AND nbr<90366111907840) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>90297392431103 AND nbr2<90366111907840) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>90297392431103 AND nbr3<90366111907840))) OR(NOT(NOT(nbr2>90297392431103 AND nbr2<90366111907840 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>90297392431103 AND nbr3<90366111907840 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>90297392431103 AND nbr3<90366111907840 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>90297392431103 AND nbr4<90366111907840 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>90297392431103 AND nbr4<90366111907840 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>90297392431103 AND nbr4<90366111907840 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
    result = mCntSqlSearch->CompareTwoColumnsWithModifiedPattern(pattern, tokens);
    QVERIFY( !result.compare( reference) );
    
    TEST_PASSED_LOG("testCompareTwoColumnsWithModifiedPattern");
    }
void UT_CntSqlSearch::testModifiedMatchColumns()
    {
    TEST_BEGIN_LOG("testModifiedMatchColumns");
    QString pattern("05");
    QString reference("((NOT(NOT(predictivesearch0.nbr>22517998136852479 AND predictivesearch0.nbr<27021597764222976) AND NOT(predictivesearch0.nbr2>22517998136852479 AND predictivesearch0.nbr2<27021597764222976) AND NOT(predictivesearch0.nbr3>22517998136852479 AND predictivesearch0.nbr3<27021597764222976) AND NOT(predictivesearch0.nbr4>22517998136852479 AND predictivesearch0.nbr4<27021597764222976))))");
    QString result = mCntSqlSearch->ModifiedMatchColumns(pattern);
    QVERIFY( !result.compare( reference) );
    
    TEST_BEGIN_LOG("testModifiedMatchColumns");
    pattern = QString ("055");
    reference = QString("((NOT(NOT(predictivesearch0.nbr>23925373020405759 AND predictivesearch0.nbr<24206847997116416) AND NOT(predictivesearch0.nbr2>23925373020405759 AND predictivesearch0.nbr2<24206847997116416) AND NOT(predictivesearch0.nbr3>23925373020405759 AND predictivesearch0.nbr3<24206847997116416) AND NOT(predictivesearch0.nbr4>23925373020405759 AND predictivesearch0.nbr4<24206847997116416))))");
    result = mCntSqlSearch->ModifiedMatchColumns(pattern);
    QVERIFY( !result.compare( reference) );
    
    TEST_BEGIN_LOG("testModifiedMatchColumns");
    pattern = QString ("55");
    reference = QString("((NOT(NOT(predictivesearch5.nbr>382805968326492159 AND predictivesearch5.nbr<387309567953862656) AND NOT(predictivesearch5.nbr2>382805968326492159 AND predictivesearch5.nbr2<387309567953862656) AND NOT(predictivesearch5.nbr3>382805968326492159 AND predictivesearch5.nbr3<387309567953862656) AND NOT(predictivesearch5.nbr4>382805968326492159 AND predictivesearch5.nbr4<387309567953862656))))");
    result = mCntSqlSearch->ModifiedMatchColumns(pattern);
    QVERIFY( !result.compare( reference) );
    
    TEST_PASSED_LOG("testModifiedMatchColumns");
    }
void UT_CntSqlSearch::testExactMatch()
{
    TEST_BEGIN_LOG("testExactMatch");

    QString pattern("25");
#if defined(USE_DEMORGAN)
    QString reference("(NOT(NOT(nbr>166633186212708351 AND nbr<171136785840078848) AND NOT(nbr2>166633186212708351 AND nbr2<171136785840078848) AND NOT(nbr3>166633186212708351 AND nbr3<171136785840078848) AND NOT(nbr4>166633186212708351 AND nbr4<171136785840078848)))");
#else // #if defined(USE_DEMORGAN)
    QString reference("(nbr>166633186212708351 AND nbr<171136785840078848) OR (nbr2>166633186212708351 AND nbr2<171136785840078848) OR (nbr3>166633186212708351 AND nbr3<171136785840078848) OR (nbr4>166633186212708351 AND nbr4<171136785840078848)");
#endif // #if defined(USE_DEMORGAN)
    QString result = mCntSqlSearch->ExactMatch(pattern);
//    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    TEST_PASSED_LOG("testExactMatch");
}
void UT_CntSqlSearch::testExactMatchQwerty()
{
    TEST_BEGIN_LOG("testExactMatchQwerty");

    QString pattern("25");
#if defined(USE_DEMORGAN)
    QString reference("(NOT(NOT(n>604608249974489087 AND n<604889724951199744) AND NOT(n2>604608249974489087 AND n2<604889724951199744) AND NOT(n3>604608249974489087 AND n3<604889724951199744) AND NOT(n4>604608249974489087 AND n4<604889724951199744) AND NOT(n5>604608249974489087 AND n5<604889724951199744) AND NOT(n6>604608249974489087 AND n6<604889724951199744) AND NOT(n7>604608249974489087 AND n7<604889724951199744)))");
#else // #if defined(USE_DEMORGAN)
    QString reference("(nbr>166633186212708351 AND nbr<171136785840078848) OR (nbr2>166633186212708351 AND nbr2<171136785840078848) OR (nbr3>166633186212708351 AND nbr3<171136785840078848) OR (nbr4>166633186212708351 AND nbr4<171136785840078848)");
#endif // #if defined(USE_DEMORGAN)
    QString result = mCntSqlSearch->ExactMatchQwerty(pattern);
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    TEST_PASSED_LOG("testExactMatchQwerty");
}

void UT_CntSqlSearch::testCreateJoinTableSearch()
{
    TEST_BEGIN_LOG("testCreateJoinTableSearch");
    
    QString pattern("5606");
    QStringList tokens;
    tokens << "56" << "6";
    QString reference;
    QString result;
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE (NOT(NOT(predictivesearch5.nbr>387415121070129151 AND predictivesearch5.nbr<387432713256173568) AND NOT(predictivesearch5.nbr2>387415121070129151 AND predictivesearch5.nbr2<387432713256173568) AND NOT(predictivesearch5.nbr3>387415121070129151 AND predictivesearch5.nbr3<387432713256173568) AND NOT(predictivesearch5.nbr4>387415121070129151 AND predictivesearch5.nbr4<387432713256173568))) UNION SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 JOIN predictivesearch6 ON predictivesearch5.contact_id = predictivesearch6.contact_id WHERE(NOT(NOT(predictivesearch5.nbr>387309567953862655 AND predictivesearch5.nbr<391813167581233152) AND NOT(predictivesearch5.nbr2>387309567953862655 AND predictivesearch5.nbr2<391813167581233152) AND NOT(predictivesearch5.nbr3>387309567953862655 AND predictivesearch5.nbr3<391813167581233152) AND NOT(predictivesearch5.nbr4>387309567953862655 AND predictivesearch5.nbr4<391813167581233152)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    // TODO: add non-De Morgan cases
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->CreateJoinTableSearch(pattern, tokens);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString ("250052");
    tokens.clear();
    tokens << "25" << "52";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>166638821209800703 AND predictivesearch2.nbr<166638889929277440) AND NOT(predictivesearch2.nbr2>166638821209800703 AND predictivesearch2.nbr2<166638889929277440) AND NOT(predictivesearch2.nbr3>166638821209800703 AND predictivesearch2.nbr3<166638889929277440) AND NOT(predictivesearch2.nbr4>166638821209800703 AND predictivesearch2.nbr4<166638889929277440))) UNION SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 JOIN predictivesearch5 ON predictivesearch2.contact_id = predictivesearch5.contact_id WHERE((NOT(NOT(predictivesearch2.nbr>166633186212708351 AND predictivesearch2.nbr<171136785840078848) AND NOT(predictivesearch2.nbr2>166633186212708351 AND predictivesearch2.nbr2<171136785840078848) AND NOT(predictivesearch2.nbr3>166633186212708351 AND predictivesearch2.nbr3<171136785840078848) AND NOT(predictivesearch2.nbr4>166633186212708351 AND predictivesearch2.nbr4<171136785840078848))) AND (NOT(NOT(predictivesearch5.nbr>369295169444380671 AND predictivesearch5.nbr<373798769071751168) AND NOT(predictivesearch5.nbr2>369295169444380671 AND predictivesearch5.nbr2<373798769071751168) AND NOT(predictivesearch5.nbr3>369295169444380671 AND predictivesearch5.nbr3<373798769071751168) AND NOT(predictivesearch5.nbr4>369295169444380671 AND predictivesearch5.nbr4<373798769071751168))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    // TODO: add non-De Morgan cases
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->CreateJoinTableSearch(pattern, tokens);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern.clear();
    pattern = "2505";
    tokens.clear();
    tokens << "25" << "5";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>166721147142930431 AND predictivesearch2.nbr<166738739328974848) AND NOT(predictivesearch2.nbr2>166721147142930431 AND predictivesearch2.nbr2<166738739328974848) AND NOT(predictivesearch2.nbr3>166721147142930431 AND predictivesearch2.nbr3<166738739328974848) AND NOT(predictivesearch2.nbr4>166721147142930431 AND predictivesearch2.nbr4<166738739328974848))) UNION SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 JOIN predictivesearch5 ON predictivesearch2.contact_id = predictivesearch5.contact_id WHERE(NOT(NOT(predictivesearch2.nbr>166633186212708351 AND predictivesearch2.nbr<171136785840078848) AND NOT(predictivesearch2.nbr2>166633186212708351 AND predictivesearch2.nbr2<171136785840078848) AND NOT(predictivesearch2.nbr3>166633186212708351 AND predictivesearch2.nbr3<171136785840078848) AND NOT(predictivesearch2.nbr4>166633186212708351 AND predictivesearch2.nbr4<171136785840078848)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    // TODO: add non-De Morgan cases
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->CreateJoinTableSearch(pattern, tokens);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    // TODO: Test this case on HW and verify leading zeros.
    pattern.clear();
    pattern = "0705";
    tokens.clear();
    tokens << "7" << "5";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>145557747331497983 AND predictivesearch2.nbr<145575339517542400) AND NOT(predictivesearch2.nbr2>145557747331497983 AND predictivesearch2.nbr2<145575339517542400) AND NOT(predictivesearch2.nbr3>145557747331497983 AND predictivesearch2.nbr3<145575339517542400) AND NOT(predictivesearch2.nbr4>145557747331497983 AND predictivesearch2.nbr4<145575339517542400))) UNION SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 JOIN predictivesearch5 ON predictivesearch2.contact_id = predictivesearch5.contact_id WHERE(NOT(NOT(predictivesearch5.nbr>369295169444380671 AND predictivesearch5.nbr<373798769071751168) AND NOT(predictivesearch5.nbr2>369295169444380671 AND predictivesearch5.nbr2<373798769071751168) AND NOT(predictivesearch5.nbr3>369295169444380671 AND predictivesearch5.nbr3<373798769071751168) AND NOT(predictivesearch5.nbr4>369295169444380671 AND predictivesearch5.nbr4<373798769071751168)))) AS PR ORDER BY PR.first_name, PR.last_name ASC");
#else // #if defined(USE_DEMORGAN)
    // TODO: add non-De Morgan cases
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->CreateJoinTableSearch(pattern, tokens);
    //qDebug() << pattern << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(result));

    pattern.clear();
    pattern = "2052";
    tokens.clear();
    tokens << "2" << "52";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>145557747331497983 AND predictivesearch2.nbr<145575339517542400) AND NOT(predictivesearch2.nbr2>145557747331497983 AND predictivesearch2.nbr2<145575339517542400) AND NOT(predictivesearch2.nbr3>145557747331497983 AND predictivesearch2.nbr3<145575339517542400) AND NOT(predictivesearch2.nbr4>145557747331497983 AND predictivesearch2.nbr4<145575339517542400))) UNION SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 JOIN predictivesearch5 ON predictivesearch2.contact_id = predictivesearch5.contact_id WHERE(NOT(NOT(predictivesearch5.nbr>369295169444380671 AND predictivesearch5.nbr<373798769071751168) AND NOT(predictivesearch5.nbr2>369295169444380671 AND predictivesearch5.nbr2<373798769071751168) AND NOT(predictivesearch5.nbr3>369295169444380671 AND predictivesearch5.nbr3<373798769071751168) AND NOT(predictivesearch5.nbr4>369295169444380671 AND predictivesearch5.nbr4<373798769071751168)))) AS PR ORDER BY PR.first_name, PR.last_name ASC");
#else // #if defined(USE_DEMORGAN)
    // TODO: add non-De Morgan cases
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->CreateJoinTableSearch(pattern, tokens);
    //qDebug() << "pattern " << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(result));
    
    TEST_PASSED_LOG("testCreateJoinTableSearch");
}
void UT_CntSqlSearch::testCompareTwoQwertyColumns()
    {
    TEST_BEGIN_LOG("testChangeStringPadings");
    QString pattern("234");
    QString result;
    QString reference("");
    //result = mCntSqlSearch->CompareTwoQwertyColumns(pattern);
    //qDebug() << pattern << " -> result" << result;
    //QVERIFY( result == reference );
    TEST_PASSED_LOG("testCreateJoinTableSearch");
    }
void UT_CntSqlSearch::testChangeStringPadings()
{
    TEST_BEGIN_LOG("testChangeStringPadings");

    QString pattern("234");
    QString result;
    QString reference("234");
    result = mCntSqlSearch->ChangeStringPadings(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );

    pattern = QString("*");
    reference = QString("A");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("+");
    reference = QString("A");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("p");
    reference = QString("A");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("w");
    reference = QString("A");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("#");
    reference = QString("B");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("0#0");
    reference = QString("0B0");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("#00");
    reference = QString("B00");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("*#");
    reference = QString("AB");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("1*2#3");
    reference = QString("1A2B3");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    //Thai tests
    QLocale::setDefault(QLocale::Thai);
    pattern = QString("*");
    reference = QString("");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("+");
    reference = QString("");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("p");
    reference = QString("");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("w");
    reference = QString("");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("#");
    reference = QString("");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("0#0");
    reference = QString("00");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("#00");
    reference = QString("00");

    pattern = QString("00*");
    reference = QString("00");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    pattern = QString("*#");
    reference = QString("");
    result = mCntSqlSearch->ChangeStringPadings(pattern);

    TEST_PASSED_LOG("testChangeStringPadings");
}

void UT_CntSqlSearch::testUpperLimit()
{
    TEST_BEGIN_LOG("testUpperLimit");
    
    QString pattern("234");
    QString result;
    QString reference("159033361841520640"); 
    result = mCntSqlSearch->UpperLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    pattern = QString("234456576687687");
    reference = QString("158828188945381000");
    result = mCntSqlSearch->UpperLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    // Same result as above case, characters beyond 15th are ignored
    pattern = QString("2344565766876874906754968");
    result = mCntSqlSearch->UpperLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );

    pattern = QString("004456");
    reference = QString("1202247245496320");
    result = mCntSqlSearch->UpperLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    pattern = QString("");
    reference = QString("1152921504606846976");
    result = mCntSqlSearch->UpperLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    
    pattern = QString("000000000000000");
    reference = QString("1");
    result = mCntSqlSearch->UpperLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    pattern = QString("0000000000000");
    reference = QString("256");
    result = mCntSqlSearch->UpperLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    TEST_PASSED_LOG("testUpperLimit");
}

void UT_CntSqlSearch::testLowerLimit()
{
    TEST_BEGIN_LOG("testLowerLimit");
    
    QString pattern("234");
    QString result;
    QString reference("158751886864809983");
    result = mCntSqlSearch->LowerLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    pattern = QString("234456576687687");
    reference = QString("158828188945380998");
    result = mCntSqlSearch->LowerLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    // Same result as above case, characters beyond 15th are ignored
    pattern = QString("23445657668768749067549685");
    result = mCntSqlSearch->LowerLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );

    pattern = QString("001021");
    reference = QString("283742719442943");
    result = mCntSqlSearch->LowerLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );

    pattern = QString("1021500");
    reference = QString("72643633735532543");
    result = mCntSqlSearch->LowerLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    pattern = QString("");
    reference = QString("-1");
    result = mCntSqlSearch->LowerLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
        
    // Lower limit for this is -1
    pattern = QString("000000000000000");
    reference = QString("-1"); // Lower limit is now zero minus one
    result = mCntSqlSearch->LowerLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    // Lower limit for this is -1
    pattern = QString("00");
    reference = QString("-1");
    result = mCntSqlSearch->LowerLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );

    // Pattern contains 0xA and 0xB digits
    pattern = QString("AB0B9A");
    reference = QString("770319633126260735");
    result = mCntSqlSearch->LowerLimit(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    TEST_PASSED_LOG("testLowerLimit");
}

void UT_CntSqlSearch::testGetTokens()
    {
    TEST_BEGIN_LOG("testGetTokens");
    
    QStringList tokens = mCntSqlSearch->GetTokens("");
    QVERIFY(tokens.count() == 0);
        
    tokens = mCntSqlSearch->GetTokens("0");
    QVERIFY(tokens.count() == 0);
    
    tokens = mCntSqlSearch->GetTokens("00");
    QVERIFY(tokens.count() == 0);

    tokens = mCntSqlSearch->GetTokens("000000000000000000000000");
    QVERIFY(tokens.count() == 0);
        
    tokens = mCntSqlSearch->GetTokens("1");
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "1");
    
    tokens = mCntSqlSearch->GetTokens("01");
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "1");
    
    tokens = mCntSqlSearch->GetTokens("1");
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "1");
    
    tokens = mCntSqlSearch->GetTokens("000028");
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "28");
    
    tokens = mCntSqlSearch->GetTokens("000019700");
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "197");
    
    tokens = mCntSqlSearch->GetTokens("200");
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "2");

    tokens = mCntSqlSearch->GetTokens("101");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "1");
    QVERIFY(tokens.at(1) == "1");
    
    tokens = mCntSqlSearch->GetTokens("1203");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "12");
    QVERIFY(tokens.at(1) == "3");
    
    tokens = mCntSqlSearch->GetTokens("000012013");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "000012");
    QVERIFY(tokens.at(1) == "13");
    
    tokens = mCntSqlSearch->GetTokens("00206");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "002");
    QVERIFY(tokens.at(1) == "6");
    
    tokens = mCntSqlSearch->GetTokens("001230045067800900");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "00123");
    QVERIFY(tokens.at(1) == "45067800900");
    
    tokens = mCntSqlSearch->GetTokens("1000002030405060708090011");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "1");
    QVERIFY(tokens.at(1) == "2030405060708090011");
    
    tokens = mCntSqlSearch->GetTokens("4304");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "43");
    QVERIFY(tokens.at(1) == "4");
    
    tokens = mCntSqlSearch->GetTokens("010203040506070809011001200130014001500");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "01");
    QVERIFY(tokens.at(1) == "203040506070809011001200130014001500");

    TEST_PASSED_LOG("testGetTokens");
    }

void UT_CntSqlSearch::testTestPattern()
    {
    TEST_BEGIN_LOG("testTestPattern");
    QString pattern("000");
    int result;
    int reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZerosEndOfFirstToken);
    QCOMPARE( result, reference );

    pattern = QString("0");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZerosEndOfFirstToken);
    QCOMPARE( result, reference );

    pattern = QString("20");
    reference = true;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZerosEndOfFirstToken);
    QCOMPARE( result, reference );

    pattern = QString("202");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZerosEndOfFirstToken);
    QCOMPARE( result, reference );

    pattern = QString("200");
    reference = true;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZerosEndOfFirstToken);
    QCOMPARE( result, reference );

    pattern = QString("2000");
    reference = true;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZerosEndOfFirstToken);
    QCOMPARE( result, reference );

    pattern = QString("020002");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZerosEndOfFirstToken);
    QCOMPARE( result, reference );

    pattern = QString("A0");
    reference = true;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZerosEndOfFirstToken);
    QCOMPARE( result, reference );

    pattern = QString("");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZerosEndOfFirstToken);
    QCOMPARE( result, reference );
    TEST_PASSED_LOG("testTestPattern");

    pattern = QString("232");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZerosEndOfFirstToken);
    QCOMPARE( result, reference );
    
    pattern = QString("232");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("2320");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("2302");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("23020");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("023020");
    reference = true;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("02320");
    reference = true;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("02302");
    reference = true;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("0232");
    reference = true;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("00232");
    reference = true;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("052207");
    reference = true;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("0");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("00");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("1");
    reference = false;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
    
    pattern = QString("05");
    reference = true;
    result = mCntSqlSearch->TestPattern(pattern, CntSqlSearch::ZeroIsFirstNumber);
    QCOMPARE( result, reference );
     
    TEST_PASSED_LOG("testTestPattern");
    }

void UT_CntSqlSearch::testIsQwerty()
    {
    TEST_BEGIN_LOG("testTestIsQwerty");
    QString pattern = QString("s") + QChar(30) + QString("vqwerty");
    QVERIFY(mCntSqlSearch->isQwerty(pattern));
    pattern = QString(" ") + QChar(30) + QString("vqwerty");
    QVERIFY(mCntSqlSearch->isQwerty(pattern));
    pattern = QString("") + QChar(30) + QString("vqwerty");
    QVERIFY(mCntSqlSearch->isQwerty(pattern));
    pattern = QString("p a") + QChar(30) + QString("vqwerty");
    QVERIFY(mCntSqlSearch->isQwerty(pattern));
    pattern = QString("&") + QChar(30) + QString("vqwerty");
    QVERIFY(mCntSqlSearch->isQwerty(pattern));
    pattern = QString("6") + QChar(30) + QString("vqwerty");
    QVERIFY(mCntSqlSearch->isQwerty(pattern));
    pattern = QString("6") + QChar(30) + QString("vqwerty");
    QVERIFY(mCntSqlSearch->isQwerty(pattern));
    pattern = QString("vqwerty");
    QVERIFY(!mCntSqlSearch->isQwerty(pattern));
    pattern = QChar(30);
    QVERIFY(!mCntSqlSearch->isQwerty(pattern));
    TEST_PASSED_LOG("testIsQwerty");
    }
void UT_CntSqlSearch::testremZerosEndOfString()
    {
    TEST_BEGIN_LOG("testremZerosEndOfString");
    QString reference("002");
    QString pattern = QString("002");
    QString result = mCntSqlSearch->remZerosEndOfString(pattern);
    QVERIFY( result == reference );
    reference = QString("002");
    pattern = QString("00200");
    result = mCntSqlSearch->remZerosEndOfString(pattern);   
    QVERIFY( result == reference );
    reference = QString("2");
    pattern = QString("200");
    result = mCntSqlSearch->remZerosEndOfString(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    reference = QString("00202");
    pattern = QString("0020200");
    result = mCntSqlSearch->remZerosEndOfString(pattern);
    //qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    reference = QString("00202");
    pattern = QString("00202");
    result = mCntSqlSearch->remZerosEndOfString(pattern);
    QVERIFY( result == reference );
    TEST_PASSED_LOG("testremZerosEndOfString");
    }
void UT_CntSqlSearch::testQwertyTokens()
    {
    TEST_BEGIN_LOG("testQwertyTokens");
    QString pattern = QString("") + QChar(30) + QString("vqwerty");
    QStringList tokens = mCntSqlSearch->qwertyTokens(pattern);
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "");
    
    pattern = QString("a") + QChar(30) + QString("vqwerty");
    tokens = mCntSqlSearch->qwertyTokens(pattern);
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "a");
  
    pattern = QString("a a") + QChar(30) + QString("vqwerty");
    tokens = mCntSqlSearch->qwertyTokens(pattern);
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "a");
    QVERIFY(tokens.at(1) == "a");
    
    pattern = QString("abc") + QChar(30) + QString("vqwerty");
    tokens = mCntSqlSearch->qwertyTokens(pattern);
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "abc");

    pattern = QString("abc  d") + QChar(30) + QString("vqwerty");
    tokens = mCntSqlSearch->qwertyTokens(pattern);
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "abc");
    QVERIFY(tokens.at(1) == "d");
    
    pattern = QString(" abc  d") + QChar(30) + QString("vqwerty");
    tokens = mCntSqlSearch->qwertyTokens(pattern);
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "abc");
    QVERIFY(tokens.at(1) == "d");
    
    pattern = QString("abc  d") + QChar(30) + QString("vqwerty");
    tokens = mCntSqlSearch->qwertyTokens(pattern);
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "abc");
    QVERIFY(tokens.at(1) == "d");
    
    pattern = QString(" 1234  5 ") + QChar(30) + QString("vqwerty");
    tokens = mCntSqlSearch->qwertyTokens(pattern);
    QVERIFY(tokens.count() == 2);
    //QVERIFY(tokens.at(0) == "1234");
    //QVERIFY(tokens.at(1) == "5");
     
    TEST_PASSED_LOG("TestQwertyTokens");
    }
#if defined(WRITE_LOGS)
void WriteLog(const QString a, const QString b)
    {
    TPtrC16 ptr(reinterpret_cast<const TUint16*>(a.utf16()));
    WritePart(ptr);
    
    if (b.size() > 0)
        {
        TPtrC16 ptr2(reinterpret_cast<const TUint16*>(b.utf16()));
        WritePart(ptr2);
        }
    }

void WritePart(const TDesC& s)
    {
    // RDebug::Print() only writes first 256 chars
    const TInt KMaxLength = 255;
        
    TInt pos(0);
    TInt len = s.Length();  
    while (pos < len)
        {
        TInt partLength = KMaxLength;
        if (pos + partLength > len)
            {
            partLength = len - pos;
            }
        TPtrC16 part = s.Mid(pos, partLength);
        RDebug::Print(part);
        pos += KMaxLength;
        }
    }
#endif // #if defined(WRITE_LOGS)


#ifdef SQL_QT_TEST
//QTEST_APPLESS_MAIN(UT_CntSqlSearch)
#endif

