/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment unit test base
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __PGM_CHECK_H__
#define __PGM_CHECK_H__

#include <gst/check/gstcheck.h>

void pgm_check_standard_init (void);
void pgm_check_standard_shutdown (void);


#define PGM_USE_STANDARD_FIXTURES(test_case)                                \
    do{                                                                     \
      tcase_add_checked_fixture (test_case, pgm_check_standard_init,        \
                                 pgm_check_standard_shutdown);              \
    }while(0)

/* FIXME: use some error description function here when there's one */
#define ASSERT_PGM_SUCCESS(code)                                              \
G_STMT_START {                                                                \
  PgmError ret = PGM_ERROR_OK;                                                \
  ret = (code);                                                               \
  fail_unless (PGM_ERROR_OK == ret, "%s returned 0x%x "                       \
               "instead of 0x%x (OK)\n",                                      \
               #code, ret, PGM_ERROR_OK);                                     \
} G_STMT_END

#define ASSERT_PGM_ERROR(code)                                                \
G_STMT_START {                                                                \
  PgmError ret = PGM_ERROR_OK;                                                \
  ret = (code);                                                               \
  fail_unless (PGM_ERROR_OK != ret, "expected an error but %s "               \
               "returned 0x%x (OK) \n",                                       \
               #code, ret);                                                   \
} G_STMT_END

/* Use this if code is expected to return an error and call g_warning (). */
#define ASSERT_PGM_ERROR_WITH_WARNING(code)                                   \
G_STMT_START {                                                                \
  PgmError ret = PGM_ERROR_OK;                                                \
  _gst_check_expecting_log = TRUE;                                            \
  _gst_check_raised_warning = FALSE;                                          \
  ret = (code);                                                               \
  _fail_unless (_gst_check_raised_warning, __FILE__, __LINE__,                \
                "Expected g_warning, got nothing", NULL);                     \
  _fail_unless (PGM_ERROR_OK != ret, __FILE__, __LINE__,                      \
               "expected an error but %s returned 0x%x (OK) \n", #code, ret); \
  _gst_check_expecting_log = FALSE;                                           \
} G_STMT_END

/* Use this if code is expected to return an error and call g_critical () (e.g.
 * through g_return_if_fail () and friends). */
#define ASSERT_PGM_ERROR_WITH_CRITICAL(code)                                  \
G_STMT_START {                                                                \
  PgmError ret = PGM_ERROR_OK;                                                \
  _gst_check_expecting_log = TRUE;                                            \
  _gst_check_raised_critical = FALSE;                                         \
  ret = (code);                                                               \
  _fail_unless (_gst_check_raised_critical, __FILE__, __LINE__,               \
                "Expected g_critical, got nothing", NULL);                    \
  _fail_unless (PGM_ERROR_OK != ret, __FILE__, __LINE__,                      \
               "expected an error but %s returned 0x%x (OK) \n", #code, ret); \
  _gst_check_expecting_log = FALSE;                                           \
} G_STMT_END

/* Internal use. */
gboolean
_pgm_check_run_test_func (const gchar * func_name);

#define PGM_START_TEST(test_name)                                             \
  GST_START_TEST (test_name)                                                  \
  if (!_pgm_check_run_test_func (__func__))                                   \
    return;

#define PGM_END_TEST GST_END_TEST

#endif /* __PGM_CHECK_H__ */
