/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment video example
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#include <pgm/pgm.h>

int
main (int argc, char *argv[])
{
  PgmViewport *viewport = NULL;
  PgmCanvas *canvas;
  PgmDrawable *img;
  GstElement *pipeline, *image_sink;
  gulong formats;

  /* Argument check */
  if (argc != 2)
    {
      g_print ("usage: %s uri\n", argv[0]);
      return -1;
    }

  /* Init */
  pgm_init (&argc, &argv);

  /* OpenGL viewport creation */
  pgm_viewport_factory_make ("opengl", &viewport);
  if (!viewport)
    {
      g_print ("Cannot create the 'opengl' viewport\n");
      return -1;
    }
  pgm_viewport_set_title (viewport, "Video");
  pgm_viewport_set_alpha_blending (viewport, FALSE);

  /* Display supported pixel formats */
  pgm_viewport_get_pixel_formats (viewport, &formats);
  g_print ("Formats supported by 'opengl' viewport:\n"
           "RGB:  %s\nRGBA: %s\nBGR:  %s\nBGRA: %s\nI420: %s\nYV12: %s\n"
           "YUYV: %s\nUYVY: %s\n",
           (formats & PGM_IMAGE_RGB) != 0 ? "Yes" : "No",
           (formats & PGM_IMAGE_RGBA) != 0 ? "Yes" : "No",
           (formats & PGM_IMAGE_BGR) != 0 ? "Yes" : "No",
           (formats & PGM_IMAGE_BGRA) != 0 ? "Yes" : "No",
           (formats & PGM_IMAGE_I420) != 0 ? "Yes" : "No",
           (formats & PGM_IMAGE_YV12) != 0 ? "Yes" : "No",
           (formats & PGM_IMAGE_YUYV) != 0 ? "Yes" : "No",
           (formats & PGM_IMAGE_UYVY) != 0 ? "Yes" : "No");

  /* Image definition */
  img = pgm_image_new ();
  pgm_drawable_set_size (img, 4.0f, 3.0f);
  pgm_drawable_set_position (img, 0.0f, 0.0f, 0.0f);
  pgm_drawable_set_bg_color (img, 0, 0, 0, 0);
  pgm_drawable_show (img);

  /* Canvas handling */
  canvas = pgm_canvas_new ();
  pgm_viewport_set_canvas (viewport, canvas);
  pgm_canvas_add (canvas, PGM_DRAWABLE_MIDDLE, img);

  /* GStreamer pipeline setup */
  pipeline = gst_element_factory_make ("playbin", NULL);
  image_sink = gst_element_factory_make ("pgmimagesink", NULL);
  g_object_set (G_OBJECT (pipeline), "uri", argv[1], NULL);
  g_object_set (G_OBJECT (pipeline), "video-sink", image_sink, NULL);
  g_object_set (G_OBJECT (image_sink), "image", img, NULL);
  gst_element_set_state (pipeline, GST_STATE_PLAYING);

  /* Main loop */
  g_signal_connect (G_OBJECT (viewport), "delete-event",
                    G_CALLBACK (pgm_main_quit), NULL);
  pgm_viewport_show (viewport);
  pgm_main ();

  /* Deinit */
  gst_object_unref (canvas);
  gst_object_unref (viewport);
  pgm_deinit ();

  return 0;
}
