/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLTest/Thread.h"

#ifdef GTLTEST_HAVE_THREAD

class MyThreadTMMT : public GTLTest::Thread {
  public:
    MyThreadTMMT() : m_stop(false)
    {
    }
    void stop()
    {
      m_stop = true;
    }
  protected:
    virtual void run()
    {
      while(not m_stop)
      {
        int size = rand() / 1000000;
        void* m = GTLCore::MemoryManager::allocate(size);
        GTLCore::MemoryManager::desallocate(m);
      }
    }
  private:
    bool m_stop;
};

class TestMemoryManagerThread : public GTLTest::Case {
  public:
    TestMemoryManagerThread() : GTLTest::Case("MemoryManagerThread")
    {
    }
    virtual void runTest()
    {
      MyThreadTMMT thread1;
      thread1.start();
      MyThreadTMMT thread2;
      thread2.start();
      MyThreadTMMT thread3;
      thread3.start();
      MyThreadTMMT thread4;
      thread4.start();
      sleep(1);
      thread1.stop();
      thread2.stop();
      thread3.stop();
      thread4.stop();
      thread1.wait();
      thread2.wait();
      thread3.wait();
      thread4.wait();
    }
};

#endif
