/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Array.h"

#include <string.h>

#include "Debug.h"

using namespace GTLCore;

struct Array::Private {
  Private() : rawData(0) {}
  char* rawData;
};

Array::Array() : d(new Private)
{
}

Array::Array(const Array& rhs) : d(new Private)
{
  *this = rhs;
}

Array& Array::operator=(const Array& rhs)
{
  if( rhs.size() != size())
  {
    resize( rhs.size() );
  }
  GTL_ASSERT(size() == rhs.size());
  memcpy(d->rawData, rhs.d->rawData, size());
  return *this;
}

Array::Array(int size) : d(new Private)
{
  resize(size);
}
Array::~Array()
{
  delete[] d->rawData;
  delete d;
}

void Array::resize(int _size)
{
  delete[] d->rawData;
  d->rawData = new char[_size];
  setRawData(d->rawData, _size);
}
