/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _PIXEL_CONVERT_EXPRESSION_FACTORY_H_
#define _PIXEL_CONVERT_EXPRESSION_FACTORY_H_

#include "GTLCore/ConvertCenter_p.h"

namespace OpenShiva {

  class PixelConvertExpressionFactory : public GTLCore::ConvertExpressionFactory {
    public:
      PixelConvertExpressionFactory();
      virtual ~PixelConvertExpressionFactory();
      virtual GTLCore::AST::ConvertExpression* create( GTLCore::AST::Expression* value, const GTLCore::Type* _dstType ) const;
      virtual bool canConvertBetween( const GTLCore::Type* srcType, const GTLCore::Type* dstType) const;
      virtual GTLCore::ConvertCenter::ConversionQuality conversionQuality( const GTLCore::Type* _srcType, const GTLCore::Type* _dstType ) const;
  };
}

#endif
