/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_METADATA_PARSER_P_H_
#define _OPENSHIVA_METADATA_PARSER_P_H_

#include <list>
#include <GTLCore/Token_p.h>
#include <OpenShiva/Export.h>

namespace GTLCore {
  class ErrorMessage;
  class String;
  class Token;
  class Value;
  namespace Metadata {
    class Entry;
    class ParameterEntry;
    class ValueEntry;
    class TextEntry;
    class Group;
  }
}

namespace OpenShiva {
  class Metadata;
  class MetadataLexer;
  /**
    * @internal
    * @ingroup OpenShiva
    */
  class OPENSHIVA_TESTS_EXPORT MetadataParser {
    public:
      MetadataParser( MetadataLexer* _lexer, const GTLCore::String& fileName);
      ~MetadataParser();
      Metadata* parse();
      const std::list<GTLCore::ErrorMessage>& errorMessages() const;
    private:
      const GTLCore::Metadata::ValueEntry* parseValueEntry(const GTLCore::String& name);
      GTLCore::Value parseCoumpoundValue();
      const GTLCore::Metadata::ParameterEntry* parseParameterEntry(const GTLCore::String& name);
      const GTLCore::Metadata::TextEntry* parseTextEntry(const GTLCore::String& name);
      const GTLCore::Metadata::Entry* parseGroupOrParameterEntry(const GTLCore::String& name, bool _parameter);
    private:
      void getNextToken();
      const GTLCore::Token& currentToken();
      void reportError( const GTLCore::String& errMsg, const GTLCore::Token& token );
      void reportUnexpected( const GTLCore::Token& token );
      bool isOfType( const GTLCore::Token& , GTLCore::Token::Type type );
      void validateParameters(const GTLCore::Metadata::Group* arg1);
    private:
      struct Private;
      Private* const d;
  };
}

#endif
