/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_KERNEL_METADATA_H_
#define _OPENSHIVA_KERNEL_METADATA_H_

#include <GTLCore/Metadata/Group.h>
#include <OpenShiva/Export.h>

namespace OpenShiva {
  class OPENSHIVA_EXPORT Metadata : public GTLCore::Metadata::Group {
      friend class MetadataParser;
      friend class Kernel;
      Metadata( const GTLCore::Metadata::Entry* _version, const GTLCore::Metadata::Group* _infoList, const GTLCore::Metadata::Group* _parametersList );
      ~Metadata();
    public:
      int version() const;
      const GTLCore::Metadata::Group* infos() const;
      const GTLCore::Metadata::Group* parameters() const;
      const GTLCore::Metadata::ParameterEntry* parameter(const GTLCore::String& _name) const;
    private:
      struct Private;
      Private* const d;
  };
}

#endif

