/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Kernel_p.h"

#include "GTLCore/Parameter.h"
#include "GTLCore/ErrorMessage.h"
#include "GTLCore/Function.h"
#include "GTLCore/ModuleData_p.h"
#include "GTLCore/Macros_p.h"
#include "GTLCore/Type.h"
#include "GTLCore/TypesManager.h"

#include "Debug.h"

#include "Library_p.h"

using namespace OpenShiva;

KernelPrivate::KernelPrivate() : m_imageWidthHint(800), m_imageHeightHint(600)
{
}

KernelPrivate::~KernelPrivate()
{
}

void KernelPrivate::preCompilation()
{
  self->setParameter( "IMAGE_WIDTH", m_imageWidthHint );
  self->setParameter( "IMAGE_HEIGHT", m_imageHeightHint );
  std::vector<GTLCore::Value> values;
  values.push_back( m_imageWidthHint);
  values.push_back( m_imageHeightHint);
  self->setParameter( "IMAGE_SIZE", GTLCore::Value(values, GTLCore::TypesManager::getVector(GTLCore::Type::Float, 2) ) );
}

GTLCore::ModuleData* KernelPrivate::moduleData()
{
  return self->Library::d->m_moduleData;
}

void KernelPrivate::determineTypes()
{
  m_inputsTypes.clear();
  const std::list<GTLCore::Function*>*  ePFunctions = self->Library::d->m_moduleData->function( self->name(), "evaluatePixel" );
  GTL_ASSERT(ePFunctions);
  GTLCore::Function* ePFunction = ePFunctions->front();
  bool hasOutput = false;
  foreach( GTLCore::Parameter arg, ePFunction->parameters() )
  {
    if( arg.isOutput() )
    {
      SHIVA_ASSERT(not hasOutput );
      hasOutput = true;
      m_outputPixelType = arg.type();
      SHIVA_ASSERT( m_outputPixelType->dataType() == GTLCore::Type::STRUCTURE );
      SHIVA_ASSERT( m_outputPixelType->structName().head( 5 ) == "pixel" );
      if(  m_outputPixelType->structName() == "pixel" )
      {
        m_outputImageType = self->Library::d->m_moduleData->typesManager()->getStructure( "image" );
      } else {
        m_outputImageType = self->Library::d->m_moduleData->typesManager()->getStructure( "image" + m_outputPixelType->structName().tail(1) );
      }
      GTL_ASSERT( m_outputImageType );
    } else {
      SHIVA_ASSERT( arg.type()->dataType() == GTLCore::Type::STRUCTURE );
      SHIVA_ASSERT( arg.type()->structName().head( 5 ) == "image" );
      m_inputsTypes.push_back( arg.type() );
    }
  }
  SHIVA_ASSERT( hasOutput );
}

const std::list< const GTLCore::Type* >& KernelPrivate::inputsTypes()
{
  return m_inputsTypes;
}

const GTLCore::Type* KernelPrivate::outputPixelType()
{
  return m_outputPixelType;
}

const GTLCore::Type* KernelPrivate::outputImageType()
{
  return m_outputImageType;
}
