/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "../SysUtils_p.h"

class TestStringLowerUpper : public GTLTest::Case {
  public:
    TestStringLowerUpper() : GTLTest::Case("LowerUpper")
    {
    }
    virtual void runTest()
    {
      GTLCore::String string("ShIvA");
      GTLTEST_CHECK_EQUAL( string.toLower(), "shiva");
      GTLTEST_CHECK_EQUAL( string.toUpper(), "SHIVA");
      GTLTEST_CHECK_EQUAL( string, "ShIvA");
    }
};

class TestStringHeadTail : public GTLTest::Case {
  public:
    TestStringHeadTail() : GTLTest::Case("HeadTail")
    {
    }
    virtual void runTest()
    {
      GTLCore::String string("myfile.shiva");
      GTLTEST_CHECK_EQUAL( string.head(6), "myfile");
      GTLTEST_CHECK_EQUAL( string.tail(6), ".shiva");
      GTLTEST_CHECK_EQUAL( string, "myfile.shiva");
    }
};

class TestStringConstructor : public GTLTest::Case {
  public:
    TestStringConstructor() : GTLTest::Case("Constructor")
    {
    }
    virtual void runTest()
    {
      GTLCore::String string("hello");
      GTLTEST_CHECK_EQUAL( string, "hello");
      GTLTEST_CHECK_EQUAL( GTLCore::String(string), "hello");
      std::string stdstring = string;
      GTLTEST_CHECK_EQUAL( GTLCore::String(stdstring), "hello");
      string.append("bouh");
      GTLTEST_CHECK_EQUAL( string, "hellobouh");
      string.append(string);
      GTLTEST_CHECK_EQUAL( string, "hellobouhhellobouh");
    }
};

class TestStringNumber : public GTLTest::Case {
  public:
    TestStringNumber() : GTLTest::Case("Number")
    {
    }
    virtual void runTest()
    {
      GTLTEST_CHECK_EQUAL(GTLCore::String::number(10), "10");
      GTLTEST_CHECK_EQUAL(GTLCore::String::number(-10), "-10");
      GTLTEST_CHECK_EQUAL(GTLCore::String::number(12.42f), "12.42");
      GTLTEST_CHECK_EQUAL(GTLCore::String::number(-42.12f), "-42.12");
    }
};

class TestStringSplit : public GTLTest::Case {
  public:
    TestStringSplit() : GTLTest::Case("Split")
    {
    }
    virtual void runTest()
    {
      GTLCore::String hello("a,b;cd,efg;hij;jkl;mnop");
      std::list<GTLCore::String> res = hello.split(",;.");
      std::list<GTLCore::String>::iterator it = res.begin();
      GTLTEST_CHECK_EQUAL( *it, "a"); ++it;
      GTLTEST_CHECK_EQUAL( *it, "b"); ++it;
      GTLTEST_CHECK_EQUAL( *it, "cd"); ++it;
      GTLTEST_CHECK_EQUAL( *it, "efg"); ++it;
      GTLTEST_CHECK_EQUAL( *it, "hij"); ++it;
      GTLTEST_CHECK_EQUAL( *it, "jkl"); ++it;
      GTLTEST_CHECK_EQUAL( *it, "mnop");
    }
};

class TestStringSubstr : public GTLTest::Case {
  public:
    TestStringSubstr() : GTLTest::Case("Substr")
    {
    }
    virtual void runTest()
    {
      GTLCore::String hello("Hello World");
      GTLTEST_CHECK( hello.startWith("Hello") );
      GTLTEST_CHECK( not hello.startWith("World") );
      GTLTEST_CHECK( not hello.startWith("Hellow World !") );
      GTLTEST_CHECK( not hello.endWith("Hello") );
      GTLTEST_CHECK( hello.endWith("World") );
      GTLTEST_CHECK( not hello.endWith("Hellow World !") );
    }
};

class TestStringTrimmed : public GTLTest::Case {
  public:
    TestStringTrimmed() : GTLTest::Case("Trimmed")
    {
    }
    virtual void runTest()
    {
      GTLCore::String hello("  Hello world   ");
      GTLTEST_CHECK_EQUAL(hello.trimmed(), "Hello world");
      GTLCore::String hello2("  Hello world");
      GTLTEST_CHECK_EQUAL(hello2.trimmed(), "Hello world");
      GTLCore::String hello3("Hello world   ");
      GTLTEST_CHECK_EQUAL(hello3.trimmed(), "Hello world");
      GTLCore::String hello4("Hello world");
      GTLTEST_CHECK_EQUAL(hello4.trimmed(), "Hello world");
    }
};

class TestExtractDir : public GTLTest::Case {
  public:
    TestExtractDir() : GTLTest::Case("ExtractDir")
    {
    }
    virtual void runTest()
    {
      GTLTEST_CHECK_EQUAL(GTLCore::extractDir("/dir/boh"), "/dir/");
      GTLTEST_CHECK_EQUAL(GTLCore::extractDir("/dir/"), "/dir/");
      GTLTEST_CHECK_EQUAL(GTLCore::extractDir("/boh"), "/");
      GTLTEST_CHECK_EQUAL(GTLCore::extractDir("\\dir\\"), "\\dir\\");
      GTLTEST_CHECK_EQUAL(GTLCore::extractDir("boh"), "");
    }
};

class TestString : public GTLTest::Suite {
  public:
    TestString() : GTLTest::Suite("String")
    {
      addCase( new TestStringConstructor);
      addCase( new TestStringNumber);
      addCase( new TestStringLowerUpper );
      addCase( new TestStringHeadTail );
      addCase( new TestStringSplit );
      addCase( new TestStringSubstr );
      addCase( new TestStringTrimmed );
      addCase( new TestExtractDir );
    }
};
