/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "String.h"

#include <cstdlib>
#include <sstream>

using namespace GTLCore;

String::String()
{
}

String::String(char c)
{
  *((std::string*)this) = c;
}

String::String(const char* c) : std::string(c)
{
}

String::String(const std::string& str) : std::string(str)
{
}

String::String(const String& str) : std::string(str)
{
}
String& String::append(const char* c)
{
  *this += c;
  return *this;
}

String& String::append(const std::string& str)
{
  *this += str;
  return *this;
}

String& String::append(const String& str)
{
  *this += str;
  return *this;
}

String String::number(int i )
{
  std::stringstream ss;
  String str;
  ss << i;
  ss >> str;
  return str;
}

String String::number(unsigned int i)
{
  std::stringstream ss;
  String str;
  ss << i;
  ss >> str;
  return str;
}

String String::number(float f )
{
  std::stringstream ss;
  String str;
  ss << f;
  ss >> str;
  return str;
}

String String::number(double f)
{
  std::stringstream ss;
  String str;
  ss << f;
  ss >> str;
  return str;
}


int String::toInt() const
{
  return atoi( c_str() );
}

float String::toFloat() const
{
  return atof( c_str() );
}

String String::head(int n) const
{
  return substr(0, n );
}
String String::tail(int n) const
{
  return substr(length() - n, n );
}

String String::toLower() const
{
  const char* c = c_str();
  String res;
  for(unsigned int i = 0; i < length(); ++i)
  {
    res += tolower(c[i]);
  }
  return res;
}


String String::toUpper() const
{
  const char* c = c_str();
  String res;
  for(unsigned int i = 0; i < length(); ++i)
  {
    res += toupper(c[i]);
  }
  return res;
}

String& String::operator=(char c)
{
  *((std::string*)this) = c;
  return *this;
}

std::list<String> String::split( const String& _separators , bool _allowEmpty) const
{
  std::list<String> separatorsList;
  for( size_t i = 0; i < _separators.length(); ++i)
  {
    separatorsList.push_back( _separators[ i ] );
  }
  return split( separatorsList, _allowEmpty );
}

std::list<String> String::split( const std::list<String>& _separators, bool _allowEmpty) const
{
  std::list<String> result;
  int lastPos = 0;
  for( size_t i = 0; i < length(); ++i )
  {
    String::const_reference cc = (*this)[i];
    for( std::list<String>::const_iterator it = _separators.begin();
         it != _separators.end(); ++it)
    {
      if( (*it)[0] == cc )
      {
        if( i - lastPos > 0 )
        {
          result.push_back( substr( lastPos, i - lastPos ) );
        }
        lastPos = i + 1;
        break;
      }
    }
  }
  result.push_back( substr( lastPos, length() - lastPos ) );
  return result;
}

bool String::startWith(const GTLCore::String& _sw) const
{
  if(_sw.length() > length() ) return false;
  return substr(0, _sw.size()) == _sw;
}

bool String::endWith(const GTLCore::String& _sw) const
{
  if(_sw.length() > length() ) return false;
  return substr( length() - _sw.length(), _sw.length() ) == _sw;
}

String String::trimmed() const
{
  int start = 0;
  int end = length() - 1;
  while( (*this)[start] == ' ' ) ++start;
  while( (*this)[end] == ' ' ) --end;
  return substr(start, end - start + 1);
}
