/*
 *  Copyright (c) 2007 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_PARAMETER_H_
#define _OPENCTL_PARAMETER_H_

#include <GTLCore/String.h>

namespace GTLCore {
  class Type;
  class Value;
  /**
   * This class describes one argument to a function.
   * @ingroup GTLCore
   */
  class GTLCORE_EXPORT Parameter {
    public:
      Parameter(const GTLCore::String& _name, const GTLCore::Type* _type, bool _output, bool _varying, const Value& _defaultValue);
      Parameter(const Parameter& arg);
      ~Parameter();
      Parameter& operator=(const Parameter& rhs);
      const GTLCore::String& name() const;
      const GTLCore::Type* type() const;
      const Value& defaultValue() const;
      GTL_DEPRECATED bool output() const;
      bool isOutput() const;
    private:
      Parameter();
      struct Private;
      Private* const d;
  };
  
}

#endif
