/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Group.h"
#include "Factory_p.h"

#include "../Debug.h"
#include "../Macros_p.h"

#include "TextEntry.h"

using namespace GTLCore::Metadata;

struct Group::Private {
  std::list< const Entry* > entries;
  GTLCore::String label;
};

Group::Group( const GTLCore::String& _name, const std::list< const Entry* >& _entries) : Entry( _name), d(new Private)
{
  d->entries = _entries;
  // Label
  const Entry* labelEntry = entry( "label" );
  if( labelEntry )
  {
    const TextEntry* v = labelEntry->asTextEntry();
    GTL_ASSERT( v );
    d->label = v->text();
  }
}

Group::~Group()
{
  foreach( const Entry* entry, d->entries )
  {
    Factory::deleteEntry( entry );
  }
  delete d;
}

const Entry* Group::entry( const GTLCore::String& _name ) const
{
  foreach( const Entry* entry, d->entries )
  {
    GTL_ASSERT( entry );
    if( entry->name() == _name )
    {
      return entry;
    }
  }
  return 0;
}

const std::list< const Entry* >& Group::entries() const
{
  return d->entries;
}

const Group* Group::asGroup() const
{
  return this;
}

const GTLCore::String& Group::label() const
{
  return d->label;
}
