/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_METADATA_FACTORY_H_
#define _GTLCORE_METADATA_FACTORY_H_

#include <GTLCore/String.h>

namespace GTLCore {
  class Value;
  namespace Metadata {
    class Entry;
    class Group;
    class ParameterEntry;
    class TextEntry;
    class ValueEntry;
    /**
     * @internal
     * @ingroup GTLCore_Metadata
     * This class is only used to create metadata objects
     */
    class GTLCORE_EXPORT Factory {
      Factory();
      public:
        static const Entry* createEntry( const GTLCore::String& _name);
        static const TextEntry* createTextEntry( const GTLCore::String& _name, const GTLCore::String& _text);
        static const Group* createGroup( const GTLCore::String& _name, const std::list< const Entry* >& _entries);
        static void deleteEntry( const Entry* );
        static const ParameterEntry* createParameterEntry( const GTLCore::String& _name, const std::list< const Entry* >& _entries );
        static const ValueEntry* createValueEntry( const GTLCore::String& _name, const GTLCore::Value& _value  );
    };
  }
}

#endif
