/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Image.h"

#include "GTLCore/Array.h"
#include "GTLCore/PixelDescription.h"

using namespace GTLCore;

struct Image::Private {
};

Image::Image(int _width, int _height, const PixelDescription& _pixelDescription) : BufferImage(_width, _height, new Array(_height * _width * _pixelDescription.bitsSize() / 8), _pixelDescription ), d(new Private)
{
}

Image::~Image()
{
  delete d;
}
