/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ExpressionGenerationContext_p.h"

#include "Debug.h"
#include <llvm/BasicBlock.h>

#include "Macros_p.h"

using namespace GTLCore;

ExpressionGenerationContext::ExpressionGenerationContext(llvm::BasicBlock* _basicBlock) : m_currentBasicBlock(_basicBlock)
{
}
ExpressionGenerationContext::~ExpressionGenerationContext()
{
}

ExpressionGenerationContext& ExpressionGenerationContext::operator=(const ExpressionGenerationContext& rhs)
{
  UNUSED(rhs);
  GTL_ABORT("Don't copy ExpressionGenerationContext");
}
ExpressionGenerationContext::ExpressionGenerationContext(const ExpressionGenerationContext& rhs)
{
  UNUSED(rhs);
  GTL_ABORT("Don't copy ExpressionGenerationContext");
}

llvm::BasicBlock* ExpressionGenerationContext::currentBasicBlock()
{
  return m_currentBasicBlock;
}

void ExpressionGenerationContext::setCurrentBasicBlock(llvm::BasicBlock* _bb)
{
  if( m_currentBasicBlock == _bb) return;
  GTL_ASSERT( m_currentBasicBlock == 0 or m_currentBasicBlock->getTerminator() );
  m_currentBasicBlock = _bb;
}
