
import "TestFramework";

int main()
{
  int errorcount = 0;
  Test::checkNearEqual( acos(1.0), 0.0, errorcount);
  Test::checkNearEqual( asin(1.0), M_PI * 0.5, errorcount);
  Test::checkNearEqual( atan(0.0), 0, errorcount);
  Test::checkNearEqual( atan(1.0), M_PI * 0.25, errorcount);
  Test::checkNearEqual( atan(FLT_POS_INF), M_PI * 0.5, errorcount);
  Test::checkNearEqual( atan(FLT_NEG_INF), -M_PI * 0.5, errorcount);
  Test::checkNearEqual( atan2(1.0, 0.0), M_PI * 0.5, errorcount);
  Test::checkNearEqual( atan2(-1.0, 0.0), -M_PI * 0.5, errorcount);
  Test::checkNearEqual( cos(M_PI), -1.0, errorcount);
  Test::checkNearEqual( cos(0.5 * M_PI), 0.0, errorcount);
  Test::checkNearEqual( cos(0.0), 1.0, errorcount);
  Test::checkNearEqual( sin(-0.5 * M_PI), -1.0, errorcount);
  Test::checkNearEqual( sin(0.5 * M_PI), 1.0, errorcount);
  Test::checkNearEqual( sin(0.0), 0.0, errorcount);
  Test::checkNearEqual( tan(0.0), 0, errorcount);
  Test::checkNearEqual( tan(0.25 * M_PI), 1.0, errorcount);
  Test::checkNearEqual( tan(-0.25 * M_PI), -1.0, errorcount);
  
  // Multiple checks
  float v = -10.0;
  while(v <= 10.0)
  {
    Test::checkNearEqual( hypot(sin(v), cos(v)), 1.0, errorcount);
    Test::checkNearEqual( tan(v), sin(v) / cos(v), errorcount);
    v = v + 0.1;
  }

  return errorcount;
}
