/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GenerationContext_p.h"

#include "GTLCore/Macros_p.h"

#include "Debug.h"

using namespace OpenCTL;

TemplateGenerationContext::TemplateGenerationContext( const std::map< GTLCore::String, const GTLCore::Type* >& _namedTypes, const GTLCore::PixelDescription& _pixelDescription ) : m_isLocalContext(false), m_pixelDescription(_pixelDescription), m_namedTypes(_namedTypes) {
}

void TemplateGenerationContext::startLocalContext(const GTLCore::String& suffix, int _currentChannel) {
  GTL_ASSERT(not m_isLocalContext);
  m_isLocalContext = true;
  m_suffix = suffix;
  m_currentChannel = _currentChannel;
}

void TemplateGenerationContext::endLocalContext() {
  GTL_ASSERT(m_isLocalContext);
  m_isLocalContext = false;
  m_suffix = "";
  m_currentChannel = -1;
}

void TemplateGenerationContext::append(const GTLCore::String& _c) {
  m_code.append(_c);
}

const GTLCore::String& TemplateGenerationContext::code() const {
  return m_code;
}

const GTLCore::PixelDescription& TemplateGenerationContext::pixelDescription() const {
  return m_pixelDescription;
}

const GTLCore::String& TemplateGenerationContext::suffix() const {
  GTL_ASSERT(m_isLocalContext);
  return m_suffix;
}

int TemplateGenerationContext::currentChannel() const {
  GTL_ASSERT(m_isLocalContext);
  return m_currentChannel;
}

const GTLCore::Type* TemplateGenerationContext::currentChannelType() const {
  return pixelDescription().channelTypes()[currentChannel()];
}

const GTLCore::Type* TemplateGenerationContext::namedType(const GTLCore::String& _name) const {
  std::map< GTLCore::String, const GTLCore::Type* >::const_iterator cit = m_namedTypes.find(_name);
  if(cit == m_namedTypes.end())
  {
    return 0;
  } else {
    return cit->second;
  }
}
