/* ***** BEGIN LICENSE BLOCK *****
 *
 * Copyright (C) 2007 Andris Pavenis <andris.pavenis@iki.fi>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * ***** END OF LICENSE BLOCK ***** */

#ifndef MOZVOIKKO_SPELL_HXX
#define MOZVOIKKO_SPELL_HXX

#include "mozVoikko.hxx"
#include <nsStringAPI.h>
#include <mozilla/ModuleUtils.h>
#include <nsIClassInfoImpl.h>
#include <mozISpellCheckingEngine.h>
#include <mozIPersonalDictionary.h>
#include <nsCOMPtr.h>
#include <nsIUnicodeEncoder.h>
#include <nsIUnicodeDecoder.h>

#define MOZ_VOIKKOSPELL_CONTRACTID "@mozilla.org/spellchecker/engine/voikko;1"

#define MOZ_VOIKKOSPELL_GUID "{b4acd370-3025-11db-a98b-0800200c9a66}"

#define MOZ_VOIKKOSPELL_CID \
{ /* b4acd370-3025-11db-a98b-0800200c9a66 */  \
0xb4acd370, 0x3025, 0x11db, \
{ 0xa9, 0x8b, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66} }

class mozVoikkoSpell : public mozISpellCheckingEngine
{
public:
    NS_DECL_ISUPPORTS
    NS_DECL_MOZISPELLCHECKINGENGINE

    mozVoikkoSpell();
    virtual ~mozVoikkoSpell();

    // helper method for converting a word to the charset of the dictionary
    nsresult ConvertCharset(const PRUnichar* aStr, char ** aDst);

protected:
 
    nsCOMPtr<mozIPersonalDictionary> mPersonalDictionary;
    nsCOMPtr<nsIUnicodeEncoder>      mEncoder; 
    nsCOMPtr<nsIUnicodeDecoder>      mDecoder; 
    nsString  mDictionary;
    nsString  mLanguage;
    MozVoikko *voikkoSpell;
};

#endif
