/* Automatically generated by remote_generator.pl.
 * Do not edit this file.  Any changes you make will be lost.
 */

static int
remoteDispatchCPUBaseline(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_cpu_baseline_args *args,
    remote_cpu_baseline_ret *ret)
{
    int rv = -1;
    char *cpu;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((cpu = virConnectBaselineCPU(conn, (const char **)args->xmlCPUs.xmlCPUs_val, args->xmlCPUs.xmlCPUs_len, args->flags)) == NULL)
        goto cleanup;

    ret->cpu = cpu;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchCPUCompare(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_cpu_compare_args *args,
    remote_cpu_compare_ret *ret)
{
    int rv = -1;
    int result;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((result = virConnectCompareCPU(conn, args->xml, args->flags)) == VIR_CPU_COMPARE_ERROR)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchDomainAbortJob(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_abort_job_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainAbortJob(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainAttachDevice(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_attach_device_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainAttachDevice(dom, args->xml) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainAttachDeviceFlags(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_attach_device_flags_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainAttachDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainBlockStats(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_block_stats_args *args,
    remote_domain_block_stats_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainBlockStatsStruct tmp;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainBlockStats(dom, args->path, &tmp, sizeof tmp) < 0)
        goto cleanup;

    ret->rd_req = tmp.rd_req;
    ret->rd_bytes = tmp.rd_bytes;
    ret->wr_req = tmp.wr_req;
    ret->wr_bytes = tmp.wr_bytes;
    ret->errs = tmp.errs;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainCoreDump(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_core_dump_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainCoreDump(dom, args->to, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainCreate(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_create_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainCreate(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainCreateWithFlags(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_create_with_flags_args *args,
    remote_domain_create_with_flags_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainCreateWithFlags(dom, args->flags) < 0)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainCreateXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_create_xml_args *args,
    remote_domain_create_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainCreateXML(conn, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainDefineXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_define_xml_args *args,
    remote_domain_define_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainDefineXML(conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainDestroy(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_destroy_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainDestroy(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainDetachDevice(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_detach_device_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainDetachDevice(dom, args->xml) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainDetachDeviceFlags(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_detach_device_flags_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainDetachDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainGetAutostart(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_get_autostart_args *args,
    remote_domain_get_autostart_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int autostart;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGetAutostart(dom, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainGetBlockInfo(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_get_block_info_args *args,
    remote_domain_get_block_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainBlockInfo tmp;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGetBlockInfo(dom, args->path, &tmp, args->flags) < 0)
        goto cleanup;

    ret->allocation = tmp.allocation;
    ret->capacity = tmp.capacity;
    ret->physical = tmp.physical;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainGetInfo(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_get_info_args *args,
    remote_domain_get_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainInfo tmp;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGetInfo(dom, &tmp) < 0)
        goto cleanup;

    ret->state = tmp.state;
    ret->maxMem = tmp.maxMem;
    ret->memory = tmp.memory;
    ret->nrVirtCpu = tmp.nrVirtCpu;
    ret->cpuTime = tmp.cpuTime;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainGetJobInfo(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_get_job_info_args *args,
    remote_domain_get_job_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainJobInfo tmp;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGetJobInfo(dom, &tmp) < 0)
        goto cleanup;

    ret->type = tmp.type;
    ret->timeElapsed = tmp.timeElapsed;
    ret->timeRemaining = tmp.timeRemaining;
    ret->dataTotal = tmp.dataTotal;
    ret->dataProcessed = tmp.dataProcessed;
    ret->dataRemaining = tmp.dataRemaining;
    ret->memTotal = tmp.memTotal;
    ret->memProcessed = tmp.memProcessed;
    ret->memRemaining = tmp.memRemaining;
    ret->fileTotal = tmp.fileTotal;
    ret->fileProcessed = tmp.fileProcessed;
    ret->fileRemaining = tmp.fileRemaining;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainGetMaxMemory(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_get_max_memory_args *args,
    remote_domain_get_max_memory_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((memory = virDomainGetMaxMemory(dom)) == 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->memory, memory);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainGetMaxVcpus(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_get_max_vcpus_args *args,
    remote_domain_get_max_vcpus_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((num = virDomainGetMaxVcpus(dom)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainGetOSType(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_get_os_type_args *args,
    remote_domain_get_os_type_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *type;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((type = virDomainGetOSType(dom)) == NULL)
        goto cleanup;

    ret->type = type;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainGetVcpusFlags(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_get_vcpus_flags_args *args,
    remote_domain_get_vcpus_flags_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((num = virDomainGetVcpusFlags(dom, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainGetXMLDesc(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_get_xml_desc_args *args,
    remote_domain_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *xml;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((xml = virDomainGetXMLDesc(dom, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainHasCurrentSnapshot(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_has_current_snapshot_args *args,
    remote_domain_has_current_snapshot_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int result;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((result = virDomainHasCurrentSnapshot(dom, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainHasManagedSaveImage(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_has_managed_save_image_args *args,
    remote_domain_has_managed_save_image_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int result;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((result = virDomainHasManagedSaveImage(dom, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainInjectNMI(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_inject_nmi_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainInjectNMI(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainInterfaceStats(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_interface_stats_args *args,
    remote_domain_interface_stats_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainInterfaceStatsStruct tmp;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainInterfaceStats(dom, args->path, &tmp, sizeof tmp) < 0)
        goto cleanup;

    ret->rx_bytes = tmp.rx_bytes;
    ret->rx_packets = tmp.rx_packets;
    ret->rx_errs = tmp.rx_errs;
    ret->rx_drop = tmp.rx_drop;
    ret->tx_bytes = tmp.tx_bytes;
    ret->tx_packets = tmp.tx_packets;
    ret->tx_errs = tmp.tx_errs;
    ret->tx_drop = tmp.tx_drop;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainIsActive(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_is_active_args *args,
    remote_domain_is_active_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int active;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((active = virDomainIsActive(dom)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainIsPersistent(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_is_persistent_args *args,
    remote_domain_is_persistent_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int persistent;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((persistent = virDomainIsPersistent(dom)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainIsUpdated(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_is_updated_args *args,
    remote_domain_is_updated_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int updated;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((updated = virDomainIsUpdated(dom)) < 0)
        goto cleanup;

    ret->updated = updated;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainLookupByID(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_lookup_by_id_args *args,
    remote_domain_lookup_by_id_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainLookupByID(conn, args->id)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainLookupByName(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_lookup_by_name_args *args,
    remote_domain_lookup_by_name_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainLookupByUUID(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_lookup_by_uuid_args *args,
    remote_domain_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainLookupByUUID(conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainManagedSave(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_managed_save_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainManagedSave(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainManagedSaveRemove(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_managed_save_remove_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainManagedSaveRemove(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainMigrateFinish(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_migrate_finish_args *args,
    remote_domain_migrate_finish_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    virDomainPtr ddom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    if ((ddom = virDomainMigrateFinish(conn, args->dname, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->ddom, ddom);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (ddom)
        virDomainFree(ddom);
    return rv;
}

static int
remoteDispatchDomainMigrateFinish2(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_migrate_finish2_args *args,
    remote_domain_migrate_finish2_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    virDomainPtr ddom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    if ((ddom = virDomainMigrateFinish2(conn, args->dname, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags, args->retcode)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->ddom, ddom);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (ddom)
        virDomainFree(ddom);
    return rv;
}

static int
remoteDispatchDomainMigratePerform(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_migrate_perform_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long flags;
    char *dname;
    unsigned long resource;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(resource, args->resource);

    dname = args->dname ? *args->dname : NULL;

    if (virDomainMigratePerform(dom, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags, dname, resource) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainMigratePrepareTunnel(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_migrate_prepare_tunnel_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    unsigned long flags;
    char *dname;
    unsigned long resource;
    struct qemud_client_stream *stream = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(resource, args->resource);

    dname = args->dname ? *args->dname : NULL;

    if (!(stream = remoteCreateClientStream(conn, hdr)))
        goto cleanup;

    if (virDomainMigratePrepareTunnel(conn, stream->st, flags, dname, resource, args->dom_xml) < 0)
        goto cleanup;

    if (remoteAddClientStream(client, stream, 0) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        if (stream) {
            virStreamAbort(stream->st);
            remoteFreeClientStream(client, stream);
        }
    }
    return rv;
}

static int
remoteDispatchDomainMigratePrepareTunnel3(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_migrate_prepare_tunnel3_args *args,
    remote_domain_migrate_prepare_tunnel3_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    char *dname;
    unsigned long resource;
    char *cookie_out = NULL;
    int cookie_out_len = 0;
    struct qemud_client_stream *stream = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(resource, args->resource);

    dname = args->dname ? *args->dname : NULL;

    if (!(stream = remoteCreateClientStream(conn, hdr)))
        goto cleanup;

    if (virDomainMigratePrepareTunnel3(conn, stream->st, args->cookie_in.cookie_in_val, args->cookie_in.cookie_in_len, &cookie_out, &cookie_out_len, flags, dname, resource, args->dom_xml) < 0)
        goto cleanup;

    if (remoteAddClientStream(client, stream, 0) < 0)
        goto cleanup;

    ret->cookie_out.cookie_out_val = cookie_out;
    ret->cookie_out.cookie_out_len = cookie_out_len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(cookie_out);
        if (stream) {
            virStreamAbort(stream->st);
            remoteFreeClientStream(client, stream);
        }
    }
    return rv;
}

static int
remoteDispatchDomainMigrateSetMaxDowntime(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_migrate_set_max_downtime_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateSetMaxDowntime(dom, args->downtime, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainMigrateSetMaxSpeed(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_migrate_set_max_speed_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    if (virDomainMigrateSetMaxSpeed(dom, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainOpenConsole(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_open_console_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *devname;
    struct qemud_client_stream *stream = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    devname = args->devname ? *args->devname : NULL;

    if (!(stream = remoteCreateClientStream(conn, hdr)))
        goto cleanup;

    if (virDomainOpenConsole(dom, devname, stream->st, args->flags) < 0)
        goto cleanup;

    if (remoteAddClientStream(client, stream, 1) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        if (stream) {
            virStreamAbort(stream->st);
            remoteFreeClientStream(client, stream);
        }
    }
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainReboot(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_reboot_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainReboot(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainRestore(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_restore_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virDomainRestore(conn, args->from) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchDomainResume(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_resume_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainResume(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainRevertToSnapshot(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_revert_to_snapshot_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if (virDomainRevertToSnapshot(snapshot, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (snapshot)
        virDomainSnapshotFree(snapshot);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSave(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_save_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSave(dom, args->to) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSetAutostart(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_set_autostart_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetAutostart(dom, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSetBlkioParameters(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_set_blkio_parameters_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((params = remoteDeserializeTypedParameters(args->params.params_val,
                                                   args->params.params_len,
                                                   REMOTE_DOMAIN_BLKIO_PARAMETERS_MAX,
                                                   &nparams)) == NULL)
        goto cleanup;

    if (virDomainSetBlkioParameters(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    VIR_FREE(params);
    return rv;
}

static int
remoteDispatchDomainSetMaxMemory(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_set_max_memory_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMaxMemory(dom, memory) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSetMemory(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_set_memory_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMemory(dom, memory) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSetMemoryFlags(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_set_memory_flags_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMemoryFlags(dom, memory, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSetMemoryParameters(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_set_memory_parameters_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((params = remoteDeserializeTypedParameters(args->params.params_val,
                                                   args->params.params_len,
                                                   REMOTE_DOMAIN_MEMORY_PARAMETERS_MAX,
                                                   &nparams)) == NULL)
        goto cleanup;

    if (virDomainSetMemoryParameters(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    VIR_FREE(params);
    return rv;
}

static int
remoteDispatchDomainSetSchedulerParameters(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_set_scheduler_parameters_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((params = remoteDeserializeTypedParameters(args->params.params_val,
                                                   args->params.params_len,
                                                   REMOTE_DOMAIN_SCHEDULER_PARAMETERS_MAX,
                                                   &nparams)) == NULL)
        goto cleanup;

    if (virDomainSetSchedulerParameters(dom, params, nparams) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    VIR_FREE(params);
    return rv;
}

static int
remoteDispatchDomainSetSchedulerParametersFlags(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_set_scheduler_parameters_flags_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((params = remoteDeserializeTypedParameters(args->params.params_val,
                                                   args->params.params_len,
                                                   REMOTE_DOMAIN_SCHEDULER_PARAMETERS_MAX,
                                                   &nparams)) == NULL)
        goto cleanup;

    if (virDomainSetSchedulerParametersFlags(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    VIR_FREE(params);
    return rv;
}

static int
remoteDispatchDomainSetVcpus(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_set_vcpus_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetVcpus(dom, args->nvcpus) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSetVcpusFlags(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_set_vcpus_flags_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetVcpusFlags(dom, args->nvcpus, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainShutdown(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_shutdown_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainShutdown(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSnapshotCreateXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_snapshot_create_xml_args *args,
    remote_domain_snapshot_create_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotCreateXML(dom, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    if (snap)
        virDomainSnapshotFree(snap);
    return rv;
}

static int
remoteDispatchDomainSnapshotCurrent(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_snapshot_current_args *args,
    remote_domain_snapshot_current_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotCurrent(dom, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    if (snap)
        virDomainSnapshotFree(snap);
    return rv;
}

static int
remoteDispatchDomainSnapshotDelete(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_snapshot_delete_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if (virDomainSnapshotDelete(snapshot, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (snapshot)
        virDomainSnapshotFree(snapshot);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSnapshotGetXMLDesc(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_snapshot_get_xml_desc_args *args,
    remote_domain_snapshot_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    char *xml;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((xml = virDomainSnapshotGetXMLDesc(snapshot, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (snapshot)
        virDomainSnapshotFree(snapshot);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSnapshotListNames(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_snapshot_list_names_args *args,
    remote_domain_snapshot_list_names_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_NAMES_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_NAMES_MAX"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virDomainSnapshotListNames(dom, ret->names.names_val, args->maxnames, args->flags)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSnapshotLookupByName(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_snapshot_lookup_by_name_args *args,
    remote_domain_snapshot_lookup_by_name_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotLookupByName(dom, args->name, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    if (snap)
        virDomainSnapshotFree(snap);
    return rv;
}

static int
remoteDispatchDomainSnapshotNum(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_snapshot_num_args *args,
    remote_domain_snapshot_num_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((num = virDomainSnapshotNum(dom, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainSuspend(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_suspend_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSuspend(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainUndefine(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_undefine_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainUndefine(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainUpdateDeviceFlags(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_update_device_flags_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainUpdateDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}

static int
remoteDispatchDomainXMLFromNative(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_xml_from_native_args *args,
    remote_domain_xml_from_native_ret *ret)
{
    int rv = -1;
    char *domainXml;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((domainXml = virConnectDomainXMLFromNative(conn, args->nativeFormat, args->nativeConfig, args->flags)) == NULL)
        goto cleanup;

    ret->domainXml = domainXml;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchDomainXMLToNative(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_domain_xml_to_native_args *args,
    remote_domain_xml_to_native_ret *ret)
{
    int rv = -1;
    char *nativeConfig;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nativeConfig = virConnectDomainXMLToNative(conn, args->nativeFormat, args->domainXml, args->flags)) == NULL)
        goto cleanup;

    ret->nativeConfig = nativeConfig;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchFindStoragePoolSources(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_find_storage_pool_sources_args *args,
    remote_find_storage_pool_sources_ret *ret)
{
    int rv = -1;
    char *srcSpec;
    char *xml;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    srcSpec = args->srcSpec ? *args->srcSpec : NULL;

    if ((xml = virConnectFindStoragePoolSources(conn, args->type, srcSpec, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchGetCapabilities(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_get_capabilities_ret *ret)
{
    int rv = -1;
    char *capabilities;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((capabilities = virConnectGetCapabilities(conn)) == NULL)
        goto cleanup;

    ret->capabilities = capabilities;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchGetHostname(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_get_hostname_ret *ret)
{
    int rv = -1;
    char *hostname;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((hostname = virConnectGetHostname(conn)) == NULL)
        goto cleanup;

    ret->hostname = hostname;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchGetLibVersion(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_get_lib_version_ret *ret)
{
    int rv = -1;
    unsigned long lib_ver;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virConnectGetLibVersion(conn, &lib_ver) < 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->lib_ver, lib_ver);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchGetMaxVcpus(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_get_max_vcpus_args *args,
    remote_get_max_vcpus_ret *ret)
{
    int rv = -1;
    char *type;
    int max_vcpus;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    type = args->type ? *args->type : NULL;

    if ((max_vcpus = virConnectGetMaxVcpus(conn, type)) < 0)
        goto cleanup;

    ret->max_vcpus = max_vcpus;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchGetSysinfo(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_get_sysinfo_args *args,
    remote_get_sysinfo_ret *ret)
{
    int rv = -1;
    char *sysinfo;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((sysinfo = virConnectGetSysinfo(conn, args->flags)) == NULL)
        goto cleanup;

    ret->sysinfo = sysinfo;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchGetType(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_get_type_ret *ret)
{
    int rv = -1;
    const char *type;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((type = virConnectGetType(conn)) == NULL)
        goto cleanup;

    /* We have to strdup because remoteDispatchClientRequest will
     * free this string after it's been serialised. */
    if (!(ret->type = strdup(type))) {
        virReportOOMError();
        goto cleanup;
    }
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchGetURI(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_get_uri_ret *ret)
{
    int rv = -1;
    char *uri;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((uri = virConnectGetURI(conn)) == NULL)
        goto cleanup;

    ret->uri = uri;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchGetVersion(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_get_version_ret *ret)
{
    int rv = -1;
    unsigned long hv_ver;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virConnectGetVersion(conn, &hv_ver) < 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->hv_ver, hv_ver);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchInterfaceChangeBegin(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_interface_change_begin_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virInterfaceChangeBegin(conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchInterfaceChangeCommit(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_interface_change_commit_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virInterfaceChangeCommit(conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchInterfaceChangeRollback(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_interface_change_rollback_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virInterfaceChangeRollback(conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchInterfaceCreate(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_interface_create_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(conn, args->iface)))
        goto cleanup;

    if (virInterfaceCreate(iface, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}

static int
remoteDispatchInterfaceDefineXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_interface_define_xml_args *args,
    remote_interface_define_xml_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((iface = virInterfaceDefineXML(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}

static int
remoteDispatchInterfaceDestroy(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_interface_destroy_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(conn, args->iface)))
        goto cleanup;

    if (virInterfaceDestroy(iface, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}

static int
remoteDispatchInterfaceGetXMLDesc(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_interface_get_xml_desc_args *args,
    remote_interface_get_xml_desc_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    char *xml;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(conn, args->iface)))
        goto cleanup;

    if ((xml = virInterfaceGetXMLDesc(iface, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}

static int
remoteDispatchInterfaceIsActive(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_interface_is_active_args *args,
    remote_interface_is_active_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    int active;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(conn, args->iface)))
        goto cleanup;

    if ((active = virInterfaceIsActive(iface)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}

static int
remoteDispatchInterfaceLookupByMACString(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_interface_lookup_by_mac_string_args *args,
    remote_interface_lookup_by_mac_string_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((iface = virInterfaceLookupByMACString(conn, args->mac)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}

static int
remoteDispatchInterfaceLookupByName(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_interface_lookup_by_name_args *args,
    remote_interface_lookup_by_name_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((iface = virInterfaceLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}

static int
remoteDispatchInterfaceUndefine(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_interface_undefine_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(conn, args->iface)))
        goto cleanup;

    if (virInterfaceUndefine(iface) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}

static int
remoteDispatchIsSecure(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_is_secure_ret *ret)
{
    int rv = -1;
    int secure;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secure = virConnectIsSecure(conn)) < 0)
        goto cleanup;

    ret->secure = secure;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchListDefinedDomains(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_list_defined_domains_args *args,
    remote_list_defined_domains_ret *ret)
{
    int rv = -1;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_DOMAIN_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_DOMAIN_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListDefinedDomains(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}

static int
remoteDispatchListDefinedInterfaces(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_list_defined_interfaces_args *args,
    remote_list_defined_interfaces_ret *ret)
{
    int rv = -1;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_DEFINED_INTERFACE_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_DEFINED_INTERFACE_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListDefinedInterfaces(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}

static int
remoteDispatchListDefinedNetworks(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_list_defined_networks_args *args,
    remote_list_defined_networks_ret *ret)
{
    int rv = -1;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NETWORK_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_NETWORK_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListDefinedNetworks(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}

static int
remoteDispatchListDefinedStoragePools(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_list_defined_storage_pools_args *args,
    remote_list_defined_storage_pools_ret *ret)
{
    int rv = -1;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_STORAGE_POOL_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_STORAGE_POOL_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListDefinedStoragePools(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}

static int
remoteDispatchListDomains(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_list_domains_args *args,
    remote_list_domains_ret *ret)
{
    int rv = -1;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxids > REMOTE_DOMAIN_ID_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxids > REMOTE_DOMAIN_ID_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->ids.ids_val, args->maxids) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListDomains(conn, ret->ids.ids_val, args->maxids)) < 0)
        goto cleanup;

    ret->ids.ids_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->ids.ids_val);
    }
    return rv;
}

static int
remoteDispatchListInterfaces(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_list_interfaces_args *args,
    remote_list_interfaces_ret *ret)
{
    int rv = -1;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_INTERFACE_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_INTERFACE_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListInterfaces(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}

static int
remoteDispatchListNetworks(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_list_networks_args *args,
    remote_list_networks_ret *ret)
{
    int rv = -1;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NETWORK_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_NETWORK_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListNetworks(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}

static int
remoteDispatchListNWFilters(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_list_nwfilters_args *args,
    remote_list_nwfilters_ret *ret)
{
    int rv = -1;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NWFILTER_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_NWFILTER_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListNWFilters(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}

static int
remoteDispatchListSecrets(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_list_secrets_args *args,
    remote_list_secrets_ret *ret)
{
    int rv = -1;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxuuids > REMOTE_SECRET_UUID_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxuuids > REMOTE_SECRET_UUID_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->uuids.uuids_val, args->maxuuids) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListSecrets(conn, ret->uuids.uuids_val, args->maxuuids)) < 0)
        goto cleanup;

    ret->uuids.uuids_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->uuids.uuids_val);
    }
    return rv;
}

static int
remoteDispatchListStoragePools(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_list_storage_pools_args *args,
    remote_list_storage_pools_ret *ret)
{
    int rv = -1;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_STORAGE_POOL_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_STORAGE_POOL_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListStoragePools(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}

static int
remoteDispatchNetworkCreate(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_create_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if (virNetworkCreate(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkCreateXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_create_xml_args *args,
    remote_network_create_xml_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkCreateXML(conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkDefineXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_define_xml_args *args,
    remote_network_define_xml_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkDefineXML(conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkDestroy(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_destroy_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if (virNetworkDestroy(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkGetAutostart(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_get_autostart_args *args,
    remote_network_get_autostart_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int autostart;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if (virNetworkGetAutostart(net, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkGetBridgeName(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_get_bridge_name_args *args,
    remote_network_get_bridge_name_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    char *name;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if ((name = virNetworkGetBridgeName(net)) == NULL)
        goto cleanup;

    ret->name = name;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkGetXMLDesc(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_get_xml_desc_args *args,
    remote_network_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    char *xml;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if ((xml = virNetworkGetXMLDesc(net, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkIsActive(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_is_active_args *args,
    remote_network_is_active_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int active;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if ((active = virNetworkIsActive(net)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkIsPersistent(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_is_persistent_args *args,
    remote_network_is_persistent_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int persistent;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if ((persistent = virNetworkIsPersistent(net)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkLookupByName(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_lookup_by_name_args *args,
    remote_network_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkLookupByUUID(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_lookup_by_uuid_args *args,
    remote_network_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkLookupByUUID(conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkSetAutostart(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_set_autostart_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if (virNetworkSetAutostart(net, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNetworkUndefine(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_network_undefine_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if (virNetworkUndefine(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}

static int
remoteDispatchNodeDeviceCreateXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_device_create_xml_args *args,
    remote_node_device_create_xml_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dev = virNodeDeviceCreateXML(conn, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_node_device(&ret->dev, dev);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}

static int
remoteDispatchNodeDeviceDestroy(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_device_destroy_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceDestroy(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}

static int
remoteDispatchNodeDeviceDettach(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_device_dettach_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceDettach(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}

static int
remoteDispatchNodeDeviceGetXMLDesc(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_device_get_xml_desc_args *args,
    remote_node_device_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    char *xml;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(conn, args->name)))
        goto cleanup;

    if ((xml = virNodeDeviceGetXMLDesc(dev, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}

static int
remoteDispatchNodeDeviceListCaps(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_device_list_caps_args *args,
    remote_node_device_list_caps_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NODE_DEVICE_CAPS_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_NODE_DEVICE_CAPS_LIST_MAX"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(conn, args->name)))
        goto cleanup;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virNodeDeviceListCaps(dev, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}

static int
remoteDispatchNodeDeviceLookupByName(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_device_lookup_by_name_args *args,
    remote_node_device_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dev = virNodeDeviceLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_node_device(&ret->dev, dev);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}

static int
remoteDispatchNodeDeviceNumOfCaps(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_device_num_of_caps_args *args,
    remote_node_device_num_of_caps_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(conn, args->name)))
        goto cleanup;

    if ((num = virNodeDeviceNumOfCaps(dev)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}

static int
remoteDispatchNodeDeviceReAttach(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_device_re_attach_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceReAttach(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}

static int
remoteDispatchNodeDeviceReset(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_device_reset_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceReset(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}

static int
remoteDispatchNodeGetCellsFreeMemory(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_get_cells_free_memory_args *args,
    remote_node_get_cells_free_memory_ret *ret)
{
    int rv = -1;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxcells > REMOTE_NODE_MAX_CELLS) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxcells > REMOTE_NODE_MAX_CELLS"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->cells.cells_val, args->maxcells) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virNodeGetCellsFreeMemory(conn, (unsigned long long *)ret->cells.cells_val, args->startCell, args->maxcells)) <= 0)
        goto cleanup;

    ret->cells.cells_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->cells.cells_val);
    }
    return rv;
}

static int
remoteDispatchNodeGetFreeMemory(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_node_get_free_memory_ret *ret)
{
    int rv = -1;
    unsigned long long freeMem;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((freeMem = virNodeGetFreeMemory(conn)) == 0)
        goto cleanup;

    ret->freeMem = freeMem;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNodeGetInfo(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_node_get_info_ret *ret)
{
    int rv = -1;
    virNodeInfo tmp;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virNodeGetInfo(conn, &tmp) < 0)
        goto cleanup;

    memcpy(ret->model, tmp.model, sizeof ret->model);
    ret->memory = tmp.memory;
    ret->cpus = tmp.cpus;
    ret->mhz = tmp.mhz;
    ret->nodes = tmp.nodes;
    ret->sockets = tmp.sockets;
    ret->cores = tmp.cores;
    ret->threads = tmp.threads;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNodeListDevices(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_list_devices_args *args,
    remote_node_list_devices_ret *ret)
{
    int rv = -1;
    char *cap;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NODE_DEVICE_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_NODE_DEVICE_NAME_LIST_MAX"));
        goto cleanup;
    }

    cap = args->cap ? *args->cap : NULL;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virNodeListDevices(conn, cap, ret->names.names_val, args->maxnames, args->flags)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}

static int
remoteDispatchNodeNumOfDevices(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_node_num_of_devices_args *args,
    remote_node_num_of_devices_ret *ret)
{
    int rv = -1;
    char *cap;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    cap = args->cap ? *args->cap : NULL;

    if ((num = virNodeNumOfDevices(conn, cap, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNumOfDefinedDomains(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_num_of_defined_domains_ret *ret)
{
    int rv = -1;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedDomains(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNumOfDefinedInterfaces(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_num_of_defined_interfaces_ret *ret)
{
    int rv = -1;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedInterfaces(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNumOfDefinedNetworks(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_num_of_defined_networks_ret *ret)
{
    int rv = -1;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedNetworks(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNumOfDefinedStoragePools(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_num_of_defined_storage_pools_ret *ret)
{
    int rv = -1;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedStoragePools(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNumOfDomains(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_num_of_domains_ret *ret)
{
    int rv = -1;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDomains(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNumOfInterfaces(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_num_of_interfaces_ret *ret)
{
    int rv = -1;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfInterfaces(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNumOfNetworks(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_num_of_networks_ret *ret)
{
    int rv = -1;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfNetworks(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNumOfNWFilters(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_num_of_nwfilters_ret *ret)
{
    int rv = -1;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfNWFilters(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNumOfSecrets(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_num_of_secrets_ret *ret)
{
    int rv = -1;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfSecrets(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNumOfStoragePools(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    void *args ATTRIBUTE_UNUSED,
    remote_num_of_storage_pools_ret *ret)
{
    int rv = -1;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfStoragePools(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}

static int
remoteDispatchNWFilterDefineXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_nwfilter_define_xml_args *args,
    remote_nwfilter_define_xml_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nwfilter = virNWFilterDefineXML(conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (nwfilter)
        virNWFilterFree(nwfilter);
    return rv;
}

static int
remoteDispatchNWFilterGetXMLDesc(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_nwfilter_get_xml_desc_args *args,
    remote_nwfilter_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    char *xml;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(nwfilter = get_nonnull_nwfilter(conn, args->nwfilter)))
        goto cleanup;

    if ((xml = virNWFilterGetXMLDesc(nwfilter, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (nwfilter)
        virNWFilterFree(nwfilter);
    return rv;
}

static int
remoteDispatchNWFilterLookupByName(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_nwfilter_lookup_by_name_args *args,
    remote_nwfilter_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nwfilter = virNWFilterLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (nwfilter)
        virNWFilterFree(nwfilter);
    return rv;
}

static int
remoteDispatchNWFilterLookupByUUID(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_nwfilter_lookup_by_uuid_args *args,
    remote_nwfilter_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nwfilter = virNWFilterLookupByUUID(conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (nwfilter)
        virNWFilterFree(nwfilter);
    return rv;
}

static int
remoteDispatchNWFilterUndefine(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_nwfilter_undefine_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(nwfilter = get_nonnull_nwfilter(conn, args->nwfilter)))
        goto cleanup;

    if (virNWFilterUndefine(nwfilter) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (nwfilter)
        virNWFilterFree(nwfilter);
    return rv;
}

static int
remoteDispatchSecretDefineXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_secret_define_xml_args *args,
    remote_secret_define_xml_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secret = virSecretDefineXML(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}

static int
remoteDispatchSecretGetXMLDesc(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_secret_get_xml_desc_args *args,
    remote_secret_get_xml_desc_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    char *xml;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(secret = get_nonnull_secret(conn, args->secret)))
        goto cleanup;

    if ((xml = virSecretGetXMLDesc(secret, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}

static int
remoteDispatchSecretLookupByUsage(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_secret_lookup_by_usage_args *args,
    remote_secret_lookup_by_usage_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secret = virSecretLookupByUsage(conn, args->usageType, args->usageID)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}

static int
remoteDispatchSecretLookupByUUID(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_secret_lookup_by_uuid_args *args,
    remote_secret_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secret = virSecretLookupByUUID(conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}

static int
remoteDispatchSecretSetValue(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_secret_set_value_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virSecretPtr secret = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(secret = get_nonnull_secret(conn, args->secret)))
        goto cleanup;

    if (virSecretSetValue(secret, (const unsigned char *)args->value.value_val, args->value.value_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}

static int
remoteDispatchSecretUndefine(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_secret_undefine_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virSecretPtr secret = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(secret = get_nonnull_secret(conn, args->secret)))
        goto cleanup;

    if (virSecretUndefine(secret) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}

static int
remoteDispatchStoragePoolBuild(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_build_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolBuild(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolCreate(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_create_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolCreate(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolCreateXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_create_xml_args *args,
    remote_storage_pool_create_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolCreateXML(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolDefineXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_define_xml_args *args,
    remote_storage_pool_define_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolDefineXML(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolDelete(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_delete_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolDelete(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolDestroy(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_destroy_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolDestroy(pool) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolGetAutostart(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_get_autostart_args *args,
    remote_storage_pool_get_autostart_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int autostart;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolGetAutostart(pool, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolGetInfo(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_get_info_args *args,
    remote_storage_pool_get_info_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStoragePoolInfo tmp;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolGetInfo(pool, &tmp) < 0)
        goto cleanup;

    ret->state = tmp.state;
    ret->capacity = tmp.capacity;
    ret->allocation = tmp.allocation;
    ret->available = tmp.available;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolGetXMLDesc(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_get_xml_desc_args *args,
    remote_storage_pool_get_xml_desc_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    char *xml;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((xml = virStoragePoolGetXMLDesc(pool, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolIsActive(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_is_active_args *args,
    remote_storage_pool_is_active_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int active;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((active = virStoragePoolIsActive(pool)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolIsPersistent(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_is_persistent_args *args,
    remote_storage_pool_is_persistent_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int persistent;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((persistent = virStoragePoolIsPersistent(pool)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolListVolumes(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_list_volumes_args *args,
    remote_storage_pool_list_volumes_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int len;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_STORAGE_VOL_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_STORAGE_VOL_NAME_LIST_MAX"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virStoragePoolListVolumes(pool, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolLookupByName(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_lookup_by_name_args *args,
    remote_storage_pool_lookup_by_name_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolLookupByUUID(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_lookup_by_uuid_args *args,
    remote_storage_pool_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolLookupByUUID(conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolLookupByVolume(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_lookup_by_volume_args *args,
    remote_storage_pool_lookup_by_volume_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if ((pool = virStoragePoolLookupByVolume(vol)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (vol)
        virStorageVolFree(vol);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolNumOfVolumes(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_num_of_volumes_args *args,
    remote_storage_pool_num_of_volumes_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int num;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((num = virStoragePoolNumOfVolumes(pool)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolRefresh(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_refresh_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolRefresh(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolSetAutostart(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_set_autostart_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolSetAutostart(pool, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStoragePoolUndefine(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_pool_undefine_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolUndefine(pool) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}

static int
remoteDispatchStorageVolCreateXML(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_create_xml_args *args,
    remote_storage_vol_create_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr vol = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((vol = virStorageVolCreateXML(pool, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchStorageVolCreateXMLFrom(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_create_xml_from_args *args,
    remote_storage_vol_create_xml_from_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr clonevol = NULL;
    virStorageVolPtr vol = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (!(clonevol = get_nonnull_storage_vol(conn, args->clonevol)))
        goto cleanup;

    if ((vol = virStorageVolCreateXMLFrom(pool, args->xml, clonevol, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    if (clonevol)
        virStorageVolFree(clonevol);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchStorageVolDelete(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_delete_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (virStorageVolDelete(vol, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchStorageVolDownload(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_download_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct qemud_client_stream *stream = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (!(stream = remoteCreateClientStream(conn, hdr)))
        goto cleanup;

    if (virStorageVolDownload(vol, stream->st, args->offset, args->length, args->flags) < 0)
        goto cleanup;

    if (remoteAddClientStream(client, stream, 1) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        if (stream) {
            virStreamAbort(stream->st);
            remoteFreeClientStream(client, stream);
        }
    }
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchStorageVolGetInfo(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_get_info_args *args,
    remote_storage_vol_get_info_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    virStorageVolInfo tmp;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (virStorageVolGetInfo(vol, &tmp) < 0)
        goto cleanup;

    ret->type = tmp.type;
    ret->capacity = tmp.capacity;
    ret->allocation = tmp.allocation;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchStorageVolGetPath(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_get_path_args *args,
    remote_storage_vol_get_path_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    char *name;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if ((name = virStorageVolGetPath(vol)) == NULL)
        goto cleanup;

    ret->name = name;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchStorageVolGetXMLDesc(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_get_xml_desc_args *args,
    remote_storage_vol_get_xml_desc_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    char *xml;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if ((xml = virStorageVolGetXMLDesc(vol, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchStorageVolLookupByKey(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_lookup_by_key_args *args,
    remote_storage_vol_lookup_by_key_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((vol = virStorageVolLookupByKey(conn, args->key)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchStorageVolLookupByName(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_lookup_by_name_args *args,
    remote_storage_vol_lookup_by_name_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr vol = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((vol = virStorageVolLookupByName(pool, args->name)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchStorageVolLookupByPath(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_lookup_by_path_args *args,
    remote_storage_vol_lookup_by_path_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((vol = virStorageVolLookupByPath(conn, args->path)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchStorageVolUpload(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_upload_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct qemud_client_stream *stream = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (!(stream = remoteCreateClientStream(conn, hdr)))
        goto cleanup;

    if (virStorageVolUpload(vol, stream->st, args->offset, args->length, args->flags) < 0)
        goto cleanup;

    if (remoteAddClientStream(client, stream, 0) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        remoteDispatchError(rerr);
        if (stream) {
            virStreamAbort(stream->st);
            remoteFreeClientStream(client, stream);
        }
    }
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchStorageVolWipe(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_storage_vol_wipe_args *args,
    void *ret ATTRIBUTE_UNUSED)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (virStorageVolWipe(vol, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}

static int
remoteDispatchSupportsFeature(
    struct qemud_server *server ATTRIBUTE_UNUSED,
    struct qemud_client *client ATTRIBUTE_UNUSED,
    virConnectPtr conn,
    remote_message_header *hdr ATTRIBUTE_UNUSED,
    remote_error *rerr,
    remote_supports_feature_args *args,
    remote_supports_feature_ret *ret)
{
    int rv = -1;
    int supported;

    if (!conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((supported = virDrvSupportsFeature(conn, args->feature)) < 0)
        goto cleanup;

    ret->supported = supported;
    rv = 0;

cleanup:
    if (rv < 0)
        remoteDispatchError(rerr);
    return rv;
}
