/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

using GLib;

namespace Unity {

public enum CategoryRenderer
{
  VERTICAL_TILE,
  HORIZONTAL_TILE,
  LIST_TILE,
  FLOW,
  TABULAR_TILE
}

public class Category : GLib.Object
{
  public string name { get; construct; }
  public Icon? icon_hint { get; construct; }
  public CategoryRenderer default_renderer { get; construct; }

  public Category (string name,
                   Icon icon_hint,
                   CategoryRenderer renderer=CategoryRenderer.VERTICAL_TILE)
  {
    Object(name:name, icon_hint:icon_hint, default_renderer:renderer);
  }

  /*
   * Implementation
   */
  construct
  {
    hints = new HashTable<string, Variant> (null, null);
  }

  internal string renderer {
    get {
      switch (default_renderer)
      {
        case CategoryRenderer.VERTICAL_TILE:
          return "tile-vertical";
        case CategoryRenderer.HORIZONTAL_TILE:
          return "tile-horizontal";
        case CategoryRenderer.LIST_TILE:
          return "tile-list";
        case CategoryRenderer.FLOW:
          return "flow";
        case CategoryRenderer.TABULAR_TILE:
          return "tile-tabular";
        default:
          return "tile-vertical";
      }
    }
  }
  internal HashTable<string, Variant> hints { get; set; }
}

} /* namespace */
