/* unity-scope-factory.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-scope-factory.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "unity.h"
#include <dee.h>
#include <unity-trace.h>
#include <config.h>


#define UNITY_TYPE_SCOPE_FACTORY (unity_scope_factory_get_type ())
#define UNITY_SCOPE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactory))
#define UNITY_SCOPE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactoryClass))
#define UNITY_IS_SCOPE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_FACTORY))
#define UNITY_IS_SCOPE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_FACTORY))
#define UNITY_SCOPE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactoryClass))

typedef struct _UnityScopeFactory UnityScopeFactory;
typedef struct _UnityScopeFactoryClass UnityScopeFactoryClass;
typedef struct _UnityScopeFactoryPrivate UnityScopeFactoryPrivate;

#define UNITY_TYPE_SCOPE_PROXY (unity_scope_proxy_get_type ())
#define UNITY_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxy))
#define UNITY_IS_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY))
#define UNITY_SCOPE_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxyIface))

typedef struct _UnityScopeProxy UnityScopeProxy;
typedef struct _UnityScopeProxyIface UnityScopeProxyIface;

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;

#define UNITY_TYPE_VIEW_TYPE (unity_view_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityScopeFactoryListLensDirectoryData UnityScopeFactoryListLensDirectoryData;

#define UNITY_TYPE_SCOPE_PROXY_REMOTE (unity_scope_proxy_remote_get_type ())
#define UNITY_SCOPE_PROXY_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemote))
#define UNITY_SCOPE_PROXY_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemoteClass))
#define UNITY_IS_SCOPE_PROXY_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE))
#define UNITY_IS_SCOPE_PROXY_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_PROXY_REMOTE))
#define UNITY_SCOPE_PROXY_REMOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemoteClass))

typedef struct _UnityScopeProxyRemote UnityScopeProxyRemote;
typedef struct _UnityScopeProxyRemoteClass UnityScopeProxyRemoteClass;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))

#define UNITY_TYPE_SCOPE_PROXY_LOCAL (unity_scope_proxy_local_get_type ())
#define UNITY_SCOPE_PROXY_LOCAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY_LOCAL, UnityScopeProxyLocal))
#define UNITY_SCOPE_PROXY_LOCAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_PROXY_LOCAL, UnityScopeProxyLocalClass))
#define UNITY_IS_SCOPE_PROXY_LOCAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY_LOCAL))
#define UNITY_IS_SCOPE_PROXY_LOCAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_PROXY_LOCAL))
#define UNITY_SCOPE_PROXY_LOCAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_PROXY_LOCAL, UnityScopeProxyLocalClass))

typedef struct _UnityScopeProxyLocal UnityScopeProxyLocal;
typedef struct _UnityScopeProxyLocalClass UnityScopeProxyLocalClass;

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

typedef enum  {
	UNITY_VIEW_TYPE_HIDDEN,
	UNITY_VIEW_TYPE_HOME_VIEW,
	UNITY_VIEW_TYPE_LENS_VIEW
} UnityViewType;

struct _UnityScopeProxyIface {
	GTypeInterface parent_iface;
	void (*activate) (UnityScopeProxy* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityActivationReplyRaw* result);
	void (*search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*global_search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*global_search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*preview) (UnityScopeProxy* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result);
	void (*set_active_sources) (UnityScopeProxy* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	UnityOptionsFilter* (*get_sources) (UnityScopeProxy* self);
	void (*set_sources) (UnityScopeProxy* self, UnityOptionsFilter* value);
	gboolean (*get_search_in_global) (UnityScopeProxy* self);
	void (*set_search_in_global) (UnityScopeProxy* self, gboolean value);
	UnityViewType (*get_view_type) (UnityScopeProxy* self);
	void (*set_view_type) (UnityScopeProxy* self, UnityViewType value);
	DeeSerializableModel* (*get_results_model) (UnityScopeProxy* self);
	void (*set_results_model) (UnityScopeProxy* self, DeeSerializableModel* value);
	DeeSerializableModel* (*get_global_results_model) (UnityScopeProxy* self);
	void (*set_global_results_model) (UnityScopeProxy* self, DeeSerializableModel* value);
	DeeSerializableModel* (*get_filters_model) (UnityScopeProxy* self);
	void (*set_filters_model) (UnityScopeProxy* self, DeeSerializableModel* value);
};

struct _UnityScopeFactory {
	GObject parent_instance;
	UnityScopeFactoryPrivate * priv;
	GeeArrayList* scopes;
};

struct _UnityScopeFactoryClass {
	GObjectClass parent_class;
};

struct _UnityScopeFactoryPrivate {
	gchar* _lens_id;
	gchar* _lenses_directory;
};

struct _UnityScopeFactoryListLensDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeFactory* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* dir;
	GFile* _tmp3_;
	GFileEnumerator* _tmp4_;
	GFileEnumerator* e;
	GFileEnumerator* _tmp5_;
	GList* _tmp6_;
	GList* files;
	GList* _tmp7_;
	GList* _tmp8_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp9_;
	GFileInfo* info;
	GFileInfo* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* name;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_;
	GError* _error_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError * _inner_error_;
};


static gpointer unity_scope_factory_parent_class = NULL;

GType unity_scope_factory_get_type (void) G_GNUC_CONST;
GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_view_type_get_type (void) G_GNUC_CONST;
GType unity_scope_proxy_get_type (void) G_GNUC_CONST;
#define UNITY_SCOPE_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactoryPrivate))
enum  {
	UNITY_SCOPE_FACTORY_DUMMY_PROPERTY,
	UNITY_SCOPE_FACTORY_LENS_ID,
	UNITY_SCOPE_FACTORY_LENSES_DIRECTORY
};
UnityScopeFactory* unity_scope_factory_new (const gchar* lens_id_, const gchar* lenses_directory_);
UnityScopeFactory* unity_scope_factory_construct (GType object_type, const gchar* lens_id_, const gchar* lenses_directory_);
static void unity_scope_factory_list_lens_directory_data_free (gpointer _data);
static void unity_scope_factory_list_lens_directory (UnityScopeFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_factory_list_lens_directory_finish (UnityScopeFactory* self, GAsyncResult* _res_);
static gboolean unity_scope_factory_list_lens_directory_co (UnityScopeFactoryListLensDirectoryData* _data_);
const gchar* unity_scope_factory_get_lenses_directory (UnityScopeFactory* self);
static void unity_scope_factory_list_lens_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void unity_scope_factory_load_scope_file (UnityScopeFactory* self, const gchar* name);
UnityScopeProxyRemote* unity_scope_proxy_remote_new (const gchar* dbus_name_, const gchar* dbus_path_);
UnityScopeProxyRemote* unity_scope_proxy_remote_construct (GType object_type, const gchar* dbus_name_, const gchar* dbus_path_);
GType unity_scope_proxy_remote_get_type (void) G_GNUC_CONST;
void unity_scope_factory_add_local_scope (UnityScopeFactory* self, UnityScope* scope);
UnityScopeProxyLocal* unity_scope_proxy_local_new (UnityScope* scope);
UnityScopeProxyLocal* unity_scope_proxy_local_construct (GType object_type, UnityScope* scope);
GType unity_scope_proxy_local_get_type (void) G_GNUC_CONST;
void unity_scope_set_local (UnityScope* self, gboolean is_local_);
const gchar* unity_scope_factory_get_lens_id (UnityScopeFactory* self);
static void unity_scope_factory_set_lens_id (UnityScopeFactory* self, const gchar* value);
static void unity_scope_factory_set_lenses_directory (UnityScopeFactory* self, const gchar* value);
static GObject * unity_scope_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_scope_factory_finalize (GObject* obj);
static void _vala_unity_scope_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_scope_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


UnityScopeFactory* unity_scope_factory_construct (GType object_type, const gchar* lens_id_, const gchar* lenses_directory_) {
	UnityScopeFactory * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (lens_id_ != NULL, NULL);
	g_return_val_if_fail (lenses_directory_ != NULL, NULL);
	_tmp0_ = lens_id_;
	_tmp1_ = lenses_directory_;
	self = (UnityScopeFactory*) g_object_new (object_type, "lens-id", _tmp0_, "lenses-directory", _tmp1_, NULL);
	return self;
}


UnityScopeFactory* unity_scope_factory_new (const gchar* lens_id_, const gchar* lenses_directory_) {
	return unity_scope_factory_construct (UNITY_TYPE_SCOPE_FACTORY, lens_id_, lenses_directory_);
}


static void unity_scope_factory_list_lens_directory_data_free (gpointer _data) {
	UnityScopeFactoryListLensDirectoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeFactoryListLensDirectoryData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_scope_factory_list_lens_directory (UnityScopeFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeFactoryListLensDirectoryData* _data_;
	UnityScopeFactory* _tmp0_;
	_data_ = g_slice_new0 (UnityScopeFactoryListLensDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_factory_list_lens_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_factory_list_lens_directory_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	unity_scope_factory_list_lens_directory_co (_data_);
}


static void unity_scope_factory_list_lens_directory_finish (UnityScopeFactory* self, GAsyncResult* _res_) {
	UnityScopeFactoryListLensDirectoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_scope_factory_list_lens_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeFactoryListLensDirectoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_factory_list_lens_directory_co (_data_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean unity_scope_factory_list_lens_directory_co (UnityScopeFactoryListLensDirectoryData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_lenses_directory;
	unity_trace_log_object ((GObject*) _data_->self, "Searching for Scopes in %s", _data_->_tmp0_);
	_data_->_tmp1_ = _data_->self->priv->_lenses_directory;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_file_new_for_path (_data_->_tmp1_);
	_data_->dir = _data_->_tmp2_;
	{
		_data_->_tmp3_ = _data_->dir;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp3_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, NULL, unity_scope_factory_list_lens_directory_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_file_enumerate_children_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
		_data_->e = _data_->_tmp4_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
		while (TRUE) {
			_data_->_tmp5_ = _data_->e;
			_data_->_state_ = 2;
			g_file_enumerator_next_files_async (_data_->_tmp5_, 10, G_PRIORITY_DEFAULT, NULL, unity_scope_factory_list_lens_directory_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = g_file_enumerator_next_files_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
			_data_->files = _data_->_tmp6_;
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->e);
				goto __catch20_g_error;
			}
			_data_->_tmp7_ = _data_->files;
			if (_data_->_tmp7_ == NULL) {
				__g_list_free__g_object_unref0_0 (_data_->files);
				break;
			}
			_data_->_tmp8_ = _data_->files;
			{
				_data_->info_collection = _data_->_tmp8_;
				_data_->info_it = NULL;
				for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
					_data_->_tmp9_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
					_data_->info = _data_->_tmp9_;
					{
						_data_->_tmp10_ = _data_->info;
						_data_->_tmp11_ = NULL;
						_data_->_tmp11_ = g_file_info_get_name (_data_->_tmp10_);
						_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
						_data_->name = _data_->_tmp12_;
						_data_->_tmp13_ = _data_->name;
						_data_->_tmp14_ = FALSE;
						_data_->_tmp14_ = g_str_has_suffix (_data_->_tmp13_, ".scope");
						if (_data_->_tmp14_) {
							_data_->_tmp15_ = _data_->name;
							unity_scope_factory_load_scope_file (_data_->self, _data_->_tmp15_);
						}
						_g_free0 (_data_->name);
						_g_object_unref0 (_data_->info);
					}
				}
			}
			__g_list_free__g_object_unref0_0 (_data_->files);
		}
		_g_object_unref0 (_data_->e);
	}
	goto __finally20;
	__catch20_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp16_ = _data_->_error_;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		g_warning ("unity-scope-factory.vala:78: Unable to search for scopes: %s", _data_->_tmp17_);
		_g_error_free0 (_data_->_error_);
	}
	__finally20:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->dir);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_factory_load_scope_file (UnityScopeFactory* self, const gchar* name) {
	static const char GROUP[] = "Scope";
	static const char DBUS_NAME[] = "DBusName";
	static const char DBUS_PATH[] = "DBusPath";
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* path;
	GKeyFile* _tmp3_;
	GKeyFile* key_file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->_lenses_directory;
	_tmp1_ = name;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, NULL);
	path = _tmp2_;
	_tmp3_ = g_key_file_new ();
	key_file = _tmp3_;
	{
		GKeyFile* _tmp4_;
		const gchar* _tmp5_;
		GKeyFile* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = key_file;
		_tmp5_ = path;
		g_key_file_load_from_file (_tmp4_, _tmp5_, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		_tmp6_ = key_file;
		_tmp7_ = g_key_file_has_group (_tmp6_, "Scope");
		if (_tmp7_) {
			GKeyFile* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* dbus_name;
			GKeyFile* _tmp10_;
			gchar* _tmp11_ = NULL;
			gchar* dbus_path;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			UnityScopeProxyRemote* _tmp14_;
			UnityScopeProxyRemote* scope;
			GeeArrayList* _tmp15_;
			UnityScopeProxyRemote* _tmp16_;
			UnityScopeProxyRemote* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp8_ = key_file;
			_tmp9_ = g_key_file_get_string (_tmp8_, GROUP, DBUS_NAME, &_inner_error_);
			dbus_name = _tmp9_;
			if (_inner_error_ != NULL) {
				goto __catch21_g_error;
			}
			_tmp10_ = key_file;
			_tmp11_ = g_key_file_get_string (_tmp10_, GROUP, DBUS_PATH, &_inner_error_);
			dbus_path = _tmp11_;
			if (_inner_error_ != NULL) {
				_g_free0 (dbus_name);
				goto __catch21_g_error;
			}
			_tmp12_ = dbus_name;
			_tmp13_ = dbus_path;
			_tmp14_ = unity_scope_proxy_remote_new (_tmp12_, _tmp13_);
			scope = _tmp14_;
			_tmp15_ = self->scopes;
			_tmp16_ = scope;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, (UnityScopeProxy*) _tmp16_);
			_tmp17_ = scope;
			g_signal_emit_by_name (self, "scope-added", (UnityScopeProxy*) _tmp17_);
			_tmp18_ = path;
			_tmp19_ = dbus_path;
			_tmp20_ = dbus_name;
			unity_trace_log_object ((GObject*) self, "Successfully loaded %s: %s@%s", _tmp18_, _tmp19_, _tmp20_);
			_g_object_unref0 (scope);
			_g_free0 (dbus_path);
			_g_free0 (dbus_name);
		} else {
			const gchar* _tmp21_;
			_tmp21_ = path;
			g_warning ("unity-scope-factory.vala:107: Unable to load %s: Does not contain 'Sco" \
"pe' group", _tmp21_);
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = path;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("unity-scope-factory.vala:110: Unable to load %s: %s", _tmp22_, _tmp24_);
		_g_error_free0 (e);
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (key_file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_key_file_free0 (key_file);
	_g_free0 (path);
}


void unity_scope_factory_add_local_scope (UnityScopeFactory* self, UnityScope* scope) {
	UnityScope* _tmp0_;
	UnityScopeProxyLocal* _tmp1_;
	UnityScopeProxyLocal* proxy;
	UnityScope* _tmp2_;
	GeeArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scope != NULL);
	_tmp0_ = scope;
	_tmp1_ = unity_scope_proxy_local_new (_tmp0_);
	proxy = _tmp1_;
	_tmp2_ = scope;
	unity_scope_set_local (_tmp2_, TRUE);
	_tmp3_ = self->scopes;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, (UnityScopeProxy*) proxy);
	g_signal_emit_by_name (self, "scope-added", (UnityScopeProxy*) proxy);
	_g_object_unref0 (proxy);
}


const gchar* unity_scope_factory_get_lens_id (UnityScopeFactory* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lens_id;
	result = _tmp0_;
	return result;
}


static void unity_scope_factory_set_lens_id (UnityScopeFactory* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_lens_id);
	self->priv->_lens_id = _tmp1_;
	g_object_notify ((GObject *) self, "lens-id");
}


const gchar* unity_scope_factory_get_lenses_directory (UnityScopeFactory* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lenses_directory;
	result = _tmp0_;
	return result;
}


static void unity_scope_factory_set_lenses_directory (UnityScopeFactory* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_lenses_directory);
	self->priv->_lenses_directory = _tmp1_;
	g_object_notify ((GObject *) self, "lenses-directory");
}


static GObject * unity_scope_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityScopeFactory * self;
	const gchar* _tmp0_;
	GeeArrayList* _tmp4_;
	parent_class = G_OBJECT_CLASS (unity_scope_factory_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_SCOPE_FACTORY (obj);
	_tmp0_ = self->priv->_lenses_directory;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = self->priv->_lens_id;
		_tmp2_ = g_strdup_printf ("%s/unity/lenses/%s", DATADIR, _tmp1_);
		_tmp3_ = _tmp2_;
		unity_scope_factory_set_lenses_directory (self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	_tmp4_ = gee_array_list_new (UNITY_TYPE_SCOPE_PROXY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->scopes);
	self->scopes = _tmp4_;
	unity_scope_factory_list_lens_directory (self, NULL, NULL);
	return obj;
}


static void unity_scope_factory_class_init (UnityScopeFactoryClass * klass) {
	unity_scope_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityScopeFactoryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_scope_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_scope_factory_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_scope_factory_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_scope_factory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_FACTORY_LENS_ID, g_param_spec_string ("lens-id", "lens-id", "lens-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_FACTORY_LENSES_DIRECTORY, g_param_spec_string ("lenses-directory", "lenses-directory", "lenses-directory", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("scope_added", UNITY_TYPE_SCOPE_FACTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, UNITY_TYPE_SCOPE_PROXY);
}


static void unity_scope_factory_instance_init (UnityScopeFactory * self) {
	self->priv = UNITY_SCOPE_FACTORY_GET_PRIVATE (self);
}


static void unity_scope_factory_finalize (GObject* obj) {
	UnityScopeFactory * self;
	self = UNITY_SCOPE_FACTORY (obj);
	_g_free0 (self->priv->_lens_id);
	_g_free0 (self->priv->_lenses_directory);
	_g_object_unref0 (self->scopes);
	G_OBJECT_CLASS (unity_scope_factory_parent_class)->finalize (obj);
}


GType unity_scope_factory_get_type (void) {
	static volatile gsize unity_scope_factory_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityScopeFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_scope_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityScopeFactory), 0, (GInstanceInitFunc) unity_scope_factory_instance_init, NULL };
		GType unity_scope_factory_type_id;
		unity_scope_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityScopeFactory", &g_define_type_info, 0);
		g_once_init_leave (&unity_scope_factory_type_id__volatile, unity_scope_factory_type_id);
	}
	return unity_scope_factory_type_id__volatile;
}


static void _vala_unity_scope_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityScopeFactory * self;
	self = UNITY_SCOPE_FACTORY (object);
	switch (property_id) {
		case UNITY_SCOPE_FACTORY_LENS_ID:
		g_value_set_string (value, unity_scope_factory_get_lens_id (self));
		break;
		case UNITY_SCOPE_FACTORY_LENSES_DIRECTORY:
		g_value_set_string (value, unity_scope_factory_get_lenses_directory (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_scope_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityScopeFactory * self;
	self = UNITY_SCOPE_FACTORY (object);
	switch (property_id) {
		case UNITY_SCOPE_FACTORY_LENS_ID:
		unity_scope_factory_set_lens_id (self, g_value_get_string (value));
		break;
		case UNITY_SCOPE_FACTORY_LENSES_DIRECTORY:
		unity_scope_factory_set_lenses_directory (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



