/* unity-lens-private.c generated by valac 0.12.1, the Vala compiler
 * generated from unity-lens-private.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "unity.h"
#include <dee.h>
#include <time.h>
#include <gee.h>


#define UNITY_TYPE_LENS_SERVICE (unity_lens_service_get_type ())
#define UNITY_LENS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_LENS_SERVICE, UnityLensService))
#define UNITY_IS_LENS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_LENS_SERVICE))
#define UNITY_LENS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_LENS_SERVICE, UnityLensServiceIface))

typedef struct _UnityLensService UnityLensService;
typedef struct _UnityLensServiceIface UnityLensServiceIface;

#define UNITY_TYPE_LENS_SERVICE_PROXY (unity_lens_service_proxy_get_type ())

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;

#define UNITY_TYPE_LENS_IMPL (unity_lens_impl_get_type ())
#define UNITY_LENS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_LENS_IMPL, UnityLensImpl))
#define UNITY_LENS_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_LENS_IMPL, UnityLensImplClass))
#define UNITY_IS_LENS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_LENS_IMPL))
#define UNITY_IS_LENS_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_LENS_IMPL))
#define UNITY_LENS_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_LENS_IMPL, UnityLensImplClass))

typedef struct _UnityLensImpl UnityLensImpl;
typedef struct _UnityLensImplClass UnityLensImplClass;
typedef struct _UnityLensImplPrivate UnityLensImplPrivate;

#define UNITY_TYPE_SCOPE_FACTORY (unity_scope_factory_get_type ())
#define UNITY_SCOPE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactory))
#define UNITY_SCOPE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactoryClass))
#define UNITY_IS_SCOPE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_FACTORY))
#define UNITY_IS_SCOPE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_FACTORY))
#define UNITY_SCOPE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactoryClass))

typedef struct _UnityScopeFactory UnityScopeFactory;
typedef struct _UnityScopeFactoryClass UnityScopeFactoryClass;

#define UNITY_TYPE_RESULTS_SYNCHRONIZER (unity_results_synchronizer_get_type ())
#define UNITY_RESULTS_SYNCHRONIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_RESULTS_SYNCHRONIZER, UnityResultsSynchronizer))
#define UNITY_RESULTS_SYNCHRONIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_RESULTS_SYNCHRONIZER, UnityResultsSynchronizerClass))
#define UNITY_IS_RESULTS_SYNCHRONIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_RESULTS_SYNCHRONIZER))
#define UNITY_IS_RESULTS_SYNCHRONIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_RESULTS_SYNCHRONIZER))
#define UNITY_RESULTS_SYNCHRONIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_RESULTS_SYNCHRONIZER, UnityResultsSynchronizerClass))

typedef struct _UnityResultsSynchronizer UnityResultsSynchronizer;
typedef struct _UnityResultsSynchronizerClass UnityResultsSynchronizerClass;

#define UNITY_TYPE_FILTERS_SYNCHRONIZER (unity_filters_synchronizer_get_type ())
#define UNITY_FILTERS_SYNCHRONIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_FILTERS_SYNCHRONIZER, UnityFiltersSynchronizer))
#define UNITY_FILTERS_SYNCHRONIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_FILTERS_SYNCHRONIZER, UnityFiltersSynchronizerClass))
#define UNITY_IS_FILTERS_SYNCHRONIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_FILTERS_SYNCHRONIZER))
#define UNITY_IS_FILTERS_SYNCHRONIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_FILTERS_SYNCHRONIZER))
#define UNITY_FILTERS_SYNCHRONIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_FILTERS_SYNCHRONIZER, UnityFiltersSynchronizerClass))

typedef struct _UnityFiltersSynchronizer UnityFiltersSynchronizer;
typedef struct _UnityFiltersSynchronizerClass UnityFiltersSynchronizerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_TYPE_SCOPE_PROXY (unity_scope_proxy_get_type ())
#define UNITY_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxy))
#define UNITY_IS_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY))
#define UNITY_SCOPE_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxyIface))

typedef struct _UnityScopeProxy UnityScopeProxy;
typedef struct _UnityScopeProxyIface UnityScopeProxyIface;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define UNITY_TYPE_LENS_INFO (unity_lens_info_get_type ())
typedef struct _UnityLensInfo UnityLensInfo;
typedef struct _Block1Data Block1Data;

#define UNITY_TYPE_SCOPE_PROXY_REMOTE (unity_scope_proxy_remote_get_type ())
#define UNITY_SCOPE_PROXY_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemote))
#define UNITY_SCOPE_PROXY_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemoteClass))
#define UNITY_IS_SCOPE_PROXY_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE))
#define UNITY_IS_SCOPE_PROXY_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_PROXY_REMOTE))
#define UNITY_SCOPE_PROXY_REMOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemoteClass))

typedef struct _UnityScopeProxyRemote UnityScopeProxyRemote;
typedef struct _UnityScopeProxyRemoteClass UnityScopeProxyRemoteClass;
typedef struct _UnityLensImplInfoRequestData UnityLensImplInfoRequestData;
typedef struct _UnityLensImplActivateData UnityLensImplActivateData;
typedef struct _UnityScopeFactoryPrivate UnityScopeFactoryPrivate;
typedef struct _UnityLensImplSearchData UnityLensImplSearchData;
typedef struct _UnityLensImplGlobalSearchData UnityLensImplGlobalSearchData;
typedef struct _UnityLensImplPreviewData UnityLensImplPreviewData;
typedef struct _UnityLensImplUpdateFilterData UnityLensImplUpdateFilterData;
typedef struct _UnityLensImplSetActiveData UnityLensImplSetActiveData;

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

struct _UnityLensServiceIface {
	GTypeInterface parent_iface;
	void (*info_request) (UnityLensService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*info_request_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*activate) (UnityLensService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityLensService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
	void (*search) (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*global_search) (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*global_search_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*preview) (UnityLensService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityLensService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
	void (*update_filter) (UnityLensService* self, const gchar* filter_name, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_filter_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*set_active) (UnityLensService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
};

struct _UnityLensImpl {
	GObject parent_instance;
	UnityLensImplPrivate * priv;
};

struct _UnityLensImplClass {
	GObjectClass parent_class;
};

struct _UnityLensImplPrivate {
	UnityLens* _owner;
	guint _dbus_id;
	guint _info_changed_id;
	DeeSharedModel* _results_model;
	DeeSharedModel* _global_results_model;
	DeeSharedModel* _categories_model;
	DeeSharedModel* _filters_model;
	UnityScopeFactory* _scope_factory;
	UnityResultsSynchronizer* _results_sync;
	UnityResultsSynchronizer* _global_results_sync;
	UnityFiltersSynchronizer* _filters_sync;
};

struct _UnityScopeProxyIface {
	GTypeInterface parent_iface;
	void (*activate) (UnityScopeProxy* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityActivationReplyRaw* result);
	void (*search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*global_search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*global_search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*preview) (UnityScopeProxy* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result);
	void (*set_active) (UnityScopeProxy* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*set_active_sources) (UnityScopeProxy* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	gchar** (*get_sources) (UnityScopeProxy* self, int* result_length1);
	void (*set_sources) (UnityScopeProxy* self, gchar** value, int value_length1);
	gboolean (*get_search_in_global) (UnityScopeProxy* self);
	void (*set_search_in_global) (UnityScopeProxy* self, gboolean value);
	DeeSharedModel* (*get_results_model) (UnityScopeProxy* self);
	void (*set_results_model) (UnityScopeProxy* self, DeeSharedModel* value);
	DeeSharedModel* (*get_global_results_model) (UnityScopeProxy* self);
	void (*set_global_results_model) (UnityScopeProxy* self, DeeSharedModel* value);
	DeeSharedModel* (*get_filters_model) (UnityScopeProxy* self);
	void (*set_filters_model) (UnityScopeProxy* self, DeeSharedModel* value);
};

struct _UnityLensInfo {
	gchar* dbus_path;
	gboolean search_in_global;
	gboolean visible;
	gchar* search_hint;
	gchar* private_connection_name;
	gchar* results_model_name;
	gchar* global_results_model_name;
	gchar* categories_model_name;
	gchar* filters_model_name;
	GHashTable* hints;
};

struct _Block1Data {
	int _ref_count_;
	UnityLensImpl * self;
	UnityScopeProxy* scope;
};

struct _UnityLensImplInfoRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
};

struct _UnityLensImplActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	gchar* uri;
	guint action_type;
	UnityActivationReplyRaw result;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	UnityScopeProxy* _tmp2_;
	UnityScopeProxy* scope;
	UnityActivationReplyRaw raw;
	GHashTable* _tmp3_;
	UnityActivationReplyRaw _tmp4_;
	UnityActivationReplyRaw _tmp5_;
	gchar* _tmp6_;
};

struct _UnityScopeFactory {
	GObject parent_instance;
	UnityScopeFactoryPrivate * priv;
	GeeArrayList* scopes;
};

struct _UnityScopeFactoryClass {
	GObjectClass parent_class;
};

struct _UnityLensImplSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	gchar* search_string;
	GHashTable* hints;
	GeeArrayList* _tmp0_;
	GeeArrayList* _scope_list;
	gint _tmp1_;
	gint _scope_size;
	gint _scope_index;
	gpointer _tmp2_;
	UnityScopeProxy* scope;
};

struct _UnityLensImplGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	gchar* search_string;
	GHashTable* hints;
	GeeArrayList* _tmp0_;
	GeeArrayList* _scope_list;
	gint _tmp1_;
	gint _scope_size;
	gint _scope_index;
	gpointer _tmp2_;
	UnityScopeProxy* scope;
	gboolean _tmp3_;
};

struct _UnityLensImplPreviewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	gchar* uri;
	UnityPreviewReplyRaw result;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	UnityScopeProxy* _tmp2_;
	UnityScopeProxy* scope;
	UnityPreviewReplyRaw raw;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	UnityPreviewReplyRaw _tmp5_;
	UnityPreviewReplyRaw _tmp6_;
	gchar* _tmp7_;
};

struct _UnityLensImplUpdateFilterData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	gchar* filter_name;
	GHashTable* properties;
};

struct _UnityLensImplSetActiveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	gboolean is_active;
	GeeArrayList* _tmp0_;
	GeeArrayList* _scope_list;
	gint _tmp1_;
	gint _scope_size;
	gint _scope_index;
	gpointer _tmp2_;
	UnityScopeProxy* scope;
};


static gpointer unity_lens_impl_parent_class = NULL;
static UnityLensServiceIface* unity_lens_impl_unity_lens_service_parent_iface = NULL;

GType unity_lens_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_lens_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_lens_service_get_type (void) G_GNUC_CONST;
GType unity_lens_impl_get_type (void) G_GNUC_CONST;
GType unity_scope_factory_get_type (void) G_GNUC_CONST;
GType unity_results_synchronizer_get_type (void) G_GNUC_CONST;
GType unity_filters_synchronizer_get_type (void) G_GNUC_CONST;
#define UNITY_LENS_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_LENS_IMPL, UnityLensImplPrivate))
enum  {
	UNITY_LENS_IMPL_DUMMY_PROPERTY
};
UnityLensImpl* unity_lens_impl_new (UnityLens* owner);
UnityLensImpl* unity_lens_impl_construct (GType object_type, UnityLens* owner);
static void unity_lens_impl_queue_info_changed (UnityLensImpl* self);
static void _unity_lens_impl_queue_info_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_lens_impl_create_models (UnityLensImpl* self, const gchar* dbus_name);
static gchar* unity_lens_impl_create_dbus_name (UnityLensImpl* self);
static void unity_lens_impl_create_synchronizers (UnityLensImpl* self);
UnityScopeFactory* unity_scope_factory_new (const gchar* lens_id_, const gchar* lenses_directory_);
UnityScopeFactory* unity_scope_factory_construct (GType object_type, const gchar* lens_id_, const gchar* lenses_directory_);
GType unity_scope_proxy_get_type (void) G_GNUC_CONST;
static void unity_lens_impl_on_scope_added (UnityLensImpl* self, UnityScopeFactory* factory, UnityScopeProxy* scope);
static void _unity_lens_impl_on_scope_added_unity_scope_factory_scope_added (UnityScopeFactory* _sender, UnityScopeProxy* scope, gpointer self);
UnityResultsSynchronizer* unity_results_synchronizer_new (DeeModel* receiver);
UnityResultsSynchronizer* unity_results_synchronizer_construct (GType object_type, DeeModel* receiver);
UnityFiltersSynchronizer* unity_filters_synchronizer_new (DeeModel* provider);
UnityFiltersSynchronizer* unity_filters_synchronizer_construct (GType object_type, DeeModel* provider);
void unity_lens_impl_export (UnityLensImpl* self, GError** error);
void unity_lens_impl_load_categories (UnityLensImpl* self, GList* categories);
const gchar* unity_category_get_renderer (UnityCategory* self);
GVariant* unity_tools_hash_table_to_asv (GHashTable* hash);
GHashTable* unity_category_get_hints (UnityCategory* self);
void unity_lens_impl_load_filters (UnityLensImpl* self, GList* filters);
GHashTable* unity_filter_get_hints (UnityFilter* self);
static gboolean unity_lens_impl_emit_info_changed (UnityLensImpl* self);
static gboolean _unity_lens_impl_emit_info_changed_gsource_func (gpointer self);
GType unity_lens_info_get_type (void) G_GNUC_CONST;
UnityLensInfo* unity_lens_info_dup (const UnityLensInfo* self);
void unity_lens_info_free (UnityLensInfo* self);
void unity_lens_info_copy (const UnityLensInfo* self, UnityLensInfo* dest);
void unity_lens_info_destroy (UnityLensInfo* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void unity_lens_impl_on_scope_results_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec);
static void _unity_lens_impl_on_scope_results_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_lens_impl_on_scope_global_results_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec);
static void _unity_lens_impl_on_scope_global_results_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_lens_impl_on_scope_filters_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec);
static void _unity_lens_impl_on_scope_filters_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void unity_results_synchronizer_add_provider (UnityResultsSynchronizer* self, DeeModel* provider, const gchar* uid);
DeeSharedModel* unity_scope_proxy_get_results_model (UnityScopeProxy* self);
static gchar* unity_lens_impl_uid_for_scope (UnityLensImpl* self, UnityScopeProxy* scope);
DeeSharedModel* unity_scope_proxy_get_global_results_model (UnityScopeProxy* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
GType unity_scope_proxy_remote_get_type (void) G_GNUC_CONST;
DeeSharedModel* unity_scope_proxy_get_filters_model (UnityScopeProxy* self);
static void _lambda7_ (Block1Data* _data1_);
void unity_filters_synchronizer_add_receiver (UnityFiltersSynchronizer* self, DeeModel* receiver);
static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void unity_lens_impl_add_local_scope (UnityLensImpl* self, UnityScope* scope);
void unity_scope_factory_add_local_scope (UnityScopeFactory* self, UnityScope* scope);
static void unity_lens_impl_real_info_request_data_free (gpointer _data);
static void unity_lens_impl_real_info_request (UnityLensService* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_info_request_co (UnityLensImplInfoRequestData* data);
static void unity_lens_impl_real_activate_data_free (gpointer _data);
static void unity_lens_impl_real_activate (UnityLensService* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_activate_co (UnityLensImplActivateData* data);
static UnityScopeProxy* unity_lens_impl_get_scope_for_uid (UnityLensImpl* self, const gchar* uid);
void unity_scope_proxy_activate (UnityScopeProxy* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_proxy_activate_finish (UnityScopeProxy* self, GAsyncResult* _res_, UnityActivationReplyRaw* result);
static void unity_lens_impl_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_lens_impl_real_search_data_free (gpointer _data);
static void unity_lens_impl_real_search (UnityLensService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_search_co (UnityLensImplSearchData* data);
void unity_scope_proxy_search (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_proxy_search_finish (UnityScopeProxy* self, GAsyncResult* _res_);
static void unity_lens_impl_real_global_search_data_free (gpointer _data);
static void unity_lens_impl_real_global_search (UnityLensService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_global_search_co (UnityLensImplGlobalSearchData* data);
gboolean unity_scope_proxy_get_search_in_global (UnityScopeProxy* self);
void unity_scope_proxy_global_search (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_proxy_global_search_finish (UnityScopeProxy* self, GAsyncResult* _res_);
static void unity_lens_impl_real_preview_data_free (gpointer _data);
static void unity_lens_impl_real_preview (UnityLensService* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_preview_co (UnityLensImplPreviewData* data);
void unity_scope_proxy_preview (UnityScopeProxy* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_proxy_preview_finish (UnityScopeProxy* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result);
static void unity_lens_impl_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_lens_impl_real_update_filter_data_free (gpointer _data);
static void unity_lens_impl_real_update_filter (UnityLensService* base, const gchar* filter_name, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_update_filter_co (UnityLensImplUpdateFilterData* data);
static void unity_lens_impl_real_set_active_data_free (gpointer _data);
static void unity_lens_impl_real_set_active (UnityLensService* base, gboolean is_active, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_set_active_co (UnityLensImplSetActiveData* data);
void unity_scope_proxy_set_active (UnityScopeProxy* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_proxy_set_active_finish (UnityScopeProxy* self, GAsyncResult* _res_);
void unity_lens_set_active_internal (UnityLens* self, gboolean is_active);
static void unity_lens_impl_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _unity_lens_impl_queue_info_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_lens_impl_queue_info_changed (self);
}


static void _unity_lens_impl_on_scope_added_unity_scope_factory_scope_added (UnityScopeFactory* _sender, UnityScopeProxy* scope, gpointer self) {
	unity_lens_impl_on_scope_added (self, _sender, scope);
}


UnityLensImpl* unity_lens_impl_construct (GType object_type, UnityLens* owner) {
	UnityLensImpl * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	UnityScopeFactory* _tmp3_ = NULL;
	g_return_val_if_fail (owner != NULL, NULL);
	self = (UnityLensImpl*) g_object_new (object_type, NULL);
	self->priv->_owner = owner;
	g_signal_connect_object ((GObject*) self->priv->_owner, "notify::search-in-global", (GCallback) _unity_lens_impl_queue_info_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->_owner, "notify::visible", (GCallback) _unity_lens_impl_queue_info_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->_owner, "notify::search-hint", (GCallback) _unity_lens_impl_queue_info_changed_g_object_notify, self, 0);
	_tmp0_ = unity_lens_impl_create_dbus_name (self);
	_tmp1_ = _tmp0_;
	unity_lens_impl_create_models (self, _tmp1_);
	_g_free0 (_tmp1_);
	unity_lens_impl_create_synchronizers (self);
	_tmp2_ = unity_lens_get_id (self->priv->_owner);
	_tmp3_ = unity_scope_factory_new (_tmp2_, "");
	_g_object_unref0 (self->priv->_scope_factory);
	self->priv->_scope_factory = _tmp3_;
	g_signal_connect_object (self->priv->_scope_factory, "scope-added", (GCallback) _unity_lens_impl_on_scope_added_unity_scope_factory_scope_added, self, 0);
	return self;
}


UnityLensImpl* unity_lens_impl_new (UnityLens* owner) {
	return unity_lens_impl_construct (UNITY_TYPE_LENS_IMPL, owner);
}


static gchar* unity_lens_impl_create_dbus_name (UnityLensImpl* self) {
	gchar* result = NULL;
	time_t _tmp0_;
	guint t;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = time (NULL);
	t = (guint) _tmp0_;
	_tmp1_ = unity_lens_get_id (self->priv->_owner);
	_tmp2_ = g_strconcat ("com.canonical.Unity.Lens" ".", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (".T%u", t);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	result = _tmp7_;
	return result;
}


static void unity_lens_impl_create_models (UnityLensImpl* self, const gchar* dbus_name) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	DeeSharedModel* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	DeeSharedModel* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	DeeSharedModel* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	DeeSharedModel* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_name != NULL);
	_tmp0_ = g_strconcat (dbus_name, ".Results", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = (DeeSharedModel*) dee_shared_model_new (_tmp1_);
	_g_object_unref0 (self->priv->_results_model);
	self->priv->_results_model = _tmp2_;
	_g_free0 (_tmp1_);
	dee_model_set_schema ((DeeModel*) self->priv->_results_model, "s", "s", "u", "s", "s", "s", "s", NULL);
	_tmp3_ = g_strconcat (dbus_name, ".GlobalResults", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = (DeeSharedModel*) dee_shared_model_new (_tmp4_);
	_g_object_unref0 (self->priv->_global_results_model);
	self->priv->_global_results_model = _tmp5_;
	_g_free0 (_tmp4_);
	dee_model_set_schema ((DeeModel*) self->priv->_global_results_model, "s", "s", "u", "s", "s", "s", "s", NULL);
	_tmp6_ = g_strconcat (dbus_name, ".Categories", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = (DeeSharedModel*) dee_shared_model_new (_tmp7_);
	_g_object_unref0 (self->priv->_categories_model);
	self->priv->_categories_model = _tmp8_;
	_g_free0 (_tmp7_);
	dee_model_set_schema ((DeeModel*) self->priv->_categories_model, "s", "s", "s", "a{sv}", NULL);
	_tmp9_ = g_strconcat (dbus_name, ".Filters", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = (DeeSharedModel*) dee_shared_model_new (_tmp10_);
	_g_object_unref0 (self->priv->_filters_model);
	self->priv->_filters_model = _tmp11_;
	_g_free0 (_tmp10_);
	dee_model_set_schema ((DeeModel*) self->priv->_filters_model, "s", "s", "s", "s", "a{sv}", "b", "b", "b", NULL);
}


static void unity_lens_impl_create_synchronizers (UnityLensImpl* self) {
	UnityResultsSynchronizer* _tmp0_ = NULL;
	UnityResultsSynchronizer* _tmp1_ = NULL;
	UnityFiltersSynchronizer* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_results_synchronizer_new ((DeeModel*) self->priv->_results_model);
	_g_object_unref0 (self->priv->_results_sync);
	self->priv->_results_sync = _tmp0_;
	_tmp1_ = unity_results_synchronizer_new ((DeeModel*) self->priv->_global_results_model);
	_g_object_unref0 (self->priv->_global_results_sync);
	self->priv->_global_results_sync = _tmp1_;
	_tmp2_ = unity_filters_synchronizer_new ((DeeModel*) self->priv->_filters_model);
	_g_object_unref0 (self->priv->_filters_sync);
	self->priv->_filters_sync = _tmp2_;
}


void unity_lens_impl_export (UnityLensImpl* self, GError** error) {
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* conn;
	const gchar* _tmp1_ = NULL;
	UnityLensImpl* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	conn = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = unity_lens_get_dbus_path (self->priv->_owner);
	_tmp2_ = self;
	_tmp3_ = unity_lens_service_register_object (UNITY_IS_LENS_SERVICE (_tmp2_) ? ((UnityLensService*) _tmp2_) : NULL, conn, _tmp1_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (conn);
			return;
		} else {
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_dbus_id = _tmp4_;
	unity_lens_impl_queue_info_changed (self);
	_g_object_unref0 (conn);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_lens_impl_load_categories (UnityLensImpl* self, GList* categories) {
	g_return_if_fail (self != NULL);
	{
		GList* category_collection;
		GList* category_it;
		category_collection = categories;
		for (category_it = category_collection; category_it != NULL; category_it = category_it->next) {
			UnityCategory* _tmp0_;
			UnityCategory* category;
			_tmp0_ = _g_object_ref0 ((UnityCategory*) category_it->data);
			category = _tmp0_;
			{
				gchar* _tmp1_ = NULL;
				GIcon* _tmp2_ = NULL;
				gchar* _tmp6_;
				gchar* icon_hint_s;
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				GHashTable* _tmp9_ = NULL;
				GVariant* _tmp10_ = NULL;
				GVariant* _tmp11_;
				_tmp2_ = unity_category_get_icon_hint (category);
				if (_tmp2_ != NULL) {
					GIcon* _tmp3_ = NULL;
					gchar* _tmp4_ = NULL;
					_tmp3_ = unity_category_get_icon_hint (category);
					_tmp4_ = g_icon_to_string (_tmp3_);
					_g_free0 (_tmp1_);
					_tmp1_ = _tmp4_;
				} else {
					gchar* _tmp5_;
					_tmp5_ = g_strdup ("");
					_g_free0 (_tmp1_);
					_tmp1_ = _tmp5_;
				}
				_tmp6_ = g_strdup (_tmp1_);
				icon_hint_s = _tmp6_;
				_tmp7_ = unity_category_get_name (category);
				_tmp8_ = unity_category_get_renderer (category);
				_tmp9_ = unity_category_get_hints (category);
				_tmp10_ = unity_tools_hash_table_to_asv (_tmp9_);
				_tmp11_ = _tmp10_;
				dee_model_append ((DeeModel*) self->priv->_categories_model, _tmp7_, icon_hint_s, _tmp8_, _tmp11_, NULL);
				_g_variant_unref0 (_tmp11_);
				_g_free0 (icon_hint_s);
				_g_free0 (_tmp1_);
				_g_object_unref0 (category);
			}
		}
	}
}


void unity_lens_impl_load_filters (UnityLensImpl* self, GList* filters) {
	g_return_if_fail (self != NULL);
	{
		GList* filter_collection;
		GList* filter_it;
		filter_collection = filters;
		for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
			UnityFilter* _tmp0_;
			UnityFilter* filter;
			_tmp0_ = _g_object_ref0 ((UnityFilter*) filter_it->data);
			filter = _tmp0_;
			{
				gchar* _tmp1_ = NULL;
				GIcon* _tmp2_ = NULL;
				gchar* _tmp6_;
				gchar* icon_hint_s;
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				GHashTable* _tmp10_ = NULL;
				GHashTable* _tmp11_;
				GVariant* _tmp12_ = NULL;
				GVariant* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp2_ = unity_filter_get_icon_hint (filter);
				if (_tmp2_ != NULL) {
					GIcon* _tmp3_ = NULL;
					gchar* _tmp4_ = NULL;
					_tmp3_ = unity_filter_get_icon_hint (filter);
					_tmp4_ = g_icon_to_string (_tmp3_);
					_g_free0 (_tmp1_);
					_tmp1_ = _tmp4_;
				} else {
					gchar* _tmp5_;
					_tmp5_ = g_strdup ("");
					_g_free0 (_tmp1_);
					_tmp1_ = _tmp5_;
				}
				_tmp6_ = g_strdup (_tmp1_);
				icon_hint_s = _tmp6_;
				_tmp7_ = unity_filter_get_id (filter);
				_tmp8_ = unity_filter_get_display_name (filter);
				_tmp9_ = unity_filter_get_renderer_name (filter);
				_tmp10_ = unity_filter_get_hints (filter);
				_tmp11_ = _tmp10_;
				_tmp12_ = unity_tools_hash_table_to_asv (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = unity_filter_get_visible (filter);
				_tmp15_ = unity_filter_get_collapsed (filter);
				_tmp16_ = unity_filter_get_filtering (filter);
				dee_model_append ((DeeModel*) self->priv->_filters_model, _tmp7_, _tmp8_, icon_hint_s, _tmp9_, _tmp13_, _tmp14_, _tmp15_, _tmp16_, NULL);
				_g_variant_unref0 (_tmp13_);
				_g_hash_table_unref0 (_tmp11_);
				_g_free0 (icon_hint_s);
				_g_free0 (_tmp1_);
				_g_object_unref0 (filter);
			}
		}
	}
}


static gboolean _unity_lens_impl_emit_info_changed_gsource_func (gpointer self) {
	gboolean result;
	result = unity_lens_impl_emit_info_changed (self);
	return result;
}


static void unity_lens_impl_queue_info_changed (UnityLensImpl* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_info_changed_id == 0) {
		guint _tmp0_;
		_tmp0_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _unity_lens_impl_emit_info_changed_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_info_changed_id = _tmp0_;
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gboolean unity_lens_impl_emit_info_changed (UnityLensImpl* self) {
	gboolean result = FALSE;
	UnityLensInfo info = {0};
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	GHashTable* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&info, 0, sizeof (UnityLensInfo));
	_tmp0_ = unity_lens_get_dbus_path (self->priv->_owner);
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (info.dbus_path);
	info.dbus_path = _tmp1_;
	_tmp2_ = unity_lens_get_search_in_global (self->priv->_owner);
	info.search_in_global = _tmp2_;
	_tmp3_ = unity_lens_get_search_hint (self->priv->_owner);
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (info.search_hint);
	info.search_hint = _tmp4_;
	_tmp5_ = unity_lens_get_visible (self->priv->_owner);
	info.visible = _tmp5_;
	_tmp6_ = g_strdup ("<not implemented>");
	_g_free0 (info.private_connection_name);
	info.private_connection_name = _tmp6_;
	_tmp7_ = dee_shared_model_get_swarm_name (self->priv->_results_model);
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (info.results_model_name);
	info.results_model_name = _tmp8_;
	_tmp9_ = dee_shared_model_get_swarm_name (self->priv->_global_results_model);
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (info.global_results_model_name);
	info.global_results_model_name = _tmp10_;
	_tmp11_ = dee_shared_model_get_swarm_name (self->priv->_categories_model);
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (info.categories_model_name);
	info.categories_model_name = _tmp12_;
	_tmp13_ = dee_shared_model_get_swarm_name (self->priv->_filters_model);
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (info.filters_model_name);
	info.filters_model_name = _tmp14_;
	_tmp15_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (info.hints);
	info.hints = _tmp15_;
	g_signal_emit_by_name ((UnityLensService*) self, "changed", &info);
	self->priv->_info_changed_id = (guint) 0;
	result = FALSE;
	unity_lens_info_destroy (&info);
	return result;
}


static void _unity_lens_impl_on_scope_results_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_lens_impl_on_scope_results_model_changed (self, _sender, pspec);
}


static void _unity_lens_impl_on_scope_global_results_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_lens_impl_on_scope_global_results_model_changed (self, _sender, pspec);
}


static void _unity_lens_impl_on_scope_filters_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_lens_impl_on_scope_filters_model_changed (self, _sender, pspec);
}


static void unity_lens_impl_on_scope_added (UnityLensImpl* self, UnityScopeFactory* factory, UnityScopeProxy* scope) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (factory != NULL);
	g_return_if_fail (scope != NULL);
	g_signal_connect_object ((GObject*) scope, "notify::results-model", (GCallback) _unity_lens_impl_on_scope_results_model_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) scope, "notify::global-results-model", (GCallback) _unity_lens_impl_on_scope_global_results_model_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) scope, "notify::filters-model", (GCallback) _unity_lens_impl_on_scope_filters_model_changed_g_object_notify, self, 0);
}


static void unity_lens_impl_on_scope_results_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec) {
	GObject* _tmp0_;
	UnityScopeProxy* _tmp1_;
	UnityScopeProxy* scope;
	DeeSharedModel* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_SCOPE_PROXY (_tmp0_) ? ((UnityScopeProxy*) _tmp0_) : NULL);
	scope = _tmp1_;
	_tmp2_ = unity_scope_proxy_get_results_model (scope);
	_tmp3_ = unity_lens_impl_uid_for_scope (self, scope);
	_tmp4_ = _tmp3_;
	unity_results_synchronizer_add_provider (self->priv->_results_sync, (DeeModel*) _tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (scope);
}


static void unity_lens_impl_on_scope_global_results_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec) {
	GObject* _tmp0_;
	UnityScopeProxy* _tmp1_;
	UnityScopeProxy* scope;
	DeeSharedModel* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_SCOPE_PROXY (_tmp0_) ? ((UnityScopeProxy*) _tmp0_) : NULL);
	scope = _tmp1_;
	_tmp2_ = unity_scope_proxy_get_global_results_model (scope);
	_tmp3_ = g_strdup_printf ("%p", scope);
	_tmp4_ = _tmp3_;
	unity_results_synchronizer_add_provider (self->priv->_global_results_sync, (DeeModel*) _tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (scope);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->scope);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda7_ (Block1Data* _data1_) {
	UnityLensImpl * self;
	DeeSharedModel* _tmp0_ = NULL;
	self = _data1_->self;
	_tmp0_ = unity_scope_proxy_get_filters_model (_data1_->scope);
	unity_filters_synchronizer_add_receiver (self->priv->_filters_sync, (DeeModel*) _tmp0_);
}


static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda7_ (self);
}


static void unity_lens_impl_on_scope_filters_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec) {
	Block1Data* _data1_;
	GObject* _tmp0_;
	UnityScopeProxy* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_SCOPE_PROXY (_tmp0_) ? ((UnityScopeProxy*) _tmp0_) : NULL);
	_data1_->scope = _tmp1_;
	if (UNITY_IS_SCOPE_PROXY_REMOTE (_data1_->scope)) {
		DeeSharedModel* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp3_ = unity_scope_proxy_get_filters_model (_data1_->scope);
		g_object_get (_tmp3_, "synchronized", &_tmp4_, NULL);
		_tmp2_ = _tmp4_ == FALSE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		DeeSharedModel* _tmp5_ = NULL;
		_tmp5_ = unity_scope_proxy_get_filters_model (_data1_->scope);
		g_signal_connect_data ((GObject*) _tmp5_, "notify::synchronized", (GCallback) __lambda7__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	} else {
		DeeSharedModel* _tmp6_ = NULL;
		_tmp6_ = unity_scope_proxy_get_filters_model (_data1_->scope);
		unity_filters_synchronizer_add_receiver (self->priv->_filters_sync, (DeeModel*) _tmp6_);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


void unity_lens_impl_add_local_scope (UnityLensImpl* self, UnityScope* scope) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scope != NULL);
	unity_scope_factory_add_local_scope (self->priv->_scope_factory, scope);
}


static void unity_lens_impl_real_info_request_data_free (gpointer _data) {
	UnityLensImplInfoRequestData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (UnityLensImplInfoRequestData, data);
}


static void unity_lens_impl_real_info_request (UnityLensService* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplInfoRequestData* _data_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplInfoRequestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_info_request);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_info_request_data_free);
	_data_->self = _g_object_ref0 (self);
	unity_lens_impl_real_info_request_co (_data_);
}


static void unity_lens_impl_real_info_request_finish (UnityLensService* base, GAsyncResult* _res_, GError** error) {
	UnityLensImplInfoRequestData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_lens_impl_real_info_request_co (UnityLensImplInfoRequestData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	unity_lens_impl_queue_info_changed (data->self);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_activate_data_free (gpointer _data) {
	UnityLensImplActivateData* data;
	data = _data;
	_g_free0 (data->uri);
	unity_activation_reply_raw_destroy (&data->result);
	_g_object_unref0 (data->self);
	g_slice_free (UnityLensImplActivateData, data);
}


static void unity_lens_impl_real_activate (UnityLensService* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplActivateData* _data_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_activate_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uri = g_strdup (uri);
	_data_->action_type = action_type;
	unity_lens_impl_real_activate_co (_data_);
}


static void unity_lens_impl_real_activate_finish (UnityLensService* base, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error) {
	UnityLensImplActivateData* _data_;
	UnityActivationReplyRaw _tmp0_ = {0};
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_activation_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_lens_impl_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityLensImplActivateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_lens_impl_real_activate_co (data);
}


static gboolean unity_lens_impl_real_activate_co (UnityLensImplActivateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp1_ = NULL;
	data->_tmp1_ = data->_tmp0_ = g_strsplit (data->uri, ":", 2);
	data->tokens = data->_tmp1_;
	data->tokens_length1 = _vala_array_length (data->_tmp0_);
	data->_tokens_size_ = _vala_array_length (data->_tmp0_);
	data->_tmp2_ = NULL;
	data->_tmp2_ = unity_lens_impl_get_scope_for_uid (data->self, data->tokens[0]);
	data->scope = data->_tmp2_;
	memset (&data->raw, 0, sizeof (UnityActivationReplyRaw));
	data->raw.handled = (guint) UNITY_HANDLED_TYPE_NOT_HANDLED;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (data->raw.hints);
	data->raw.hints = data->_tmp3_;
	if (UNITY_IS_SCOPE_PROXY (data->scope)) {
		memset (&data->_tmp4_, 0, sizeof (UnityActivationReplyRaw));
		data->_state_ = 1;
		unity_scope_proxy_activate (data->scope, data->tokens[1], data->action_type, unity_lens_impl_activate_ready, data);
		return FALSE;
		_state_1:
		unity_scope_proxy_activate_finish (data->scope, data->_res_, &data->_tmp4_);
		memset (&data->_tmp5_, 0, sizeof (UnityActivationReplyRaw));
		data->_tmp5_ = data->_tmp4_;
		unity_activation_reply_raw_destroy (&data->raw);
		data->raw = data->_tmp5_;
	}
	data->_tmp6_ = g_strdup (data->uri);
	_g_free0 (data->raw.uri);
	data->raw.uri = data->_tmp6_;
	data->result = data->raw;
	_g_object_unref0 (data->scope);
	data->tokens = (_vala_array_free (data->tokens, data->tokens_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	unity_activation_reply_raw_destroy (&data->raw);
	_g_object_unref0 (data->scope);
	data->tokens = (_vala_array_free (data->tokens, data->tokens_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_search_data_free (gpointer _data) {
	UnityLensImplSearchData* data;
	data = _data;
	_g_free0 (data->search_string);
	_g_hash_table_unref0 (data->hints);
	_g_object_unref0 (data->self);
	g_slice_free (UnityLensImplSearchData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void unity_lens_impl_real_search (UnityLensService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplSearchData* _data_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->search_string = g_strdup (search_string);
	_data_->hints = _g_hash_table_ref0 (hints);
	unity_lens_impl_real_search_co (_data_);
}


static void unity_lens_impl_real_search_finish (UnityLensService* base, GAsyncResult* _res_, GError** error) {
	UnityLensImplSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_lens_impl_real_search_co (UnityLensImplSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = _g_object_ref0 (data->self->priv->_scope_factory->scopes);
		data->_scope_list = data->_tmp0_;
		data->_tmp1_ = gee_collection_get_size ((GeeCollection*) data->_scope_list);
		data->_scope_size = data->_tmp1_;
		data->_scope_index = -1;
		while (TRUE) {
			data->_scope_index = data->_scope_index + 1;
			if (!(data->_scope_index < data->_scope_size)) {
				break;
			}
			data->_tmp2_ = NULL;
			data->_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) data->_scope_list, data->_scope_index);
			data->scope = (UnityScopeProxy*) data->_tmp2_;
			unity_scope_proxy_search (data->scope, data->search_string, data->hints, NULL, NULL);
			_g_object_unref0 (data->scope);
		}
		_g_object_unref0 (data->_scope_list);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_global_search_data_free (gpointer _data) {
	UnityLensImplGlobalSearchData* data;
	data = _data;
	_g_free0 (data->search_string);
	_g_hash_table_unref0 (data->hints);
	_g_object_unref0 (data->self);
	g_slice_free (UnityLensImplGlobalSearchData, data);
}


static void unity_lens_impl_real_global_search (UnityLensService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplGlobalSearchData* _data_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_global_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->search_string = g_strdup (search_string);
	_data_->hints = _g_hash_table_ref0 (hints);
	unity_lens_impl_real_global_search_co (_data_);
}


static void unity_lens_impl_real_global_search_finish (UnityLensService* base, GAsyncResult* _res_, GError** error) {
	UnityLensImplGlobalSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_lens_impl_real_global_search_co (UnityLensImplGlobalSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = _g_object_ref0 (data->self->priv->_scope_factory->scopes);
		data->_scope_list = data->_tmp0_;
		data->_tmp1_ = gee_collection_get_size ((GeeCollection*) data->_scope_list);
		data->_scope_size = data->_tmp1_;
		data->_scope_index = -1;
		while (TRUE) {
			data->_scope_index = data->_scope_index + 1;
			if (!(data->_scope_index < data->_scope_size)) {
				break;
			}
			data->_tmp2_ = NULL;
			data->_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) data->_scope_list, data->_scope_index);
			data->scope = (UnityScopeProxy*) data->_tmp2_;
			data->_tmp3_ = unity_scope_proxy_get_search_in_global (data->scope);
			if (data->_tmp3_) {
				unity_scope_proxy_global_search (data->scope, data->search_string, data->hints, NULL, NULL);
			}
			_g_object_unref0 (data->scope);
		}
		_g_object_unref0 (data->_scope_list);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_preview_data_free (gpointer _data) {
	UnityLensImplPreviewData* data;
	data = _data;
	_g_free0 (data->uri);
	unity_preview_reply_raw_destroy (&data->result);
	_g_object_unref0 (data->self);
	g_slice_free (UnityLensImplPreviewData, data);
}


static void unity_lens_impl_real_preview (UnityLensService* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplPreviewData* _data_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplPreviewData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_preview);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_preview_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uri = g_strdup (uri);
	unity_lens_impl_real_preview_co (_data_);
}


static void unity_lens_impl_real_preview_finish (UnityLensService* base, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error) {
	UnityLensImplPreviewData* _data_;
	UnityPreviewReplyRaw _tmp0_ = {0};
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_preview_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_lens_impl_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityLensImplPreviewData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_lens_impl_real_preview_co (data);
}


static gboolean unity_lens_impl_real_preview_co (UnityLensImplPreviewData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp1_ = NULL;
	data->_tmp1_ = data->_tmp0_ = g_strsplit (data->uri, ":", 2);
	data->tokens = data->_tmp1_;
	data->tokens_length1 = _vala_array_length (data->_tmp0_);
	data->_tokens_size_ = _vala_array_length (data->_tmp0_);
	data->_tmp2_ = NULL;
	data->_tmp2_ = unity_lens_impl_get_scope_for_uid (data->self, data->tokens[0]);
	data->scope = data->_tmp2_;
	memset (&data->raw, 0, sizeof (UnityPreviewReplyRaw));
	data->_tmp3_ = g_strdup ("preview-none");
	_g_free0 (data->raw.renderer_name);
	data->raw.renderer_name = data->_tmp3_;
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (data->raw.properties);
	data->raw.properties = data->_tmp4_;
	if (UNITY_IS_SCOPE_PROXY (data->scope)) {
		memset (&data->_tmp5_, 0, sizeof (UnityPreviewReplyRaw));
		data->_state_ = 1;
		unity_scope_proxy_preview (data->scope, data->tokens[1], unity_lens_impl_preview_ready, data);
		return FALSE;
		_state_1:
		unity_scope_proxy_preview_finish (data->scope, data->_res_, &data->_tmp5_);
		memset (&data->_tmp6_, 0, sizeof (UnityPreviewReplyRaw));
		data->_tmp6_ = data->_tmp5_;
		unity_preview_reply_raw_destroy (&data->raw);
		data->raw = data->_tmp6_;
	}
	data->_tmp7_ = g_strdup (data->uri);
	_g_free0 (data->raw.uri);
	data->raw.uri = data->_tmp7_;
	data->result = data->raw;
	_g_object_unref0 (data->scope);
	data->tokens = (_vala_array_free (data->tokens, data->tokens_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	unity_preview_reply_raw_destroy (&data->raw);
	_g_object_unref0 (data->scope);
	data->tokens = (_vala_array_free (data->tokens, data->tokens_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_update_filter_data_free (gpointer _data) {
	UnityLensImplUpdateFilterData* data;
	data = _data;
	_g_free0 (data->filter_name);
	_g_hash_table_unref0 (data->properties);
	_g_object_unref0 (data->self);
	g_slice_free (UnityLensImplUpdateFilterData, data);
}


static void unity_lens_impl_real_update_filter (UnityLensService* base, const gchar* filter_name, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplUpdateFilterData* _data_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplUpdateFilterData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_update_filter);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_update_filter_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->filter_name = g_strdup (filter_name);
	_data_->properties = _g_hash_table_ref0 (properties);
	unity_lens_impl_real_update_filter_co (_data_);
}


static void unity_lens_impl_real_update_filter_finish (UnityLensService* base, GAsyncResult* _res_, GError** error) {
	UnityLensImplUpdateFilterData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_lens_impl_real_update_filter_co (UnityLensImplUpdateFilterData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("unity-lens-private.vala:270: %s", data->filter_name);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_set_active_data_free (gpointer _data) {
	UnityLensImplSetActiveData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (UnityLensImplSetActiveData, data);
}


static void unity_lens_impl_real_set_active (UnityLensService* base, gboolean is_active, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplSetActiveData* _data_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplSetActiveData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_set_active);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_set_active_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->is_active = is_active;
	unity_lens_impl_real_set_active_co (_data_);
}


static void unity_lens_impl_real_set_active_finish (UnityLensService* base, GAsyncResult* _res_, GError** error) {
	UnityLensImplSetActiveData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_lens_impl_real_set_active_co (UnityLensImplSetActiveData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = _g_object_ref0 (data->self->priv->_scope_factory->scopes);
		data->_scope_list = data->_tmp0_;
		data->_tmp1_ = gee_collection_get_size ((GeeCollection*) data->_scope_list);
		data->_scope_size = data->_tmp1_;
		data->_scope_index = -1;
		while (TRUE) {
			data->_scope_index = data->_scope_index + 1;
			if (!(data->_scope_index < data->_scope_size)) {
				break;
			}
			data->_tmp2_ = NULL;
			data->_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) data->_scope_list, data->_scope_index);
			data->scope = (UnityScopeProxy*) data->_tmp2_;
			unity_scope_proxy_set_active (data->scope, data->is_active, NULL, NULL);
			_g_object_unref0 (data->scope);
		}
		_g_object_unref0 (data->_scope_list);
	}
	unity_lens_set_active_internal (data->self->priv->_owner, data->is_active);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static UnityScopeProxy* unity_lens_impl_get_scope_for_uid (UnityLensImpl* self, const gchar* uid) {
	UnityScopeProxy* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _scope_list;
		gint _tmp1_;
		gint _scope_size;
		gint _scope_index;
		_tmp0_ = _g_object_ref0 (self->priv->_scope_factory->scopes);
		_scope_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _scope_list);
		_scope_size = _tmp1_;
		_scope_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			UnityScopeProxy* scope;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gboolean _tmp5_;
			_scope_index = _scope_index + 1;
			if (!(_scope_index < _scope_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _scope_list, _scope_index);
			scope = (UnityScopeProxy*) _tmp2_;
			_tmp3_ = unity_lens_impl_uid_for_scope (self, scope);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strcmp0 (uid, _tmp4_) == 0;
			_g_free0 (_tmp4_);
			if (_tmp5_) {
				result = scope;
				_g_object_unref0 (_scope_list);
				return result;
			}
			_g_object_unref0 (scope);
		}
		_g_object_unref0 (_scope_list);
	}
	result = NULL;
	return result;
}


static gchar* unity_lens_impl_uid_for_scope (UnityLensImpl* self, UnityScopeProxy* scope) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (scope != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%p", scope);
	result = _tmp0_;
	return result;
}


static void unity_lens_impl_class_init (UnityLensImplClass * klass) {
	unity_lens_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLensImplPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_lens_impl_finalize;
}


static void unity_lens_impl_unity_lens_service_interface_init (UnityLensServiceIface * iface) {
	unity_lens_impl_unity_lens_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->info_request = (void (*)(UnityLensService* ,GError**)) unity_lens_impl_real_info_request;
	iface->info_request_finish = unity_lens_impl_real_info_request_finish;
	iface->activate = (UnityActivationReplyRaw (*)(UnityLensService* ,const gchar* ,guint ,UnityActivationReplyRaw* ,GError**)) unity_lens_impl_real_activate;
	iface->activate_finish = unity_lens_impl_real_activate_finish;
	iface->search = (void (*)(UnityLensService* ,const gchar* ,GHashTable* ,GError**)) unity_lens_impl_real_search;
	iface->search_finish = unity_lens_impl_real_search_finish;
	iface->global_search = (void (*)(UnityLensService* ,const gchar* ,GHashTable* ,GError**)) unity_lens_impl_real_global_search;
	iface->global_search_finish = unity_lens_impl_real_global_search_finish;
	iface->preview = (UnityPreviewReplyRaw (*)(UnityLensService* ,const gchar* ,UnityPreviewReplyRaw* ,GError**)) unity_lens_impl_real_preview;
	iface->preview_finish = unity_lens_impl_real_preview_finish;
	iface->update_filter = (void (*)(UnityLensService* ,const gchar* ,GHashTable* ,GError**)) unity_lens_impl_real_update_filter;
	iface->update_filter_finish = unity_lens_impl_real_update_filter_finish;
	iface->set_active = (void (*)(UnityLensService* ,gboolean ,GError**)) unity_lens_impl_real_set_active;
	iface->set_active_finish = unity_lens_impl_real_set_active_finish;
}


static void unity_lens_impl_instance_init (UnityLensImpl * self) {
	self->priv = UNITY_LENS_IMPL_GET_PRIVATE (self);
}


static void unity_lens_impl_finalize (GObject* obj) {
	UnityLensImpl * self;
	self = UNITY_LENS_IMPL (obj);
	_g_object_unref0 (self->priv->_results_model);
	_g_object_unref0 (self->priv->_global_results_model);
	_g_object_unref0 (self->priv->_categories_model);
	_g_object_unref0 (self->priv->_filters_model);
	_g_object_unref0 (self->priv->_scope_factory);
	_g_object_unref0 (self->priv->_results_sync);
	_g_object_unref0 (self->priv->_global_results_sync);
	_g_object_unref0 (self->priv->_filters_sync);
	G_OBJECT_CLASS (unity_lens_impl_parent_class)->finalize (obj);
}


GType unity_lens_impl_get_type (void) {
	static volatile gsize unity_lens_impl_type_id__volatile = 0;
	if (g_once_init_enter (&unity_lens_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLensImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_lens_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLensImpl), 0, (GInstanceInitFunc) unity_lens_impl_instance_init, NULL };
		static const GInterfaceInfo unity_lens_service_info = { (GInterfaceInitFunc) unity_lens_impl_unity_lens_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_lens_impl_type_id;
		unity_lens_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityLensImpl", &g_define_type_info, 0);
		g_type_add_interface_static (unity_lens_impl_type_id, UNITY_TYPE_LENS_SERVICE, &unity_lens_service_info);
		g_once_init_leave (&unity_lens_impl_type_id__volatile, unity_lens_impl_type_id);
	}
	return unity_lens_impl_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



