#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

#include "uwa-test-client.h"

static GMainLoop *mainloop = NULL;

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  unity_webapps_indicator_show_indicator (context, "Invalid file");
  unity_webapps_indicator_set_property_icon(context, "Invalid file",
					    "icon", "http://www.ubuntu.com/not-an-image.not-a-file-format");
  
  unity_webapps_indicator_show_indicator (context, "Invalid image");
  unity_webapps_indicator_set_property_icon (context, "Invalid image",
					     "icon", "http://www.google.com/index.html");

  unity_webapps_indicator_show_indicator (context, "Invalid URL");
  unity_webapps_indicator_set_property_icon (context, "Invalid URL",
					     "icon", "0jasf oaisfhaosi bacon");
  
					  
  
  uwa_emit_test_finished ();
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
