/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-runner.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 *
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */
#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"
#include "unity-webapps-runner-amazon.h"

static UnityWebappsService *service = NULL;

static gchar *name = NULL;
static gchar *domain = NULL;
static gchar *homepage = NULL;
static gboolean amazon = FALSE;
GMainLoop *loop = NULL;

static GOptionEntry option_entries[] =
	{
		{ "name", 'n',0,G_OPTION_ARG_STRING, &name, "Application name", NULL },
		{ "domain", 'd',0, G_OPTION_ARG_STRING, &domain, "Application domain", NULL},
		{ "amazon", 'a',0, G_OPTION_ARG_NONE, &amazon, "Launch amazon (with geoclue store selection)", NULL},
		{ "homepage", 'h',0, G_OPTION_ARG_STRING, &homepage, "Launch app by homepage", NULL}
	};

gboolean
has_context (const gchar *name, const gchar *domain)
{
	gboolean res = FALSE;
	gchar** it;
	gchar** contexts = unity_webapps_service_list_contexts (service);

	for (it = contexts; it && *it; it++)
		{
			UnityWebappsContext *context = unity_webapps_context_new_for_context_name (service, *it);

			res = res || ((g_strcmp0 (unity_webapps_context_get_name (context), name) == 0)
						  && (g_strcmp0 (unity_webapps_context_get_domain (context), domain) == 0));

			g_object_unref (context);
		}

	return res;
}


static void
on_context_appeared (UnityWebappsService *service, const gchar *context_name, gpointer user_data)
{
	UnityWebappsContext *context = unity_webapps_context_new_for_context_name (service, context_name);

	if ((g_strcmp0 (unity_webapps_context_get_name (context), name) == 0)
		&& (g_strcmp0 (unity_webapps_context_get_domain (context), domain) == 0))
		{
			g_usleep (G_USEC_PER_SEC * 2);
			g_main_loop_quit (loop);
		}

	g_object_unref (context);
}

gint
main (gint argc, gchar **argv)
{
	gint i;
	gsize len;
	GOptionContext *context;
	GError *error;
	gboolean has_files;
	gchar *files[argc];

	g_type_init ();

	service = unity_webapps_service_new ();

	error = NULL;

	context = g_option_context_new ("- Activate Unity WebApps");

	// TODO: GETTEXT
	g_option_context_add_main_entries (context, option_entries, NULL);

	if (!g_option_context_parse (context, &argc, &argv, &error))
		{
			printf("Failed to parse arguments: %s\n", error->message);
			exit(1);
		}
	
	if (homepage != NULL)
	  {
		unity_webapps_service_open_homepage_sync (service, homepage);
		exit(0);
	  }
	
	if (amazon == TRUE)
	  {
		gchar *country;
		const gchar *url;
		
		country = unity_webapps_runner_amazon_get_country ();

		url = unity_webapps_runner_amazon_get_homepage_for_country (country);
		if (NULL == url)
		  {
			g_error("Could not retrieve the url associated with the current country %s", country);
			return 1;
		  }
		g_free (country);

		unity_webapps_service_open_homepage_sync (service, url);
		
		return 0;
	  }

	g_base64_decode_inplace (name, &len);

	for (i = 1; i < argc; i++)
		files[i - 1] = argv[i];

	files[argc - 1] = NULL;

	has_files = files[0] != NULL;

	if (has_files && !has_context (name, domain))
		{
			loop = g_main_loop_new (NULL, FALSE);
			unity_webapps_service_on_context_appeared (service, on_context_appeared, NULL);

			unity_webapps_service_activate_application (service, name, domain, (const gchar * const*)files);

			g_main_loop_run (loop);

			unity_webapps_service_activate_application (service, name, domain, (const gchar * const*)files);
		}
	else
		{
			unity_webapps_service_activate_application (service, name, domain, (const gchar * const*)files);
		}
	
	exit (0);
}
