/**
 * ===========================================================
 * LibRepository : a free Java content repository access layer
 * ===========================================================
 *
 * Project Info:  http://reporting.pentaho.org/librepository/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * ContentIOException.java
 * ------------
 */

package org.pentaho.reporting.libraries.repository;

import org.pentaho.reporting.libraries.base.util.StackableException;

/**
 * A Exception that indicates repository related errors. 
 *
 * @author Thomas Morgner
 */
public class ContentIOException extends StackableException
{
  private static final long serialVersionUID = 2947843470210463760L;

  /**
   * Creates a ContentIOException with no message and no parent.
   */
  public ContentIOException()
  {
  }

  /**
   * Creates an ContentIOException.
   *
   * @param message the exception message.
   * @param ex      the parent exception.
   */
  public ContentIOException(final String message, final Exception ex)
  {
    super(message, ex);
  }

  /**
   * Creates an ContentIOException.
   *
   * @param message the exception message.
   */
  public ContentIOException(final String message)
  {
    super(message);
  }
}
