/* testmap.c generated by valac 0.12.0, the Vala compiler
 * generated from testmap.vala, do not modify */

/* testmap.vala
 *
 * Copyright (C) 2008  Jürg Billeter, Maciej Piechotka
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_MAP_TESTS (map_tests_get_type ())
#define MAP_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP_TESTS, MapTests))
#define MAP_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP_TESTS, MapTestsClass))
#define IS_MAP_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP_TESTS))
#define IS_MAP_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP_TESTS))
#define MAP_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP_TESTS, MapTestsClass))

typedef struct _MapTests MapTests;
typedef struct _MapTestsClass MapTestsClass;
typedef struct _MapTestsPrivate MapTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAP_TESTS_TYPE_TEST_ENTRY (map_tests_test_entry_get_type ())
#define MAP_TESTS_TEST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntry))
#define MAP_TESTS_TEST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntryClass))
#define MAP_TESTS_IS_TEST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAP_TESTS_TYPE_TEST_ENTRY))
#define MAP_TESTS_IS_TEST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAP_TESTS_TYPE_TEST_ENTRY))
#define MAP_TESTS_TEST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntryClass))

typedef struct _MapTestsTestEntry MapTestsTestEntry;
typedef struct _MapTestsTestEntryClass MapTestsTestEntryClass;
typedef struct _MapTestsTestEntryPrivate MapTestsTestEntryPrivate;
#define _k_destroy_func0(var) (((var == NULL) || (k_destroy_func == NULL)) ? NULL : (var = (k_destroy_func (var), NULL)))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _MapTests {
	GeeTestCase parent_instance;
	MapTestsPrivate * priv;
	GeeMap* test_map;
};

struct _MapTestsClass {
	GeeTestCaseClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);
struct _MapTestsTestEntry {
	GeeMapEntry parent_instance;
	MapTestsTestEntryPrivate * priv;
};

struct _MapTestsTestEntryClass {
	GeeMapEntryClass parent_class;
};

struct _MapTestsTestEntryPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	gpointer _key;
	gpointer _value;
};


static gpointer map_tests_parent_class = NULL;
static gpointer map_tests_test_entry_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType map_tests_get_type (void) G_GNUC_CONST;
enum  {
	MAP_TESTS_DUMMY_PROPERTY
};
MapTests* map_tests_construct (GType object_type, const gchar* name);
GeeTestCase* gee_test_case_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target);
void map_tests_test_type_correctness (MapTests* self);
static void _map_tests_test_type_correctness_gee_test_case_test_method (gpointer self);
void map_tests_test_has_key_size_is_empty (MapTests* self);
static void _map_tests_test_has_key_size_is_empty_gee_test_case_test_method (gpointer self);
void map_tests_test_keys (MapTests* self);
static void _map_tests_test_keys_gee_test_case_test_method (gpointer self);
void map_tests_test_values (MapTests* self);
static void _map_tests_test_values_gee_test_case_test_method (gpointer self);
void map_tests_test_entries (MapTests* self);
static void _map_tests_test_entries_gee_test_case_test_method (gpointer self);
void map_tests_test_set_all (MapTests* self);
static void _map_tests_test_set_all_gee_test_case_test_method (gpointer self);
void map_tests_test_unset_all (MapTests* self);
static void _map_tests_test_unset_all_gee_test_case_test_method (gpointer self);
void map_tests_test_has_all (MapTests* self);
static void _map_tests_test_has_all_gee_test_case_test_method (gpointer self);
void map_tests_test_gobject_properties (MapTests* self);
static void _map_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
MapTestsTestEntry* map_tests_test_entry_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, gconstpointer key, gconstpointer value);
MapTestsTestEntry* map_tests_test_entry_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, gconstpointer key, gconstpointer value);
GType map_tests_test_entry_get_type (void) G_GNUC_CONST;
void map_tests_test_clear (MapTests* self);
#define MAP_TESTS_TEST_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntryPrivate))
enum  {
	MAP_TESTS_TEST_ENTRY_DUMMY_PROPERTY,
	MAP_TESTS_TEST_ENTRY_K_TYPE,
	MAP_TESTS_TEST_ENTRY_K_DUP_FUNC,
	MAP_TESTS_TEST_ENTRY_K_DESTROY_FUNC,
	MAP_TESTS_TEST_ENTRY_V_TYPE,
	MAP_TESTS_TEST_ENTRY_V_DUP_FUNC,
	MAP_TESTS_TEST_ENTRY_V_DESTROY_FUNC,
	MAP_TESTS_TEST_ENTRY_KEY,
	MAP_TESTS_TEST_ENTRY_VALUE
};
static void map_tests_test_entry_finalize (GObject* obj);
static void _vala_map_tests_test_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_map_tests_test_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void map_tests_finalize (GObject* obj);


static void _map_tests_test_type_correctness_gee_test_case_test_method (gpointer self) {
	map_tests_test_type_correctness (self);
}


static void _map_tests_test_has_key_size_is_empty_gee_test_case_test_method (gpointer self) {
	map_tests_test_has_key_size_is_empty (self);
}


static void _map_tests_test_keys_gee_test_case_test_method (gpointer self) {
	map_tests_test_keys (self);
}


static void _map_tests_test_values_gee_test_case_test_method (gpointer self) {
	map_tests_test_values (self);
}


static void _map_tests_test_entries_gee_test_case_test_method (gpointer self) {
	map_tests_test_entries (self);
}


static void _map_tests_test_set_all_gee_test_case_test_method (gpointer self) {
	map_tests_test_set_all (self);
}


static void _map_tests_test_unset_all_gee_test_case_test_method (gpointer self) {
	map_tests_test_unset_all (self);
}


static void _map_tests_test_has_all_gee_test_case_test_method (gpointer self) {
	map_tests_test_has_all (self);
}


static void _map_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	map_tests_test_gobject_properties (self);
}


MapTests* map_tests_construct (GType object_type, const gchar* name) {
	MapTests * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (MapTests*) gee_test_case_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] type correctness", _map_tests_test_type_correctness_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] has_key, size and is_empty", _map_tests_test_has_key_size_is_empty_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] keys", _map_tests_test_keys_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] values", _map_tests_test_values_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] entries", _map_tests_test_entries_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] set all", _map_tests_test_set_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] unset all", _map_tests_test_unset_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] has all", _map_tests_test_has_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] GObject properties", _map_tests_test_gobject_properties_gee_test_case_test_method, self);
	return self;
}


void map_tests_test_type_correctness (MapTests* self) {
	GType _tmp0_;
	GType _tmp1_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_map != NULL);
	_tmp0_ = gee_map_get_key_type (self->test_map);
	g_assert (_tmp0_ == G_TYPE_STRING);
	_tmp1_ = gee_map_get_value_type (self->test_map);
	g_assert (_tmp1_ == G_TYPE_STRING);
}


void map_tests_test_has_key_size_is_empty (MapTests* self) {
	gchar* value = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gpointer _tmp8_ = NULL;
	gchar* _tmp9_;
	gboolean _tmp10_;
	gpointer _tmp11_ = NULL;
	gchar* _tmp12_;
	gboolean _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gint _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gboolean _tmp24_;
	gpointer _tmp25_ = NULL;
	gchar* _tmp26_;
	gboolean _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	gint _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gpointer _tmp33_ = NULL;
	gchar* _tmp34_;
	gboolean _tmp35_;
	gpointer _tmp36_ = NULL;
	gchar* _tmp37_;
	gboolean _tmp38_;
	gpointer _tmp39_ = NULL;
	gchar* _tmp40_;
	gint _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	gpointer _tmp44_ = NULL;
	gchar* _tmp45_;
	gboolean _tmp46_;
	gpointer _tmp47_ = NULL;
	gchar* _tmp48_;
	gboolean _tmp49_;
	gpointer _tmp50_ = NULL;
	gchar* _tmp51_;
	gint _tmp52_;
	gboolean _tmp53_;
	gboolean _tmp54_;
	gpointer _tmp55_ = NULL;
	gchar* _tmp56_;
	gboolean _tmp57_;
	gpointer _tmp58_ = NULL;
	gchar* _tmp59_;
	gboolean _tmp60_;
	gpointer _tmp61_ = NULL;
	gchar* _tmp62_;
	gint _tmp63_;
	gboolean _tmp64_;
	gboolean _tmp65_;
	gpointer _tmp66_ = NULL;
	gchar* _tmp67_;
	gboolean _tmp68_;
	gpointer _tmp69_ = NULL;
	gchar* _tmp70_;
	gboolean _tmp71_;
	gpointer _tmp72_ = NULL;
	gchar* _tmp73_;
	gint _tmp74_;
	gboolean _tmp75_;
	gpointer _tmp76_ = NULL;
	gboolean _tmp77_;
	gboolean _tmp78_;
	gpointer _tmp79_ = NULL;
	gchar* _tmp80_;
	gboolean _tmp81_;
	gpointer _tmp82_ = NULL;
	gchar* _tmp83_;
	gboolean _tmp84_;
	gpointer _tmp85_ = NULL;
	gchar* _tmp86_;
	gint _tmp87_;
	gboolean _tmp88_;
	gpointer _tmp89_ = NULL;
	gboolean _tmp90_;
	gboolean _tmp91_;
	gboolean _tmp92_;
	gboolean _tmp93_;
	gint _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp96_;
	gpointer _tmp97_ = NULL;
	gchar* _tmp98_;
	gboolean _tmp99_;
	gpointer _tmp100_ = NULL;
	gchar* _tmp101_;
	gboolean _tmp102_;
	gpointer _tmp103_ = NULL;
	gchar* _tmp104_;
	gint _tmp105_;
	gboolean _tmp106_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_map != NULL);
	_tmp0_ = gee_map_has_key (self->test_map, "one");
	g_assert (!_tmp0_);
	_tmp1_ = gee_map_has_key (self->test_map, "two");
	g_assert (!_tmp1_);
	_tmp2_ = gee_map_has_key (self->test_map, "three");
	g_assert (!_tmp2_);
	_tmp3_ = gee_map_get_size (self->test_map);
	g_assert (_tmp3_ == 0);
	_tmp4_ = gee_map_get_is_empty (self->test_map);
	g_assert (_tmp4_);
	gee_map_set (self->test_map, "one", "value_of_one");
	_tmp5_ = gee_map_has_key (self->test_map, "one");
	g_assert (_tmp5_);
	_tmp6_ = gee_map_has (self->test_map, "one", "value_of_one");
	g_assert (_tmp6_);
	_tmp7_ = gee_map_has (self->test_map, "one", "another_value_for_one");
	g_assert (!_tmp7_);
	_tmp8_ = gee_map_get (self->test_map, "one");
	_tmp9_ = (gchar*) _tmp8_;
	g_assert (g_strcmp0 (_tmp9_, "value_of_one") == 0);
	_g_free0 (_tmp9_);
	_tmp10_ = gee_map_has_key (self->test_map, "two");
	g_assert (!_tmp10_);
	_tmp11_ = gee_map_get (self->test_map, "two");
	_tmp12_ = (gchar*) _tmp11_;
	g_assert (_tmp12_ == NULL);
	_g_free0 (_tmp12_);
	_tmp13_ = gee_map_has_key (self->test_map, "three");
	g_assert (!_tmp13_);
	_tmp14_ = gee_map_get (self->test_map, "three");
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (_tmp15_ == NULL);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_map_get_size (self->test_map);
	g_assert (_tmp16_ == 1);
	_tmp17_ = gee_map_get_is_empty (self->test_map);
	g_assert (!_tmp17_);
	_tmp18_ = gee_map_unset (self->test_map, "one", NULL);
	g_assert (_tmp18_);
	_tmp19_ = gee_map_has_key (self->test_map, "one");
	g_assert (!_tmp19_);
	_tmp20_ = gee_map_has (self->test_map, "one", "value_of_one");
	g_assert (!_tmp20_);
	_tmp21_ = gee_map_has (self->test_map, "one", "another_value_for_one");
	g_assert (!_tmp21_);
	_tmp22_ = gee_map_get (self->test_map, "one");
	_tmp23_ = (gchar*) _tmp22_;
	g_assert (_tmp23_ == NULL);
	_g_free0 (_tmp23_);
	_tmp24_ = gee_map_has_key (self->test_map, "two");
	g_assert (!_tmp24_);
	_tmp25_ = gee_map_get (self->test_map, "two");
	_tmp26_ = (gchar*) _tmp25_;
	g_assert (_tmp26_ == NULL);
	_g_free0 (_tmp26_);
	_tmp27_ = gee_map_has_key (self->test_map, "three");
	g_assert (!_tmp27_);
	_tmp28_ = gee_map_get (self->test_map, "three");
	_tmp29_ = (gchar*) _tmp28_;
	g_assert (_tmp29_ == NULL);
	_g_free0 (_tmp29_);
	_tmp30_ = gee_map_get_size (self->test_map);
	g_assert (_tmp30_ == 0);
	_tmp31_ = gee_map_get_is_empty (self->test_map);
	g_assert (_tmp31_);
	gee_map_set (self->test_map, "one", "value_of_one");
	_tmp32_ = gee_map_has_key (self->test_map, "one");
	g_assert (_tmp32_);
	_tmp33_ = gee_map_get (self->test_map, "one");
	_tmp34_ = (gchar*) _tmp33_;
	g_assert (g_strcmp0 (_tmp34_, "value_of_one") == 0);
	_g_free0 (_tmp34_);
	_tmp35_ = gee_map_has_key (self->test_map, "two");
	g_assert (!_tmp35_);
	_tmp36_ = gee_map_get (self->test_map, "two");
	_tmp37_ = (gchar*) _tmp36_;
	g_assert (_tmp37_ == NULL);
	_g_free0 (_tmp37_);
	_tmp38_ = gee_map_has_key (self->test_map, "three");
	g_assert (!_tmp38_);
	_tmp39_ = gee_map_get (self->test_map, "three");
	_tmp40_ = (gchar*) _tmp39_;
	g_assert (_tmp40_ == NULL);
	_g_free0 (_tmp40_);
	_tmp41_ = gee_map_get_size (self->test_map);
	g_assert (_tmp41_ == 1);
	_tmp42_ = gee_map_get_is_empty (self->test_map);
	g_assert (!_tmp42_);
	gee_map_set (self->test_map, "two", "value_of_two");
	_tmp43_ = gee_map_has_key (self->test_map, "one");
	g_assert (_tmp43_);
	_tmp44_ = gee_map_get (self->test_map, "one");
	_tmp45_ = (gchar*) _tmp44_;
	g_assert (g_strcmp0 (_tmp45_, "value_of_one") == 0);
	_g_free0 (_tmp45_);
	_tmp46_ = gee_map_has_key (self->test_map, "two");
	g_assert (_tmp46_);
	_tmp47_ = gee_map_get (self->test_map, "two");
	_tmp48_ = (gchar*) _tmp47_;
	g_assert (g_strcmp0 (_tmp48_, "value_of_two") == 0);
	_g_free0 (_tmp48_);
	_tmp49_ = gee_map_has_key (self->test_map, "three");
	g_assert (!_tmp49_);
	_tmp50_ = gee_map_get (self->test_map, "three");
	_tmp51_ = (gchar*) _tmp50_;
	g_assert (_tmp51_ == NULL);
	_g_free0 (_tmp51_);
	_tmp52_ = gee_map_get_size (self->test_map);
	g_assert (_tmp52_ == 2);
	_tmp53_ = gee_map_get_is_empty (self->test_map);
	g_assert (!_tmp53_);
	gee_map_set (self->test_map, "three", "value_of_three");
	_tmp54_ = gee_map_has_key (self->test_map, "one");
	g_assert (_tmp54_);
	_tmp55_ = gee_map_get (self->test_map, "one");
	_tmp56_ = (gchar*) _tmp55_;
	g_assert (g_strcmp0 (_tmp56_, "value_of_one") == 0);
	_g_free0 (_tmp56_);
	_tmp57_ = gee_map_has_key (self->test_map, "two");
	g_assert (_tmp57_);
	_tmp58_ = gee_map_get (self->test_map, "two");
	_tmp59_ = (gchar*) _tmp58_;
	g_assert (g_strcmp0 (_tmp59_, "value_of_two") == 0);
	_g_free0 (_tmp59_);
	_tmp60_ = gee_map_has_key (self->test_map, "three");
	g_assert (_tmp60_);
	_tmp61_ = gee_map_get (self->test_map, "three");
	_tmp62_ = (gchar*) _tmp61_;
	g_assert (g_strcmp0 (_tmp62_, "value_of_three") == 0);
	_g_free0 (_tmp62_);
	_tmp63_ = gee_map_get_size (self->test_map);
	g_assert (_tmp63_ == 3);
	_tmp64_ = gee_map_get_is_empty (self->test_map);
	g_assert (!_tmp64_);
	gee_map_set (self->test_map, "two", "value_of_two_new");
	_tmp65_ = gee_map_has_key (self->test_map, "one");
	g_assert (_tmp65_);
	_tmp66_ = gee_map_get (self->test_map, "one");
	_tmp67_ = (gchar*) _tmp66_;
	g_assert (g_strcmp0 (_tmp67_, "value_of_one") == 0);
	_g_free0 (_tmp67_);
	_tmp68_ = gee_map_has_key (self->test_map, "two");
	g_assert (_tmp68_);
	_tmp69_ = gee_map_get (self->test_map, "two");
	_tmp70_ = (gchar*) _tmp69_;
	g_assert (g_strcmp0 (_tmp70_, "value_of_two_new") == 0);
	_g_free0 (_tmp70_);
	_tmp71_ = gee_map_has_key (self->test_map, "three");
	g_assert (_tmp71_);
	_tmp72_ = gee_map_get (self->test_map, "three");
	_tmp73_ = (gchar*) _tmp72_;
	g_assert (g_strcmp0 (_tmp73_, "value_of_three") == 0);
	_g_free0 (_tmp73_);
	_tmp74_ = gee_map_get_size (self->test_map);
	g_assert (_tmp74_ == 3);
	_tmp75_ = gee_map_get_is_empty (self->test_map);
	g_assert (!_tmp75_);
	_tmp77_ = gee_map_unset (self->test_map, "two", &_tmp76_);
	_g_free0 (value);
	value = _tmp76_;
	g_assert (_tmp77_);
	g_assert (g_strcmp0 (value, "value_of_two_new") == 0);
	_tmp78_ = gee_map_has_key (self->test_map, "one");
	g_assert (_tmp78_);
	_tmp79_ = gee_map_get (self->test_map, "one");
	_tmp80_ = (gchar*) _tmp79_;
	g_assert (g_strcmp0 (_tmp80_, "value_of_one") == 0);
	_g_free0 (_tmp80_);
	_tmp81_ = gee_map_has_key (self->test_map, "two");
	g_assert (!_tmp81_);
	_tmp82_ = gee_map_get (self->test_map, "two");
	_tmp83_ = (gchar*) _tmp82_;
	g_assert (_tmp83_ == NULL);
	_g_free0 (_tmp83_);
	_tmp84_ = gee_map_has_key (self->test_map, "three");
	g_assert (_tmp84_);
	_tmp85_ = gee_map_get (self->test_map, "three");
	_tmp86_ = (gchar*) _tmp85_;
	g_assert (g_strcmp0 (_tmp86_, "value_of_three") == 0);
	_g_free0 (_tmp86_);
	_tmp87_ = gee_map_get_size (self->test_map);
	g_assert (_tmp87_ == 2);
	_tmp88_ = gee_map_get_is_empty (self->test_map);
	g_assert (!_tmp88_);
	_tmp90_ = gee_map_unset (self->test_map, "two", &_tmp89_);
	_g_free0 (value);
	value = _tmp89_;
	g_assert (!_tmp90_);
	g_assert (value == NULL);
	_tmp91_ = gee_map_has_key (self->test_map, "one");
	g_assert (_tmp91_);
	_tmp92_ = gee_map_has_key (self->test_map, "two");
	g_assert (!_tmp92_);
	_tmp93_ = gee_map_has_key (self->test_map, "three");
	g_assert (_tmp93_);
	_tmp94_ = gee_map_get_size (self->test_map);
	g_assert (_tmp94_ == 2);
	_tmp95_ = gee_map_get_is_empty (self->test_map);
	g_assert (!_tmp95_);
	gee_map_clear (self->test_map);
	_tmp96_ = gee_map_has_key (self->test_map, "one");
	g_assert (!_tmp96_);
	_tmp97_ = gee_map_get (self->test_map, "one");
	_tmp98_ = (gchar*) _tmp97_;
	g_assert (_tmp98_ == NULL);
	_g_free0 (_tmp98_);
	_tmp99_ = gee_map_has_key (self->test_map, "two");
	g_assert (!_tmp99_);
	_tmp100_ = gee_map_get (self->test_map, "two");
	_tmp101_ = (gchar*) _tmp100_;
	g_assert (_tmp101_ == NULL);
	_g_free0 (_tmp101_);
	_tmp102_ = gee_map_has_key (self->test_map, "three");
	g_assert (!_tmp102_);
	_tmp103_ = gee_map_get (self->test_map, "three");
	_tmp104_ = (gchar*) _tmp103_;
	g_assert (_tmp104_ == NULL);
	_g_free0 (_tmp104_);
	_tmp105_ = gee_map_get_size (self->test_map);
	g_assert (_tmp105_ == 0);
	_tmp106_ = gee_map_get_is_empty (self->test_map);
	g_assert (_tmp106_);
	_g_free0 (value);
}


void map_tests_test_keys (MapTests* self) {
	GeeSet* _tmp0_ = NULL;
	GeeSet* keys;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	GeeSet* _tmp4_ = NULL;
	gint _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gint _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GeeSet* _tmp12_ = NULL;
	gint _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
	GeeSet* _tmp17_ = NULL;
	gint _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_map_get_keys (self->test_map);
	keys = _tmp0_;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) keys);
	g_assert (_tmp1_ == 0);
	gee_map_set (self->test_map, "one", "value_of_one");
	_tmp2_ = gee_collection_get_size ((GeeCollection*) keys);
	g_assert (_tmp2_ == 1);
	_tmp3_ = gee_collection_contains ((GeeCollection*) keys, "one");
	g_assert (_tmp3_);
	_tmp4_ = gee_map_get_keys (self->test_map);
	_g_object_unref0 (keys);
	keys = _tmp4_;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) keys);
	g_assert (_tmp5_ == 1);
	_tmp6_ = gee_collection_contains ((GeeCollection*) keys, "one");
	g_assert (_tmp6_);
	_tmp7_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp7_) {
		gboolean _tmp8_;
		_tmp8_ = gee_collection_add ((GeeCollection*) keys, "three");
		g_assert (!_tmp8_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr ("*code should not be reached*");
	gee_map_set (self->test_map, "two", "value_of_two");
	_tmp9_ = gee_collection_get_size ((GeeCollection*) keys);
	g_assert (_tmp9_ == 2);
	_tmp10_ = gee_collection_contains ((GeeCollection*) keys, "one");
	g_assert (_tmp10_);
	_tmp11_ = gee_collection_contains ((GeeCollection*) keys, "two");
	g_assert (_tmp11_);
	_tmp12_ = gee_map_get_keys (self->test_map);
	_g_object_unref0 (keys);
	keys = _tmp12_;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) keys);
	g_assert (_tmp13_ == 2);
	_tmp14_ = gee_collection_contains ((GeeCollection*) keys, "one");
	g_assert (_tmp14_);
	_tmp15_ = gee_collection_contains ((GeeCollection*) keys, "two");
	g_assert (_tmp15_);
	gee_map_clear (self->test_map);
	_tmp16_ = gee_collection_get_size ((GeeCollection*) keys);
	g_assert (_tmp16_ == 0);
	_tmp17_ = gee_map_get_keys (self->test_map);
	_g_object_unref0 (keys);
	keys = _tmp17_;
	_tmp18_ = gee_collection_get_size ((GeeCollection*) keys);
	g_assert (_tmp18_ == 0);
	_g_object_unref0 (keys);
}


void map_tests_test_values (MapTests* self) {
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* values;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	GeeCollection* _tmp4_ = NULL;
	gint _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gint _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GeeCollection* _tmp12_ = NULL;
	gint _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
	GeeCollection* _tmp17_ = NULL;
	gint _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_map_get_values (self->test_map);
	values = _tmp0_;
	_tmp1_ = gee_collection_get_size (values);
	g_assert (_tmp1_ == 0);
	gee_map_set (self->test_map, "one", "value_of_one");
	_tmp2_ = gee_collection_get_size (values);
	g_assert (_tmp2_ == 1);
	_tmp3_ = gee_collection_contains (values, "value_of_one");
	g_assert (_tmp3_);
	_tmp4_ = gee_map_get_values (self->test_map);
	_g_object_unref0 (values);
	values = _tmp4_;
	_tmp5_ = gee_collection_get_size (values);
	g_assert (_tmp5_ == 1);
	_tmp6_ = gee_collection_contains (values, "value_of_one");
	g_assert (_tmp6_);
	_tmp7_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp7_) {
		gboolean _tmp8_;
		_tmp8_ = gee_collection_add (values, "two");
		g_assert (!_tmp8_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr ("*code should not be reached*");
	gee_map_set (self->test_map, "two", "value_of_two");
	_tmp9_ = gee_collection_get_size (values);
	g_assert (_tmp9_ == 2);
	_tmp10_ = gee_collection_contains (values, "value_of_one");
	g_assert (_tmp10_);
	_tmp11_ = gee_collection_contains (values, "value_of_two");
	g_assert (_tmp11_);
	_tmp12_ = gee_map_get_values (self->test_map);
	_g_object_unref0 (values);
	values = _tmp12_;
	_tmp13_ = gee_collection_get_size (values);
	g_assert (_tmp13_ == 2);
	_tmp14_ = gee_collection_contains (values, "value_of_one");
	g_assert (_tmp14_);
	_tmp15_ = gee_collection_contains (values, "value_of_two");
	g_assert (_tmp15_);
	gee_map_clear (self->test_map);
	_tmp16_ = gee_collection_get_size (values);
	g_assert (_tmp16_ == 0);
	_tmp17_ = gee_map_get_values (self->test_map);
	_g_object_unref0 (values);
	values = _tmp17_;
	_tmp18_ = gee_collection_get_size (values);
	g_assert (_tmp18_ == 0);
	_g_object_unref0 (values);
}


void map_tests_test_entries (MapTests* self) {
	GeeSet* _tmp0_ = NULL;
	GeeSet* entries;
	gint _tmp1_;
	gint _tmp2_;
	MapTestsTestEntry* _tmp3_ = NULL;
	MapTestsTestEntry* _tmp4_;
	gboolean _tmp5_;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_;
	MapTestsTestEntry* _tmp8_ = NULL;
	MapTestsTestEntry* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gint _tmp15_;
	MapTestsTestEntry* _tmp16_ = NULL;
	MapTestsTestEntry* _tmp17_;
	gboolean _tmp18_;
	MapTestsTestEntry* _tmp19_ = NULL;
	MapTestsTestEntry* _tmp20_;
	gboolean _tmp21_;
	GeeSet* _tmp22_ = NULL;
	gint _tmp23_;
	MapTestsTestEntry* _tmp24_ = NULL;
	MapTestsTestEntry* _tmp25_;
	gboolean _tmp26_;
	MapTestsTestEntry* _tmp27_ = NULL;
	MapTestsTestEntry* _tmp28_;
	gboolean _tmp29_;
	gint _tmp30_;
	GeeSet* _tmp31_ = NULL;
	gint _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_map_get_entries (self->test_map);
	entries = _tmp0_;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) entries);
	g_assert (_tmp1_ == 0);
	gee_map_set (self->test_map, "one", "value_of_one");
	_tmp2_ = gee_collection_get_size ((GeeCollection*) entries);
	g_assert (_tmp2_ == 1);
	_tmp3_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "one", "value_of_one");
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) _tmp4_);
	g_assert (_tmp5_);
	_g_object_unref0 (_tmp4_);
	_tmp6_ = gee_map_get_entries (self->test_map);
	_g_object_unref0 (entries);
	entries = _tmp6_;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) entries);
	g_assert (_tmp7_ == 1);
	_tmp8_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "one", "value_of_one");
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) _tmp9_);
	g_assert (_tmp10_);
	_g_object_unref0 (_tmp9_);
	_tmp11_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp11_) {
		MapTestsTestEntry* _tmp12_ = NULL;
		MapTestsTestEntry* _tmp13_;
		gboolean _tmp14_;
		_tmp12_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "two", "value_of_two");
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_collection_add ((GeeCollection*) entries, (GeeMapEntry*) _tmp13_);
		g_assert (!_tmp14_);
		_g_object_unref0 (_tmp13_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr ("*code should not be reached*");
	gee_map_set (self->test_map, "two", "value_of_two");
	_tmp15_ = gee_collection_get_size ((GeeCollection*) entries);
	g_assert (_tmp15_ == 2);
	_tmp16_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "one", "value_of_one");
	_tmp17_ = _tmp16_;
	_tmp18_ = gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) _tmp17_);
	g_assert (_tmp18_);
	_g_object_unref0 (_tmp17_);
	_tmp19_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "two", "value_of_two");
	_tmp20_ = _tmp19_;
	_tmp21_ = gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) _tmp20_);
	g_assert (_tmp21_);
	_g_object_unref0 (_tmp20_);
	_tmp22_ = gee_map_get_entries (self->test_map);
	_g_object_unref0 (entries);
	entries = _tmp22_;
	_tmp23_ = gee_collection_get_size ((GeeCollection*) entries);
	g_assert (_tmp23_ == 2);
	_tmp24_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "one", "value_of_one");
	_tmp25_ = _tmp24_;
	_tmp26_ = gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) _tmp25_);
	g_assert (_tmp26_);
	_g_object_unref0 (_tmp25_);
	_tmp27_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "two", "value_of_two");
	_tmp28_ = _tmp27_;
	_tmp29_ = gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) _tmp28_);
	g_assert (_tmp29_);
	_g_object_unref0 (_tmp28_);
	gee_map_clear (self->test_map);
	_tmp30_ = gee_collection_get_size ((GeeCollection*) entries);
	g_assert (_tmp30_ == 0);
	_tmp31_ = gee_map_get_entries (self->test_map);
	_g_object_unref0 (entries);
	entries = _tmp31_;
	_tmp32_ = gee_collection_get_size ((GeeCollection*) entries);
	g_assert (_tmp32_ == 0);
	_g_object_unref0 (entries);
}


void map_tests_test_clear (MapTests* self) {
	gint _tmp0_;
	GeeSet* _tmp1_ = NULL;
	GeeSet* keys;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* ikeys;
	gboolean _tmp3_;
	GeeCollection* _tmp4_ = NULL;
	GeeCollection* vals;
	GeeIterator* _tmp5_ = NULL;
	GeeIterator* ivals;
	gboolean _tmp6_;
	GeeSet* _tmp7_ = NULL;
	GeeSet* ents;
	GeeIterator* _tmp8_ = NULL;
	GeeIterator* ients;
	gboolean _tmp9_;
	GeeMapIterator* _tmp10_ = NULL;
	GeeMapIterator* iter;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_map_set (self->test_map, "three", "value_of_three");
	gee_map_clear (self->test_map);
	_tmp0_ = gee_map_get_size (self->test_map);
	g_assert (_tmp0_ == 0);
	_tmp1_ = gee_map_get_keys (self->test_map);
	keys = _tmp1_;
	g_assert (keys != NULL);
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) keys);
	ikeys = _tmp2_;
	g_assert (ikeys != NULL);
	_tmp3_ = gee_iterator_has_next (ikeys);
	g_assert (!_tmp3_);
	_tmp4_ = gee_map_get_values (self->test_map);
	vals = _tmp4_;
	g_assert (vals != NULL);
	_tmp5_ = gee_iterable_iterator ((GeeIterable*) vals);
	ivals = _tmp5_;
	g_assert (ivals != NULL);
	_tmp6_ = gee_iterator_has_next (ivals);
	g_assert (!_tmp6_);
	_tmp7_ = gee_map_get_entries (self->test_map);
	ents = _tmp7_;
	g_assert (ents != NULL);
	_tmp8_ = gee_iterable_iterator ((GeeIterable*) ents);
	ients = _tmp8_;
	g_assert (ients != NULL);
	_tmp9_ = gee_iterator_has_next (ients);
	g_assert (!_tmp9_);
	_tmp10_ = gee_map_map_iterator (self->test_map);
	iter = _tmp10_;
	g_assert (iter != NULL);
	_tmp11_ = gee_map_iterator_has_next (iter);
	g_assert (!_tmp11_);
	_g_object_unref0 (iter);
	_g_object_unref0 (ients);
	_g_object_unref0 (ents);
	_g_object_unref0 (ivals);
	_g_object_unref0 (vals);
	_g_object_unref0 (ikeys);
	_g_object_unref0 (keys);
}


void map_tests_test_set_all (MapTests* self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* another_map;
	gint _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gpointer _tmp8_ = NULL;
	gchar* _tmp9_;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	another_map = _tmp0_;
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_map_set (self->test_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "five", "value_of_five");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "six", "value_of_six");
	gee_map_set_all (self->test_map, (GeeMap*) another_map);
	_tmp1_ = gee_map_get_size (self->test_map);
	g_assert (_tmp1_ == 6);
	_tmp2_ = gee_map_has_key (self->test_map, "one");
	g_assert (_tmp2_);
	_tmp3_ = gee_map_has_key (self->test_map, "two");
	g_assert (_tmp3_);
	_tmp4_ = gee_map_has_key (self->test_map, "three");
	g_assert (_tmp4_);
	_tmp5_ = gee_map_has_key (self->test_map, "four");
	g_assert (_tmp5_);
	_tmp6_ = gee_map_has_key (self->test_map, "five");
	g_assert (_tmp6_);
	_tmp7_ = gee_map_has_key (self->test_map, "six");
	g_assert (_tmp7_);
	_tmp8_ = gee_map_get (self->test_map, "one");
	_tmp9_ = (gchar*) _tmp8_;
	g_assert (g_strcmp0 (_tmp9_, "value_of_one") == 0);
	_g_free0 (_tmp9_);
	_tmp10_ = gee_map_get (self->test_map, "two");
	_tmp11_ = (gchar*) _tmp10_;
	g_assert (g_strcmp0 (_tmp11_, "value_of_two") == 0);
	_g_free0 (_tmp11_);
	_tmp12_ = gee_map_get (self->test_map, "three");
	_tmp13_ = (gchar*) _tmp12_;
	g_assert (g_strcmp0 (_tmp13_, "value_of_three") == 0);
	_g_free0 (_tmp13_);
	_tmp14_ = gee_map_get (self->test_map, "four");
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (g_strcmp0 (_tmp15_, "value_of_four") == 0);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_map_get (self->test_map, "five");
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "value_of_five") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_map_get (self->test_map, "six");
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "value_of_six") == 0);
	_g_free0 (_tmp19_);
	_g_object_unref0 (another_map);
}


void map_tests_test_unset_all (MapTests* self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* another_map;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gint _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gboolean _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	another_map = _tmp0_;
	_tmp1_ = gee_map_get_is_empty (self->test_map);
	g_assert (_tmp1_);
	_tmp2_ = gee_abstract_map_get_is_empty ((GeeAbstractMap*) another_map);
	g_assert (_tmp2_);
	_tmp3_ = gee_map_unset_all (self->test_map, (GeeMap*) another_map);
	g_assert (!_tmp3_);
	_tmp4_ = gee_map_get_is_empty (self->test_map);
	g_assert (_tmp4_);
	_tmp5_ = gee_abstract_map_get_is_empty ((GeeAbstractMap*) another_map);
	g_assert (_tmp5_);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	_tmp6_ = gee_map_get_is_empty (self->test_map);
	g_assert (_tmp6_);
	_tmp7_ = gee_map_get_size ((GeeMap*) another_map);
	g_assert (_tmp7_ == 2);
	_tmp8_ = gee_map_unset_all (self->test_map, (GeeMap*) another_map);
	g_assert (!_tmp8_);
	_tmp9_ = gee_map_get_is_empty (self->test_map);
	g_assert (_tmp9_);
	_tmp10_ = gee_map_get_size ((GeeMap*) another_map);
	g_assert (_tmp10_ == 2);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	_tmp11_ = gee_map_get_size (self->test_map);
	g_assert (_tmp11_ == 2);
	_tmp12_ = gee_abstract_map_get_is_empty ((GeeAbstractMap*) another_map);
	g_assert (_tmp12_);
	_tmp13_ = gee_map_unset_all (self->test_map, (GeeMap*) another_map);
	g_assert (!_tmp13_);
	_tmp14_ = gee_map_get_size (self->test_map);
	g_assert (_tmp14_ == 2);
	_tmp15_ = gee_abstract_map_get_is_empty ((GeeAbstractMap*) another_map);
	g_assert (_tmp15_);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	_tmp16_ = gee_map_get_size (self->test_map);
	g_assert (_tmp16_ == 2);
	_tmp17_ = gee_map_get_size ((GeeMap*) another_map);
	g_assert (_tmp17_ == 2);
	_tmp18_ = gee_map_unset_all (self->test_map, (GeeMap*) another_map);
	g_assert (_tmp18_);
	_tmp19_ = gee_map_get_is_empty (self->test_map);
	g_assert (_tmp19_);
	_tmp20_ = gee_map_get_size ((GeeMap*) another_map);
	g_assert (_tmp20_ == 2);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_map_set (self->test_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "five", "value_of_five");
	_tmp21_ = gee_map_get_size (self->test_map);
	g_assert (_tmp21_ == 3);
	_tmp22_ = gee_map_get_size ((GeeMap*) another_map);
	g_assert (_tmp22_ == 4);
	_tmp23_ = gee_map_unset_all (self->test_map, (GeeMap*) another_map);
	g_assert (_tmp23_);
	_tmp24_ = gee_map_get_size (self->test_map);
	g_assert (_tmp24_ == 1);
	_tmp25_ = gee_map_get_size ((GeeMap*) another_map);
	g_assert (_tmp25_ == 4);
	_tmp26_ = gee_map_has_key (self->test_map, "one");
	g_assert (_tmp26_);
	_g_object_unref0 (another_map);
}


void map_tests_test_has_all (MapTests* self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* another_map;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	another_map = _tmp0_;
	_tmp1_ = gee_map_has_all (self->test_map, (GeeMap*) another_map);
	g_assert (_tmp1_);
	gee_map_set (self->test_map, "one", "value_of_one");
	_tmp2_ = gee_map_has_all (self->test_map, (GeeMap*) another_map);
	g_assert (_tmp2_);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	_tmp3_ = gee_map_has_all (self->test_map, (GeeMap*) another_map);
	g_assert (!_tmp3_);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	_tmp4_ = gee_map_has_all (self->test_map, (GeeMap*) another_map);
	g_assert (_tmp4_);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "another_value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "another_value_of_two");
	_tmp5_ = gee_map_has_all (self->test_map, (GeeMap*) another_map);
	g_assert (!_tmp5_);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	_tmp6_ = gee_map_has_all (self->test_map, (GeeMap*) another_map);
	g_assert (!_tmp6_);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_map_set (self->test_map, "three", "value_of_three");
	gee_map_set (self->test_map, "four", "value_of_four");
	gee_map_set (self->test_map, "five", "value_of_five");
	gee_map_set (self->test_map, "six", "value_of_six");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	_tmp7_ = gee_map_has_all (self->test_map, (GeeMap*) another_map);
	g_assert (_tmp7_);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_map_set (self->test_map, "three", "value_of_three");
	gee_map_set (self->test_map, "four", "value_of_four");
	gee_map_set (self->test_map, "five", "value_of_five");
	gee_map_set (self->test_map, "six", "value_of_six");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "height", "value_of_height");
	_tmp8_ = gee_map_has_all (self->test_map, (GeeMap*) another_map);
	g_assert (!_tmp8_);
	_g_object_unref0 (another_map);
}


void map_tests_test_gobject_properties (MapTests* self) {
	GValue value = {0};
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean _tmp3_;
	GValue _tmp4_ = {0};
	GValue _tmp5_ = {0};
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_map != NULL);
	g_value_init (&_tmp0_, G_TYPE_BOOLEAN);
	_tmp1_ = _tmp0_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp1_;
	g_object_get_property ((GObject*) self->test_map, "is-empty", &value);
	_tmp2_ = g_value_get_boolean (&value);
	_tmp3_ = gee_map_get_is_empty (self->test_map);
	g_assert (_tmp2_ == _tmp3_);
	g_value_unset (&value);
	g_value_init (&_tmp4_, G_TYPE_INT);
	_tmp5_ = _tmp4_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp5_;
	g_object_get_property ((GObject*) self->test_map, "size", &value);
	_tmp6_ = g_value_get_int (&value);
	_tmp7_ = gee_map_get_size (self->test_map);
	g_assert (_tmp6_ == _tmp7_);
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}


MapTestsTestEntry* map_tests_test_entry_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, gconstpointer key, gconstpointer value) {
	MapTestsTestEntry * self = NULL;
	gpointer _tmp0_;
	gconstpointer _tmp1_;
	self = (MapTestsTestEntry*) gee_map_entry_construct (object_type, k_type, (GBoxedCopyFunc) k_dup_func, k_destroy_func, v_type, (GBoxedCopyFunc) v_dup_func, v_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	_tmp0_ = (_tmp1_ = key, ((_tmp1_ == NULL) || (k_dup_func == NULL)) ? ((gpointer) _tmp1_) : k_dup_func ((gpointer) _tmp1_));
	_k_destroy_func0 (self->priv->_key);
	self->priv->_key = _tmp0_;
	gee_map_entry_set_value ((GeeMapEntry*) self, value);
	return self;
}


MapTestsTestEntry* map_tests_test_entry_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, gconstpointer key, gconstpointer value) {
	return map_tests_test_entry_construct (MAP_TESTS_TYPE_TEST_ENTRY, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, key, value);
}


static gconstpointer map_tests_test_entry_real_get_key (GeeMapEntry* base) {
	gconstpointer result;
	MapTestsTestEntry* self;
	self = (MapTestsTestEntry*) base;
	result = self->priv->_key;
	return result;
}


static gconstpointer map_tests_test_entry_real_get_value (GeeMapEntry* base) {
	gconstpointer result;
	MapTestsTestEntry* self;
	self = (MapTestsTestEntry*) base;
	result = self->priv->_value;
	return result;
}


static void map_tests_test_entry_real_set_value (GeeMapEntry* base, gconstpointer value) {
	MapTestsTestEntry* self;
	gpointer _tmp0_;
	gconstpointer _tmp1_;
	self = (MapTestsTestEntry*) base;
	_tmp0_ = (_tmp1_ = value, ((_tmp1_ == NULL) || (self->priv->v_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->v_dup_func ((gpointer) _tmp1_));
	((self->priv->_value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->v_destroy_func (self->priv->_value), NULL));
	self->priv->_value = _tmp0_;
	g_object_notify ((GObject *) self, "value");
}


static void map_tests_test_entry_class_init (MapTestsTestEntryClass * klass) {
	map_tests_test_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MapTestsTestEntryPrivate));
	GEE_MAP_ENTRY_CLASS (klass)->get_key = map_tests_test_entry_real_get_key;
	GEE_MAP_ENTRY_CLASS (klass)->get_value = map_tests_test_entry_real_get_value;
	GEE_MAP_ENTRY_CLASS (klass)->set_value = map_tests_test_entry_real_set_value;
	G_OBJECT_CLASS (klass)->get_property = _vala_map_tests_test_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_map_tests_test_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = map_tests_test_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_K_TYPE, g_param_spec_gtype ("k-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_K_DUP_FUNC, g_param_spec_pointer ("k-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_K_DESTROY_FUNC, g_param_spec_pointer ("k-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_V_TYPE, g_param_spec_gtype ("v-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_V_DUP_FUNC, g_param_spec_pointer ("v-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_V_DESTROY_FUNC, g_param_spec_pointer ("v-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_KEY, "key");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_VALUE, "value");
}


static void map_tests_test_entry_instance_init (MapTestsTestEntry * self) {
	self->priv = MAP_TESTS_TEST_ENTRY_GET_PRIVATE (self);
}


static void map_tests_test_entry_finalize (GObject* obj) {
	MapTestsTestEntry * self;
	self = MAP_TESTS_TEST_ENTRY (obj);
	((self->priv->_key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (self->priv->_key = (self->priv->k_destroy_func (self->priv->_key), NULL));
	((self->priv->_value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->v_destroy_func (self->priv->_value), NULL));
	G_OBJECT_CLASS (map_tests_test_entry_parent_class)->finalize (obj);
}


GType map_tests_test_entry_get_type (void) {
	static volatile gsize map_tests_test_entry_type_id__volatile = 0;
	if (g_once_init_enter (&map_tests_test_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MapTestsTestEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) map_tests_test_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MapTestsTestEntry), 0, (GInstanceInitFunc) map_tests_test_entry_instance_init, NULL };
		GType map_tests_test_entry_type_id;
		map_tests_test_entry_type_id = g_type_register_static (GEE_MAP_TYPE_ENTRY, "MapTestsTestEntry", &g_define_type_info, 0);
		g_once_init_leave (&map_tests_test_entry_type_id__volatile, map_tests_test_entry_type_id);
	}
	return map_tests_test_entry_type_id__volatile;
}


static void _vala_map_tests_test_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MapTestsTestEntry * self;
	self = MAP_TESTS_TEST_ENTRY (object);
	switch (property_id) {
		case MAP_TESTS_TEST_ENTRY_KEY:
		g_value_set_pointer (value, gee_map_entry_get_key ((GeeMapEntry*) self));
		break;
		case MAP_TESTS_TEST_ENTRY_VALUE:
		g_value_set_pointer (value, gee_map_entry_get_value ((GeeMapEntry*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_map_tests_test_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MapTestsTestEntry * self;
	self = MAP_TESTS_TEST_ENTRY (object);
	switch (property_id) {
		case MAP_TESTS_TEST_ENTRY_VALUE:
		gee_map_entry_set_value ((GeeMapEntry*) self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case MAP_TESTS_TEST_ENTRY_K_TYPE:
		self->priv->k_type = g_value_get_gtype (value);
		break;
		case MAP_TESTS_TEST_ENTRY_K_DUP_FUNC:
		self->priv->k_dup_func = g_value_get_pointer (value);
		break;
		case MAP_TESTS_TEST_ENTRY_K_DESTROY_FUNC:
		self->priv->k_destroy_func = g_value_get_pointer (value);
		break;
		case MAP_TESTS_TEST_ENTRY_V_TYPE:
		self->priv->v_type = g_value_get_gtype (value);
		break;
		case MAP_TESTS_TEST_ENTRY_V_DUP_FUNC:
		self->priv->v_dup_func = g_value_get_pointer (value);
		break;
		case MAP_TESTS_TEST_ENTRY_V_DESTROY_FUNC:
		self->priv->v_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void map_tests_class_init (MapTestsClass * klass) {
	map_tests_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = map_tests_finalize;
}


static void map_tests_instance_init (MapTests * self) {
}


static void map_tests_finalize (GObject* obj) {
	MapTests * self;
	self = MAP_TESTS (obj);
	_g_object_unref0 (self->test_map);
	G_OBJECT_CLASS (map_tests_parent_class)->finalize (obj);
}


GType map_tests_get_type (void) {
	static volatile gsize map_tests_type_id__volatile = 0;
	if (g_once_init_enter (&map_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MapTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) map_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MapTests), 0, (GInstanceInitFunc) map_tests_instance_init, NULL };
		GType map_tests_type_id;
		map_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "MapTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&map_tests_type_id__volatile, map_tests_type_id);
	}
	return map_tests_type_id__volatile;
}



