/* testarraylist.c generated by valac 0.12.0, the Vala compiler
 * generated from testarraylist.vala, do not modify */

/* testarraylist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_LIST_TESTS (list_tests_get_type ())
#define LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_TESTS, ListTests))
#define LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_TESTS, ListTestsClass))
#define IS_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_TESTS))
#define IS_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_TESTS))
#define LIST_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_TESTS, ListTestsClass))

typedef struct _ListTests ListTests;
typedef struct _ListTestsClass ListTestsClass;
typedef struct _ListTestsPrivate ListTestsPrivate;

#define TYPE_ARRAY_LIST_TESTS (array_list_tests_get_type ())
#define ARRAY_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ARRAY_LIST_TESTS, ArrayListTests))
#define ARRAY_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ARRAY_LIST_TESTS, ArrayListTestsClass))
#define IS_ARRAY_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ARRAY_LIST_TESTS))
#define IS_ARRAY_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ARRAY_LIST_TESTS))
#define ARRAY_LIST_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ARRAY_LIST_TESTS, ArrayListTestsClass))

typedef struct _ArrayListTests ArrayListTests;
typedef struct _ArrayListTestsClass ArrayListTestsClass;
typedef struct _ArrayListTestsPrivate ArrayListTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _ListTests {
	CollectionTests parent_instance;
	ListTestsPrivate * priv;
};

struct _ListTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_retained) (ListTests* self);
};

struct _ArrayListTests {
	ListTests parent_instance;
	ArrayListTestsPrivate * priv;
};

struct _ArrayListTestsClass {
	ListTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer array_list_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType list_tests_get_type (void) G_GNUC_CONST;
GType array_list_tests_get_type (void) G_GNUC_CONST;
enum  {
	ARRAY_LIST_TESTS_DUMMY_PROPERTY
};
#define ARRAY_LIST_TESTS_BIG_SORT_SIZE 1000000
ArrayListTests* array_list_tests_new (void);
ArrayListTests* array_list_tests_construct (GType object_type);
ListTests* list_tests_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target);
void array_list_tests_test_selected_functions (ArrayListTests* self);
static void _array_list_tests_test_selected_functions_gee_test_case_test_method (gpointer self);
void array_list_tests_test_gobject_properties (ArrayListTests* self);
static void _array_list_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
static void array_list_tests_test_small_sort (ArrayListTests* self);
static void _array_list_tests_test_small_sort_gee_test_case_test_method (gpointer self);
static void array_list_tests_test_big_sort (ArrayListTests* self);
static void _array_list_tests_test_big_sort_gee_test_case_test_method (gpointer self);
static void array_list_tests_test_typed_to_array (ArrayListTests* self);
static void _array_list_tests_test_typed_to_array_gee_test_case_test_method (gpointer self);
static void array_list_tests_real_set_up (GeeTestCase* base);
static void array_list_tests_real_tear_down (GeeTestCase* base);
static gdouble* _double_dup (gdouble* self);


static void _array_list_tests_test_selected_functions_gee_test_case_test_method (gpointer self) {
	array_list_tests_test_selected_functions (self);
}


static void _array_list_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	array_list_tests_test_gobject_properties (self);
}


static void _array_list_tests_test_small_sort_gee_test_case_test_method (gpointer self) {
	array_list_tests_test_small_sort (self);
}


static void _array_list_tests_test_big_sort_gee_test_case_test_method (gpointer self) {
	array_list_tests_test_big_sort (self);
}


static void _array_list_tests_test_typed_to_array_gee_test_case_test_method (gpointer self) {
	array_list_tests_test_typed_to_array (self);
}


ArrayListTests* array_list_tests_construct (GType object_type) {
	ArrayListTests * self = NULL;
	self = (ArrayListTests*) list_tests_construct (object_type, "ArrayList");
	gee_test_case_add_test ((GeeTestCase*) self, "[ArrayList] selected functions", _array_list_tests_test_selected_functions_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ArrayList] GObject properties", _array_list_tests_test_gobject_properties_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ArrayList] small sort (insertion)", _array_list_tests_test_small_sort_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ArrayList] big sort (timsort)", _array_list_tests_test_big_sort_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ArrayList] typed to_array calls", _array_list_tests_test_typed_to_array_gee_test_case_test_method, self);
	return self;
}


ArrayListTests* array_list_tests_new (void) {
	return array_list_tests_construct (TYPE_ARRAY_LIST_TESTS);
}


static void array_list_tests_real_set_up (GeeTestCase* base) {
	ArrayListTests * self;
	GeeArrayList* _tmp0_ = NULL;
	self = (ArrayListTests*) base;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (((CollectionTests*) self)->test_collection);
	((CollectionTests*) self)->test_collection = (GeeCollection*) _tmp0_;
}


static void array_list_tests_real_tear_down (GeeTestCase* base) {
	ArrayListTests * self;
	self = (ArrayListTests*) base;
	_g_object_unref0 (((CollectionTests*) self)->test_collection);
	((CollectionTests*) self)->test_collection = NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void array_list_tests_test_selected_functions (ArrayListTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* test_list;
	GEqualFunc _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (GEE_IS_ARRAY_LIST (_tmp0_) ? ((GeeArrayList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = gee_array_list_get_equal_func (test_list);
	g_assert (_tmp2_ == g_str_equal);
	_g_object_unref0 (test_list);
}


void array_list_tests_test_gobject_properties (ArrayListTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* test_list;
	GValue value = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	void* _tmp4_ = NULL;
	GEqualFunc _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (GEE_IS_ARRAY_LIST (_tmp0_) ? ((GeeArrayList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	g_value_init (&_tmp2_, G_TYPE_POINTER);
	_tmp3_ = _tmp2_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp3_;
	g_object_get_property ((GObject*) test_list, "equal-func", &value);
	_tmp4_ = g_value_get_pointer (&value);
	_tmp5_ = gee_array_list_get_equal_func (test_list);
	g_assert (_tmp4_ == ((void*) _tmp5_));
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	_g_object_unref0 (test_list);
}


static void array_list_tests_test_small_sort (ArrayListTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* test_list;
	gpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	gpointer _tmp4_ = NULL;
	gchar* _tmp5_;
	gpointer _tmp6_ = NULL;
	gchar* _tmp7_;
	gpointer _tmp8_ = NULL;
	gchar* _tmp9_;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (GEE_IS_ARRAY_LIST (_tmp0_) ? ((GeeArrayList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "one");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "two");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "three");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "four");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "five");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "six");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "seven");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "eight");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "nine");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "ten");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "eleven");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "twelve");
	gee_list_sort ((GeeList*) test_list, NULL);
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 0);
	_tmp3_ = (gchar*) _tmp2_;
	g_assert (g_strcmp0 (_tmp3_, "eight") == 0);
	_g_free0 (_tmp3_);
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 1);
	_tmp5_ = (gchar*) _tmp4_;
	g_assert (g_strcmp0 (_tmp5_, "eleven") == 0);
	_g_free0 (_tmp5_);
	_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 2);
	_tmp7_ = (gchar*) _tmp6_;
	g_assert (g_strcmp0 (_tmp7_, "five") == 0);
	_g_free0 (_tmp7_);
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 3);
	_tmp9_ = (gchar*) _tmp8_;
	g_assert (g_strcmp0 (_tmp9_, "four") == 0);
	_g_free0 (_tmp9_);
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 4);
	_tmp11_ = (gchar*) _tmp10_;
	g_assert (g_strcmp0 (_tmp11_, "nine") == 0);
	_g_free0 (_tmp11_);
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 5);
	_tmp13_ = (gchar*) _tmp12_;
	g_assert (g_strcmp0 (_tmp13_, "one") == 0);
	_g_free0 (_tmp13_);
	_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 6);
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (g_strcmp0 (_tmp15_, "seven") == 0);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 7);
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "six") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 8);
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "ten") == 0);
	_g_free0 (_tmp19_);
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 9);
	_tmp21_ = (gchar*) _tmp20_;
	g_assert (g_strcmp0 (_tmp21_, "three") == 0);
	_g_free0 (_tmp21_);
	_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 10);
	_tmp23_ = (gchar*) _tmp22_;
	g_assert (g_strcmp0 (_tmp23_, "twelve") == 0);
	_g_free0 (_tmp23_);
	_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) test_list, 11);
	_tmp25_ = (gchar*) _tmp24_;
	g_assert (g_strcmp0 (_tmp25_, "two") == 0);
	_g_free0 (_tmp25_);
	_g_object_unref0 (test_list);
}


static void array_list_tests_test_big_sort (ArrayListTests* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeList* big_test_list;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
	big_test_list = (GeeList*) _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint32 _tmp2_;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < ARRAY_LIST_TESTS_BIG_SORT_SIZE)) {
					break;
				}
				_tmp2_ = g_random_int_range ((gint32) 1, (gint32) (ARRAY_LIST_TESTS_BIG_SORT_SIZE - 1));
				gee_collection_add ((GeeCollection*) big_test_list, GINT_TO_POINTER (_tmp2_));
			}
		}
	}
	gee_list_sort (big_test_list, NULL);
	{
		gint i;
		i = 1;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gpointer _tmp4_ = NULL;
				gpointer _tmp5_ = NULL;
				if (!_tmp3_) {
					i++;
				}
				_tmp3_ = FALSE;
				if (!(i < ARRAY_LIST_TESTS_BIG_SORT_SIZE)) {
					break;
				}
				_tmp4_ = gee_list_get (big_test_list, i - 1);
				_tmp5_ = gee_list_get (big_test_list, i);
				g_assert (GPOINTER_TO_INT (_tmp4_) <= GPOINTER_TO_INT (_tmp5_));
			}
		}
	}
	_g_object_unref0 (big_test_list);
}


static gdouble* _double_dup (gdouble* self) {
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}


static void array_list_tests_test_typed_to_array (ArrayListTests* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeList* bool_list;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_;
	gpointer* _tmp5_ = NULL;
	gboolean* bool_array;
	gint bool_array_length1;
	gint _bool_array_size_;
	gint index;
	GeeArrayList* _tmp10_ = NULL;
	GeeList* int_list;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gint _tmp14_;
	gpointer* _tmp15_ = NULL;
	gint* int_array;
	gint int_array_length1;
	gint _int_array_size_;
	GeeArrayList* _tmp20_ = NULL;
	GeeList* double_list;
	gdouble _tmp21_;
	gboolean _tmp22_;
	gdouble _tmp23_;
	gboolean _tmp24_;
	gdouble _tmp25_;
	gboolean _tmp26_;
	gint _tmp27_;
	gpointer* _tmp28_ = NULL;
	gdouble* double_array;
	gint double_array_length1;
	gint _double_array_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_BOOLEAN, NULL, NULL, NULL);
	bool_list = (GeeList*) _tmp0_;
	_tmp1_ = gee_collection_add ((GeeCollection*) bool_list, GINT_TO_POINTER (TRUE));
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) bool_list, GINT_TO_POINTER (TRUE));
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) bool_list, GINT_TO_POINTER (FALSE));
	g_assert (_tmp3_);
	_tmp5_ = gee_collection_to_array ((GeeCollection*) bool_list, &_tmp4_);
	bool_array = _tmp5_;
	bool_array_length1 = _tmp4_;
	_bool_array_size_ = _tmp4_;
	index = 0;
	{
		GeeList* _tmp6_;
		GeeList* _element_list;
		gint _tmp7_;
		gint _element_size;
		gint _element_index;
		_tmp6_ = _g_object_ref0 (bool_list);
		_element_list = _tmp6_;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _element_list);
		_element_size = _tmp7_;
		_element_index = -1;
		while (TRUE) {
			gpointer _tmp8_ = NULL;
			gboolean element;
			gint _tmp9_;
			_element_index = _element_index + 1;
			if (!(_element_index < _element_size)) {
				break;
			}
			_tmp8_ = gee_list_get (_element_list, _element_index);
			element = GPOINTER_TO_INT (_tmp8_);
			_tmp9_ = index;
			index = _tmp9_ + 1;
			g_assert (element == bool_array[_tmp9_]);
		}
		_g_object_unref0 (_element_list);
	}
	_tmp10_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
	int_list = (GeeList*) _tmp10_;
	_tmp11_ = gee_collection_add ((GeeCollection*) int_list, GINT_TO_POINTER (1));
	g_assert (_tmp11_);
	_tmp12_ = gee_collection_add ((GeeCollection*) int_list, GINT_TO_POINTER (2));
	g_assert (_tmp12_);
	_tmp13_ = gee_collection_add ((GeeCollection*) int_list, GINT_TO_POINTER (3));
	g_assert (_tmp13_);
	_tmp15_ = gee_collection_to_array ((GeeCollection*) int_list, &_tmp14_);
	int_array = _tmp15_;
	int_array_length1 = _tmp14_;
	_int_array_size_ = _tmp14_;
	index = 0;
	{
		GeeList* _tmp16_;
		GeeList* _element_list;
		gint _tmp17_;
		gint _element_size;
		gint _element_index;
		_tmp16_ = _g_object_ref0 (int_list);
		_element_list = _tmp16_;
		_tmp17_ = gee_collection_get_size ((GeeCollection*) _element_list);
		_element_size = _tmp17_;
		_element_index = -1;
		while (TRUE) {
			gpointer _tmp18_ = NULL;
			gint element;
			gint _tmp19_;
			_element_index = _element_index + 1;
			if (!(_element_index < _element_size)) {
				break;
			}
			_tmp18_ = gee_list_get (_element_list, _element_index);
			element = GPOINTER_TO_INT (_tmp18_);
			_tmp19_ = index;
			index = _tmp19_ + 1;
			g_assert (element == int_array[_tmp19_]);
		}
		_g_object_unref0 (_element_list);
	}
	_tmp20_ = gee_array_list_new (G_TYPE_DOUBLE, (GBoxedCopyFunc) _double_dup, g_free, NULL);
	double_list = (GeeList*) _tmp20_;
	_tmp21_ = 1.0;
	_tmp22_ = gee_collection_add ((GeeCollection*) double_list, &_tmp21_);
	g_assert (_tmp22_);
	_tmp23_ = 1.5;
	_tmp24_ = gee_collection_add ((GeeCollection*) double_list, &_tmp23_);
	g_assert (_tmp24_);
	_tmp25_ = 2.0;
	_tmp26_ = gee_collection_add ((GeeCollection*) double_list, &_tmp25_);
	g_assert (_tmp26_);
	_tmp28_ = gee_collection_to_array ((GeeCollection*) double_list, &_tmp27_);
	double_array = _tmp28_;
	double_array_length1 = _tmp27_;
	_double_array_size_ = _tmp27_;
	index = 0;
	{
		GeeList* _tmp29_;
		GeeList* _element_list;
		gint _tmp30_;
		gint _element_size;
		gint _element_index;
		_tmp29_ = _g_object_ref0 (double_list);
		_element_list = _tmp29_;
		_tmp30_ = gee_collection_get_size ((GeeCollection*) _element_list);
		_element_size = _tmp30_;
		_element_index = -1;
		while (TRUE) {
			gpointer _tmp31_ = NULL;
			gdouble* _tmp32_;
			gdouble _tmp33_;
			gdouble element;
			gint _tmp34_;
			_element_index = _element_index + 1;
			if (!(_element_index < _element_size)) {
				break;
			}
			_tmp31_ = gee_list_get (_element_list, _element_index);
			_tmp32_ = (gdouble*) _tmp31_;
			_tmp33_ = *_tmp32_;
			_g_free0 (_tmp32_);
			element = _tmp33_;
			_tmp34_ = index;
			index = _tmp34_ + 1;
			g_assert (element == double_array[_tmp34_]);
		}
		_g_object_unref0 (_element_list);
	}
	double_array = (g_free (double_array), NULL);
	_g_object_unref0 (double_list);
	int_array = (g_free (int_array), NULL);
	_g_object_unref0 (int_list);
	bool_array = (g_free (bool_array), NULL);
	_g_object_unref0 (bool_list);
}


static void array_list_tests_class_init (ArrayListTestsClass * klass) {
	array_list_tests_parent_class = g_type_class_peek_parent (klass);
	GEE_TEST_CASE_CLASS (klass)->set_up = array_list_tests_real_set_up;
	GEE_TEST_CASE_CLASS (klass)->tear_down = array_list_tests_real_tear_down;
}


static void array_list_tests_instance_init (ArrayListTests * self) {
}


GType array_list_tests_get_type (void) {
	static volatile gsize array_list_tests_type_id__volatile = 0;
	if (g_once_init_enter (&array_list_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ArrayListTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) array_list_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ArrayListTests), 0, (GInstanceInitFunc) array_list_tests_instance_init, NULL };
		GType array_list_tests_type_id;
		array_list_tests_type_id = g_type_register_static (TYPE_LIST_TESTS, "ArrayListTests", &g_define_type_info, 0);
		g_once_init_leave (&array_list_tests_type_id__volatile, array_list_tests_type_id);
	}
	return array_list_tests_type_id__volatile;
}



