// -*- C++ -*-

#ifndef EPT_CORE_SOURCE_H
#define EPT_CORE_SOURCE_H

namespace ept {
namespace core {

template< typename Self, typename Setup,
          template< typename Setup::PropertyId > class PType >
struct Source {
    typedef typename Setup::PropertyId PropertyId;
    typedef typename Setup::Token Token;

    Self &self() { return *static_cast< Self * >( this ); }

    template< PropertyId property >
    typename PType< property >::T get( Token t ) {
        return self().template getInternal< property >( self().lookupToken( t ) );
    }

    template< PropertyId _property >
    struct ComposedList {
        typedef Self Origin;
        typedef typename Setup::Token Token;
        typedef typename PType< _property >::T Property;
        typedef ComposedList Type;

        Origin *origin;
        typename Setup::InternalList internal;

        ComposedList tail() {
            return ComposedList< _property >( *origin, internal.tail() );
        }

        bool empty() { return internal.empty(); }

        ComposedList &head() { return *this; }

        Token token() { return origin->getToken( internal.head() ); }

        Property property() {
            return origin->template getInternal< _property >(
                internal.head() );
        }

        ComposedList( Origin &o, typename Setup::InternalList i )
            : origin( &o ), internal( i ) {}
    };

    template< PropertyId property >
    ComposedList< property > list()
    {
        return ComposedList< property >( self(), self().listInternal() );
    }

    Source()
    {
    }
};

}
}

#endif
