package Date::Manip::TZ::afcasa00;
# Copyright (c) 2008-2012 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Wed May 30 08:37:01 EDT 2012
#    Data version: tzdata2012c
#    Code version: tzcode2012b

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

=pod

=head1 NAME

Date::Manip::TZ::afcasa00 - Support for the Africa/Casablanca time zone

=head1 SYNPOSIS

This module contains data describing a time zone.  Most of the time zone
data comes from the Olsen database, but there are a few exceptions.

This module is not intended to be used directly.  Other Date::Manip modules
will load it as needed.

=cut

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.32';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,23,29,40],'-00:30:20',[0,-30,-20],
          'LMT',0,[1913,10,26,0,30,19],[1913,10,25,23,59,59],
          '0001010200:00:00','0001010123:29:40','1913102600:30:19','1913102523:59:59' ],
     ],
   1913 =>
     [
        [ [1913,10,26,0,30,20],[1913,10,26,0,30,20],'+00:00:00',[0,0,0],
          'WET',0,[1939,9,11,23,59,59],[1939,9,11,23,59,59],
          '1913102600:30:20','1913102600:30:20','1939091123:59:59','1939091123:59:59' ],
     ],
   1939 =>
     [
        [ [1939,9,12,0,0,0],[1939,9,12,1,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[1939,11,18,22,59,59],[1939,11,18,23,59,59],
          '1939091200:00:00','1939091201:00:00','1939111822:59:59','1939111823:59:59' ],
        [ [1939,11,18,23,0,0],[1939,11,18,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[1940,2,24,23,59,59],[1940,2,24,23,59,59],
          '1939111823:00:00','1939111823:00:00','1940022423:59:59','1940022423:59:59' ],
     ],
   1940 =>
     [
        [ [1940,2,25,0,0,0],[1940,2,25,1,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[1945,11,17,22,59,59],[1945,11,17,23,59,59],
          '1940022500:00:00','1940022501:00:00','1945111722:59:59','1945111723:59:59' ],
     ],
   1945 =>
     [
        [ [1945,11,17,23,0,0],[1945,11,17,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[1950,6,10,23,59,59],[1950,6,10,23,59,59],
          '1945111723:00:00','1945111723:00:00','1950061023:59:59','1950061023:59:59' ],
     ],
   1950 =>
     [
        [ [1950,6,11,0,0,0],[1950,6,11,1,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[1950,10,28,22,59,59],[1950,10,28,23,59,59],
          '1950061100:00:00','1950061101:00:00','1950102822:59:59','1950102823:59:59' ],
        [ [1950,10,28,23,0,0],[1950,10,28,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[1967,6,3,11,59,59],[1967,6,3,11,59,59],
          '1950102823:00:00','1950102823:00:00','1967060311:59:59','1967060311:59:59' ],
     ],
   1967 =>
     [
        [ [1967,6,3,12,0,0],[1967,6,3,13,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[1967,9,30,22,59,59],[1967,9,30,23,59,59],
          '1967060312:00:00','1967060313:00:00','1967093022:59:59','1967093023:59:59' ],
        [ [1967,9,30,23,0,0],[1967,9,30,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[1974,6,23,23,59,59],[1974,6,23,23,59,59],
          '1967093023:00:00','1967093023:00:00','1974062323:59:59','1974062323:59:59' ],
     ],
   1974 =>
     [
        [ [1974,6,24,0,0,0],[1974,6,24,1,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[1974,8,31,22,59,59],[1974,8,31,23,59,59],
          '1974062400:00:00','1974062401:00:00','1974083122:59:59','1974083123:59:59' ],
        [ [1974,8,31,23,0,0],[1974,8,31,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[1976,4,30,23,59,59],[1976,4,30,23,59,59],
          '1974083123:00:00','1974083123:00:00','1976043023:59:59','1976043023:59:59' ],
     ],
   1976 =>
     [
        [ [1976,5,1,0,0,0],[1976,5,1,1,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[1976,7,31,22,59,59],[1976,7,31,23,59,59],
          '1976050100:00:00','1976050101:00:00','1976073122:59:59','1976073123:59:59' ],
        [ [1976,7,31,23,0,0],[1976,7,31,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[1977,4,30,23,59,59],[1977,4,30,23,59,59],
          '1976073123:00:00','1976073123:00:00','1977043023:59:59','1977043023:59:59' ],
     ],
   1977 =>
     [
        [ [1977,5,1,0,0,0],[1977,5,1,1,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[1977,9,27,22,59,59],[1977,9,27,23,59,59],
          '1977050100:00:00','1977050101:00:00','1977092722:59:59','1977092723:59:59' ],
        [ [1977,9,27,23,0,0],[1977,9,27,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[1978,5,31,23,59,59],[1978,5,31,23,59,59],
          '1977092723:00:00','1977092723:00:00','1978053123:59:59','1978053123:59:59' ],
     ],
   1978 =>
     [
        [ [1978,6,1,0,0,0],[1978,6,1,1,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[1978,8,3,22,59,59],[1978,8,3,23,59,59],
          '1978060100:00:00','1978060101:00:00','1978080322:59:59','1978080323:59:59' ],
        [ [1978,8,3,23,0,0],[1978,8,3,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[1984,3,15,23,59,59],[1984,3,15,23,59,59],
          '1978080323:00:00','1978080323:00:00','1984031523:59:59','1984031523:59:59' ],
     ],
   1984 =>
     [
        [ [1984,3,16,0,0,0],[1984,3,16,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1985,12,31,22,59,59],[1985,12,31,23,59,59],
          '1984031600:00:00','1984031601:00:00','1985123122:59:59','1985123123:59:59' ],
     ],
   1985 =>
     [
        [ [1985,12,31,23,0,0],[1985,12,31,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2008,5,31,23,59,59],[2008,5,31,23,59,59],
          '1985123123:00:00','1985123123:00:00','2008053123:59:59','2008053123:59:59' ],
     ],
   2008 =>
     [
        [ [2008,6,1,0,0,0],[2008,6,1,1,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2008,8,31,22,59,59],[2008,8,31,23,59,59],
          '2008060100:00:00','2008060101:00:00','2008083122:59:59','2008083123:59:59' ],
        [ [2008,8,31,23,0,0],[2008,8,31,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2009,5,31,23,59,59],[2009,5,31,23,59,59],
          '2008083123:00:00','2008083123:00:00','2009053123:59:59','2009053123:59:59' ],
     ],
   2009 =>
     [
        [ [2009,6,1,0,0,0],[2009,6,1,1,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2009,8,20,22,59,59],[2009,8,20,23,59,59],
          '2009060100:00:00','2009060101:00:00','2009082022:59:59','2009082023:59:59' ],
        [ [2009,8,20,23,0,0],[2009,8,20,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2010,5,1,23,59,59],[2010,5,1,23,59,59],
          '2009082023:00:00','2009082023:00:00','2010050123:59:59','2010050123:59:59' ],
     ],
   2010 =>
     [
        [ [2010,5,2,0,0,0],[2010,5,2,1,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2010,8,7,22,59,59],[2010,8,7,23,59,59],
          '2010050200:00:00','2010050201:00:00','2010080722:59:59','2010080723:59:59' ],
        [ [2010,8,7,23,0,0],[2010,8,7,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2011,4,2,23,59,59],[2011,4,2,23,59,59],
          '2010080723:00:00','2010080723:00:00','2011040223:59:59','2011040223:59:59' ],
     ],
   2011 =>
     [
        [ [2011,4,3,0,0,0],[2011,4,3,1,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2011,7,30,22,59,59],[2011,7,30,23,59,59],
          '2011040300:00:00','2011040301:00:00','2011073022:59:59','2011073023:59:59' ],
        [ [2011,7,30,23,0,0],[2011,7,30,23,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2012,4,29,1,59,59],[2012,4,29,1,59,59],
          '2011073023:00:00','2011073023:00:00','2012042901:59:59','2012042901:59:59' ],
     ],
   2012 =>
     [
        [ [2012,4,29,2,0,0],[2012,4,29,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2012,9,30,1,59,59],[2012,9,30,2,59,59],
          '2012042902:00:00','2012042903:00:00','2012093001:59:59','2012093002:59:59' ],
        [ [2012,9,30,2,0,0],[2012,9,30,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2013,4,28,1,59,59],[2013,4,28,1,59,59],
          '2012093002:00:00','2012093002:00:00','2013042801:59:59','2013042801:59:59' ],
     ],
   2013 =>
     [
        [ [2013,4,28,2,0,0],[2013,4,28,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2013,9,29,1,59,59],[2013,9,29,2,59,59],
          '2013042802:00:00','2013042803:00:00','2013092901:59:59','2013092902:59:59' ],
        [ [2013,9,29,2,0,0],[2013,9,29,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2014,4,27,1,59,59],[2014,4,27,1,59,59],
          '2013092902:00:00','2013092902:00:00','2014042701:59:59','2014042701:59:59' ],
     ],
   2014 =>
     [
        [ [2014,4,27,2,0,0],[2014,4,27,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2014,9,28,1,59,59],[2014,9,28,2,59,59],
          '2014042702:00:00','2014042703:00:00','2014092801:59:59','2014092802:59:59' ],
        [ [2014,9,28,2,0,0],[2014,9,28,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2015,4,26,1,59,59],[2015,4,26,1,59,59],
          '2014092802:00:00','2014092802:00:00','2015042601:59:59','2015042601:59:59' ],
     ],
   2015 =>
     [
        [ [2015,4,26,2,0,0],[2015,4,26,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2015,9,27,1,59,59],[2015,9,27,2,59,59],
          '2015042602:00:00','2015042603:00:00','2015092701:59:59','2015092702:59:59' ],
        [ [2015,9,27,2,0,0],[2015,9,27,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2016,4,24,1,59,59],[2016,4,24,1,59,59],
          '2015092702:00:00','2015092702:00:00','2016042401:59:59','2016042401:59:59' ],
     ],
   2016 =>
     [
        [ [2016,4,24,2,0,0],[2016,4,24,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2016,9,25,1,59,59],[2016,9,25,2,59,59],
          '2016042402:00:00','2016042403:00:00','2016092501:59:59','2016092502:59:59' ],
        [ [2016,9,25,2,0,0],[2016,9,25,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2017,4,30,1,59,59],[2017,4,30,1,59,59],
          '2016092502:00:00','2016092502:00:00','2017043001:59:59','2017043001:59:59' ],
     ],
   2017 =>
     [
        [ [2017,4,30,2,0,0],[2017,4,30,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2017,9,24,1,59,59],[2017,9,24,2,59,59],
          '2017043002:00:00','2017043003:00:00','2017092401:59:59','2017092402:59:59' ],
        [ [2017,9,24,2,0,0],[2017,9,24,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2018,4,29,1,59,59],[2018,4,29,1,59,59],
          '2017092402:00:00','2017092402:00:00','2018042901:59:59','2018042901:59:59' ],
     ],
   2018 =>
     [
        [ [2018,4,29,2,0,0],[2018,4,29,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2018,9,30,1,59,59],[2018,9,30,2,59,59],
          '2018042902:00:00','2018042903:00:00','2018093001:59:59','2018093002:59:59' ],
        [ [2018,9,30,2,0,0],[2018,9,30,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2019,4,28,1,59,59],[2019,4,28,1,59,59],
          '2018093002:00:00','2018093002:00:00','2019042801:59:59','2019042801:59:59' ],
     ],
   2019 =>
     [
        [ [2019,4,28,2,0,0],[2019,4,28,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2019,9,29,1,59,59],[2019,9,29,2,59,59],
          '2019042802:00:00','2019042803:00:00','2019092901:59:59','2019092902:59:59' ],
        [ [2019,9,29,2,0,0],[2019,9,29,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2020,4,26,1,59,59],[2020,4,26,1,59,59],
          '2019092902:00:00','2019092902:00:00','2020042601:59:59','2020042601:59:59' ],
     ],
   2020 =>
     [
        [ [2020,4,26,2,0,0],[2020,4,26,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2020,9,27,1,59,59],[2020,9,27,2,59,59],
          '2020042602:00:00','2020042603:00:00','2020092701:59:59','2020092702:59:59' ],
        [ [2020,9,27,2,0,0],[2020,9,27,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2021,4,25,1,59,59],[2021,4,25,1,59,59],
          '2020092702:00:00','2020092702:00:00','2021042501:59:59','2021042501:59:59' ],
     ],
   2021 =>
     [
        [ [2021,4,25,2,0,0],[2021,4,25,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2021,9,26,1,59,59],[2021,9,26,2,59,59],
          '2021042502:00:00','2021042503:00:00','2021092601:59:59','2021092602:59:59' ],
        [ [2021,9,26,2,0,0],[2021,9,26,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2022,4,24,1,59,59],[2022,4,24,1,59,59],
          '2021092602:00:00','2021092602:00:00','2022042401:59:59','2022042401:59:59' ],
     ],
   2022 =>
     [
        [ [2022,4,24,2,0,0],[2022,4,24,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2022,9,25,1,59,59],[2022,9,25,2,59,59],
          '2022042402:00:00','2022042403:00:00','2022092501:59:59','2022092502:59:59' ],
        [ [2022,9,25,2,0,0],[2022,9,25,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2023,4,30,1,59,59],[2023,4,30,1,59,59],
          '2022092502:00:00','2022092502:00:00','2023043001:59:59','2023043001:59:59' ],
     ],
   2023 =>
     [
        [ [2023,4,30,2,0,0],[2023,4,30,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2023,9,24,1,59,59],[2023,9,24,2,59,59],
          '2023043002:00:00','2023043003:00:00','2023092401:59:59','2023092402:59:59' ],
        [ [2023,9,24,2,0,0],[2023,9,24,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2024,4,28,1,59,59],[2024,4,28,1,59,59],
          '2023092402:00:00','2023092402:00:00','2024042801:59:59','2024042801:59:59' ],
     ],
   2024 =>
     [
        [ [2024,4,28,2,0,0],[2024,4,28,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2024,9,29,1,59,59],[2024,9,29,2,59,59],
          '2024042802:00:00','2024042803:00:00','2024092901:59:59','2024092902:59:59' ],
        [ [2024,9,29,2,0,0],[2024,9,29,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2025,4,27,1,59,59],[2025,4,27,1,59,59],
          '2024092902:00:00','2024092902:00:00','2025042701:59:59','2025042701:59:59' ],
     ],
   2025 =>
     [
        [ [2025,4,27,2,0,0],[2025,4,27,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2025,9,28,1,59,59],[2025,9,28,2,59,59],
          '2025042702:00:00','2025042703:00:00','2025092801:59:59','2025092802:59:59' ],
        [ [2025,9,28,2,0,0],[2025,9,28,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2026,4,26,1,59,59],[2026,4,26,1,59,59],
          '2025092802:00:00','2025092802:00:00','2026042601:59:59','2026042601:59:59' ],
     ],
   2026 =>
     [
        [ [2026,4,26,2,0,0],[2026,4,26,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2026,9,27,1,59,59],[2026,9,27,2,59,59],
          '2026042602:00:00','2026042603:00:00','2026092701:59:59','2026092702:59:59' ],
        [ [2026,9,27,2,0,0],[2026,9,27,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2027,4,25,1,59,59],[2027,4,25,1,59,59],
          '2026092702:00:00','2026092702:00:00','2027042501:59:59','2027042501:59:59' ],
     ],
   2027 =>
     [
        [ [2027,4,25,2,0,0],[2027,4,25,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2027,9,26,1,59,59],[2027,9,26,2,59,59],
          '2027042502:00:00','2027042503:00:00','2027092601:59:59','2027092602:59:59' ],
        [ [2027,9,26,2,0,0],[2027,9,26,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2028,4,30,1,59,59],[2028,4,30,1,59,59],
          '2027092602:00:00','2027092602:00:00','2028043001:59:59','2028043001:59:59' ],
     ],
   2028 =>
     [
        [ [2028,4,30,2,0,0],[2028,4,30,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2028,9,24,1,59,59],[2028,9,24,2,59,59],
          '2028043002:00:00','2028043003:00:00','2028092401:59:59','2028092402:59:59' ],
        [ [2028,9,24,2,0,0],[2028,9,24,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2029,4,29,1,59,59],[2029,4,29,1,59,59],
          '2028092402:00:00','2028092402:00:00','2029042901:59:59','2029042901:59:59' ],
     ],
   2029 =>
     [
        [ [2029,4,29,2,0,0],[2029,4,29,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2029,9,30,1,59,59],[2029,9,30,2,59,59],
          '2029042902:00:00','2029042903:00:00','2029093001:59:59','2029093002:59:59' ],
        [ [2029,9,30,2,0,0],[2029,9,30,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2030,4,28,1,59,59],[2030,4,28,1,59,59],
          '2029093002:00:00','2029093002:00:00','2030042801:59:59','2030042801:59:59' ],
     ],
   2030 =>
     [
        [ [2030,4,28,2,0,0],[2030,4,28,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2030,9,29,1,59,59],[2030,9,29,2,59,59],
          '2030042802:00:00','2030042803:00:00','2030092901:59:59','2030092902:59:59' ],
        [ [2030,9,29,2,0,0],[2030,9,29,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2031,4,27,1,59,59],[2031,4,27,1,59,59],
          '2030092902:00:00','2030092902:00:00','2031042701:59:59','2031042701:59:59' ],
     ],
   2031 =>
     [
        [ [2031,4,27,2,0,0],[2031,4,27,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2031,9,28,1,59,59],[2031,9,28,2,59,59],
          '2031042702:00:00','2031042703:00:00','2031092801:59:59','2031092802:59:59' ],
        [ [2031,9,28,2,0,0],[2031,9,28,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2032,4,25,1,59,59],[2032,4,25,1,59,59],
          '2031092802:00:00','2031092802:00:00','2032042501:59:59','2032042501:59:59' ],
     ],
   2032 =>
     [
        [ [2032,4,25,2,0,0],[2032,4,25,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2032,9,26,1,59,59],[2032,9,26,2,59,59],
          '2032042502:00:00','2032042503:00:00','2032092601:59:59','2032092602:59:59' ],
        [ [2032,9,26,2,0,0],[2032,9,26,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2033,4,24,1,59,59],[2033,4,24,1,59,59],
          '2032092602:00:00','2032092602:00:00','2033042401:59:59','2033042401:59:59' ],
     ],
   2033 =>
     [
        [ [2033,4,24,2,0,0],[2033,4,24,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2033,9,25,1,59,59],[2033,9,25,2,59,59],
          '2033042402:00:00','2033042403:00:00','2033092501:59:59','2033092502:59:59' ],
        [ [2033,9,25,2,0,0],[2033,9,25,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2034,4,30,1,59,59],[2034,4,30,1,59,59],
          '2033092502:00:00','2033092502:00:00','2034043001:59:59','2034043001:59:59' ],
     ],
   2034 =>
     [
        [ [2034,4,30,2,0,0],[2034,4,30,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2034,9,24,1,59,59],[2034,9,24,2,59,59],
          '2034043002:00:00','2034043003:00:00','2034092401:59:59','2034092402:59:59' ],
        [ [2034,9,24,2,0,0],[2034,9,24,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2035,4,29,1,59,59],[2035,4,29,1,59,59],
          '2034092402:00:00','2034092402:00:00','2035042901:59:59','2035042901:59:59' ],
     ],
   2035 =>
     [
        [ [2035,4,29,2,0,0],[2035,4,29,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2035,9,30,1,59,59],[2035,9,30,2,59,59],
          '2035042902:00:00','2035042903:00:00','2035093001:59:59','2035093002:59:59' ],
        [ [2035,9,30,2,0,0],[2035,9,30,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2036,4,27,1,59,59],[2036,4,27,1,59,59],
          '2035093002:00:00','2035093002:00:00','2036042701:59:59','2036042701:59:59' ],
     ],
   2036 =>
     [
        [ [2036,4,27,2,0,0],[2036,4,27,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2036,9,28,1,59,59],[2036,9,28,2,59,59],
          '2036042702:00:00','2036042703:00:00','2036092801:59:59','2036092802:59:59' ],
        [ [2036,9,28,2,0,0],[2036,9,28,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2037,4,26,1,59,59],[2037,4,26,1,59,59],
          '2036092802:00:00','2036092802:00:00','2037042601:59:59','2037042601:59:59' ],
     ],
   2037 =>
     [
        [ [2037,4,26,2,0,0],[2037,4,26,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2037,9,27,1,59,59],[2037,9,27,2,59,59],
          '2037042602:00:00','2037042603:00:00','2037092701:59:59','2037092702:59:59' ],
        [ [2037,9,27,2,0,0],[2037,9,27,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2038,4,25,1,59,59],[2038,4,25,1,59,59],
          '2037092702:00:00','2037092702:00:00','2038042501:59:59','2038042501:59:59' ],
     ],
   2038 =>
     [
        [ [2038,4,25,2,0,0],[2038,4,25,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2038,9,26,1,59,59],[2038,9,26,2,59,59],
          '2038042502:00:00','2038042503:00:00','2038092601:59:59','2038092602:59:59' ],
        [ [2038,9,26,2,0,0],[2038,9,26,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2039,4,24,1,59,59],[2039,4,24,1,59,59],
          '2038092602:00:00','2038092602:00:00','2039042401:59:59','2039042401:59:59' ],
     ],
   2039 =>
     [
        [ [2039,4,24,2,0,0],[2039,4,24,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2039,9,25,1,59,59],[2039,9,25,2,59,59],
          '2039042402:00:00','2039042403:00:00','2039092501:59:59','2039092502:59:59' ],
        [ [2039,9,25,2,0,0],[2039,9,25,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2040,4,29,1,59,59],[2040,4,29,1,59,59],
          '2039092502:00:00','2039092502:00:00','2040042901:59:59','2040042901:59:59' ],
     ],
   2040 =>
     [
        [ [2040,4,29,2,0,0],[2040,4,29,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2040,9,30,1,59,59],[2040,9,30,2,59,59],
          '2040042902:00:00','2040042903:00:00','2040093001:59:59','2040093002:59:59' ],
        [ [2040,9,30,2,0,0],[2040,9,30,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2041,4,28,1,59,59],[2041,4,28,1,59,59],
          '2040093002:00:00','2040093002:00:00','2041042801:59:59','2041042801:59:59' ],
     ],
   2041 =>
     [
        [ [2041,4,28,2,0,0],[2041,4,28,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2041,9,29,1,59,59],[2041,9,29,2,59,59],
          '2041042802:00:00','2041042803:00:00','2041092901:59:59','2041092902:59:59' ],
        [ [2041,9,29,2,0,0],[2041,9,29,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2042,4,27,1,59,59],[2042,4,27,1,59,59],
          '2041092902:00:00','2041092902:00:00','2042042701:59:59','2042042701:59:59' ],
     ],
   2042 =>
     [
        [ [2042,4,27,2,0,0],[2042,4,27,3,0,0],'+01:00:00',[1,0,0],
          'WEST',1,[2042,9,28,1,59,59],[2042,9,28,2,59,59],
          '2042042702:00:00','2042042703:00:00','2042092801:59:59','2042092802:59:59' ],
        [ [2042,9,28,2,0,0],[2042,9,28,2,0,0],'+00:00:00',[0,0,0],
          'WET',0,[2043,4,26,1,59,59],[2043,4,26,1,59,59],
          '2042092802:00:00','2042092802:00:00','2043042601:59:59','2043042601:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+01:00:00',
                'stdoff' => '+00:00:00',
               },
   'rules'  => {
                '04' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'WEST',
                        },
                '09' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '03:00:00',
                         'isdst'   => '0',
                         'abb'     => 'WET',
                        },
               },
);

1;
