/*
 * Copyright (c) Likewise Software.  All rights Reserved.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the license, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.  You should have received a copy
 * of the GNU Lesser General Public License along with this program.  If
 * not, see <http://www.gnu.org/licenses/>.
 *
 * LIKEWISE SOFTWARE MAKES THIS SOFTWARE AVAILABLE UNDER OTHER LICENSING
 * TERMS AS WELL.  IF YOU HAVE ENTERED INTO A SEPARATE LICENSE AGREEMENT
 * WITH LIKEWISE SOFTWARE, THEN YOU MAY ELECT TO USE THE SOFTWARE UNDER THE
 * TERMS OF THAT SOFTWARE LICENSE AGREEMENT INSTEAD OF THE TERMS OF THE GNU
 * LESSER GENERAL PUBLIC LICENSE, NOTWITHSTANDING THE ABOVE NOTICE.  IF YOU
 * HAVE QUESTIONS, OR WISH TO REQUEST A COPY OF THE ALTERNATE LICENSING
 * TERMS OFFERED BY LIKEWISE SOFTWARE, PLEASE CONTACT LIKEWISE SOFTWARE AT
 * license@likewise.com
 */

/*
 * Module Name:
 *
 *        error-table.h
 *
 *   NT status and Win32 error code mapping table
 *
 *   Some of these definitions were written from scratch.
 *
 *   NT status codes are unsigned 32-bit hex values
 *
 *   Win32 error codes are unsigned 32-bit decimal values
 *
 */

/* Win32 codes*/
#ifdef __ERROR_WIN32__

#include <lw/winerror.h>

#endif

/* Equivalence table*/
#ifdef __ERROR_XMACRO__
#define S STATUS_CODE

S ( LW_STATUS_SUCCESS,                ERROR_SUCCESS,             0      , "Success" )
S ( LW_STATUS_MORE_ENTRIES,           ERROR_MORE_DATA,           EAGAIN , "More data available" )
S ( LW_STATUS_NOT_IMPLEMENTED,        ERROR_INVALID_FUNCTION,    ENOTSUP, "" )
S ( LW_STATUS_INVALID_INFO_CLASS,     -1,                        -1     , "" )
S ( LW_STATUS_INVALID_PARAMETER,      ERROR_INVALID_PARAMETER,   EINVAL , "Invalid parameter passed" )
S ( LW_STATUS_NO_MEMORY,              ERROR_OUTOFMEMORY,         ENOMEM , "Out of memory" )
S ( LW_STATUS_INVALID_SID,            -1,                        EINVAL , "" )
S ( LW_STATUS_INSUFFICIENT_RESOURCES, -1,                        ENOSPC , "" )
S ( LW_STATUS_UNHANDLED_EXCEPTION,    -1,                        -1     , "" )
S ( LW_STATUS_ACCESS_DENIED,          ERROR_ACCESS_DENIED,       EACCES , "Access is denied" )
S ( LW_STATUS_NONE_MAPPED,            ERROR_NONE_MAPPED,         -1     , "Specified account has no mapping to a valid SID" )
S ( LW_STATUS_CONNECTION_REFUSED,     ERROR_CONNECTION_REFUSED,  111    , "" )
S ( LW_STATUS_SPECIAL_ACCOUNT,        ERROR_SPECIAL_ACCOUNT,     -1     , "Cannot perform this operation on built-in accounts" )

S ( LW_STATUS_WAIT_1, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WAIT_2, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WAIT_3, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WAIT_63, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ABANDONED_WAIT_0, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ABANDONED_WAIT_63, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_USER_APC, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_KERNEL_APC, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ALERTED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_TIMEOUT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PENDING, ERROR_IO_PENDING, -1, "" )
S ( LW_STATUS_REPARSE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NOT_ALL_ASSIGNED, ERROR_NOT_ALL_ASSIGNED, -1, "" )
S ( LW_STATUS_SOME_NOT_MAPPED, ERROR_SOME_NOT_MAPPED, -1, "" )
S ( LW_STATUS_OPLOCK_BREAK_IN_PROGRESS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_VOLUME_MOUNTED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RXACT_COMMITTED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NOTIFY_CLEANUP, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NOTIFY_ENUM_DIR, ERROR_NOTIFY_ENUM_DIR, -1, "" )
S ( LW_STATUS_NO_QUOTAS_FOR_ACCOUNT, ERROR_NO_QUOTAS_FOR_ACCOUNT, -1, "" )
S ( LW_STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PAGE_FAULT_TRANSITION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PAGE_FAULT_DEMAND_ZERO, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PAGE_FAULT_COPY_ON_WRITE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PAGE_FAULT_GUARD_PAGE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PAGE_FAULT_PAGING_FILE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CACHE_PAGE_LOCKED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CRASH_DUMP, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_BUFFER_ALL_ZEROS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_REPARSE_OBJECT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RESOURCE_REQUIREMENTS_CHANGED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_TRANSLATION_COMPLETE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY, ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY, -1, "" )
S ( LW_STATUS_NOTHING_TO_TERMINATE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PROCESS_NOT_IN_JOB, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PROCESS_IN_JOB, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_VOLSNAP_HIBERNATE_READY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INTERRUPT_STILL_CONNECTED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PROCESS_CLONED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FILE_LOCKED_WITH_ONLY_READERS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FILE_LOCKED_WITH_WRITERS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RESOURCEMANAGER_READ_ONLY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WAIT_FOR_OPLOCK, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_DBG_EXCEPTION_HANDLED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_DBG_CONTINUE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_OBJECT_NAME_EXISTS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_THREAD_WAS_SUSPENDED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WORKING_SET_LIMIT_RANGE, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_IMAGE_NOT_AT_BASE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RXACT_STATE_CREATED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SEGMENT_NOTIFICATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_LOCAL_USER_SESSION_KEY, ERROR_LOCAL_USER_SESSION_KEY, -1, "" )
S ( LW_STATUS_BAD_CURRENT_DIRECTORY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SERIAL_MORE_WRITES, ERROR_MORE_WRITES, -1, "" )
S ( LW_STATUS_REGISTRY_RECOVERED, ERROR_REGISTRY_RECOVERED, -1, "" )
S ( LW_STATUS_FT_READ_RECOVERY_FROM_BACKUP, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FT_WRITE_RECOVERY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SERIAL_COUNTER_TIMEOUT, ERROR_COUNTER_TIMEOUT, -1, "" )
S ( LW_STATUS_NULL_LM_PASSWORD, ERROR_NULL_LM_PASSWORD, -1, "" )
S ( LW_STATUS_IMAGE_MACHINE_TYPE_MISMATCH, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RECEIVE_PARTIAL, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RECEIVE_EXPEDITED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RECEIVE_PARTIAL_EXPEDITED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_EVENT_DONE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_EVENT_PENDING, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CHECKING_FILE_SYSTEM, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FATAL_APP_EXIT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PREDEFINED_HANDLE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WAS_UNLOCKED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SERVICE_NOTIFICATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WAS_LOCKED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_LOG_HARD_ERROR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ALREADY_WIN32, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WX86_UNSIMULATE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WX86_CONTINUE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WX86_SINGLE_STEP, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WX86_BREAKPOINT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WX86_EXCEPTION_CONTINUE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WX86_EXCEPTION_LASTCHANCE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WX86_EXCEPTION_CHAIN, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_YIELD_PERFORMED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_TIMER_RESUME_IGNORED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ARBITRATION_UNHANDLED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CARDBUS_NOT_SUPPORTED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WX86_CREATEWX86TIB, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_MP_PROCESSOR_MISMATCH, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_HIBERNATED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RESUME_HIBERNATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FIRMWARE_UPDATED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DRIVERS_LEAKING_LOCKED_PAGES, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_RETRIEVED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SYSTEM_POWERSTATE_TRANSITION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ALPC_CHECK_COMPLETION_LIST, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ACCESS_AUDIT_BY_POLICY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ABANDON_HIBERFILE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_BIZRULES_NOT_ENABLED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WAKE_SYSTEM, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DS_SHUTTING_DOWN, ERROR_DS_SHUTTING_DOWN, -1, "" )
S ( LW_DBG_REPLY_LATER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_DBG_UNABLE_TO_PROVIDE_HANDLE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_DBG_TERMINATE_THREAD, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_DBG_TERMINATE_PROCESS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_DBG_CONTROL_C, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_DBG_PRINTEXCEPTION_C, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_DBG_RIPEXCEPTION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_DBG_CONTROL_BREAK, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_DBG_COMMAND_EXCEPTION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_RPC_NT_UUID_LOCAL_ONLY, RPC_S_UUID_LOCAL_ONLY, -1, "" )
S ( LW_RPC_NT_SEND_INCOMPLETE, RPC_S_SEND_INCOMPLETE, -1, "" )
S ( LW_STATUS_GUARD_PAGE_VIOLATION, -2147483647, -1, "" )
S ( LW_STATUS_DATATYPE_MISALIGNMENT, ERROR_NOACCESS, -1, "" )
S ( LW_STATUS_BREAKPOINT, -2147483645, -1, "" )
S ( LW_STATUS_SINGLE_STEP, -2147483644, -1, "" )
S ( LW_STATUS_BUFFER_OVERFLOW, ERROR_MORE_DATA, -1, "" )
S ( LW_STATUS_NO_MORE_FILES, ERROR_NO_MORE_FILES, -1, "" )
S ( LW_STATUS_WAKE_SYSTEM_DEBUGGER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_HANDLES_CLOSED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_INHERITANCE, ERROR_NO_INHERITANCE, -1, "" )
S ( LW_STATUS_GUID_SUBSTITUTION_MADE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PARTIAL_COPY, ERROR_PARTIAL_COPY, -1, "" )
S ( LW_STATUS_DEVICE_PAPER_EMPTY, ERROR_OUT_OF_PAPER, -1, "" )
S ( LW_STATUS_DEVICE_POWERED_OFF, ERROR_NOT_READY, -1, "" )
S ( LW_STATUS_DEVICE_OFF_LINE, ERROR_NOT_READY, -1, "" )
S ( LW_STATUS_DEVICE_BUSY, ERROR_BUSY, -1, "" )
S ( LW_STATUS_NO_MORE_EAS, ERROR_NO_MORE_ITEMS, -1, "" )
S ( LW_STATUS_INVALID_EA_NAME, ERROR_INVALID_EA_NAME, -1, "" )
S ( LW_STATUS_EA_LIST_INCONSISTENT, ERROR_EA_LIST_INCONSISTENT, -1, "" )
S ( LW_STATUS_INVALID_EA_FLAG, ERROR_EA_LIST_INCONSISTENT, -1, "" )
S ( LW_STATUS_VERIFY_REQUIRED, ERROR_MEDIA_CHANGED, -1, "" )
S ( LW_STATUS_EXTRANEOUS_INFORMATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RXACT_COMMIT_NECESSARY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_MORE_ENTRIES, ERROR_NO_MORE_ITEMS, -1, "" )
S ( LW_STATUS_FILEMARK_DETECTED, ERROR_FILEMARK_DETECTED, -1, "" )
S ( LW_STATUS_MEDIA_CHANGED, ERROR_MEDIA_CHANGED, -1, "" )
S ( LW_STATUS_BUS_RESET, ERROR_BUS_RESET, -1, "" )
S ( LW_STATUS_END_OF_MEDIA, ERROR_END_OF_MEDIA, -1, "" )
S ( LW_STATUS_BEGINNING_OF_MEDIA, ERROR_BEGINNING_OF_MEDIA, -1, "" )
S ( LW_STATUS_MEDIA_CHECK, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SETMARK_DETECTED, ERROR_SETMARK_DETECTED, -1, "" )
S ( LW_STATUS_NO_DATA_DETECTED, ERROR_NO_DATA_DETECTED, -1, "" )
S ( LW_STATUS_REDIRECTOR_HAS_OPEN_HANDLES, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SERVER_HAS_OPEN_HANDLES, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ALREADY_DISCONNECTED, NERR_ActiveConns, -1, "" )
S ( LW_STATUS_LONGJUMP, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CLEANER_CARTRIDGE_INSTALLED, ERROR_CLEANER_CARTRIDGE_INSTALLED, -1, "" )
S ( LW_STATUS_PLUGPLAY_QUERY_VETOED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_UNWIND_CONSOLIDATE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_REGISTRY_HIVE_RECOVERED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DLL_MIGHT_BE_INSECURE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DLL_MIGHT_BE_INCOMPATIBLE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_STOPPED_ON_SYMLINK, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DEVICE_REQUIRES_CLEANING, ERROR_DEVICE_REQUIRES_CLEANING, -1, "" )
S ( LW_STATUS_DEVICE_DOOR_OPEN, ERROR_DEVICE_DOOR_OPEN, -1, "" )
S ( LW_DBG_EXCEPTION_NOT_HANDLED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_UNSUCCESSFUL, ERROR_GEN_FAILURE, -1, "" )
S ( LW_STATUS_INFO_LENGTH_MISMATCH, ERROR_BAD_LENGTH, -1, "" )
S ( LW_STATUS_ACCESS_VIOLATION, ERROR_NOACCESS, -1, "" )
S ( LW_STATUS_IN_PAGE_ERROR, ERROR_SWAPERROR, -1, "" )
S ( LW_STATUS_PAGEFILE_QUOTA, ERROR_PAGEFILE_QUOTA, -1, "" )
S ( LW_STATUS_INVALID_HANDLE, ERROR_INVALID_HANDLE, EBADF, "" )
S ( LW_STATUS_BAD_INITIAL_STACK, ERROR_STACK_OVERFLOW, -1, "" )
S ( LW_STATUS_BAD_INITIAL_PC, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_INVALID_CID, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_TIMER_NOT_CANCELED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_SUCH_FILE, ERROR_FILE_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_SUCH_DEVICE, ERROR_FILE_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_DEVICE_REQUEST, ERROR_INVALID_FUNCTION, -1, "" )
S ( LW_STATUS_END_OF_FILE, ERROR_HANDLE_EOF, -1, "" )
S ( LW_STATUS_WRONG_VOLUME, ERROR_WRONG_DISK, -1, "" )
S ( LW_STATUS_NO_MEDIA_IN_DEVICE, ERROR_NOT_READY, -1, "" )
S ( LW_STATUS_UNRECOGNIZED_MEDIA, ERROR_UNRECOGNIZED_MEDIA, -1, "" )
S ( LW_STATUS_NONEXISTENT_SECTOR, ERROR_SECTOR_NOT_FOUND, -1, "" )
S ( LW_STATUS_MORE_PROCESSING_REQUIRED, ERROR_MORE_DATA, -1, "" )
S ( LW_STATUS_CONFLICTING_ADDRESSES, ERROR_INVALID_ADDRESS, -1, "" )
S ( LW_STATUS_NOT_MAPPED_VIEW, ERROR_INVALID_ADDRESS, -1, "" )
S ( LW_STATUS_UNABLE_TO_FREE_VM, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_UNABLE_TO_DELETE_SECTION, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_SYSTEM_SERVICE, ERROR_INVALID_FUNCTION, -1, "" )
S ( LW_STATUS_ILLEGAL_INSTRUCTION, -1073741795, -1, "" )
S ( LW_STATUS_INVALID_LOCK_SEQUENCE, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_INVALID_VIEW_SIZE, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_INVALID_FILE_FOR_SECTION, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_ALREADY_COMMITTED, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_BUFFER_TOO_SMALL, ERROR_INSUFFICIENT_BUFFER, -1, "" )
S ( LW_STATUS_OBJECT_TYPE_MISMATCH, ERROR_INVALID_HANDLE, -1, "" )
S ( LW_STATUS_NONCONTINUABLE_EXCEPTION, -1073741787, -1, "" )
S ( LW_STATUS_INVALID_DISPOSITION, -1073741786, -1, "" )
S ( LW_STATUS_UNWIND, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_BAD_STACK, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_UNWIND_TARGET, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NOT_LOCKED, ERROR_NOT_LOCKED, -1, "" )
S ( LW_STATUS_PARITY_ERROR, -1073741781, -1, "" )
S ( LW_STATUS_UNABLE_TO_DECOMMIT_VM, ERROR_INVALID_ADDRESS, -1, "" )
S ( LW_STATUS_NOT_COMMITTED, ERROR_INVALID_ADDRESS, -1, "" )
S ( LW_STATUS_INVALID_PORT_ATTRIBUTES, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PORT_MESSAGE_TOO_LONG, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_MIX, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_QUOTA_LOWER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DISK_CORRUPT_ERROR, ERROR_DISK_CORRUPT, -1, "" )
S ( LW_STATUS_OBJECT_NAME_INVALID, ERROR_INVALID_NAME, -1, "" )
S ( LW_STATUS_OBJECT_NAME_NOT_FOUND, ERROR_FILE_NOT_FOUND, -1, "" )
S ( LW_STATUS_OBJECT_NAME_COLLISION, ERROR_ALREADY_EXISTS, EEXIST, "" )
S ( LW_STATUS_PORT_DISCONNECTED, ERROR_INVALID_HANDLE, -1, "" )
S ( LW_STATUS_DEVICE_ALREADY_ATTACHED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_OBJECT_PATH_INVALID, ERROR_BAD_PATHNAME, -1, "" )
S ( LW_STATUS_OBJECT_PATH_NOT_FOUND, ERROR_PATH_NOT_FOUND, -1, "" )
S ( LW_STATUS_OBJECT_PATH_SYNTAX_BAD, ERROR_BAD_PATHNAME, -1, "" )
S ( LW_STATUS_DATA_OVERRUN, ERROR_IO_DEVICE, -1, "" )
S ( LW_STATUS_DATA_LATE_ERROR, ERROR_IO_DEVICE, -1, "" )
S ( LW_STATUS_DATA_ERROR, ERROR_CRC, -1, "" )
S ( LW_STATUS_CRC_ERROR, ERROR_CRC, -1, "" )
S ( LW_STATUS_SECTION_TOO_BIG, ERROR_NOT_ENOUGH_MEMORY, -1, "" )
S ( LW_STATUS_PORT_CONNECTION_REFUSED, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_INVALID_PORT_HANDLE, ERROR_INVALID_HANDLE, -1, "" )
S ( LW_STATUS_SHARING_VIOLATION, ERROR_SHARING_VIOLATION, -1, "" )
S ( LW_STATUS_QUOTA_EXCEEDED, ERROR_NOT_ENOUGH_QUOTA, -1, "Not enough quota is available" )
S ( LW_STATUS_INVALID_PAGE_PROTECTION, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_MUTANT_NOT_OWNED, ERROR_NOT_OWNER, -1, "" )
S ( LW_STATUS_SEMAPHORE_LIMIT_EXCEEDED, ERROR_TOO_MANY_POSTS, -1, "" )
S ( LW_STATUS_PORT_ALREADY_SET, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_SECTION_NOT_IMAGE, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_SUSPEND_COUNT_EXCEEDED, ERROR_SIGNAL_REFUSED, -1, "" )
S ( LW_STATUS_THREAD_IS_TERMINATING, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_BAD_WORKING_SET_LIMIT, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INCOMPATIBLE_FILE_MAP, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_SECTION_PROTECTION, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_EAS_NOT_SUPPORTED, ERROR_EAS_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_EA_TOO_LARGE, ERROR_EA_LIST_INCONSISTENT, -1, "" )
S ( LW_STATUS_NONEXISTENT_EA_ENTRY, ERROR_FILE_CORRUPT, -1, "" )
S ( LW_STATUS_NO_EAS_ON_FILE, ERROR_FILE_CORRUPT, -1, "" )
S ( LW_STATUS_EA_CORRUPT_ERROR, ERROR_FILE_CORRUPT, -1, "" )
S ( LW_STATUS_FILE_LOCK_CONFLICT, ERROR_LOCK_VIOLATION, -1, "" )
S ( LW_STATUS_LOCK_NOT_GRANTED, ERROR_LOCK_VIOLATION, -1, "" )
S ( LW_STATUS_DELETE_PENDING, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_CTL_FILE_NOT_SUPPORTED, ERROR_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_UNKNOWN_REVISION, ERROR_UNKNOWN_REVISION, -1, "" )
S ( LW_STATUS_REVISION_MISMATCH, ERROR_REVISION_MISMATCH, -1, "" )
S ( LW_STATUS_INVALID_OWNER, ERROR_INVALID_OWNER, -1, "" )
S ( LW_STATUS_INVALID_PRIMARY_GROUP, ERROR_INVALID_PRIMARY_GROUP, -1, "" )
S ( LW_STATUS_NO_IMPERSONATION_TOKEN, ERROR_NO_IMPERSONATION_TOKEN, -1, "" )
S ( LW_STATUS_CANT_DISABLE_MANDATORY, ERROR_CANT_DISABLE_MANDATORY, -1, "" )
S ( LW_STATUS_NO_LOGON_SERVERS, ERROR_NO_LOGON_SERVERS, -1, "" )
S ( LW_STATUS_NO_SUCH_LOGON_SESSION, ERROR_NO_SUCH_LOGON_SESSION, -1, "" )
S ( LW_STATUS_NO_SUCH_PRIVILEGE, ERROR_NO_SUCH_PRIVILEGE, -1, "" )
S ( LW_STATUS_PRIVILEGE_NOT_HELD, ERROR_PRIVILEGE_NOT_HELD, -1, "" )
S ( LW_STATUS_INVALID_ACCOUNT_NAME, ERROR_INVALID_ACCOUNT_NAME, -1, "" )
S ( LW_STATUS_USER_EXISTS, ERROR_USER_EXISTS, -1, "" )
S ( LW_STATUS_NO_SUCH_USER, ERROR_NO_SUCH_USER, -1, "" )
S ( LW_STATUS_GROUP_EXISTS, ERROR_GROUP_EXISTS, -1, "" )
S ( LW_STATUS_NO_SUCH_GROUP, ERROR_NO_SUCH_GROUP, -1, "" )
S ( LW_STATUS_MEMBER_IN_GROUP, ERROR_MEMBER_IN_GROUP, -1, "" )
S ( LW_STATUS_MEMBER_NOT_IN_GROUP, ERROR_MEMBER_NOT_IN_GROUP, -1, "" )
S ( LW_STATUS_LAST_ADMIN, ERROR_LAST_ADMIN, -1, "" )
S ( LW_STATUS_WRONG_PASSWORD, ERROR_INVALID_PASSWORD, -1, "" )
S ( LW_STATUS_ILL_FORMED_PASSWORD, ERROR_ILL_FORMED_PASSWORD, -1, "" )
S ( LW_STATUS_PASSWORD_RESTRICTION, ERROR_PASSWORD_RESTRICTION, -1, "Password does not meet requirements" )
S ( LW_STATUS_LOGON_FAILURE, ERROR_LOGON_FAILURE, -1, "" )
S ( LW_STATUS_ACCOUNT_RESTRICTION, ERROR_ACCOUNT_RESTRICTION, -1, "" )
S ( LW_STATUS_INVALID_LOGON_HOURS, ERROR_INVALID_LOGON_HOURS, -1, "" )
S ( LW_STATUS_INVALID_WORKSTATION, ERROR_INVALID_WORKSTATION, -1, "" )
S ( LW_STATUS_PASSWORD_EXPIRED, ERROR_PASSWORD_EXPIRED, -1, "" )
S ( LW_STATUS_ACCOUNT_DISABLED, ERROR_ACCOUNT_DISABLED, -1, "" )
S ( LW_STATUS_TOO_MANY_LUIDS_REQUESTED, ERROR_TOO_MANY_LUIDS_REQUESTED, -1, "" )
S ( LW_STATUS_LUIDS_EXHAUSTED, ERROR_LUIDS_EXHAUSTED, -1, "" )
S ( LW_STATUS_INVALID_SUB_AUTHORITY, ERROR_INVALID_SUB_AUTHORITY, -1, "" )
S ( LW_STATUS_INVALID_ACL, ERROR_INVALID_ACL, -1, "" )
S ( LW_STATUS_INVALID_SECURITY_DESCR, ERROR_INVALID_SECURITY_DESCR, -1, "" )
S ( LW_STATUS_PROCEDURE_NOT_FOUND, ERROR_PROC_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_IMAGE_FORMAT, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_NO_TOKEN, ERROR_NO_TOKEN, -1, "" )
S ( LW_STATUS_BAD_INHERITANCE_ACL, ERROR_BAD_INHERITANCE_ACL, -1, "" )
S ( LW_STATUS_RANGE_NOT_LOCKED, ERROR_NOT_LOCKED, -1, "" )
S ( LW_STATUS_DISK_FULL, ERROR_DISK_FULL, -1, "" )
S ( LW_STATUS_SERVER_DISABLED, ERROR_SERVER_DISABLED, -1, "" )
S ( LW_STATUS_SERVER_NOT_DISABLED, ERROR_SERVER_NOT_DISABLED, -1, "" )
S ( LW_STATUS_TOO_MANY_GUIDS_REQUESTED, ERROR_TOO_MANY_NAMES, -1, "" )
S ( LW_STATUS_GUIDS_EXHAUSTED, ERROR_NO_MORE_ITEMS, -1, "" )
S ( LW_STATUS_INVALID_ID_AUTHORITY, ERROR_INVALID_ID_AUTHORITY, -1, "" )
S ( LW_STATUS_AGENTS_EXHAUSTED, ERROR_NO_MORE_ITEMS, -1, "" )
S ( LW_STATUS_INVALID_VOLUME_LABEL, ERROR_LABEL_TOO_LONG, -1, "" )
S ( LW_STATUS_SECTION_NOT_EXTENDED, ERROR_OUTOFMEMORY, -1, "" )
S ( LW_STATUS_NOT_MAPPED_DATA, ERROR_INVALID_ADDRESS, -1, "" )
S ( LW_STATUS_RESOURCE_DATA_NOT_FOUND, ERROR_RESOURCE_DATA_NOT_FOUND, -1, "" )
S ( LW_STATUS_RESOURCE_TYPE_NOT_FOUND, ERROR_RESOURCE_TYPE_NOT_FOUND, -1, "" )
S ( LW_STATUS_RESOURCE_NAME_NOT_FOUND, ERROR_RESOURCE_NAME_NOT_FOUND, -1, "" )
S ( LW_STATUS_ARRAY_BOUNDS_EXCEEDED, -1073741684, -1, "" )
S ( LW_STATUS_FLOAT_DENORMAL_OPERAND, -1073741683, -1, "" )
S ( LW_STATUS_FLOAT_DIVIDE_BY_ZERO, -1073741682, -1, "" )
S ( LW_STATUS_FLOAT_INEXACT_RESULT, -1073741681, -1, "" )
S ( LW_STATUS_FLOAT_INVALID_OPERATION, -1073741680, -1, "" )
S ( LW_STATUS_FLOAT_OVERFLOW, -1073741679, -1, "" )
S ( LW_STATUS_FLOAT_STACK_CHECK, -1073741678, -1, "" )
S ( LW_STATUS_FLOAT_UNDERFLOW, -1073741677, -1, "" )
S ( LW_STATUS_INTEGER_DIVIDE_BY_ZERO, -1073741676, -1, "" )
S ( LW_STATUS_INTEGER_OVERFLOW, ERROR_ARITHMETIC_OVERFLOW, -1, "" )
S ( LW_STATUS_PRIVILEGED_INSTRUCTION, -1073741674, -1, "" )
S ( LW_STATUS_TOO_MANY_PAGING_FILES, ERROR_NOT_ENOUGH_MEMORY, -1, "" )
S ( LW_STATUS_FILE_INVALID, ERROR_FILE_INVALID, -1, "" )
S ( LW_STATUS_ALLOTTED_SPACE_EXCEEDED, ERROR_ALLOTTED_SPACE_EXCEEDED, -1, "" )
S ( LW_STATUS_DFS_EXIT_PATH_FOUND, ERROR_PATH_NOT_FOUND, -1, "" )
S ( LW_STATUS_DEVICE_DATA_ERROR, ERROR_CRC, -1, "" )
S ( LW_STATUS_DEVICE_NOT_CONNECTED, ERROR_DEVICE_NOT_CONNECTED, -1, "" )
S ( LW_STATUS_DEVICE_POWER_FAILURE, ERROR_NOT_READY, -1, "" )
S ( LW_STATUS_FREE_VM_NOT_AT_BASE, ERROR_INVALID_ADDRESS, -1, "" )
S ( LW_STATUS_MEMORY_NOT_ALLOCATED, ERROR_INVALID_ADDRESS, -1, "" )
S ( LW_STATUS_WORKING_SET_QUOTA, ERROR_WORKING_SET_QUOTA, -1, "" )
S ( LW_STATUS_MEDIA_WRITE_PROTECTED, ERROR_WRITE_PROTECT, -1, "" )
S ( LW_STATUS_DEVICE_NOT_READY, ERROR_NOT_READY, -1, "" )
S ( LW_STATUS_INVALID_GROUP_ATTRIBUTES, ERROR_INVALID_GROUP_ATTRIBUTES, -1, "" )
S ( LW_STATUS_BAD_IMPERSONATION_LEVEL, ERROR_BAD_IMPERSONATION_LEVEL, -1, "" )
S ( LW_STATUS_CANT_OPEN_ANONYMOUS, ERROR_CANT_OPEN_ANONYMOUS, -1, "" )
S ( LW_STATUS_BAD_VALIDATION_CLASS, ERROR_BAD_VALIDATION_CLASS, -1, "" )
S ( LW_STATUS_BAD_TOKEN_TYPE, ERROR_BAD_TOKEN_TYPE, -1, "" )
S ( LW_STATUS_BAD_MASTER_BOOT_RECORD, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INSTRUCTION_MISALIGNMENT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INSTANCE_NOT_AVAILABLE, ERROR_PIPE_BUSY, -1, "" )
S ( LW_STATUS_PIPE_NOT_AVAILABLE, ERROR_PIPE_BUSY, -1, "" )
S ( LW_STATUS_INVALID_PIPE_STATE, ERROR_BAD_PIPE, -1, "" )
S ( LW_STATUS_PIPE_BUSY, ERROR_PIPE_BUSY, -1, "" )
S ( LW_STATUS_ILLEGAL_FUNCTION, ERROR_INVALID_FUNCTION, -1, "" )
S ( LW_STATUS_PIPE_DISCONNECTED, ERROR_PIPE_NOT_CONNECTED, -1, "" )
S ( LW_STATUS_PIPE_CLOSING, ERROR_NO_DATA, -1, "" )
S ( LW_STATUS_PIPE_CONNECTED, ERROR_PIPE_CONNECTED, -1, "" )
S ( LW_STATUS_PIPE_LISTENING, ERROR_PIPE_LISTENING, -1, "" )
S ( LW_STATUS_INVALID_READ_MODE, ERROR_BAD_PIPE, -1, "" )
S ( LW_STATUS_IO_TIMEOUT, ERROR_SEM_TIMEOUT, -1, "" )
S ( LW_STATUS_FILE_FORCED_CLOSED, ERROR_HANDLE_EOF, -1, "" )
S ( LW_STATUS_PROFILING_NOT_STARTED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PROFILING_NOT_STOPPED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_COULD_NOT_INTERPRET, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FILE_IS_A_DIRECTORY, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_NOT_SUPPORTED, ERROR_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_REMOTE_NOT_LISTENING, ERROR_REM_NOT_LIST, -1, "" )
S ( LW_STATUS_DUPLICATE_NAME, ERROR_DUP_NAME, -1, "" )
S ( LW_STATUS_BAD_NETWORK_PATH, ERROR_BAD_NETPATH, -1, "" )
S ( LW_STATUS_NETWORK_BUSY, ERROR_NETWORK_BUSY, -1, "" )
S ( LW_STATUS_DEVICE_DOES_NOT_EXIST, ERROR_DEV_NOT_EXIST, -1, "" )
S ( LW_STATUS_TOO_MANY_COMMANDS, ERROR_TOO_MANY_CMDS, -1, "" )
S ( LW_STATUS_ADAPTER_HARDWARE_ERROR, ERROR_ADAP_HDW_ERR, -1, "" )
S ( LW_STATUS_INVALID_NETWORK_RESPONSE, ERROR_BAD_NET_RESP, EBADMSG, "" )
S ( LW_STATUS_UNEXPECTED_NETWORK_ERROR, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_BAD_REMOTE_ADAPTER, ERROR_BAD_REM_ADAP, -1, "" )
S ( LW_STATUS_PRINT_QUEUE_FULL, ERROR_PRINTQ_FULL, -1, "" )
S ( LW_STATUS_NO_SPOOL_SPACE, ERROR_NO_SPOOL_SPACE, -1, "" )
S ( LW_STATUS_PRINT_CANCELLED, ERROR_PRINT_CANCELLED, -1, "" )
S ( LW_STATUS_NETWORK_NAME_DELETED, ERROR_NETNAME_DELETED, -1, "" )
S ( LW_STATUS_NETWORK_ACCESS_DENIED, ERROR_NETWORK_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_BAD_DEVICE_TYPE, ERROR_BAD_DEV_TYPE, -1, "" )
S ( LW_STATUS_BAD_NETWORK_NAME, ERROR_BAD_NET_NAME, -1, "Network name not found." )
S ( LW_STATUS_TOO_MANY_NAMES, ERROR_TOO_MANY_NAMES, -1, "" )
S ( LW_STATUS_TOO_MANY_SESSIONS, ERROR_TOO_MANY_SESS, -1, "" )
S ( LW_STATUS_SHARING_PAUSED, ERROR_SHARING_PAUSED, -1, "" )
S ( LW_STATUS_REQUEST_NOT_ACCEPTED, ERROR_REQ_NOT_ACCEP, -1, "" )
S ( LW_STATUS_REDIRECTOR_PAUSED, ERROR_REDIR_PAUSED, -1, "" )
S ( LW_STATUS_NET_WRITE_FAULT, ERROR_NET_WRITE_FAULT, -1, "" )
S ( LW_STATUS_PROFILING_AT_LIMIT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NOT_SAME_DEVICE, ERROR_NOT_SAME_DEVICE, -1, "" )
S ( LW_STATUS_FILE_RENAMED, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_VIRTUAL_CIRCUIT_CLOSED, ERROR_VC_DISCONNECTED, -1, "" )
S ( LW_STATUS_NO_SECURITY_ON_OBJECT, ERROR_NO_SECURITY_ON_OBJECT, -1, "" )
S ( LW_STATUS_CANT_WAIT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PIPE_EMPTY, ERROR_NO_DATA, -1, "" )
S ( LW_STATUS_CANT_ACCESS_DOMAIN_INFO, ERROR_CANT_ACCESS_DOMAIN_INFO, -1, "" )
S ( LW_STATUS_CANT_TERMINATE_SELF, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_SERVER_STATE, ERROR_INVALID_SERVER_STATE, -1, "" )
S ( LW_STATUS_INVALID_DOMAIN_STATE, ERROR_INVALID_DOMAIN_STATE, -1, "" )
S ( LW_STATUS_INVALID_DOMAIN_ROLE, ERROR_INVALID_DOMAIN_ROLE, -1, "" )
S ( LW_STATUS_NO_SUCH_DOMAIN, ERROR_NO_SUCH_DOMAIN, -1, "" )
S ( LW_STATUS_DOMAIN_EXISTS, ERROR_DOMAIN_EXISTS, -1, "" )
S ( LW_STATUS_DOMAIN_LIMIT_EXCEEDED, ERROR_DOMAIN_LIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_OPLOCK_NOT_GRANTED, ERROR_OPLOCK_NOT_GRANTED, -1, "" )
S ( LW_STATUS_INVALID_OPLOCK_PROTOCOL, ERROR_INVALID_OPLOCK_PROTOCOL, -1, "" )
S ( LW_STATUS_INTERNAL_DB_CORRUPTION, ERROR_INTERNAL_DB_CORRUPTION, -1, "" )
S ( LW_STATUS_INTERNAL_ERROR, ERROR_INTERNAL_ERROR, -1, "" )
S ( LW_STATUS_GENERIC_NOT_MAPPED, ERROR_GENERIC_NOT_MAPPED, -1, "" )
S ( LW_STATUS_BAD_DESCRIPTOR_FORMAT, ERROR_BAD_DESCRIPTOR_FORMAT, -1, "" )
S ( LW_STATUS_INVALID_USER_BUFFER, ERROR_INVALID_USER_BUFFER, -1, "" )
S ( LW_STATUS_UNEXPECTED_IO_ERROR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_UNEXPECTED_MM_CREATE_ERR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_UNEXPECTED_MM_MAP_ERROR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_UNEXPECTED_MM_EXTEND_ERR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NOT_LOGON_PROCESS, ERROR_NOT_LOGON_PROCESS, -1, "" )
S ( LW_STATUS_LOGON_SESSION_EXISTS, ERROR_LOGON_SESSION_EXISTS, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_1, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_2, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_3, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_4, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_5, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_6, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_7, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_8, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_9, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_10, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_11, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_INVALID_PARAMETER_12, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_REDIRECTOR_NOT_STARTED, ERROR_PATH_NOT_FOUND, -1, "" )
S ( LW_STATUS_REDIRECTOR_STARTED, ERROR_SERVICE_ALREADY_RUNNING, -1, "" )
S ( LW_STATUS_STACK_OVERFLOW, ERROR_STACK_OVERFLOW, -1, "" )
S ( LW_STATUS_NO_SUCH_PACKAGE, ERROR_NO_SUCH_PACKAGE, -1, "" )
S ( LW_STATUS_BAD_FUNCTION_TABLE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_VARIABLE_NOT_FOUND, ERROR_ENVVAR_NOT_FOUND, -1, "" )
S ( LW_STATUS_DIRECTORY_NOT_EMPTY, ERROR_DIR_NOT_EMPTY, -1, "" )
S ( LW_STATUS_FILE_CORRUPT_ERROR, ERROR_FILE_CORRUPT, -1, "" )
S ( LW_STATUS_NOT_A_DIRECTORY, ERROR_DIRECTORY, -1, "" )
S ( LW_STATUS_BAD_LOGON_SESSION_STATE, ERROR_BAD_LOGON_SESSION_STATE, -1, "" )
S ( LW_STATUS_LOGON_SESSION_COLLISION, ERROR_LOGON_SESSION_COLLISION, -1, "" )
S ( LW_STATUS_NAME_TOO_LONG, ERROR_FILENAME_EXCED_RANGE, -1, "" )
S ( LW_STATUS_FILES_OPEN, NERR_OpenFiles, -1, "" )
S ( LW_STATUS_CONNECTION_IN_USE, NERR_DevInUse, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PROCESS_IS_TERMINATING, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_INVALID_LOGON_TYPE, ERROR_INVALID_LOGON_TYPE, -1, "" )
S ( LW_STATUS_NO_GUID_TRANSLATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CANNOT_IMPERSONATE, ERROR_CANNOT_IMPERSONATE, -1, "" )
S ( LW_STATUS_IMAGE_ALREADY_LOADED, ERROR_SERVICE_ALREADY_RUNNING, -1, "" )
S ( LW_STATUS_ABIOS_NOT_PRESENT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ABIOS_LID_NOT_EXIST, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ABIOS_LID_ALREADY_OWNED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ABIOS_NOT_LID_OWNER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ABIOS_INVALID_COMMAND, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ABIOS_INVALID_LID, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ABIOS_INVALID_SELECTOR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_LDT, ERROR_INVALID_THREAD_ID, -1, "" )
S ( LW_STATUS_INVALID_LDT_SIZE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_LDT_OFFSET, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_LDT_DESCRIPTOR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_IMAGE_NE_FORMAT, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_RXACT_INVALID_STATE, ERROR_RXACT_INVALID_STATE, -1, "" )
S ( LW_STATUS_RXACT_COMMIT_FAILURE, ERROR_RXACT_COMMIT_FAILURE, -1, "" )
S ( LW_STATUS_MAPPED_FILE_SIZE_ZERO, ERROR_FILE_INVALID, -1, "" )
S ( LW_STATUS_TOO_MANY_OPENED_FILES, ERROR_TOO_MANY_OPEN_FILES, EMFILE, "" )
S ( LW_STATUS_CANCELLED, ERROR_OPERATION_ABORTED, -1, "" )
S ( LW_STATUS_CANNOT_DELETE, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_INVALID_COMPUTER_NAME, ERROR_INVALID_COMPUTERNAME, -1, "" )
S ( LW_STATUS_FILE_DELETED, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_SPECIAL_GROUP, ERROR_SPECIAL_GROUP, -1, "" )
S ( LW_STATUS_SPECIAL_USER, ERROR_SPECIAL_USER, -1, "" )
S ( LW_STATUS_MEMBERS_PRIMARY_GROUP, ERROR_MEMBERS_PRIMARY_GROUP, -1, "Group is a primary group of one or more users" )
S ( LW_STATUS_FILE_CLOSED, ERROR_INVALID_HANDLE, -1, "" )
S ( LW_STATUS_TOO_MANY_THREADS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_THREAD_NOT_IN_PROCESS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_TOKEN_ALREADY_IN_USE, ERROR_TOKEN_ALREADY_IN_USE, -1, "" )
S ( LW_STATUS_PAGEFILE_QUOTA_EXCEEDED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_COMMITMENT_LIMIT, ERROR_COMMITMENT_LIMIT, -1, "" )
S ( LW_STATUS_INVALID_IMAGE_LE_FORMAT, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_INVALID_IMAGE_NOT_MZ, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_INVALID_IMAGE_PROTECT, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_INVALID_IMAGE_WIN_16, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_LOGON_SERVER_CONFLICT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_TIME_DIFFERENCE_AT_DC, ERROR_TIME_SKEW, -1, "" )
S ( LW_STATUS_SYNCHRONIZATION_REQUIRED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DLL_NOT_FOUND, ERROR_MOD_NOT_FOUND, -1, "" )
S ( LW_STATUS_OPEN_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_IO_PRIVILEGE_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ORDINAL_NOT_FOUND, ERROR_INVALID_ORDINAL, -1, "" )
S ( LW_STATUS_ENTRYPOINT_NOT_FOUND, ERROR_PROC_NOT_FOUND, -1, "" )
S ( LW_STATUS_CONTROL_C_EXIT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_LOCAL_DISCONNECT, ERROR_NETNAME_DELETED, -1, "" )
S ( LW_STATUS_REMOTE_DISCONNECT, ERROR_NETNAME_DELETED, -1, "" )
S ( LW_STATUS_REMOTE_RESOURCES, ERROR_REM_NOT_LIST, -1, "" )
S ( LW_STATUS_LINK_FAILED, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_LINK_TIMEOUT, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_INVALID_CONNECTION, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_INVALID_ADDRESS, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_DLL_INIT_FAILED, ERROR_DLL_INIT_FAILED, -1, "" )
S ( LW_STATUS_MISSING_SYSTEMFILE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_APP_INIT_FAILURE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PAGEFILE_CREATE_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_PAGEFILE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_LEVEL, ERROR_INVALID_LEVEL, -1, "" )
S ( LW_STATUS_WRONG_PASSWORD_CORE, ERROR_INVALID_PASSWORD, -1, "" )
S ( LW_STATUS_ILLEGAL_FLOAT_CONTEXT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PIPE_BROKEN, ERROR_BROKEN_PIPE, -1, "" )
S ( LW_STATUS_REGISTRY_CORRUPT, ERROR_BADDB, -1, "" )
S ( LW_STATUS_REGISTRY_IO_FAILED, ERROR_REGISTRY_IO_FAILED, -1, "" )
S ( LW_STATUS_NO_EVENT_PAIR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_UNRECOGNIZED_VOLUME, ERROR_UNRECOGNIZED_VOLUME, -1, "" )
S ( LW_STATUS_SERIAL_NO_DEVICE_INITED, ERROR_SERIAL_NO_DEVICE, -1, "" )
S ( LW_STATUS_NO_SUCH_ALIAS, ERROR_NO_SUCH_ALIAS, -1, "No such local group" )
S ( LW_STATUS_MEMBER_NOT_IN_ALIAS, ERROR_MEMBER_NOT_IN_ALIAS, -1, "User is not a member of local group" )
S ( LW_STATUS_MEMBER_IN_ALIAS, ERROR_MEMBER_IN_ALIAS, -1, "User is already in local group" )
S ( LW_STATUS_ALIAS_EXISTS, ERROR_ALIAS_EXISTS, -1, "Local group exists" )
S ( LW_STATUS_LOGON_NOT_GRANTED, ERROR_LOGON_NOT_GRANTED, -1, "" )
S ( LW_STATUS_TOO_MANY_SECRETS, ERROR_TOO_MANY_SECRETS, -1, "" )
S ( LW_STATUS_SECRET_TOO_LONG, ERROR_SECRET_TOO_LONG, -1, "" )
S ( LW_STATUS_INTERNAL_DB_ERROR, ERROR_INTERNAL_DB_ERROR, -1, "" )
S ( LW_STATUS_FULLSCREEN_MODE, ERROR_FULLSCREEN_MODE, -1, "" )
S ( LW_STATUS_TOO_MANY_CONTEXT_IDS, ERROR_TOO_MANY_CONTEXT_IDS, -1, "" )
S ( LW_STATUS_LOGON_TYPE_NOT_GRANTED, ERROR_LOGON_TYPE_NOT_GRANTED, -1, "" )
S ( LW_STATUS_NOT_REGISTRY_FILE, ERROR_NOT_REGISTRY_FILE, -1, "" )
S ( LW_STATUS_NT_CROSS_ENCRYPTION_REQUIRED, ERROR_NT_CROSS_ENCRYPTION_REQUIRED, -1, "" )
S ( LW_STATUS_DOMAIN_CTRLR_CONFIG_ERROR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FT_MISSING_MEMBER, ERROR_IO_DEVICE, -1, "" )
S ( LW_STATUS_ILL_FORMED_SERVICE_ENTRY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ILLEGAL_CHARACTER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_UNMAPPABLE_CHARACTER, ERROR_NO_UNICODE_TRANSLATION, -1, "" )
S ( LW_STATUS_UNDEFINED_CHARACTER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FLOPPY_VOLUME, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FLOPPY_ID_MARK_NOT_FOUND, ERROR_FLOPPY_ID_MARK_NOT_FOUND, -1, "" )
S ( LW_STATUS_FLOPPY_WRONG_CYLINDER, ERROR_FLOPPY_WRONG_CYLINDER, -1, "" )
S ( LW_STATUS_FLOPPY_UNKNOWN_ERROR, ERROR_FLOPPY_UNKNOWN_ERROR, -1, "" )
S ( LW_STATUS_FLOPPY_BAD_REGISTERS, ERROR_FLOPPY_BAD_REGISTERS, -1, "" )
S ( LW_STATUS_DISK_RECALIBRATE_FAILED, ERROR_DISK_RECALIBRATE_FAILED, -1, "" )
S ( LW_STATUS_DISK_OPERATION_FAILED, ERROR_DISK_OPERATION_FAILED, -1, "" )
S ( LW_STATUS_DISK_RESET_FAILED, ERROR_DISK_RESET_FAILED, -1, "" )
S ( LW_STATUS_SHARED_IRQ_BUSY, ERROR_IRQ_BUSY, -1, "" )
S ( LW_STATUS_FT_ORPHANING, ERROR_IO_DEVICE, -1, "" )
S ( LW_STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PARTITION_FAILURE, ERROR_PARTITION_FAILURE, -1, "" )
S ( LW_STATUS_INVALID_BLOCK_LENGTH, ERROR_INVALID_BLOCK_LENGTH, -1, "" )
S ( LW_STATUS_DEVICE_NOT_PARTITIONED, ERROR_DEVICE_NOT_PARTITIONED, -1, "" )
S ( LW_STATUS_UNABLE_TO_LOCK_MEDIA, ERROR_UNABLE_TO_LOCK_MEDIA, -1, "" )
S ( LW_STATUS_UNABLE_TO_UNLOAD_MEDIA, ERROR_UNABLE_TO_UNLOAD_MEDIA, -1, "" )
S ( LW_STATUS_EOM_OVERFLOW, ERROR_EOM_OVERFLOW, -1, "" )
S ( LW_STATUS_NO_MEDIA, ERROR_NO_MEDIA_IN_DRIVE, -1, "" )
S ( LW_STATUS_NO_SUCH_MEMBER, ERROR_NO_SUCH_MEMBER, -1, "" )
S ( LW_STATUS_INVALID_MEMBER, ERROR_INVALID_MEMBER, -1, "" )
S ( LW_STATUS_KEY_DELETED, ERROR_KEY_DELETED, -1, "" )
S ( LW_STATUS_NO_LOG_SPACE, ERROR_NO_LOG_SPACE, -1, "" )
S ( LW_STATUS_TOO_MANY_SIDS, ERROR_TOO_MANY_SIDS, -1, "" )
S ( LW_STATUS_LM_CROSS_ENCRYPTION_REQUIRED, ERROR_LM_CROSS_ENCRYPTION_REQUIRED, -1, "" )
S ( LW_STATUS_KEY_HAS_CHILDREN, ERROR_KEY_HAS_CHILDREN, -1, "" )
S ( LW_STATUS_CHILD_MUST_BE_VOLATILE, ERROR_CHILD_MUST_BE_VOLATILE, -1, "" )
S ( LW_STATUS_DEVICE_CONFIGURATION_ERROR, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_DRIVER_INTERNAL_ERROR, ERROR_IO_DEVICE, -1, "" )
S ( LW_STATUS_INVALID_DEVICE_STATE, ERROR_BAD_COMMAND, -1, "" )
S ( LW_STATUS_IO_DEVICE_ERROR, ERROR_IO_DEVICE, -1, "" )
S ( LW_STATUS_DEVICE_PROTOCOL_ERROR, ERROR_IO_DEVICE, -1, "" )
S ( LW_STATUS_BACKUP_CONTROLLER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_LOG_FILE_FULL, ERROR_LOG_FILE_FULL, -1, "" )
S ( LW_STATUS_TOO_LATE, ERROR_WRITE_PROTECT, -1, "" )
S ( LW_STATUS_NO_TRUST_LSA_SECRET, ERROR_NO_TRUST_LSA_SECRET, -1, "" )
S ( LW_STATUS_NO_TRUST_SAM_ACCOUNT, ERROR_NO_TRUST_SAM_ACCOUNT, -1, "" )
S ( LW_STATUS_TRUSTED_DOMAIN_FAILURE, ERROR_TRUSTED_DOMAIN_FAILURE, -1, "" )
S ( LW_STATUS_TRUSTED_RELATIONSHIP_FAILURE, ERROR_TRUSTED_RELATIONSHIP_FAILURE, -1, "" )
S ( LW_STATUS_EVENTLOG_FILE_CORRUPT, ERROR_EVENTLOG_FILE_CORRUPT, -1, "" )
S ( LW_STATUS_EVENTLOG_CANT_START, ERROR_EVENTLOG_CANT_START, -1, "" )
S ( LW_STATUS_TRUST_FAILURE, ERROR_TRUST_FAILURE, -1, "" )
S ( LW_STATUS_MUTANT_LIMIT_EXCEEDED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NETLOGON_NOT_STARTED, ERROR_NETLOGON_NOT_STARTED, -1, "" )
S ( LW_STATUS_ACCOUNT_EXPIRED, ERROR_ACCOUNT_EXPIRED, -1, "" )
S ( LW_STATUS_POSSIBLE_DEADLOCK, ERROR_POSSIBLE_DEADLOCK, -1, "" )
S ( LW_STATUS_NETWORK_CREDENTIAL_CONFLICT, ERROR_SESSION_CREDENTIAL_CONFLICT, -1, "" )
S ( LW_STATUS_REMOTE_SESSION_LIMIT, ERROR_REMOTE_SESSION_LIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_EVENTLOG_FILE_CHANGED, ERROR_EVENTLOG_FILE_CHANGED, -1, "" )
S ( LW_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT, ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT, -1, "" )
S ( LW_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT, ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT, -1, "" )
S ( LW_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT, ERROR_NOLOGON_SERVER_TRUST_ACCOUNT, -1, "" )
S ( LW_STATUS_DOMAIN_TRUST_INCONSISTENT, ERROR_DOMAIN_TRUST_INCONSISTENT, -1, "" )
S ( LW_STATUS_FS_DRIVER_REQUIRED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_IMAGE_ALREADY_LOADED_AS_DLL, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NETWORK_OPEN_RESTRICTION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_USER_SESSION_KEY, ERROR_NO_USER_SESSION_KEY, -1, "" )
S ( LW_STATUS_USER_SESSION_DELETED, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_RESOURCE_LANG_NOT_FOUND, ERROR_RESOURCE_LANG_NOT_FOUND, -1, "" )
S ( LW_STATUS_INSUFF_SERVER_RESOURCES, ERROR_NOT_ENOUGH_SERVER_MEMORY, -1, "" )
S ( LW_STATUS_INVALID_BUFFER_SIZE, ERROR_INVALID_USER_BUFFER, EFAULT, "" )
S ( LW_STATUS_INVALID_ADDRESS_COMPONENT, ERROR_INVALID_NETNAME, -1, "" )
S ( LW_STATUS_INVALID_ADDRESS_WILDCARD, ERROR_INVALID_NETNAME, -1, "" )
S ( LW_STATUS_TOO_MANY_ADDRESSES, ERROR_TOO_MANY_NAMES, -1, "" )
S ( LW_STATUS_ADDRESS_ALREADY_EXISTS, ERROR_DUP_NAME, -1, "" )
S ( LW_STATUS_ADDRESS_CLOSED, ERROR_NETNAME_DELETED, -1, "" )
S ( LW_STATUS_CONNECTION_DISCONNECTED, ERROR_NETNAME_DELETED, -1, "" )
S ( LW_STATUS_CONNECTION_RESET, ERROR_NETNAME_DELETED, -1, "" )
S ( LW_STATUS_TOO_MANY_NODES, ERROR_TOO_MANY_NAMES, -1, "" )
S ( LW_STATUS_TRANSACTION_ABORTED, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_TRANSACTION_TIMED_OUT, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_TRANSACTION_NO_RELEASE, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_TRANSACTION_NO_MATCH, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_TRANSACTION_RESPONDED, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_TRANSACTION_INVALID_ID, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_TRANSACTION_INVALID_TYPE, ERROR_UNEXP_NET_ERR, -1, "" )
S ( LW_STATUS_NOT_SERVER_SESSION, ERROR_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_NOT_CLIENT_SESSION, ERROR_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_CANNOT_LOAD_REGISTRY_FILE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DEBUG_ATTACH_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SYSTEM_PROCESS_TERMINATED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DATA_NOT_ACCEPTED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_BROWSER_SERVERS_FOUND, ERROR_NO_BROWSER_SERVERS_FOUND, -1, "" )
S ( LW_STATUS_VDM_HARD_ERROR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DRIVER_CANCEL_TIMEOUT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_REPLY_MESSAGE_MISMATCH, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_MAPPED_ALIGNMENT, ERROR_MAPPED_ALIGNMENT, -1, "" )
S ( LW_STATUS_IMAGE_CHECKSUM_MISMATCH, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_LOST_WRITEBEHIND_DATA, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CLIENT_SERVER_PARAMETERS_INVALID, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PASSWORD_MUST_CHANGE, ERROR_PASSWORD_MUST_CHANGE, -1, "" )
S ( LW_STATUS_NOT_FOUND, ERROR_NOT_FOUND, -1, "" )
S ( LW_STATUS_NOT_TINY_STREAM, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RECOVERY_FAILURE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_STACK_OVERFLOW_READ, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FAIL_CHECK, ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_DUPLICATE_OBJECTID, -1073741270, -1, "" )
S ( LW_STATUS_OBJECTID_EXISTS, -1073741269, -1, "" )
S ( LW_STATUS_CONVERT_TO_LARGE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RETRY, ERROR_RETRY, EAGAIN, "The request needs to be retried" )
S ( LW_STATUS_FOUND_OUT_OF_SCOPE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ALLOCATE_BUCKET, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PROPSET_NOT_FOUND, ERROR_SET_NOT_FOUND, -1, "" )
S ( LW_STATUS_MARSHALL_OVERFLOW, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_VARIANT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DOMAIN_CONTROLLER_NOT_FOUND, ERROR_DOMAIN_CONTROLLER_NOT_FOUND, -1, "" )
S ( LW_STATUS_ACCOUNT_LOCKED_OUT, ERROR_ACCOUNT_LOCKED_OUT, -1, "" )
S ( LW_STATUS_HANDLE_NOT_CLOSABLE, ERROR_INVALID_HANDLE, -1, "" )
S ( LW_STATUS_GRACEFUL_DISCONNECT, ERROR_GRACEFUL_DISCONNECT, -1, "" )
S ( LW_STATUS_ADDRESS_ALREADY_ASSOCIATED, ERROR_ADDRESS_ALREADY_ASSOCIATED, -1, "" )
S ( LW_STATUS_ADDRESS_NOT_ASSOCIATED, ERROR_ADDRESS_NOT_ASSOCIATED, -1, "" )
S ( LW_STATUS_CONNECTION_INVALID, ERROR_CONNECTION_INVALID, -1, "" )
S ( LW_STATUS_CONNECTION_ACTIVE, ERROR_CONNECTION_ACTIVE, -1, "" )
S ( LW_STATUS_NETWORK_UNREACHABLE, ERROR_NETWORK_UNREACHABLE, -1, "" )
S ( LW_STATUS_HOST_UNREACHABLE, ERROR_HOST_UNREACHABLE, -1, "" )
S ( LW_STATUS_PROTOCOL_UNREACHABLE, ERROR_PROTOCOL_UNREACHABLE, -1, "" )
S ( LW_STATUS_PORT_UNREACHABLE, ERROR_PORT_UNREACHABLE, -1, "" )
S ( LW_STATUS_REQUEST_ABORTED, ERROR_REQUEST_ABORTED, -1, "" )
S ( LW_STATUS_CONNECTION_ABORTED, ERROR_CONNECTION_ABORTED, -1, "" )
S ( LW_STATUS_BAD_COMPRESSION_BUFFER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_USER_MAPPED_FILE, ERROR_USER_MAPPED_FILE, -1, "" )
S ( LW_STATUS_AUDIT_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_TIMER_RESOLUTION_NOT_SET, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CONNECTION_COUNT_LIMIT, ERROR_CONNECTION_COUNT_LIMIT, -1, "" )
S ( LW_STATUS_LOGIN_TIME_RESTRICTION, ERROR_LOGIN_TIME_RESTRICTION, -1, "" )
S ( LW_STATUS_LOGIN_WKSTA_RESTRICTION, ERROR_LOGIN_WKSTA_RESTRICTION, -1, "" )
S ( LW_STATUS_IMAGE_MP_UP_MISMATCH, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_INSUFFICIENT_LOGON_INFO, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_BAD_DLL_ENTRYPOINT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_BAD_SERVICE_ENTRYPOINT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_LPC_REPLY_LOST, ERROR_INTERNAL_ERROR, -1, "" )
S ( LW_STATUS_IP_ADDRESS_CONFLICT1, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_IP_ADDRESS_CONFLICT2, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_REGISTRY_QUOTA_LIMIT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PATH_NOT_COVERED, ERROR_HOST_UNREACHABLE, -1, "" )
S ( LW_STATUS_NO_CALLBACK_ACTIVE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_LICENSE_QUOTA_EXCEEDED, ERROR_LICENSE_QUOTA_EXCEEDED, -1, "" )
S ( LW_STATUS_PWD_TOO_SHORT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PWD_TOO_RECENT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PWD_HISTORY_CONFLICT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PLUGPLAY_NO_DEVICE, ERROR_SERVICE_DISABLED, -1, "" )
S ( LW_STATUS_UNSUPPORTED_COMPRESSION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_HW_PROFILE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_PLUGPLAY_DEVICE_PATH, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DRIVER_ORDINAL_NOT_FOUND, ERROR_INVALID_ORDINAL, -1, "" )
S ( LW_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND, ERROR_PROC_NOT_FOUND, -1, "" )
S ( LW_STATUS_RESOURCE_NOT_OWNED, ERROR_NOT_OWNER, -1, "" )
S ( LW_STATUS_TOO_MANY_LINKS, ERROR_TOO_MANY_LINKS, -1, "" )
S ( LW_STATUS_QUOTA_LIST_INCONSISTENT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FILE_IS_OFFLINE, ERROR_FILE_OFFLINE, -1, "" )
S ( LW_STATUS_EVALUATION_EXPIRATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ILLEGAL_DLL_RELOCATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_LICENSE_VIOLATION, ERROR_CTX_LICENSE_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_DLL_INIT_FAILED_LOGOFF, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DRIVER_UNABLE_TO_LOAD, ERROR_BAD_DRIVER, -1, "" )
S ( LW_STATUS_DFS_UNAVAILABLE, ERROR_CONNECTION_UNAVAIL, -1, "" )
S ( LW_STATUS_VOLUME_DISMOUNTED, ERROR_NOT_READY, -1, "" )
S ( LW_STATUS_WX86_INTERNAL_ERROR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WX86_FLOAT_STACK_CHECK, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_VALIDATE_CONTINUE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_MATCH, ERROR_NO_MATCH, -1, "" )
S ( LW_STATUS_NO_MORE_MATCHES, ERROR_NO_MORE_MATCHES, -1, "No more find results match query" )
S ( LW_STATUS_NOT_A_REPARSE_POINT, ERROR_NOT_A_REPARSE_POINT, -1, "" )
S ( LW_STATUS_IO_REPARSE_TAG_INVALID, ERROR_REPARSE_TAG_INVALID, -1, "" )
S ( LW_STATUS_IO_REPARSE_TAG_MISMATCH, ERROR_REPARSE_TAG_MISMATCH, -1, "" )
S ( LW_STATUS_IO_REPARSE_DATA_INVALID, ERROR_INVALID_REPARSE_DATA, -1, "" )
S ( LW_STATUS_IO_REPARSE_TAG_NOT_HANDLED, ERROR_CANT_ACCESS_FILE, -1, "" )
S ( LW_STATUS_REPARSE_POINT_NOT_RESOLVED, ERROR_CANT_RESOLVE_FILENAME, -1, "" )
S ( LW_STATUS_DIRECTORY_IS_A_REPARSE_POINT, ERROR_BAD_PATHNAME, -1, "" )
S ( LW_STATUS_RANGE_LIST_CONFLICT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SOURCE_ELEMENT_EMPTY, ERROR_SOURCE_ELEMENT_EMPTY, -1, "" )
S ( LW_STATUS_DESTINATION_ELEMENT_FULL, ERROR_DESTINATION_ELEMENT_FULL, -1, "" )
S ( LW_STATUS_ILLEGAL_ELEMENT_ADDRESS, ERROR_ILLEGAL_ELEMENT_ADDRESS, -1, "" )
S ( LW_STATUS_MAGAZINE_NOT_PRESENT, ERROR_MAGAZINE_NOT_PRESENT, -1, "" )
S ( LW_STATUS_REINITIALIZATION_NEEDED, ERROR_DEVICE_REINITIALIZATION_NEEDED, -1, "" )
S ( LW_STATUS_ENCRYPTION_FAILED, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_DECRYPTION_FAILED, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_RANGE_NOT_FOUND, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_RECOVERY_POLICY, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_NO_EFS, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_WRONG_EFS, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_NO_USER_KEYS, ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_FILE_NOT_ENCRYPTED, ERROR_FILE_NOT_ENCRYPTED, -1, "" )
S ( LW_STATUS_NOT_EXPORT_FORMAT, ERROR_NOT_EXPORT_FORMAT, -1, "" )
S ( LW_STATUS_FILE_ENCRYPTED, ERROR_FILE_ENCRYPTED, -1, "" )
S ( LW_STATUS_WMI_GUID_NOT_FOUND, ERROR_WMI_GUID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WMI_INSTANCE_NOT_FOUND, ERROR_WMI_INSTANCE_NOT_FOUND, -1, "" )
S ( LW_STATUS_WMI_ITEMID_NOT_FOUND, ERROR_WMI_ITEMID_NOT_FOUND, -1, "" )
S ( LW_STATUS_WMI_TRY_AGAIN, ERROR_WMI_TRY_AGAIN, -1, "" )
S ( LW_STATUS_SHARED_POLICY, ERROR_SHARED_POLICY, -1, "" )
S ( LW_STATUS_POLICY_OBJECT_NOT_FOUND, ERROR_POLICY_OBJECT_NOT_FOUND, -1, "" )
S ( LW_STATUS_POLICY_ONLY_IN_DS, ERROR_POLICY_ONLY_IN_DS, -1, "" )
S ( LW_STATUS_VOLUME_NOT_UPGRADED, ERROR_INVALID_FUNCTION, -1, "" )
S ( LW_STATUS_REMOTE_STORAGE_NOT_ACTIVE, ERROR_REMOTE_STORAGE_NOT_ACTIVE, -1, "" )
S ( LW_STATUS_REMOTE_STORAGE_MEDIA_ERROR, ERROR_REMOTE_STORAGE_MEDIA_ERROR, -1, "" )
S ( LW_STATUS_NO_TRACKING_SERVICE, ERROR_NO_TRACKING_SERVICE, -1, "" )
S ( LW_STATUS_SERVER_SID_MISMATCH, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DS_NO_ATTRIBUTE_OR_VALUE, ERROR_DS_NO_ATTRIBUTE_OR_VALUE, -1, "" )
S ( LW_STATUS_DS_INVALID_ATTRIBUTE_SYNTAX, ERROR_DS_INVALID_ATTRIBUTE_SYNTAX, -1, "" )
S ( LW_STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED, ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED, -1, "" )
S ( LW_STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS, ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS, -1, "" )
S ( LW_STATUS_DS_BUSY, ERROR_DS_BUSY, -1, "" )
S ( LW_STATUS_DS_UNAVAILABLE, ERROR_DS_UNAVAILABLE, -1, "" )
S ( LW_STATUS_DS_NO_RIDS_ALLOCATED, ERROR_DS_NO_RIDS_ALLOCATED, -1, "" )
S ( LW_STATUS_DS_NO_MORE_RIDS, ERROR_DS_NO_MORE_RIDS, -1, "" )
S ( LW_STATUS_DS_INCORRECT_ROLE_OWNER, ERROR_DS_INCORRECT_ROLE_OWNER, -1, "" )
S ( LW_STATUS_DS_RIDMGR_INIT_ERROR, ERROR_DS_RIDMGR_INIT_ERROR, -1, "" )
S ( LW_STATUS_DS_OBJ_CLASS_VIOLATION, ERROR_DS_OBJ_CLASS_VIOLATION, -1, "" )
S ( LW_STATUS_DS_CANT_ON_NON_LEAF, ERROR_DS_CANT_ON_NON_LEAF, -1, "" )
S ( LW_STATUS_DS_CANT_ON_RDN, ERROR_DS_CANT_ON_RDN, -1, "" )
S ( LW_STATUS_DS_CANT_MOD_OBJ_CLASS, ERROR_DS_CANT_MOD_OBJ_CLASS, -1, "" )
S ( LW_STATUS_DS_CROSS_DOM_MOVE_FAILED, ERROR_DS_CROSS_DOM_MOVE_ERROR, -1, "" )
S ( LW_STATUS_DS_GC_NOT_AVAILABLE, ERROR_DS_GC_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_DIRECTORY_SERVICE_REQUIRED, ERROR_DS_DS_REQUIRED, -1, "" )
S ( LW_STATUS_REPARSE_ATTRIBUTE_CONFLICT, ERROR_REPARSE_ATTRIBUTE_CONFLICT, -1, "" )
S ( LW_STATUS_CANT_ENABLE_DENY_ONLY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FLOAT_MULTIPLE_FAULTS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FLOAT_MULTIPLE_TRAPS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DEVICE_REMOVED, ERROR_DEVICE_REMOVED, -1, "" )
S ( LW_STATUS_JOURNAL_DELETE_IN_PROGRESS, ERROR_JOURNAL_DELETE_IN_PROGRESS, -1, "" )
S ( LW_STATUS_JOURNAL_NOT_ACTIVE, ERROR_JOURNAL_NOT_ACTIVE, -1, "" )
S ( LW_STATUS_NOINTERFACE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DS_ADMIN_LIMIT_EXCEEDED, ERROR_DS_ADMIN_LIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_DRIVER_FAILED_SLEEP, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_MUTUAL_AUTHENTICATION_FAILED, ERROR_MUTUAL_AUTH_FAILED, -1, "" )
S ( LW_STATUS_CORRUPT_SYSTEM_FILE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DATATYPE_MISALIGNMENT_ERROR, ERROR_NOACCESS, -1, "" )
S ( LW_STATUS_WMI_READ_ONLY, ERROR_WMI_READ_ONLY, -1, "" )
S ( LW_STATUS_WMI_SET_FAILURE, ERROR_WMI_SET_FAILURE, -1, "" )
S ( LW_STATUS_COMMITMENT_MINIMUM, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_REG_NAT_CONSUMPTION, ERROR_REG_NAT_CONSUMPTION, -1, "" )
S ( LW_STATUS_TRANSPORT_FULL, ERROR_TRANSPORT_FULL, -1, "" )
S ( LW_STATUS_DS_SAM_INIT_FAILURE, ERROR_DS_SAM_INIT_FAILURE, -1, "" )
S ( LW_STATUS_ONLY_IF_CONNECTED, ERROR_ONLY_IF_CONNECTED, -1, "" )
S ( LW_STATUS_DS_SENSITIVE_GROUP_VIOLATION, ERROR_DS_SENSITIVE_GROUP_VIOLATION, -1, "" )
S ( LW_STATUS_PNP_RESTART_ENUMERATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_JOURNAL_ENTRY_DELETED, ERROR_JOURNAL_ENTRY_DELETED, -1, "" )
S ( LW_STATUS_DS_CANT_MOD_PRIMARYGROUPID, ERROR_DS_CANT_MOD_PRIMARYGROUPID, -1, "" )
S ( LW_STATUS_SYSTEM_IMAGE_BAD_SIGNATURE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PNP_REBOOT_REQUIRED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_POWER_STATE_INVALID, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DS_INVALID_GROUP_TYPE, ERROR_DS_INVALID_GROUP_TYPE, -1, "" )
S ( LW_STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN, ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN, -1, "" )
S ( LW_STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN, ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN, -1, "" )
S ( LW_STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER, ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER, -1, "" )
S ( LW_STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER, ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER, -1, "" )
S ( LW_STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER, ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER, -1, "" )
S ( LW_STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER, ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER, -1, "" )
S ( LW_STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER, ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER, -1, "" )
S ( LW_STATUS_DS_HAVE_PRIMARY_MEMBERS, ERROR_DS_HAVE_PRIMARY_MEMBERS, -1, "" )
S ( LW_STATUS_WMI_NOT_SUPPORTED, ERROR_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_INSUFFICIENT_POWER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SAM_NEED_BOOTKEY_PASSWORD, ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD, -1, "" )
S ( LW_STATUS_SAM_NEED_BOOTKEY_FLOPPY, ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY, -1, "" )
S ( LW_STATUS_DS_CANT_START, ERROR_DS_CANT_START, -1, "" )
S ( LW_STATUS_DS_INIT_FAILURE, ERROR_DS_INIT_FAILURE, -1, "" )
S ( LW_STATUS_SAM_INIT_FAILURE, ERROR_SAM_INIT_FAILURE, -1, "" )
S ( LW_STATUS_DS_GC_REQUIRED, ERROR_DS_GC_REQUIRED, -1, "" )
S ( LW_STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY, ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY, -1, "" )
S ( LW_STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS, ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS, -1, "" )
S ( LW_STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED, ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED, -1, "" )
S ( LW_STATUS_MULTIPLE_FAULT_VIOLATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CURRENT_DOMAIN_NOT_ALLOWED, ERROR_CURRENT_DOMAIN_NOT_ALLOWED, -1, "" )
S ( LW_STATUS_CANNOT_MAKE, ERROR_CANNOT_MAKE, -1, "" )
S ( LW_STATUS_SYSTEM_SHUTDOWN, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DS_INIT_FAILURE_CONSOLE, ERROR_DS_INIT_FAILURE_CONSOLE, -1, "" )
S ( LW_STATUS_DS_SAM_INIT_FAILURE_CONSOLE, ERROR_DS_SAM_INIT_FAILURE_CONSOLE, -1, "" )
S ( LW_STATUS_UNFINISHED_CONTEXT_DELETED, -2146893005, -1, "" )
S ( LW_STATUS_NO_TGT_REPLY, -2146893004, -1, "" )
S ( LW_STATUS_OBJECTID_NOT_FOUND, ERROR_FILE_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_IP_ADDRESSES, -2146893003, -1, "" )
S ( LW_STATUS_WRONG_CREDENTIAL_HANDLE, -2146893002, -1, "" )
S ( LW_STATUS_CRYPTO_SYSTEM_INVALID, -2146893001, -1, "" )
S ( LW_STATUS_MAX_REFERRALS_EXCEEDED, -2146893000, -1, "" )
S ( LW_STATUS_MUST_BE_KDC, -2146892999, -1, "" )
S ( LW_STATUS_STRONG_CRYPTO_NOT_SUPPORTED, -2146892998, -1, "" )
S ( LW_STATUS_TOO_MANY_PRINCIPALS, -2146892997, -1, "" )
S ( LW_STATUS_NO_PA_DATA, -2146892996, -1, "" )
S ( LW_STATUS_PKINIT_NAME_MISMATCH, -2146892995, -1, "" )
S ( LW_STATUS_SMARTCARD_LOGON_REQUIRED, SEC_E_SMARTCARD_LOGON_REQUIRED, -1, "SEC_E_SMARTCARD_LOGON_REQUIRED" )
S ( LW_STATUS_KDC_INVALID_REQUEST, -2146892992, -1, "" )
S ( LW_STATUS_KDC_UNABLE_TO_REFER, -2146892991, -1, "" )
S ( LW_STATUS_KDC_UNKNOWN_ETYPE, -2146892990, -1, "" )
S ( LW_STATUS_SHUTDOWN_IN_PROGRESS, ERROR_SHUTDOWN_IN_PROGRESS, -1, "" )
S ( LW_STATUS_SERVER_SHUTDOWN_IN_PROGRESS, ERROR_SERVER_SHUTDOWN_IN_PROGRESS, -1, "" )
S ( LW_STATUS_NOT_SUPPORTED_ON_SBS, ERROR_NOT_SUPPORTED_ON_SBS, -1, "" )
S ( LW_STATUS_WMI_GUID_DISCONNECTED, ERROR_WMI_GUID_DISCONNECTED, -1, "" )
S ( LW_STATUS_WMI_ALREADY_DISABLED, ERROR_WMI_ALREADY_DISABLED, -1, "" )
S ( LW_STATUS_WMI_ALREADY_ENABLED, ERROR_WMI_ALREADY_ENABLED, -1, "" )
S ( LW_STATUS_MFT_TOO_FRAGMENTED, ERROR_DISK_TOO_FRAGMENTED, -1, "" )
S ( LW_STATUS_COPY_PROTECTION_FAILURE, -2147286267, -1, "" )
S ( LW_STATUS_CSS_AUTHENTICATION_FAILURE, -2147286266, -1, "" )
S ( LW_STATUS_CSS_KEY_NOT_PRESENT, -2147286265, -1, "" )
S ( LW_STATUS_CSS_KEY_NOT_ESTABLISHED, -2147286264, -1, "" )
S ( LW_STATUS_CSS_SCRAMBLED_SECTOR, -2147286263, -1, "" )
S ( LW_STATUS_CSS_REGION_MISMATCH, -2147286262, -1, "" )
S ( LW_STATUS_CSS_RESETS_EXHAUSTED, -2147286261, -1, "" )
S ( LW_STATUS_PKINIT_FAILURE, ERROR_PKINIT_FAILURE, -1, "" )
S ( LW_STATUS_SMARTCARD_SUBSYSTEM_FAILURE, ERROR_SMARTCARD_SUBSYSTEM_FAILURE, -1, "" )
S ( LW_STATUS_NO_KERB_KEY, -2146892984, -1, "" )
S ( LW_STATUS_HOST_DOWN, ERROR_HOST_DOWN, -1, "" )
S ( LW_STATUS_UNSUPPORTED_PREAUTH, -2146892989, -1, "" )
S ( LW_STATUS_EFS_ALG_BLOB_TOO_BIG, ERROR_EFS_ALG_BLOB_TOO_BIG, -1, "" )
S ( LW_STATUS_PORT_NOT_SET, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DEBUGGER_INACTIVE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DS_VERSION_CHECK_FAILURE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_AUDITING_DISABLED, -1073151999, -1, "" )
S ( LW_STATUS_PRENT4_MACHINE_ACCOUNT, ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4, -1, "" )
S ( LW_STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER, ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER, -1, "" )
S ( LW_STATUS_INVALID_IMAGE_WIN_32, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_INVALID_IMAGE_WIN_64, ERROR_BAD_EXE_FORMAT, -1, "" )
S ( LW_STATUS_BAD_BINDINGS, -2146892986, -1, "" )
S ( LW_STATUS_NETWORK_SESSION_EXPIRED, ERROR_NO_USER_SESSION_KEY, -1, "" )
S ( LW_STATUS_APPHELP_BLOCK, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ALL_SIDS_FILTERED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NOT_SAFE_MODE_DRIVER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT, ERROR_ACCESS_DISABLED_BY_POLICY, -1, "" )
S ( LW_STATUS_ACCESS_DISABLED_BY_POLICY_PATH, ERROR_ACCESS_DISABLED_BY_POLICY, -1, "" )
S ( LW_STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER, ERROR_ACCESS_DISABLED_BY_POLICY, -1, "" )
S ( LW_STATUS_ACCESS_DISABLED_BY_POLICY_OTHER, ERROR_ACCESS_DISABLED_BY_POLICY, -1, "" )
S ( LW_STATUS_FAILED_DRIVER_ENTRY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DEVICE_ENUMERATION_ERROR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_MOUNT_POINT_NOT_RESOLVED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_DEVICE_OBJECT_PARAMETER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_MCA_OCCURED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DRIVER_BLOCKED_CRITICAL, ERROR_DRIVER_BLOCKED, -1, "" )
S ( LW_STATUS_DRIVER_BLOCKED, ERROR_DRIVER_BLOCKED, -1, "" )
S ( LW_STATUS_DRIVER_DATABASE_ERROR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SYSTEM_HIVE_TOO_LARGE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_IMPORT_OF_NON_DLL, ERROR_INVALID_IMPORT_OF_NON_DLL, -1, "" )
S ( LW_STATUS_NO_SECRETS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FAILED_STACK_SWITCH, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_HEAP_CORRUPTION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SMARTCARD_WRONG_PIN, -2146434965, -1, "" )
S ( LW_STATUS_SMARTCARD_CARD_BLOCKED, -2146434964, -1, "" )
S ( LW_STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED, -2146434961, -1, "" )
S ( LW_STATUS_SMARTCARD_NO_CARD, SCARD_E_NO_SMARTCARD, -1, "SCARD_E_NO_SMARTCARD" )
S ( LW_STATUS_SMARTCARD_NO_KEY_CONTAINER, -2146893811, -1, "" )
S ( LW_STATUS_SMARTCARD_NO_CERTIFICATE, SCARD_E_NO_SUCH_CERTIFICATE, -1, "SCARD_E_NO_SUCH_CERTIFICATE" )
S ( LW_STATUS_SMARTCARD_NO_KEYSET, -2146893802, -1, "" )
S ( LW_STATUS_SMARTCARD_IO_ERROR, -2146435025, -1, "" )
S ( LW_STATUS_DOWNGRADE_DETECTED, ERROR_DOWNGRADE_DETECTED, -1, "" )
S ( LW_STATUS_SMARTCARD_CERT_REVOKED, 1266, -1, "" )
S ( LW_STATUS_ISSUING_CA_UNTRUSTED, 1267, -1, "" )
S ( LW_STATUS_REVOCATION_OFFLINE_C, 1268, -1, "" )
S ( LW_STATUS_PKINIT_CLIENT_FAILURE, 1269, -1, "" )
S ( LW_STATUS_SMARTCARD_CERT_EXPIRED, 1270, -1, "" )
S ( LW_STATUS_DRIVER_FAILED_PRIOR_UNLOAD, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SMARTCARD_SILENT_CONTEXT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PER_USER_TRUST_QUOTA_EXCEEDED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DS_NAME_NOT_UNIQUE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DS_DUPLICATE_ID_FOUND, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DS_GROUP_CONVERSION_ERROR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_VOLSNAP_PREPARE_HIBERNATE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_USER2USER_REQUIRED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_STACK_BUFFER_OVERRUN, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_S4U_PROT_SUPPORT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CROSSREALM_DELEGATION_FAILURE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_REVOCATION_OFFLINE_KDC, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ISSUING_CA_UNTRUSTED_KDC, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_KDC_CERT_EXPIRED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_KDC_CERT_REVOKED, SEC_E_KDC_CERT_REVOKED, -1, "" )
S ( LW_STATUS_PARAMETER_QUOTA_EXCEEDED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_HIBERNATION_FAILURE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DELAY_LOAD_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_AUTHENTICATION_FIREWALL_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_VDM_DISALLOWED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_HUNG_DISPLAY_DRIVER_THREAD, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_CRUNTIME_PARAMETER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NTLM_BLOCKED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ASSERTION_FAILURE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_VERIFIER_STOP, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CALLBACK_POP_STACK, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INCOMPATIBLE_DRIVER_BLOCKED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_HIVE_UNLOADED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_COMPRESSION_DISABLED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_FILE_SYSTEM_LIMITATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_IMAGE_HASH, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NOT_CAPABLE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_REQUEST_OUT_OF_SEQUENCE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_IMPLEMENTATION_LIMIT, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ELEVATION_REQUIRED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_BEYOND_VDL, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ENCOUNTERED_WRITE_IN_PROGRESS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PTE_CHANGED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PURGE_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CRED_REQUIRES_CONFIRMATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CS_ENCRYPTION_FILE_NOT_CSE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_LABEL, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_DRIVER_PROCESS_TERMINATED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_AMBIGUOUS_SYSTEM_DEVICE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SYSTEM_DEVICE_NOT_FOUND, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RESTART_BOOT_APPLICATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_TASK_NAME, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_TASK_INDEX, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_THREAD_ALREADY_IN_TASK, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CALLBACK_BYPASS, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PORT_CLOSED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_LOST, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_MESSAGE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_REQUEST_CANCELED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RECURSIVE_DISPATCH, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_LPC_RECEIVE_BUFFER_EXPECTED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_LPC_INVALID_CONNECTION_USAGE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_LPC_REQUESTS_NOT_ALLOWED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_RESOURCE_IN_USE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_HARDWARE_MEMORY_ERROR, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_THREADPOOL_HANDLE_EXCEPTION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_THREADPOOL_RELEASED_DURING_OPERATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_APC_RETURNED_WHILE_IMPERSONATING, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PROCESS_IS_PROTECTED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_MCA_EXCEPTION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_SYMLINK_CLASS_DISABLED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_IDN_NORMALIZATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_NO_UNICODE_TRANSLATION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_ALREADY_REGISTERED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CONTEXT_MISMATCH, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_PORT_ALREADY_HAS_COMPLETION_LIST, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CALLBACK_RETURNED_THREAD_PRIORITY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_INVALID_THREAD, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CALLBACK_RETURNED_TRANSACTION, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CALLBACK_RETURNED_LDR_LOCK, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CALLBACK_RETURNED_LANG, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CALLBACK_RETURNED_PRI_BACK, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_STATUS_CALLBACK_RETURNED_THREAD_AFFINITY, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_DBG_NO_STATE_CHANGE, ERROR_INVALID_FUNCTION, -1, "" )
S ( LW_DBG_APP_NOT_IDLE, ERROR_FILE_NOT_FOUND, -1, "" )
S ( LW_RPC_NT_INVALID_STRING_BINDING, RPC_S_INVALID_STRING_BINDING, -1, "" )
S ( LW_RPC_NT_WRONG_KIND_OF_BINDING, RPC_S_WRONG_KIND_OF_BINDING, -1, "" )
S ( LW_RPC_NT_INVALID_BINDING, ERROR_INVALID_HANDLE, -1, "" )
S ( LW_RPC_NT_PROTSEQ_NOT_SUPPORTED, RPC_S_PROTSEQ_NOT_SUPPORTED, -1, "" )
S ( LW_RPC_NT_INVALID_RPC_PROTSEQ, RPC_S_INVALID_RPC_PROTSEQ, -1, "" )
S ( LW_RPC_NT_INVALID_STRING_UUID, RPC_S_INVALID_STRING_UUID, -1, "" )
S ( LW_RPC_NT_INVALID_ENDPOINT_FORMAT, RPC_S_INVALID_ENDPOINT_FORMAT, -1, "" )
S ( LW_RPC_NT_INVALID_NET_ADDR, RPC_S_INVALID_NET_ADDR, -1, "" )
S ( LW_RPC_NT_NO_ENDPOINT_FOUND, RPC_S_NO_ENDPOINT_FOUND, -1, "" )
S ( LW_RPC_NT_INVALID_TIMEOUT, RPC_S_INVALID_TIMEOUT, -1, "" )
S ( LW_RPC_NT_OBJECT_NOT_FOUND, RPC_S_OBJECT_NOT_FOUND, -1, "" )
S ( LW_RPC_NT_ALREADY_REGISTERED, RPC_S_ALREADY_REGISTERED, -1, "" )
S ( LW_RPC_NT_TYPE_ALREADY_REGISTERED, RPC_S_TYPE_ALREADY_REGISTERED, -1, "" )
S ( LW_RPC_NT_ALREADY_LISTENING, RPC_S_ALREADY_LISTENING, -1, "" )
S ( LW_RPC_NT_NO_PROTSEQS_REGISTERED, RPC_S_NO_PROTSEQS_REGISTERED, -1, "" )
S ( LW_RPC_NT_NOT_LISTENING, RPC_S_NOT_LISTENING, -1, "" )
S ( LW_RPC_NT_UNKNOWN_MGR_TYPE, RPC_S_UNKNOWN_MGR_TYPE, -1, "" )
S ( LW_RPC_NT_UNKNOWN_IF, RPC_S_UNKNOWN_IF, -1, "" )
S ( LW_RPC_NT_NO_BINDINGS, RPC_S_NO_BINDINGS, -1, "" )
S ( LW_RPC_NT_NO_PROTSEQS, RPC_S_NO_PROTSEQS, -1, "" )
S ( LW_RPC_NT_CANT_CREATE_ENDPOINT, RPC_S_CANT_CREATE_ENDPOINT, -1, "" )
S ( LW_RPC_NT_OUT_OF_RESOURCES, RPC_S_OUT_OF_RESOURCES, -1, "" )
S ( LW_RPC_NT_SERVER_UNAVAILABLE, RPC_S_SERVER_UNAVAILABLE, -1, "" )
S ( LW_RPC_NT_SERVER_TOO_BUSY, RPC_S_SERVER_TOO_BUSY, -1, "" )
S ( LW_RPC_NT_INVALID_NETWORK_OPTIONS, RPC_S_INVALID_NETWORK_OPTIONS, -1, "" )
S ( LW_RPC_NT_NO_CALL_ACTIVE, RPC_S_NO_CALL_ACTIVE, -1, "" )
S ( LW_RPC_NT_CALL_FAILED, RPC_S_CALL_FAILED, -1, "" )
S ( LW_RPC_NT_CALL_FAILED_DNE, RPC_S_CALL_FAILED_DNE, -1, "" )
S ( LW_RPC_NT_PROTOCOL_ERROR, RPC_S_PROTOCOL_ERROR, -1, "" )
S ( LW_RPC_NT_UNSUPPORTED_TRANS_SYN, RPC_S_UNSUPPORTED_TRANS_SYN, -1, "" )
S ( LW_RPC_NT_UNSUPPORTED_TYPE, RPC_S_UNSUPPORTED_TYPE, -1, "" )
S ( LW_RPC_NT_INVALID_TAG, RPC_S_INVALID_TAG, -1, "" )
S ( LW_RPC_NT_INVALID_BOUND, RPC_S_INVALID_BOUND, -1, "" )
S ( LW_RPC_NT_NO_ENTRY_NAME, RPC_S_NO_ENTRY_NAME, -1, "" )
S ( LW_RPC_NT_INVALID_NAME_SYNTAX, RPC_S_INVALID_NAME_SYNTAX, -1, "" )
S ( LW_RPC_NT_UNSUPPORTED_NAME_SYNTAX, RPC_S_UNSUPPORTED_NAME_SYNTAX, -1, "" )
S ( LW_RPC_NT_UUID_NO_ADDRESS, RPC_S_UUID_NO_ADDRESS, -1, "" )
S ( LW_RPC_NT_DUPLICATE_ENDPOINT, RPC_S_DUPLICATE_ENDPOINT, -1, "" )
S ( LW_RPC_NT_UNKNOWN_AUTHN_TYPE, RPC_S_UNKNOWN_AUTHN_TYPE, -1, "" )
S ( LW_RPC_NT_MAX_CALLS_TOO_SMALL, RPC_S_MAX_CALLS_TOO_SMALL, -1, "" )
S ( LW_RPC_NT_STRING_TOO_LONG, RPC_S_STRING_TOO_LONG, -1, "" )
S ( LW_RPC_NT_PROTSEQ_NOT_FOUND, RPC_S_PROTSEQ_NOT_FOUND, -1, "" )
S ( LW_RPC_NT_PROCNUM_OUT_OF_RANGE, RPC_S_PROCNUM_OUT_OF_RANGE, -1, "" )
S ( LW_RPC_NT_BINDING_HAS_NO_AUTH, RPC_S_BINDING_HAS_NO_AUTH, -1, "" )
S ( LW_RPC_NT_UNKNOWN_AUTHN_SERVICE, RPC_S_UNKNOWN_AUTHN_SERVICE, -1, "" )
S ( LW_RPC_NT_UNKNOWN_AUTHN_LEVEL, RPC_S_UNKNOWN_AUTHN_LEVEL, -1, "" )
S ( LW_RPC_NT_INVALID_AUTH_IDENTITY, RPC_S_INVALID_AUTH_IDENTITY, -1, "" )
S ( LW_RPC_NT_UNKNOWN_AUTHZ_SERVICE, RPC_S_UNKNOWN_AUTHZ_SERVICE, -1, "" )
S ( LW_EPT_NT_INVALID_ENTRY, EPT_S_INVALID_ENTRY, -1, "" )
S ( LW_EPT_NT_CANT_PERFORM_OP, EPT_S_CANT_PERFORM_OP, -1, "" )
S ( LW_EPT_NT_NOT_REGISTERED, EPT_S_NOT_REGISTERED, -1, "" )
S ( LW_RPC_NT_NOTHING_TO_EXPORT, RPC_S_NOTHING_TO_EXPORT, -1, "" )
S ( LW_RPC_NT_INCOMPLETE_NAME, RPC_S_INCOMPLETE_NAME, -1, "" )
S ( LW_RPC_NT_INVALID_VERS_OPTION, RPC_S_INVALID_VERS_OPTION, -1, "" )
S ( LW_RPC_NT_NO_MORE_MEMBERS, RPC_S_NO_MORE_MEMBERS, -1, "" )
S ( LW_RPC_NT_NOT_ALL_OBJS_UNEXPORTED, RPC_S_NOT_ALL_OBJS_UNEXPORTED, -1, "" )
S ( LW_RPC_NT_INTERFACE_NOT_FOUND, RPC_S_INTERFACE_NOT_FOUND, -1, "" )
S ( LW_RPC_NT_ENTRY_ALREADY_EXISTS, RPC_S_ENTRY_ALREADY_EXISTS, -1, "" )
S ( LW_RPC_NT_ENTRY_NOT_FOUND, RPC_S_ENTRY_NOT_FOUND, -1, "" )
S ( LW_RPC_NT_NAME_SERVICE_UNAVAILABLE, RPC_S_NAME_SERVICE_UNAVAILABLE, -1, "" )
S ( LW_RPC_NT_INVALID_NAF_ID, RPC_S_INVALID_NAF_ID, -1, "" )
S ( LW_RPC_NT_CANNOT_SUPPORT, RPC_S_CANNOT_SUPPORT, -1, "" )
S ( LW_RPC_NT_NO_CONTEXT_AVAILABLE, RPC_S_NO_CONTEXT_AVAILABLE, -1, "" )
S ( LW_RPC_NT_INTERNAL_ERROR, RPC_S_INTERNAL_ERROR, -1, "" )
S ( LW_RPC_NT_ZERO_DIVIDE, RPC_S_ZERO_DIVIDE, -1, "" )
S ( LW_RPC_NT_ADDRESS_ERROR, RPC_S_ADDRESS_ERROR, -1, "" )
S ( LW_RPC_NT_FP_DIV_ZERO, RPC_S_FP_DIV_ZERO, -1, "" )
S ( LW_RPC_NT_FP_UNDERFLOW, RPC_S_FP_UNDERFLOW, -1, "" )
S ( LW_RPC_NT_FP_OVERFLOW, RPC_S_FP_OVERFLOW, -1, "" )
S ( LW_RPC_NT_CALL_IN_PROGRESS, RPC_S_CALL_IN_PROGRESS, -1, "" )
S ( LW_RPC_NT_NO_MORE_BINDINGS, RPC_S_NO_MORE_BINDINGS, -1, "" )
S ( LW_RPC_NT_GROUP_MEMBER_NOT_FOUND, RPC_S_GROUP_MEMBER_NOT_FOUND, -1, "" )
S ( LW_EPT_NT_CANT_CREATE, EPT_S_CANT_CREATE, -1, "" )
S ( LW_RPC_NT_INVALID_OBJECT, RPC_S_INVALID_OBJECT, -1, "" )
S ( LW_RPC_NT_NO_INTERFACES, RPC_S_NO_INTERFACES, -1, "" )
S ( LW_RPC_NT_CALL_CANCELLED, RPC_S_CALL_CANCELLED, -1, "" )
S ( LW_RPC_NT_BINDING_INCOMPLETE, RPC_S_BINDING_INCOMPLETE, -1, "" )
S ( LW_RPC_NT_COMM_FAILURE, RPC_S_COMM_FAILURE, -1, "" )
S ( LW_RPC_NT_UNSUPPORTED_AUTHN_LEVEL, RPC_S_UNSUPPORTED_AUTHN_LEVEL, -1, "" )
S ( LW_RPC_NT_NO_PRINC_NAME, RPC_S_NO_PRINC_NAME, -1, "" )
S ( LW_RPC_NT_NOT_RPC_ERROR, RPC_S_NOT_RPC_ERROR, -1, "" )
S ( LW_RPC_NT_SEC_PKG_ERROR, RPC_S_SEC_PKG_ERROR, -1, "" )
S ( LW_RPC_NT_NOT_CANCELLED, RPC_S_NOT_CANCELLED, -1, "" )
S ( LW_RPC_NT_INVALID_ASYNC_HANDLE, RPC_S_INVALID_ASYNC_HANDLE, -1, "" )
S ( LW_RPC_NT_INVALID_ASYNC_CALL, RPC_S_INVALID_ASYNC_CALL, -1, "" )
S ( LW_RPC_NT_PROXY_ACCESS_DENIED, ERROR_MR_MID_NOT_FOUND, -1, "" )
S ( LW_RPC_NT_NO_MORE_ENTRIES, RPC_X_NO_MORE_ENTRIES, -1, "" )
S ( LW_RPC_NT_SS_CHAR_TRANS_OPEN_FAIL, RPC_X_SS_CHAR_TRANS_OPEN_FAIL, -1, "" )
S ( LW_RPC_NT_SS_CHAR_TRANS_SHORT_FILE, RPC_X_SS_CHAR_TRANS_SHORT_FILE, -1, "" )
S ( LW_RPC_NT_SS_IN_NULL_CONTEXT, ERROR_INVALID_HANDLE, -1, "" )
S ( LW_RPC_NT_SS_CONTEXT_MISMATCH, ERROR_INVALID_HANDLE, -1, "" )
S ( LW_RPC_NT_SS_CONTEXT_DAMAGED, RPC_X_SS_CONTEXT_DAMAGED, -1, "" )
S ( LW_RPC_NT_SS_HANDLES_MISMATCH, RPC_X_SS_HANDLES_MISMATCH, -1, "" )
S ( LW_RPC_NT_SS_CANNOT_GET_CALL_HANDLE, RPC_X_SS_CANNOT_GET_CALL_HANDLE, -1, "" )
S ( LW_RPC_NT_NULL_REF_POINTER, RPC_X_NULL_REF_POINTER, -1, "" )
S ( LW_RPC_NT_ENUM_VALUE_OUT_OF_RANGE, RPC_X_ENUM_VALUE_OUT_OF_RANGE, -1, "" )
S ( LW_RPC_NT_BYTE_COUNT_TOO_SMALL, RPC_X_BYTE_COUNT_TOO_SMALL, -1, "" )
S ( LW_RPC_NT_BAD_STUB_DATA, RPC_X_BAD_STUB_DATA, -1, "" )
S ( LW_RPC_NT_INVALID_ES_ACTION, RPC_X_INVALID_ES_ACTION, -1, "" )
S ( LW_RPC_NT_WRONG_ES_VERSION, RPC_X_WRONG_ES_VERSION, -1, "" )
S ( LW_RPC_NT_WRONG_STUB_VERSION, RPC_X_WRONG_STUB_VERSION, -1, "" )
S ( LW_RPC_NT_INVALID_PIPE_OBJECT, RPC_X_INVALID_PIPE_OBJECT, -1, "" )
S ( LW_RPC_NT_INVALID_PIPE_OPERATION, RPC_X_WRONG_PIPE_ORDER, -1, "" )
S ( LW_RPC_NT_WRONG_PIPE_VERSION, RPC_X_WRONG_PIPE_VERSION, -1, "" )
S ( LW_RPC_NT_PIPE_CLOSED, RPC_X_PIPE_CLOSED, -1, "" )
S ( LW_RPC_NT_PIPE_DISCIPLINE_ERROR, RPC_X_PIPE_DISCIPLINE_ERROR, -1, "" )
S ( LW_RPC_NT_PIPE_EMPTY, RPC_X_PIPE_EMPTY, -1, "" )

/* Win32 error codes without an equivalent NTStatus */
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ARENA_TRASHED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_ENVIRONMENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_FORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_ACCESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_DRIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CURRENT_DIRECTORY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_UNIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SEEK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_DOS_DISK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WRITE_FAULT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_READ_FAULT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SHARING_BUFFER_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HANDLE_DISK_FULL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FILE_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FAIL_I24, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_OUT_OF_STRUCTURES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALREADY_ASSIGNED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_PROC_SLOTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TOO_MANY_SEMAPHORES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EXCL_SEM_ALREADY_OWNED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SEM_IS_SET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TOO_MANY_SEM_REQUESTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_AT_INTERRUPT_TIME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SEM_OWNER_DIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SEM_USER_LIMIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DISK_CHANGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DRIVE_LOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_OPEN_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BUFFER_OVERFLOW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_MORE_SEARCH_HANDLES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_TARGET_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_CATEGORY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_VERIFY_SWITCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_DRIVER_LEVEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CALL_NOT_IMPLEMENTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_VOLUME_LABEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WAIT_NO_CHILDREN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CHILD_NOT_COMPLETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DIRECT_ACCESS_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NEGATIVE_SEEK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SEEK_ON_DEVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IS_JOIN_TARGET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IS_JOINED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IS_SUBSTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_JOINED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_SUBSTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_JOIN_TO_JOIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SUBST_TO_SUBST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_JOIN_TO_SUBST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SUBST_TO_JOIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BUSY_DRIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SAME_DRIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DIR_NOT_ROOT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IS_SUBST_PATH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IS_JOIN_PATH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PATH_BUSY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IS_SUBST_TARGET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYSTEM_TRACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_EVENT_COUNT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TOO_MANY_MUXWAITERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_LIST_FORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TOO_MANY_TCBS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DISCARDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_THREADID_ADDR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_ARGUMENTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SIGNAL_PENDING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MAX_THRDS_REACHED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOCK_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANCEL_VIOLATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ATOMIC_LOCKS_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SEGMENT_NUMBER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_FLAG_NUMBER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SEM_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_STARTING_CODESEG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_STACKSEG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_MODULETYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_EXE_SIGNATURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EXE_MARKED_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ITERATED_DATA_EXCEEDS_64k, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_MINALLOCSIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DYNLINK_FROM_INVALID_RING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IOPL_NOT_ENABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SEGDPL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_AUTODATASEG_EXCEEDS_64k, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RING2SEG_MUST_BE_MOVABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RELOC_CHAIN_XEEDS_SEGLIM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INFLOOP_IN_RELOC_CHAIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_SIGNAL_SENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RING2_STACK_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_META_EXPANSION_TOO_LONG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SIGNAL_NUMBER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_THREAD_1_INACTIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TOO_MANY_MODULES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NESTING_NOT_ALLOWED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EXE_MACHINE_TYPE_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FILE_CHECKED_OUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CHECKOUT_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_FILE_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FILE_TOO_LARGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FORMS_AUTH_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VIRUS_INFECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VIRUS_DELETED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PIPE_LOCAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WAIT_TIMEOUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANNOT_COPY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EAS_DIDNT_FIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EA_FILE_CORRUPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EA_TABLE_FULL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_EA_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DELETE_PENDING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SCOPE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FAIL_NOACTION_REBOOT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FAIL_SHUTDOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FAIL_RESTART, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MAX_SESSIONS_REACHED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_THREAD_MODE_ALREADY_BACKGROUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_THREAD_MODE_NOT_BACKGROUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROCESS_MODE_ALREADY_BACKGROUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROCESS_MODE_NOT_BACKGROUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_USER_PROFILE_LOAD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VERIFIER_STOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ABIOS_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WX86_WARNING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WX86_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TIMER_NOT_CANCELED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNWIND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_STACK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_UNWIND_TARGET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_PORT_ATTRIBUTES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PORT_MESSAGE_TOO_LONG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_QUOTA_LOWER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEVICE_ALREADY_ATTACHED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTRUCTION_MISALIGNMENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROFILING_NOT_STARTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROFILING_NOT_STOPPED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_COULD_NOT_INTERPRET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROFILING_AT_LIMIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANT_WAIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANT_TERMINATE_SELF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNEXPECTED_MM_CREATE_ERR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNEXPECTED_MM_MAP_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNEXPECTED_MM_EXTEND_ERR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_FUNCTION_TABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_GUID_TRANSLATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_LDT_SIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_LDT_OFFSET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_LDT_DESCRIPTOR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TOO_MANY_THREADS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_THREAD_NOT_IN_PROCESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PAGEFILE_QUOTA_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOGON_SERVER_CONFLICT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYNCHRONIZATION_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NET_OPEN_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IO_PRIVILEGE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CONTROL_C_EXIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MISSING_SYSTEMFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNHANDLED_EXCEPTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_APP_INIT_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PAGEFILE_CREATE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_IMAGE_HASH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_PAGEFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ILLEGAL_FLOAT_CONTEXT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_EVENT_PAIR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DOMAIN_CTRLR_CONFIG_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ILLEGAL_CHARACTER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNDEFINED_CHARACTER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FLOPPY_VOLUME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BACKUP_CONTROLLER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MUTANT_LIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FS_DRIVER_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANNOT_LOAD_REGISTRY_FILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEBUG_ATTACH_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYSTEM_PROCESS_TERMINATED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DATA_NOT_ACCEPTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VDM_HARD_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DRIVER_CANCEL_TIMEOUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REPLY_MESSAGE_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOST_WRITEBEHIND_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLIENT_SERVER_PARAMETERS_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_TINY_STREAM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_STACK_OVERFLOW_READ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CONVERT_TO_LARGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FOUND_OUT_OF_SCOPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALLOCATE_BUCKET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MARSHALL_OVERFLOW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_VARIANT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_COMPRESSION_BUFFER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_AUDIT_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TIMER_RESOLUTION_NOT_SET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSUFFICIENT_LOGON_INFO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_DLL_ENTRYPOINT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_SERVICE_ENTRYPOINT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IP_ADDRESS_CONFLICT1, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IP_ADDRESS_CONFLICT2, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REGISTRY_QUOTA_LIMIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_CALLBACK_ACTIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PWD_TOO_SHORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PWD_TOO_RECENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PWD_HISTORY_CONFLICT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNSUPPORTED_COMPRESSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_HW_PROFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_PLUGPLAY_DEVICE_PATH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_QUOTA_LIST_INCONSISTENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVALUATION_EXPIRATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ILLEGAL_DLL_RELOCATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DLL_INIT_FAILED_LOGOFF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VALIDATE_CONTINUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_MORE_MATCHES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RANGE_LIST_CONFLICT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVER_SID_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANT_ENABLE_DENY_ONLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FLOAT_MULTIPLE_FAULTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FLOAT_MULTIPLE_TRAPS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOINTERFACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DRIVER_FAILED_SLEEP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CORRUPT_SYSTEM_FILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_COMMITMENT_MINIMUM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PNP_RESTART_ENUMERATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYSTEM_IMAGE_BAD_SIGNATURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PNP_REBOOT_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSUFFICIENT_POWER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MULTIPLE_FAULT_VIOLATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYSTEM_SHUTDOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PORT_NOT_SET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_VERSION_CHECK_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RANGE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_SAFE_MODE_DRIVER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FAILED_DRIVER_ENTRY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEVICE_ENUMERATION_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MOUNT_POINT_NOT_RESOLVED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_DEVICE_OBJECT_PARAMETER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MCA_OCCURED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DRIVER_DATABASE_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYSTEM_HIVE_TOO_LARGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DRIVER_FAILED_PRIOR_UNLOAD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VOLSNAP_PREPARE_HIBERNATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HIBERNATION_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FILE_SYSTEM_LIMITATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ASSERTION_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ACPI_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WOW_ASSERTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PNP_BAD_MPS_TABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PNP_TRANSLATION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PNP_IRQ_TRANSLATION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PNP_INVALID_ID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WAKE_SYSTEM_DEBUGGER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HANDLES_CLOSED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EXTRANEOUS_INFORMATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RXACT_COMMIT_NECESSARY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MEDIA_CHECK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_GUID_SUBSTITUTION_MADE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_STOPPED_ON_SYMLINK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LONGJUMP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PLUGPLAY_QUERY_VETOED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNWIND_CONSOLIDATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REGISTRY_HIVE_RECOVERED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DLL_MIGHT_BE_INSECURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DLL_MIGHT_BE_INCOMPATIBLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_EXCEPTION_NOT_HANDLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_REPLY_LATER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_TERMINATE_THREAD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_TERMINATE_PROCESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_CONTROL_C, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_PRINTEXCEPTION_C, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_RIPEXCEPTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_CONTROL_BREAK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_COMMAND_EXCEPTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_OBJECT_NAME_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_THREAD_WAS_SUSPENDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IMAGE_NOT_AT_BASE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RXACT_STATE_CREATED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SEGMENT_NOTIFICATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_CURRENT_DIRECTORY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FT_READ_RECOVERY_FROM_BACKUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FT_WRITE_RECOVERY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IMAGE_MACHINE_TYPE_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RECEIVE_PARTIAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RECEIVE_EXPEDITED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RECEIVE_PARTIAL_EXPEDITED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVENT_DONE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVENT_PENDING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CHECKING_FILE_SYSTEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FATAL_APP_EXIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PREDEFINED_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WAS_UNLOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_NOTIFICATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WAS_LOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_HARD_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALREADY_WIN32, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_YIELD_PERFORMED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TIMER_RESUME_IGNORED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ARBITRATION_UNHANDLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CARDBUS_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MP_PROCESSOR_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HIBERNATED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESUME_HIBERNATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FIRMWARE_UPDATED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DRIVERS_LEAKING_LOCKED_PAGES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WAKE_SYSTEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WAIT_1, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WAIT_2, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WAIT_3, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WAIT_63, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ABANDONED_WAIT_0, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ABANDONED_WAIT_63, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_USER_APC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_KERNEL_APC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALERTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ELEVATION_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_OPLOCK_BREAK_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VOLUME_MOUNTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RXACT_COMMITTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOTIFY_CLEANUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PAGE_FAULT_TRANSITION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PAGE_FAULT_DEMAND_ZERO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PAGE_FAULT_COPY_ON_WRITE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PAGE_FAULT_GUARD_PAGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PAGE_FAULT_PAGING_FILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CACHE_PAGE_LOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CRASH_DUMP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BUFFER_ALL_ZEROS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REPARSE_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_REQUIREMENTS_CHANGED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSLATION_COMPLETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOTHING_TO_TERMINATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROCESS_NOT_IN_JOB, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROCESS_IN_JOB, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VOLSNAP_HIBERNATE_READY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INTERRUPT_STILL_CONNECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WAIT_FOR_OPLOCK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_EXCEPTION_HANDLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DBG_CONTINUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CALLBACK_POP_STACK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_COMPRESSION_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANTFETCHBACKWARDS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANTSCROLLBACKWARDS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ROWSNOTRELEASED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_ACCESSOR_FLAGS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ERRORS_ENCOUNTERED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_CAPABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REQUEST_OUT_OF_SEQUENCE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VERSION_PARSE_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BADSTARTPOSITION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MEMORY_HARDWARE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DISK_REPAIR_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYSTEM_POWERSTATE_TRANSITION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MCA_EXCEPTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ACCESS_AUDIT_BY_POLICY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ABANDON_HIBERFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EA_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IO_INCOMPLETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_MESSAGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CAN_NOT_COMPLETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_FLAGS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BADKEY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANTOPEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANTREAD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANTWRITE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REGISTRY_CORRUPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEPENDENT_SERVICES_RUNNING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SERVICE_CONTROL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_REQUEST_TIMEOUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_NO_THREAD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_DATABASE_LOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SERVICE_ACCOUNT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CIRCULAR_DEPENDENCY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_DOES_NOT_EXIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_CANNOT_ACCEPT_CTRL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_NOT_ACTIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FAILED_SERVICE_CONTROLLER_CONNECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EXCEPTION_IN_SERVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DATABASE_DOES_NOT_EXIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_SPECIFIC_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROCESS_ABORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_DEPENDENCY_FAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_LOGON_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_START_HANG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SERVICE_LOCK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_MARKED_FOR_DELETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALREADY_RUNNING_LKG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_DEPENDENCY_DELETED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BOOT_ALREADY_ACCEPTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_NEVER_STARTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DUPLICATE_SERVICE_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DIFFERENT_SERVICE_ACCOUNT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANNOT_DETECT_DRIVER_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANNOT_DETECT_PROCESS_ABORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_RECOVERY_PROGRAM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_NOT_IN_EXE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_SAFEBOOT_SERVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_SHUTDOWN_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SET_POWER_STATE_VETOED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SET_POWER_STATE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_OLD_WIN_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_APP_WRONG_OS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SINGLE_INSTANCE_APP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RMODE_APP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_DLL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_ASSOCIATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DDE_FAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DLL_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_MORE_USER_HANDLES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MESSAGE_SYNC_ONLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_POINT_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_VOLUME_ID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNABLE_TO_REMOVE_REPLACED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNABLE_TO_MOVE_REPLACEMENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNABLE_TO_MOVE_REPLACEMENT_2, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_POTENTIAL_FILE_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SHUTDOWN_IS_SCHEDULED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SHUTDOWN_USERS_LOGGED_ON, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_DEVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEVICE_ALREADY_REMEMBERED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_NET_OR_BAD_PATH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_PROVIDER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANNOT_OPEN_PROFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_PROFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_CONTAINER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EXTENDED_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_GROUPNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_EVENTNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_DOMAINNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SERVICENAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SHARENAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_PASSWORDNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_MESSAGENAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_MESSAGEDEST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DUP_DOMAINNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_NETWORK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANCELLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INCORRECT_ADDRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALREADY_REGISTERED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_AUTHENTICATED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_LOGGED_ON, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CONTINUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALREADY_INITIALIZED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_MORE_DEVICES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_SUCH_SITE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DOMAIN_CONTROLLER_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_OVERRIDE_NOCHANGES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_USER_PROFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NON_ACCOUNT_SID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NON_DOMAIN_SID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_APPHELP_BLOCK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CSCSHARE_OFFLINE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MACHINE_LOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CALLBACK_SUPPLIED_INVALID_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ACCESS_DISABLED_WEBBLADE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RECOVERY_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALREADY_FIBER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALREADY_THREAD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_STACK_BUFFER_OVERRUN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PARAMETER_QUOTA_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEBUGGER_INACTIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DELAY_LOAD_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VDM_DISALLOWED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNIDENTIFIED_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_CRUNTIME_PARAMETER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BEYOND_VDL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INCOMPATIBLE_SERVICE_SID_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DRIVER_PROCESS_TERMINATED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IMPLEMENTATION_LIMIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROCESS_IS_PROTECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVICE_NOTIFY_CLIENT_LAGGING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DISK_QUOTA_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CONTENT_BLOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INCOMPATIBLE_SERVICE_PRIVILEGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_LABEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WRONG_PASSWORD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WRONG_TARGET_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_WINDOW_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_MENU_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_CURSOR_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_ACCEL_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_HOOK_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_DWP_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TLW_WITH_WSCHILD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANNOT_FIND_WND_CLASS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WINDOW_OF_OTHER_THREAD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HOTKEY_ALREADY_REGISTERED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLASS_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLASS_DOES_NOT_EXIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLASS_HAS_WINDOWS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_INDEX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_ICON_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRIVATE_DIALOG_INDEX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LISTBOX_ID_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_WILDCARD_CHARACTERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLIPBOARD_NOT_OPEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HOTKEY_NOT_REGISTERED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WINDOW_NOT_DIALOG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CONTROL_ID_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_COMBOBOX_MESSAGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WINDOW_NOT_COMBOBOX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_EDIT_HEIGHT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DC_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_HOOK_FILTER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_FILTER_PROC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HOOK_NEEDS_HMOD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_GLOBAL_ONLY_HOOK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_JOURNAL_HOOK_SET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HOOK_NOT_INSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_LB_MESSAGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SETCOUNT_ON_BAD_LB, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LB_WITHOUT_TABSTOPS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DESTROY_OBJECT_OF_OTHER_THREAD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CHILD_WINDOW_MENU, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_SYSTEM_MENU, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_MSGBOX_STYLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SPI_VALUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SCREEN_ALREADY_LOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HWNDS_HAVE_DIFF_PARENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_CHILD_WINDOW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_GW_COMMAND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NON_MDICHILD_WINDOW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_POPUP_ALREADY_ACTIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_SCROLLBARS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SCROLLBAR_RANGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SHOWWIN_COMMAND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_SYSTEM_RESOURCES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NONPAGED_SYSTEM_RESOURCES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PAGED_SYSTEM_RESOURCES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MENU_ITEM_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_KEYBOARD_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HOOK_TYPE_NOT_ALLOWED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TIMEOUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_MONITOR_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INCORRECT_SIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYMLINK_CLASS_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYMLINK_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_TASK_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_TASK_INDEX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_THREAD_ALREADY_IN_TASK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_SERVICE_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_USEREXIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_SUSPEND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNKNOWN_PRODUCT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNKNOWN_FEATURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNKNOWN_COMPONENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNKNOWN_PROPERTY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_HANDLE_STATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_CONFIGURATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INDEX_ABSENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_SOURCE_ABSENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_PACKAGE_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRODUCT_UNINSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_QUERY_SYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_FIELD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_ALREADY_RUNNING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_PACKAGE_OPEN_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_PACKAGE_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_UI_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_LOG_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_LANGUAGE_UNSUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_TRANSFORM_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_PACKAGE_REJECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FUNCTION_NOT_CALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FUNCTION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_TABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DATATYPE_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNSUPPORTED_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CREATE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_TEMP_UNWRITABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_PLATFORM_UNSUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_NOTUSED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PATCH_PACKAGE_OPEN_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PATCH_PACKAGE_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PATCH_PACKAGE_UNSUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRODUCT_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_COMMAND_LINE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_REMOTE_DISALLOWED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SUCCESS_REBOOT_INITIATED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PATCH_TARGET_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PATCH_PACKAGE_REJECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_TRANSFORM_REJECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_REMOTE_PROHIBITED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PATCH_REMOVAL_UNSUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNKNOWN_PATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PATCH_NO_SEQUENCE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PATCH_REMOVAL_DISALLOWED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_PATCH_XML, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PATCH_MANAGED_ADVERTISED_PRODUCT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INSTALL_SERVICE_SAFEBOOT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, RPC_S_INVALID_BINDING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, RPC_S_PROXY_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, RPC_X_SS_IN_NULL_CONTEXT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REDIRECTOR_HAS_OPEN_HANDLES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINTER_DRIVER_ALREADY_INSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNKNOWN_PORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNKNOWN_PRINTER_DRIVER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNKNOWN_PRINTPROCESSOR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_SEPARATOR_FILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_PRIORITY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_PRINTER_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINTER_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_PRINTER_COMMAND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_DATATYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_ENVIRONMENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SERVER_HAS_OPEN_HANDLES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_TIME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_FORM_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_FORM_SIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALREADY_WAITING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINTER_DELETED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_PRINTER_STATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, OR_INVALID_OXID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, OR_INVALID_OID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, OR_INVALID_SET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_SITENAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, RPC_S_ENTRY_TYPE_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, RPC_S_NOT_ALL_OBJS_EXPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, RPC_S_INTERFACE_NOT_EXPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, RPC_S_PROFILE_NOT_ADDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, RPC_S_PRF_ELT_NOT_ADDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, RPC_S_PRF_ELT_NOT_REMOVED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, RPC_S_GRP_ELT_NOT_ADDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, RPC_S_GRP_ELT_NOT_REMOVED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_KM_DRIVER_BLOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CONTEXT_EXPIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PER_USER_TRUST_QUOTA_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_AUTHENTICATION_FIREWALL_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_PIXEL_FORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_WINDOW_STYLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_METAFILE_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSFORM_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLIPPING_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_CMM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_PROFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TAG_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TAG_NOT_PRESENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DUPLICATE_TAG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROFILE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_COLORSPACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ICM_NOT_ENABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DELETING_ICM_XFORM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_TRANSFORM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_COLORSPACE_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_COLORINDEX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROFILE_DOES_NOT_MATCH_DEVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NetNotStarted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ShareMem, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NoNetworkResource, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RemoteOnly, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DevNotRedirected, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CONNECTED_OTHER_PASSWORD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServerNotStarted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ItemNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RedirectedPath, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DuplicateShare, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NoRoom, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TooManyItems, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InvalidMaxUsers, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BufTooSmall, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RemoteErr, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LanmanIniError, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NetworkError, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_WkstaInconsistentState, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_WkstaNotStarted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BrowserNotStarted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InternalError, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadTransactConfig, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InvalidAPI, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadEventName, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DupNameReboot, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_CfgCompNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_CfgParamNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LineTooLong, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_QNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_JobNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DestNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DestExists, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_QExists, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_QNoRoom, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_JobNoRoom, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DestNoRoom, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DestIdle, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DestInvalidOp, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ProcNoRespond, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_SpoolerNotLoaded, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DestInvalidState, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_QinvalidState, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_JobInvalidState, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_SpoolNoMemory, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DriverNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DataTypeInvalid, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ProcNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServiceTableLocked, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServiceTableFull, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServiceInstalled, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServiceEntryLocked, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServiceNotInstalled, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadServiceName, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServiceCtlTimeout, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServiceCtlBusy, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadServiceProgName, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServiceNotCtrl, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServiceKillProc, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServiceCtlNotValid, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NotInDispatchTbl, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadControlRecv, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ServiceNotStarting, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_AlreadyLoggedOn, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NotLoggedOn, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BAD_USERNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadPassword, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UnableToAddName_W, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UnableToAddName_F, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UnableToDelName_W, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UnableToDelName_F, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LogonsPaused, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LogonServerConflict, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LogonNoUserPath, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LogonScriptError, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_StandaloneLogon, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LogonServerNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LogonDomainExists, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NonValidatedLogon, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ACFNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_GroupNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UserNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ResourceNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_GroupExists, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UserExists, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ResourceExists, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NotPrimary, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ACFNotLoaded, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ACFNoRoom, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ACFFileIOFail, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ACFTooManyLists, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UserLogon, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ACFNoParent, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_CanNotGrowSegment, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_SpeGroupOp, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NotInCache, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UserInGroup, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UserNotInGroup, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_AccountUndefined, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_AccountExpired, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InvalidWorkstation, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InvalidLogonHours, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PasswordExpired, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PasswordCantChange, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PasswordHistConflict, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PasswordTooShort, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PasswordTooRecent, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InvalidDatabase, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DatabaseUpToDate, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_SyncRequired, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UseNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadAsgType, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DeviceIsShared, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NoComputerName, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_MsgAlreadyStarted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_MsgInitFailed, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NameNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_AlreadyForwarded, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_AddForwarded, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_AlreadyExists, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TooManyNames, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DelComputerName, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LocalForward, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_GrpMsgProcessor, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PausedRemote, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadReceive, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NameInUse, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_MsgNotStarted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NotLocalName, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NoForwardName, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RemoteFull, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NameNotForwarded, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TruncatedBroadcast, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InvalidDevice, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_WriteFault, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DuplicateName, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DeleteLater, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_IncompleteDel, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_MultipleNets, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NetNameNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DeviceNotShared, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ClientNameNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_FileIdNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ExecFailure, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TmpFile, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TooMuchData, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DeviceShareConflict, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BrowserTableIncomplete, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NotLocalDomain, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_IsDfsShare, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DevInvalidOpCode, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DevNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DevNotOpen, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadQueueDevString, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadQueuePriority, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NoCommDevs, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_QueueNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadDevString, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadDev, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InUseBySpooler, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_CommDevInUse, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InvalidComputer, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_MaxLenExceeded, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadComponent, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_CantType, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TooManyEntries, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ProfileFileTooBig, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ProfileOffset, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ProfileCleanup, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ProfileLoadErr, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ProfileSaveErr, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LogOverflow, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LogFileChanged, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LogFileCorrupt, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_SourceIsDir, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadSource, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadDest, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DifferentServers, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RunSrvPaused, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ErrCommRunSrv, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ErrorExecingGhost, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ShareNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InvalidLana, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadPasswordCore, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LocalDrive, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_AlertExists, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TooManyAlerts, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NoSuchAlert, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadRecipient, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_AcctLimitExceeded, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InvalidLogSeek, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadUasConfig, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InvalidUASOp, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LastAdmin, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DCNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_LogonTrackingError, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NetlogonNotStarted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_CanNotGrowUASFile, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TimeDiffAtDC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PasswordMismatch, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NoSuchServer, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NoSuchSession, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NoSuchConnection, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TooManyServers, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TooManySessions, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TooManyConnections, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TooManyFiles, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NoAlternateServers, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TryDownLevel, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UPSDriverNotStarted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UPSInvalidConfig, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UPSInvalidCommPort, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UPSSignalAsserted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_UPSShutdownFailed, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadDosRetCode, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ProgNeedsExtraMem, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadDosFunction, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RemoteBootFailed, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BadFileCheckSum, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NoRplBootSystem, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplLoadrNetBiosErr, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplLoadrDiskErr, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ImageParamErr, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_TooManyImageParams, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NonDosFloppyUsed, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplBootRestart, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplSrvrCallFailed, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_CantConnectRplSrvr, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_CantOpenImageFile, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_CallingRplSrvr, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_StartingRplBoot, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplBootServiceTerm, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplBootStartFailed, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RPL_CONNECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_BrowserConfiguredToNotRun, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplNoAdaptersStarted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplBadRegistry, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplBadDatabase, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplRplfilesShare, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplNotRplServer, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplCannotEnum, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplWkstaInfoCorrupted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplWkstaNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplWkstaNameUnavailable, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplProfileInfoCorrupted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplProfileNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplProfileNameUnavailable, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplProfileNotEmpty, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplConfigInfoCorrupted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplConfigNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplAdapterInfoCorrupted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplInternal, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplVendorInfoCorrupted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplBootInfoCorrupted, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplWkstaNeedsUserAcct, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplNeedsRPLUSERAcct, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplBootNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplIncompatibleProfile, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplAdapterNameUnavailable, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplConfigNotEmpty, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplBootInUse, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplBackupDatabase, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplAdapterNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplVendorNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplVendorNameUnavailable, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplBootNameUnavailable, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_RplConfigNameUnavailable, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsInternalCorruption, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsVolumeDataCorrupt, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsNoSuchVolume, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsVolumeAlreadyExists, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsAlreadyShared, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsNoSuchShare, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsNotALeafVolume, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsLeafVolume, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsVolumeHasMultipleServers, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsCantCreateJunctionPoint, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsServerNotDfsAware, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsBadRenamePath, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsVolumeIsOffline, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsNoSuchServer, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsCyclicalName, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsNotSupportedInServerDfs, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsDuplicateService, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsCantRemoveLastServerShare, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsVolumeIsInterDfs, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsInconsistent, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsServerUpgraded, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsDataIsIdentical, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsCantRemoveDfsRoot, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsChildOrParentInDfs, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DfsInternalError, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_SetupAlreadyJoined, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_SetupNotJoined, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_SetupDomainController, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_DefaultJoinRequired, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_InvalidWorkgroupName, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_NameUsesIncompatibleCodePage, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_ComputerAccountNotFound, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PersonalSku, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PasswordMustChange, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_AccountLockedOut, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PasswordTooLong, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PasswordNotComplexEnough, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, NERR_PasswordFilterError, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNKNOWN_PRINT_MONITOR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINTER_DRIVER_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SPOOL_FILE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SPL_NO_STARTDOC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SPL_NO_ADDJOB, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINT_MONITOR_ALREADY_INSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_PRINT_MONITOR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINT_MONITOR_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINTER_HAS_JOBS_QUEUED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SUCCESS_REBOOT_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SUCCESS_RESTART_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINTER_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINTER_DRIVER_WARNED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINTER_DRIVER_BLOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PRINTER_DRIVER_PACKAGE_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FAIL_REBOOT_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FAIL_REBOOT_INITIATED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IO_REISSUE_AS_CACHED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WINS_INTERNAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CAN_NOT_DEL_LOCAL_WINS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_STATIC_INIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INC_BACKUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FULL_BACKUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REC_NON_EXISTENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RPL_NOT_ALLOWED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_CONTENTINFO_VERSION_UNSUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_CANNOT_PARSE_CONTENTINFO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_MISSING_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_NO_MORE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_NOT_INITIALIZED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_ALREADY_INITIALIZED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_SHUTDOWN_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_INVALIDATED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_OPERATION_NOTFOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_ALREADY_COMPLETED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_OUT_OF_BOUNDS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_VERSION_UNSUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_INVALID_CONFIGURATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_NOT_LICENSED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, PEERDIST_ERROR_SERVICE_UNAVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_ADDRESS_CONFLICT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WMI_DP_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WMI_UNRESOLVED_INSTANCE_REF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WMI_SERVER_UNAVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WMI_DP_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WMI_INVALID_MOF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WMI_INVALID_REGINFO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_MEDIA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_LIBRARY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_MEDIA_POOL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DRIVE_MEDIA_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MEDIA_OFFLINE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LIBRARY_OFFLINE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EMPTY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_EMPTY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MEDIA_UNAVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_CLEANER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNABLE_TO_CLEAN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_OBJECT_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DATABASE_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DATABASE_FULL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MEDIA_INCOMPATIBLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_NOT_PRESENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_OPERATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MEDIA_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEVICE_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REQUEST_REFUSED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_DRIVE_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LIBRARY_FULL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MEDIUM_NOT_ACCESSIBLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNABLE_TO_LOAD_MEDIUM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNABLE_TO_INVENTORY_DRIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNABLE_TO_INVENTORY_SLOT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNABLE_TO_INVENTORY_TRANSPORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CONTROLLING_IEPORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLEANER_SLOT_SET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLEANER_SLOT_NOT_SET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLEANER_CARTRIDGE_SPENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNEXPECTED_OMID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANT_DELETE_LAST_ITEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MESSAGE_EXCEEDS_MAX_SIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VOLUME_CONTAINS_SYS_FILES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INDIGENOUS_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_SUPPORTING_DRIVES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IEPORT_FULL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VOLUME_NOT_SIS_ENABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEPENDENT_RESOURCE_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEPENDENCY_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEPENDENCY_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_NOT_ONLINE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HOST_NODE_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SHUTDOWN_CLUSTER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANT_EVICT_ACTIVE_NODE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_OBJECT_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_OBJECT_IN_LIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_GROUP_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_GROUP_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_GROUP_NOT_ONLINE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HOST_NODE_NOT_RESOURCE_OWNER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HOST_NODE_NOT_GROUP_OWNER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESMON_CREATE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESMON_ONLINE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_ONLINE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_QUORUM_RESOURCE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_QUORUM_CAPABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_SHUTTING_DOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_STATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_PROPERTIES_STORED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_QUORUM_CLASS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CORE_RESOURCE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_QUORUM_RESOURCE_ONLINE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_QUORUMLOG_OPEN_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTERLOG_CORRUPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_QUORUM_OWNER_ALIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NETWORK_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NODE_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ALL_NODES_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_INVALID_NODE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_JOIN_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NETWORK_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NETWORK_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NETINTERFACE_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NETINTERFACE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_INVALID_REQUEST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_INVALID_NETWORK_PROVIDER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_DOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_UNREACHABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_NOT_MEMBER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_INVALID_NETWORK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_UP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_IPADDR_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_NOT_PAUSED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NO_SECURITY_CONTEXT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NETWORK_NOT_INTERNAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_ALREADY_UP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_ALREADY_DOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NETWORK_ALREADY_ONLINE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_ALREADY_MEMBER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_LAST_INTERNAL_NETWORK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_OPERATION_ON_QUORUM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEPENDENCY_NOT_ALLOWED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_PAUSED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NODE_CANT_HOST_RESOURCE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_NOT_READY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_SHUTTING_DOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_JOIN_ABORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_INCOMPATIBLE_VERSIONS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_RESNAME_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_DATABASE_SEQMISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESMON_INVALID_STATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_GUM_NOT_LOCKER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_QUORUM_DISK_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DATABASE_BACKUP_CORRUPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_PROPERTY_UNCHANGEABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_QUORUMLOG_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_MEMBERSHIP_HALT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_INSTANCE_ID_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_PARAMETER_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NODE_CANNOT_BE_CLUSTERED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_WRONG_OS_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSCFG_ALREADY_COMMITTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSCFG_ROLLBACK_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_OLD_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NO_NET_ADAPTERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_POISONED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_GROUP_MOVING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_RESOURCE_TYPE_BUSY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_CALL_TIMED_OUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_CLUSTER_IPV6_ADDRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_INTERNAL_INVALID_FUNCTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_PARAMETER_OUT_OF_BOUNDS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_PARTIAL_SEND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_REGISTRY_INVALID_FUNCTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_INVALID_STRING_TERMINATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_INVALID_STRING_FORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NULL_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_PARTIAL_READ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_PARTIAL_WRITE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_CANT_DESERIALIZE_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_NO_QUORUM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_INVALID_IPV6_NETWORK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ENCRYPTION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DECRYPTION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_RECOVERY_POLICY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_EFS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_WRONG_EFS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_USER_KEYS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FILE_READ_ONLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DIR_EFS_DISALLOWED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EFS_SERVER_NOT_TRUSTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_BAD_RECOVERY_POLICY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_VOLUME_NOT_SUPPORT_EFS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EFS_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EFS_VERSION_NOT_SUPPORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CS_ENCRYPTION_UNSUPPORTED_SERVER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CS_ENCRYPTION_FILE_NOT_CSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, SCHED_E_SERVICE_NOT_LOCALSYSTEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_SECTOR_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_SECTOR_PARITY_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_SECTOR_REMAPPED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_BLOCK_INCOMPLETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_INVALID_RANGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_BLOCKS_EXHAUSTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_READ_CONTEXT_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_RESTART_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_BLOCK_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_BLOCK_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_READ_MODE_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_NO_RESTART, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_METADATA_CORRUPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_METADATA_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_METADATA_INCONSISTENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_RESERVATION_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_CANT_DELETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_CONTAINER_LIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_START_OF_LOG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_POLICY_ALREADY_INSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_POLICY_NOT_INSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_POLICY_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_POLICY_CONFLICT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_PINNED_ARCHIVE_TAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_RECORD_NONEXISTENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_RECORDS_RESERVED_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_SPACE_RESERVED_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_TAIL_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_FULL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_COULD_NOT_RESIZE_LOG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_MULTIPLEXED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_DEDICATED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_ARCHIVE_NOT_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_ARCHIVE_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_EPHEMERAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_NOT_ENOUGH_CONTAINERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_CLIENT_ALREADY_REGISTERED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_CLIENT_NOT_REGISTERED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_FULL_HANDLER_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_CONTAINER_READ_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_CONTAINER_WRITE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_CONTAINER_OPEN_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_CONTAINER_STATE_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_STATE_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_PINNED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_METADATA_FLUSH_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_INCONSISTENT_SECURITY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_APPENDED_FLUSH_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_PINNED_RESERVATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INVALID_TRANSACTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_NOT_ACTIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_REQUEST_NOT_VALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_NOT_REQUESTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_ALREADY_ABORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_ALREADY_COMMITTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TM_INITIALIZATION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCEMANAGER_READ_ONLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_NOT_JOINED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_SUPERIOR_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CRM_PROTOCOL_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_PROPAGATION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CRM_PROTOCOL_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_INVALID_MARSHALL_BUFFER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CURRENT_TRANSACTION_NOT_VALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCEMANAGER_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ENLISTMENT_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTIONMANAGER_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTIONMANAGER_NOT_ONLINE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTIONAL_CONFLICT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RM_NOT_ACTIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RM_METADATA_CORRUPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DIRECTORY_NOT_RM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTIONS_UNSUPPORTED_REMOTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_RESIZE_INVALID_SIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_OBJECT_NO_LONGER_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_STREAM_MINIVERSION_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_STREAM_MINIVERSION_NOT_VALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANT_CREATE_MORE_STREAM_MINIVERSIONS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_REMOTE_FILE_VERSION_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_HANDLE_NO_LONGER_VALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_TXF_METADATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_CORRUPTION_DETECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANT_RECOVER_WITH_HANDLE_OPEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RM_DISCONNECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ENLISTMENT_NOT_SUPERIOR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RECOVERY_NOT_NEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RM_ALREADY_STARTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FILE_IDENTITY_NOT_PERSISTENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANT_CROSS_RM_BOUNDARY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TXF_DIR_NOT_EMPTY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_INDOUBT_TRANSACTIONS_EXIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TM_VOLATILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ROLLBACK_TIMER_EXPIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TXF_ATTRIBUTE_CORRUPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTIONAL_OPEN_NOT_ALLOWED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_LOG_GROWTH_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TXF_METADATA_ALREADY_PRESENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_REQUIRED_PROMOTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANNOT_EXECUTE_FILE_IN_TRANSACTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTIONS_NOT_FROZEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TRANSACTION_FREEZE_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_SNAPSHOT_VOLUME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_SAVEPOINT_WITH_OPEN_FILES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DATA_LOST_REPAIR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SPARSE_NOT_ALLOWED_IN_TRANSACTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TM_IDENTITY_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_FLOATED_SECTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANNOT_ACCEPT_TRANSACTED_WORK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CANNOT_ABORT_TRANSACTIONS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_WINSTATION_NAME_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_INVALID_PD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_PD_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_WD_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_SERVICE_NAME_COLLISION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_CLOSE_PENDING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_NO_OUTBUF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_MODEM_INF_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_INVALID_MODEMNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_MODEM_RESPONSE_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_MODEM_RESPONSE_TIMEOUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_MODEM_RESPONSE_NO_CARRIER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_MODEM_RESPONSE_BUSY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_MODEM_RESPONSE_VOICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_TD_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_WINSTATION_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_WINSTATION_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_WINSTATION_BUSY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_BAD_VIDEO_MODE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_GRAPHICS_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_LOGON_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_NOT_CONSOLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_CLIENT_QUERY_TIMEOUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_CONSOLE_DISCONNECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_CONSOLE_CONNECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_SHADOW_DENIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_WINSTATION_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_INVALID_WD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_SHADOW_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_SHADOW_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_CLIENT_LICENSE_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_CLIENT_LICENSE_NOT_SET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_LICENSE_CLIENT_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_LICENSE_EXPIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_SHADOW_NOT_RUNNING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ACTIVATION_COUNT_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_WINSTATIONS_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_SESSION_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_NO_FORCE_LOGOFF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_ACCOUNT_RESTRICTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RDP_PROTOCOL_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_CDM_CONNECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_CDM_DISCONNECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_CTX_SECURITY_LAYER_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_TS_INCOMPATIBLE_SESSIONS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_INVALID_API_SEQUENCE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_STARTING_SERVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_STOPPING_SERVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_INTERNAL_API, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_INTERNAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_SERVICE_COMM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_INSUFFICIENT_PRIV, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_AUTHENTICATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_PARENT_INSUFFICIENT_PRIV, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_PARENT_AUTHENTICATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_CHILD_TO_PARENT_COMM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_PARENT_TO_CHILD_COMM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_SYSVOL_POPULATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_SYSVOL_POPULATE_TIMEOUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_SYSVOL_IS_BUSY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_SYSVOL_DEMOTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, FRS_ERR_INVALID_SERVICE_PARAMETER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NOT_INSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_PROMOTION_ACTIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_PROMOTION_ACTIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OPERATIONS_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_PROTOCOL_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_TIMELIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SIZELIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_COMPARE_FALSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_COMPARE_TRUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_AUTH_METHOD_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_STRONG_AUTH_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INAPPROPRIATE_AUTH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_AUTH_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_REFERRAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_UNAVAILABLE_CRIT_EXTENSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CONFIDENTIALITY_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INAPPROPRIATE_MATCHING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CONSTRAINT_VIOLATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_SUCH_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ALIAS_PROBLEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INVALID_DN_SYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_IS_LEAF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ALIAS_DEREF_PROBLEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_UNWILLING_TO_PERFORM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_LOOP_DETECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAMING_VIOLATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OBJECT_RESULTS_TOO_LARGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_AFFECTS_MULTIPLE_DSAS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SERVER_DOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_LOCAL_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ENCODING_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DECODING_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_FILTER_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_PARAM_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_RESULTS_RETURNED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CONTROL_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CLIENT_LOOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_REFERRAL_LIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SORT_CONTROL_MISSING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OFFSET_RANGE_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ROOT_MUST_BE_NC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ADD_REPLICA_INHIBITED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ATT_NOT_DEF_IN_SCHEMA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_MAX_OBJ_SIZE_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OBJ_STRING_NAME_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_RDN_DOESNT_MATCH_SCHEMA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_REQUESTED_ATTS_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_USER_BUFFER_TO_SMALL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ATT_IS_NOT_ON_OBJ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ILLEGAL_MOD_OPERATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OBJ_TOO_LARGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_BAD_INSTANCE_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_MASTERDSA_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OBJECT_CLASS_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_MISSING_REQUIRED_ATT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ATT_NOT_DEF_FOR_CLASS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ATT_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_ADD_ATT_VALUES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SINGLE_VALUE_CONSTRAINT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_RANGE_CONSTRAINT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ATT_VAL_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_REM_MISSING_ATT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_REM_MISSING_ATT_VAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ROOT_CANT_BE_SUBREF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_CHAINING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_CHAINED_EVAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_PARENT_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_PARENT_IS_AN_ALIAS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_MIX_MASTER_AND_REPS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CHILDREN_EXIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OBJ_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ALIASED_OBJ_MISSING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_BAD_NAME_SYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ALIAS_POINTS_TO_ALIAS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_DEREF_ALIAS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OUT_OF_SCOPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OBJECT_BEING_REMOVED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_DELETE_DSA_OBJ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_GENERIC_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DSA_MUST_BE_INT_MASTER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CLASS_NOT_DSA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INSUFF_ACCESS_RIGHTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ILLEGAL_SUPERIOR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ATTRIBUTE_OWNED_BY_SAM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_TOO_MANY_PARTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_TOO_LONG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_VALUE_TOO_LONG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_UNPARSEABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_TYPE_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NOT_AN_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SEC_DESC_TOO_SHORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SEC_DESC_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_DELETED_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SUBREF_MUST_HAVE_PARENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NCNAME_MUST_BE_NC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_ADD_SYSTEM_ONLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CLASS_MUST_BE_CONCRETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INVALID_DMD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OBJ_GUID_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NOT_ON_BACKLINK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_CROSSREF_FOR_NC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_UNKNOWN_OPERATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INVALID_ROLE_OWNER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_COULDNT_CONTACT_FSMO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CROSS_NC_DN_RENAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_MOD_SYSTEM_ONLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_REPLICATOR_ONLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OBJ_CLASS_NOT_DEFINED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OBJ_CLASS_NOT_SUBCLASS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_REFERENCE_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CROSS_REF_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_DEL_MASTER_CROSSREF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DUP_RDN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DUP_OID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DUP_MAPI_ID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DUP_SCHEMA_ID_GUID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DUP_LDAP_DISPLAY_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SEMANTIC_ATT_TEST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SYNTAX_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_EXISTS_IN_MUST_HAVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_EXISTS_IN_MAY_HAVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NONEXISTENT_MAY_HAVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NONEXISTENT_MUST_HAVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_AUX_CLS_TEST_FAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NONEXISTENT_POSS_SUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SUB_CLS_TEST_FAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_BAD_RDN_ATT_ID_SYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_EXISTS_IN_AUX_CLS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_EXISTS_IN_SUB_CLS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_EXISTS_IN_POSS_SUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_RECALCSCHEMA_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_TREE_DELETE_NOT_FINISHED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_DELETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ATT_SCHEMA_REQ_ID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_BAD_ATT_SCHEMA_SYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_CACHE_ATT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_CACHE_CLASS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_REMOVE_ATT_CACHE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_REMOVE_CLASS_CACHE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_RETRIEVE_DN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_MISSING_SUPREF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_RETRIEVE_INSTANCE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CODE_INCONSISTENCY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DATABASE_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_GOVERNSID_MISSING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_MISSING_EXPECTED_ATT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NCNAME_MISSING_CR_REF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SECURITY_CHECKING_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SCHEMA_NOT_LOADED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SCHEMA_ALLOC_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ATT_SCHEMA_REQ_SYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_GCVERIFY_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_SCHEMA_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_FIND_DSA_OBJ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_FIND_EXPECTED_NC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_FIND_NC_IN_CACHE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_RETRIEVE_CHILD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SECURITY_ILLEGAL_MODIFY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_REPLACE_HIDDEN_REC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_BAD_HIERARCHY_FILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CONFIG_PARAM_MISSING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_COUNTING_AB_INDICES_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INTERNAL_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_UNKNOWN_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ROOT_REQUIRES_CLASS_TOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_REFUSING_FSMO_ROLES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_MISSING_FSMO_SETTINGS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_UNABLE_TO_SURRENDER_ROLES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_GENERIC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_BUSY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_BAD_DN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_BAD_NC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_DN_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_INTERNAL_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_INCONSISTENT_DIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_CONNECTION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_BAD_INSTANCE_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_OUT_OF_MEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_MAIL_PROBLEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_REF_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_REF_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_OBJ_IS_REP_SOURCE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_DB_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_NO_REPLICA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_RPC_CANCELLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_SOURCE_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_SINK_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_NAME_COLLISION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_SOURCE_REINSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_MISSING_PARENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_PREEMPTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_ABANDON_SYNC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_SHUTDOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_EXTN_CONNECTION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INSTALL_SCHEMA_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DUP_LINK_ID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_ERROR_RESOLVING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_ERROR_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_ERROR_NOT_UNIQUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_ERROR_NO_MAPPING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_ERROR_DOMAIN_ONLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CONSTRUCTED_ATT_MOD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_WRONG_OM_OBJ_CLASS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_REPL_PENDING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INVALID_LDAP_DISPLAY_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NON_BASE_SEARCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_RETRIEVE_ATTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_BACKLINK_WITHOUT_LINK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_EPOCH_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SRC_NAME_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SRC_AND_DST_NC_IDENTICAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DST_NC_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SRC_GUID_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_MOVE_DELETED_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_PDC_OPERATION_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NC_MUST_HAVE_NC_PARENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DST_DOMAIN_NOT_NATIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_MOVE_ACCOUNT_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_MOVE_RESOURCE_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INVALID_SEARCH_FLAG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_TREE_DELETE_ABOVE_NC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NONSAFE_SCHEMA_CHANGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SCHEMA_UPDATE_DISALLOWED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_CREATE_UNDER_SCHEMA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INSTALL_NO_SRC_SCH_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_STRING_SD_CONVERSION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAMING_MASTER_GC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DNS_LOOKUP_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_COULDNT_UPDATE_SPNS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_RETRIEVE_SD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_KEY_NOT_UNIQUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_WRONG_LINKED_ATT_SYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SOURCE_DOMAIN_IN_FOREST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SRC_SID_EXISTS_IN_FOREST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_SCHEMA_INFO_SHIP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_SCHEMA_CONFLICT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_OBJ_NC_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NC_STILL_HAS_DSAS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_ADD_TO_GC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_CHECKPOINT_WITH_PDC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SOURCE_AUDITING_NOT_ENABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INVALID_NAME_FOR_SPN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_UNICODEPWD_NOT_IN_QUOTES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_MUST_BE_RUN_ON_DST_DC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_FOREST_VERSION_TOO_HIGH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DOMAIN_VERSION_TOO_HIGH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_FOREST_VERSION_TOO_LOW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DOMAIN_VERSION_TOO_LOW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INCOMPATIBLE_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_LOW_DSA_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NOT_SUPPORTED_SORT_ORDER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_NOT_UNIQUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_OUT_OF_VERSION_STORE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INCOMPATIBLE_CONTROLS_USED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_REF_DOMAIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_RESERVED_LINK_ID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_LINK_ID_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_MODIFYDN_WRONG_GRANDPARENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NAME_ERROR_TRUST_REFERRAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_THREAD_LIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NOT_CLOSEST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_SINGLE_USER_MODE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NTDSCRIPT_SYNTAX_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NTDSCRIPT_PROCESS_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DIFFERENT_REPL_EPOCHS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRS_EXTENSIONS_CHANGED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_MSDS_INTID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DUP_MSDS_INTID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_EXISTS_IN_RDNATTID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_AUTHORIZATION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INVALID_SCRIPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_REMOTE_CROSSREF_OP_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CROSS_REF_BUSY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DUPLICATE_ID_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_GROUP_CONVERSION_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_MOVE_APP_BASIC_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_CANT_MOVE_APP_QUERY_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_ROLE_NOT_VERIFIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DOMAIN_RENAME_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_EXISTING_AD_CHILD_NC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_REPL_LIFETIME_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_LDAP_SEND_QUEUE_FULL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_DRA_OUT_SCHEDULE_WINDOW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_POLICY_NOT_KNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_SITE_SETTINGS_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_SECRETS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_NO_WRITABLE_DC_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_SERVER_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NO_NTDSA_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_NON_ASQ_SEARCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_AUDIT_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INVALID_SEARCH_FLAG_SUBTREE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DS_INVALID_SEARCH_FLAG_TUPLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_FORMAT_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_SERVER_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_NAME_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_NOT_IMPLEMENTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_REFUSED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_YXDOMAIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_YXRRSET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_NXRRSET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_NOTAUTH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_NOTZONE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_BADSIG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_BADKEY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE_BADTIME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_INFO_NO_RECORDS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_BAD_PACKET, -1, "A bad packet was received from a DNS server. Potentially the requested address does not exist." )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NO_PACKET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RCODE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_UNSECURE_PACKET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_INVALID_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_INVALID_IP_ADDRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_INVALID_PROPERTY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_TRY_AGAIN_LATER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NOT_UNIQUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NON_RFC_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_STATUS_FQDN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_STATUS_DOTTED_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_STATUS_SINGLE_PART_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_INVALID_NAME_CHAR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NUMERIC_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_CANNOT_FIND_ROOT_HINTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_INCONSISTENT_ROOT_HINTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DWORD_VALUE_TOO_SMALL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DWORD_VALUE_TOO_LARGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_BACKGROUND_LOADING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NOT_ALLOWED_ON_RODC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_ZONE_DOES_NOT_EXIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NO_ZONE_INFO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_INVALID_ZONE_OPERATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_ZONE_CONFIGURATION_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_ZONE_HAS_NO_SOA_RECORD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_ZONE_HAS_NO_NS_RECORDS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_ZONE_LOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_ZONE_CREATION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_ZONE_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_AUTOZONE_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_INVALID_ZONE_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_ZONE_NOT_SECONDARY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NEED_SECONDARY_ADDRESSES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_WINS_INIT_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NEED_WINS_SERVERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NBSTAT_INIT_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_SOA_DELETE_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_FORWARDER_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_ZONE_REQUIRES_MASTER_IP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_ZONE_IS_SHUTDOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_PRIMARY_REQUIRES_DATAFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_INVALID_DATAFILE_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DATAFILE_OPEN_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_FILE_WRITEBACK_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DATAFILE_PARSING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RECORD_DOES_NOT_EXIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RECORD_FORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NODE_CREATION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_UNKNOWN_RECORD_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RECORD_TIMED_OUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NAME_NOT_IN_ZONE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_CNAME_LOOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NODE_IS_CNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_CNAME_COLLISION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_RECORD_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_SECONDARY_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NO_CREATE_CACHE_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NAME_DOES_NOT_EXIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_WARNING_PTR_CREATE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_WARNING_DOMAIN_UNDELETED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DS_UNAVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DS_ZONE_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_INFO_AXFR_COMPLETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_AXFR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_INFO_ADDED_LOCAL_WINS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_STATUS_CONTINUE_NEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NO_TCPIP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_NO_DNS_SERVERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DP_DOES_NOT_EXIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DP_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DP_NOT_ENLISTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DP_ALREADY_ENLISTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DP_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, DNS_ERROR_DP_FSMO_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEINTR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEBADF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEACCES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEFAULT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEINVAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEMFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEWOULDBLOCK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEINPROGRESS, EINPROGRESS, "Operation now in progress" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEALREADY, EALREADY, "Operation already in progress" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAENOTSOCK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEDESTADDRREQ, EDESTADDRREQ, "Destination address required" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEMSGSIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEPROTOTYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAENOPROTOOPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEPROTONOSUPPORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAESOCKTNOSUPPORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEOPNOTSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEPFNOSUPPORT, EAFNOSUPPORT, "Protocol family not supported" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEADDRINUSE, EADDRINUSE, "Address already in use" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEADDRNOTAVAIL, EADDRNOTAVAIL, "Cannot assign requested address" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAENETDOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAENETUNREACH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAENETRESET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAECONNABORTED, ECONNABORTED, "connection abort" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAECONNRESET, ECONNRESET, "Connection reset by peer" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAENOBUFS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEISCONN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAENOTCONN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAESHUTDOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAETOOMANYREFS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAETIMEDOUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAECONNREFUSED, ECONNREFUSED, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAELOOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAENAMETOOLONG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEHOSTDOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEHOSTUNREACH, EHOSTUNREACH, "Host unreachable" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAENOTEMPTY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEPROCLIM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEUSERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEDQUOT, EDQUOT, "Disk quota exceeded" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAESTALE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEREMOTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSASYSNOTREADY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAVERNOTSUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSANOTINITIALISED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEDISCON, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAENOMORE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAECANCELLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEINVALIDPROCTABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEINVALIDPROVIDER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEPROVIDERFAILEDINIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSASYSCALLFAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSASERVICE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSATYPE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_E_NO_MORE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_E_CANCELLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAEREFUSED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSAHOST_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSATRY_AGAIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSANO_RECOVERY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSANO_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_RECEIVERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_SENDERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_NO_SENDERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_NO_RECEIVERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_REQUEST_CONFIRMED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_ADMISSION_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_POLICY_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_BAD_STYLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_BAD_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_TRAFFIC_CTRL_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_GENERIC_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_ESERVICETYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EFLOWSPEC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EPROVSPECBUF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EFILTERSTYLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EFILTERTYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EFILTERCOUNT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EOBJLENGTH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EFLOWCOUNT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EUNKOWNPSOBJ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EPOLICYOBJ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EFLOWDESC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EPSFLOWSPEC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_EPSFILTERSPEC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_ESDMODEOBJ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_ESHAPERATEOBJ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_QOS_RESERVED_PETYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WSA_IPSEC_NAME_POLICY_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_QM_POLICY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_QM_POLICY_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_QM_POLICY_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_MM_POLICY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_MM_POLICY_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_MM_POLICY_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_MM_FILTER_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_MM_FILTER_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_TRANSPORT_FILTER_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_MM_AUTH_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_MM_AUTH_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_MM_AUTH_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_TUNNEL_FILTER_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_MM_FILTER_PENDING_DELETION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_MM_POLICY_PENDING_DELETION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_MM_AUTH_PENDING_DELETION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_QM_POLICY_PENDING_DELETION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WARNING_IPSEC_MM_POLICY_PRUNED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, WARNING_IPSEC_QM_POLICY_PRUNED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NEG_STATUS_BEGIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_AUTH_FAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_ATTRIB_FAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NEGOTIATION_PENDING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_TIMED_OUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NO_CERT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_SA_DELETED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_SA_REAPED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_MM_ACQUIRE_DROP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_QM_ACQUIRE_DROP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_QUEUE_DROP_MM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_DROP_NO_RESPONSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_MM_DELAY_DROP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_QM_DELAY_DROP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_CRL_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_KEY_USAGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_CERT_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NO_PRIVATE_KEY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_SIMULTANEOUS_REKEY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_DH_FAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_CRITICAL_PAYLOAD_NOT_RECOGNIZED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_HEADER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NO_POLICY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_SIGNATURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_KERBEROS_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NO_PUBLIC_KEY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_SA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_PROP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_TRANS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_KE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_ID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_CERT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_HASH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_SIG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_NONCE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_DELETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_PAYLOAD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_LOAD_SOFT_SA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_COOKIE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NO_PEER_CERT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PEER_CRL_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_POLICY_CHANGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NO_MM_POLICY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NOTCBPRIV, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_SECLOADFAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_FAILSSPINIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_FAILQUERYSSP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_SRVACQFAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_SRVQUERYCRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_GETSPIFAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_FILTER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_OUT_OF_MEMORY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_POLICY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_UNKNOWN_DOI, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_SITUATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_DH_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_ENCRYPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_DECRYPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_POLICY_MATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_UNSUPPORTED_ID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_HASH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_HASH_ALG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_HASH_SIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_AUTH_ALG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_SIG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_LOAD_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_RPC_DELETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_BENIGN_REINIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_MAJOR_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_MM_LIMIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NEGOTIATION_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_QM_LIMIT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_MM_EXPIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_UMATTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_DOS_COOKIE_SENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_SHUTTING_DOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_CGA_AUTH_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PROCESS_ERR_NATOA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INVALID_MM_FOR_QM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_QM_EXPIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_TOO_MANY_FILTERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NEG_STATUS_END, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_COEXISTENCE_SUPPRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_RATELIMIT_DROP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE_WITH_OPTIONAL_RETRY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_AND_CERTMAP_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_BAD_SPI, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_SA_LIFETIME_EXPIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_WRONG_SA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_REPLAY_CHECK_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_INVALID_PACKET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_INTEGRITY_CHECK_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_CLEAR_TEXT_DROP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_AUTH_FIREWALL_DROP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_THROTTLE_DROP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_DOSP_BLOCK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_DOSP_RECEIVED_MULTICAST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_DOSP_INVALID_PACKET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_DOSP_MAX_ENTRIES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_DOSP_NOT_INSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_SECTION_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_CANT_GEN_ACTCTX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_INVALID_ACTCTXDATA_FORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_ASSEMBLY_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_MANIFEST_FORMAT_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_MANIFEST_PARSE_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_ACTIVATION_CONTEXT_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_KEY_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_VERSION_CONFLICT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_WRONG_SECTION_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_THREAD_QUERIES_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_UNKNOWN_ENCODING_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_UNKNOWN_ENCODING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_INVALID_XML_NAMESPACE_URI, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_DUPLICATE_DLL_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_DUPLICATE_CLSID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_DUPLICATE_IID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_DUPLICATE_TLBID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_DUPLICATE_PROGID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_DUPLICATE_ASSEMBLY_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_FILE_HASH_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_POLICY_PARSE_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_MISSINGQUOTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_COMMENTSYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_BADSTARTNAMECHAR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_BADNAMECHAR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_BADCHARINSTRING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_XMLDECLSYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_BADCHARDATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_MISSINGWHITESPACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_EXPECTINGTAGEND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_MISSINGSEMICOLON, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNBALANCEDPAREN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_INTERNALERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_INCOMPLETE_ENCODING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_MISSING_PAREN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_MULTIPLE_COLONS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_INVALID_DECIMAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_INVALID_HEXIDECIMAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_INVALID_UNICODE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNEXPECTEDENDTAG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNCLOSEDTAG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_DUPLICATEATTRIBUTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_MULTIPLEROOTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_INVALIDATROOTLEVEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_BADXMLDECL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_MISSINGROOT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNEXPECTEDEOF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_BADPEREFINSUBSET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNCLOSEDSTARTTAG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNCLOSEDENDTAG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNCLOSEDSTRING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNCLOSEDCOMMENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNCLOSEDDECL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNCLOSEDCDATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_RESERVEDNAMESPACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_INVALIDENCODING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_INVALIDSWITCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_BADXMLCASE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_INVALID_STANDALONE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_UNEXPECTED_STANDALONE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_INVALID_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_XML_E_MISSINGEQUALS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_PROTECTION_RECOVERY_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_PROTECTION_CATALOG_NOT_VALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_UNTRANSLATABLE_HRESULT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_ASSEMBLY_MISSING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_CORRUPT_ACTIVATION_STACK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_CORRUPTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_EARLY_DEACTIVATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_INVALID_DEACTIVATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_MULTIPLE_DEACTIVATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_PROCESS_TERMINATION_REQUESTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_RELEASE_ACTIVATION_CONTEXT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_IDENTITY_PARSE_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MALFORMED_SUBSTITUTION_STRING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_INCORRECT_PUBLIC_KEY_TOKEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_UNMAPPED_SUBSTITUTION_STRING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_ASSEMBLY_NOT_LOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_COMPONENT_STORE_CORRUPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_ADVANCED_INSTALLER_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_XML_ENCODING_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_IDENTITIES_DIFFERENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_MANIFEST_TOO_BIG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_SETTING_NOT_REGISTERED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_INVALID_CHANNEL_PATH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_INVALID_QUERY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_INVALID_PUBLISHER_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_INVALID_EVENT_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_CHANNEL_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_MALFORMED_XML_TEXT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_CONFIGURATION_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_QUERY_RESULT_STALE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_QUERY_RESULT_INVALID_POSITION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_NON_VALIDATING_MSXML, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_FILTER_ALREADYSCOPED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_FILTER_NOTELTSET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_FILTER_INVARG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_FILTER_INVTEST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_FILTER_INVTYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_FILTER_PARSEERR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_FILTER_UNSUPPORTEDOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_FILTER_UNEXPECTEDTOKEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_CHANNEL_CANNOT_ACTIVATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_FILTER_TOO_COMPLEX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_MESSAGE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_MESSAGE_ID_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_UNRESOLVED_VALUE_INSERT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_UNRESOLVED_PARAMETER_INSERT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_MAX_INSERTS_REACHED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_EVENT_DEFINITION_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_VERSION_TOO_OLD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_VERSION_TOO_NEW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_PUBLISHER_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EVT_FILTER_OUT_OF_RANGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EC_LOG_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EC_CIRCULAR_FORWARDING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EC_CREDSTORE_FULL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EC_CRED_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_EC_NO_ACTIVE_CHANNEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MUI_FILE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MUI_INVALID_FILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MUI_INVALID_RC_CONFIG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MUI_INVALID_LOCALE_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MUI_FILE_NOT_LOADED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_RESOURCE_ENUM_USER_STOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MCA_INVALID_CAPABILITIES_STRING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MCA_INVALID_VCP_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MCA_MCCS_VERSION_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MCA_UNSUPPORTED_MCCS_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MCA_INTERNAL_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_AMBIGUOUS_SYSTEM_DEVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_SYSTEM_DEVICE_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_SUBNET_NOT_PRESENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_ELEMENT_CANT_REMOVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_OPTION_EXITS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_OPTION_NOT_PRESENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_ADDRESS_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_JET_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_CLIENT_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_NOT_RESERVED_CLIENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_RESERVED_CLIENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_IPRANGE_EXITS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_RESERVEDIP_EXITS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_INVALID_RANGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_CLASS_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_CLASS_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_SCOPE_NAME_TOO_LONG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_IPRANGE_CONV_ILLEGAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_NETWORK_CHANGED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_CANNOT_MODIFY_BINDINGS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_SUBNET_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_DHCP_MSCOPE_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, ERROR_MSCOPE_RANGE_TOO_SMALL, -1, "" )

/* End autogenerated portion */

#undef S
#endif


/*
local variables:
mode: c
c-basic-offset: 4
indent-tabs-mode: nil
tab-width: 4
end:
*/
