#ifndef __FSERV_PROTOCOL_H__
#define __FSERV_PROTOCOL_H__

#include <lwmsg/lwmsg.h>

/* Begin message structures */

/* Opaque type -- actual definition in protocol-server.h */
typedef struct FileHandle FileHandle;

typedef enum OpenMode
{
    OPEN_MODE_READ = 1,
    OPEN_MODE_WRITE = 2,
    OPEN_MODE_APPEND = 4
} OpenMode;

/* Parameters sent in an open request */
typedef struct OpenRequest
{
    char* path;
    OpenMode mode;
} OpenRequest;

/* Parameters sent in a write request */
typedef struct WriteRequest
{
    FileHandle* handle;
    unsigned long size;
    char* data;
} WriteRequest;

/* Parameters sent in a read request */
typedef struct ReadRequest
{
    FileHandle* handle;
    unsigned long size;
} ReadRequest;

/* Generic status code reply for faild open, failed read, write, close */
typedef struct StatusReply
{
    int err;
} StatusReply;

/* Reply to a successful read request */
typedef struct ReadReply
{
    unsigned long size;
    char* data;
} ReadReply;

/* Notably missing structures:
 *
 * OpenReply - the reply type is just a FileHandle if it succeeds
 * CloseRequest - the request type is just a FileHandle
 */

/* End message structures */

/* Begin message enumeration */
typedef enum MessageType
{
    FSERV_OPEN,             /* OpenRequest */
    FSERV_OPEN_SUCCESS,     /* FileHandle */
    FSERV_OPEN_FAILED,      /* StatusReply */
    FSERV_READ,             /* ReadRequest */
    FSERV_READ_SUCCESS,     /* ReadReply */
    FSERV_READ_FAILED,      /* StatusReply */
    FSERV_WRITE,            /* WriteRequest */
    FSERV_WRITE_SUCCESS,    /* StatusReply */
    FSERV_WRITE_FAILED,     /* StatusReply */
    FSERV_CLOSE,            /* FileHandle */
    FSERV_CLOSE_SUCCESS,    /* StatusReply */
    FSERV_CLOSE_FAILED      /* StatusReply */
} MessageType;
/* End message enumeration */    

LWMsgProtocolSpec*
fserv_get_protocol(void);

#define FSERV_SOCKET_PATH "/tmp/.fserv-socket"

#endif
