/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "librpc/gen_ndr/cli_svcctl.h"

NTSTATUS rpccli_svcctl_CloseServiceHandle(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle,
					  WERROR *werror)
{
	struct svcctl_CloseServiceHandle r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_CloseServiceHandle, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_CLOSESERVICEHANDLE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_CloseServiceHandle, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_ControlService(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle,
				      uint32_t control,
				      struct SERVICE_STATUS *service_status,
				      WERROR *werror)
{
	struct svcctl_ControlService r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.control = control;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_ControlService, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_CONTROLSERVICE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_ControlService, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*service_status = *r.out.service_status;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_DeleteService(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle,
				     WERROR *werror)
{
	struct svcctl_DeleteService r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_DeleteService, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_DELETESERVICE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_DeleteService, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_LockServiceDatabase(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle,
					   struct policy_handle *lock,
					   WERROR *werror)
{
	struct svcctl_LockServiceDatabase r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_LockServiceDatabase, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_LOCKSERVICEDATABASE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_LockServiceDatabase, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*lock = *r.out.lock;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_QueryServiceObjectSecurity(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror)
{
	struct svcctl_QueryServiceObjectSecurity r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_QueryServiceObjectSecurity, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_QUERYSERVICEOBJECTSECURITY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_QueryServiceObjectSecurity, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_SetServiceObjectSecurity(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						WERROR *werror)
{
	struct svcctl_SetServiceObjectSecurity r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_SetServiceObjectSecurity, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_SETSERVICEOBJECTSECURITY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_SetServiceObjectSecurity, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_QueryServiceStatus(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle,
					  struct SERVICE_STATUS *service_status,
					  WERROR *werror)
{
	struct svcctl_QueryServiceStatus r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_QueryServiceStatus, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_QUERYSERVICESTATUS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_QueryServiceStatus, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*service_status = *r.out.service_status;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_SetServiceStatus(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror)
{
	struct svcctl_SetServiceStatus r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_SetServiceStatus, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_SETSERVICESTATUS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_SetServiceStatus, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_UnlockServiceDatabase(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *lock,
					     WERROR *werror)
{
	struct svcctl_UnlockServiceDatabase r;
	NTSTATUS status;

	/* In parameters */
	r.in.lock = lock;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_UnlockServiceDatabase, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_UNLOCKSERVICEDATABASE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_UnlockServiceDatabase, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*lock = *r.out.lock;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_NotifyBootConfigStatus(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror)
{
	struct svcctl_NotifyBootConfigStatus r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_NotifyBootConfigStatus, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_NOTIFYBOOTCONFIGSTATUS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_NotifyBootConfigStatus, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_SCSetServiceBitsW(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle,
					 uint32_t bits,
					 uint32_t bitson,
					 uint32_t immediate,
					 WERROR *werror)
{
	struct svcctl_SCSetServiceBitsW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.bits = bits;
	r.in.bitson = bitson;
	r.in.immediate = immediate;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_SCSetServiceBitsW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_SCSETSERVICEBITSW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_SCSetServiceBitsW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_ChangeServiceConfigW(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle,
					    uint32_t type,
					    uint32_t start,
					    uint32_t error,
					    const char *binary_path,
					    const char *load_order_group,
					    uint32_t *tag_id,
					    const char *dependencies,
					    const char *service_start_name,
					    const char *password,
					    const char *display_name,
					    WERROR *werror)
{
	struct svcctl_ChangeServiceConfigW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.type = type;
	r.in.start = start;
	r.in.error = error;
	r.in.binary_path = binary_path;
	r.in.load_order_group = load_order_group;
	r.in.dependencies = dependencies;
	r.in.service_start_name = service_start_name;
	r.in.password = password;
	r.in.display_name = display_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_ChangeServiceConfigW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_CHANGESERVICECONFIGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_ChangeServiceConfigW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*tag_id = *r.out.tag_id;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_CreateServiceW(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *scmanager_handle,
				      const char *ServiceName,
				      const char *DisplayName,
				      uint32_t desired_access,
				      uint32_t type,
				      uint32_t start_type,
				      uint32_t error_control,
				      const char *binary_path,
				      const char *LoadOrderGroupKey,
				      uint32_t *TagId,
				      uint8_t *dependencies,
				      uint32_t dependencies_size,
				      const char *service_start_name,
				      uint8_t *password,
				      uint32_t password_size,
				      struct policy_handle *handle,
				      WERROR *werror)
{
	struct svcctl_CreateServiceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager_handle = scmanager_handle;
	r.in.ServiceName = ServiceName;
	r.in.DisplayName = DisplayName;
	r.in.desired_access = desired_access;
	r.in.type = type;
	r.in.start_type = start_type;
	r.in.error_control = error_control;
	r.in.binary_path = binary_path;
	r.in.LoadOrderGroupKey = LoadOrderGroupKey;
	r.in.TagId = TagId;
	r.in.dependencies = dependencies;
	r.in.dependencies_size = dependencies_size;
	r.in.service_start_name = service_start_name;
	r.in.password = password;
	r.in.password_size = password_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_CreateServiceW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_CREATESERVICEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_CreateServiceW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (TagId && r.out.TagId) {
		*TagId = *r.out.TagId;
	}
	*handle = *r.out.handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_EnumDependentServicesW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *service,
					      uint32_t state,
					      struct ENUM_SERVICE_STATUS *service_status,
					      uint32_t buf_size,
					      uint32_t *bytes_needed,
					      uint32_t *services_returned,
					      WERROR *werror)
{
	struct svcctl_EnumDependentServicesW r;
	NTSTATUS status;

	/* In parameters */
	r.in.service = service;
	r.in.state = state;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_EnumDependentServicesW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_ENUMDEPENDENTSERVICESW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_EnumDependentServicesW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (service_status && r.out.service_status) {
		*service_status = *r.out.service_status;
	}
	*bytes_needed = *r.out.bytes_needed;
	*services_returned = *r.out.services_returned;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_EnumServicesStatusW(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle,
					   uint32_t type,
					   uint32_t state,
					   uint32_t buf_size,
					   uint8_t *service,
					   uint32_t *bytes_needed,
					   uint32_t *services_returned,
					   uint32_t *resume_handle,
					   WERROR *werror)
{
	struct svcctl_EnumServicesStatusW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.type = type;
	r.in.state = state;
	r.in.buf_size = buf_size;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_EnumServicesStatusW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_ENUMSERVICESSTATUSW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_EnumServicesStatusW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(service, r.out.service, r.in.buf_size);
	*bytes_needed = *r.out.bytes_needed;
	*services_returned = *r.out.services_returned;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_OpenSCManagerW(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *MachineName,
				      const char *DatabaseName,
				      uint32_t access_mask,
				      struct policy_handle *handle,
				      WERROR *werror)
{
	struct svcctl_OpenSCManagerW r;
	NTSTATUS status;

	/* In parameters */
	r.in.MachineName = MachineName;
	r.in.DatabaseName = DatabaseName;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_OpenSCManagerW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_OPENSCMANAGERW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_OpenSCManagerW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_OpenServiceW(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *scmanager_handle,
				    const char *ServiceName,
				    uint32_t access_mask,
				    struct policy_handle *handle,
				    WERROR *werror)
{
	struct svcctl_OpenServiceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager_handle = scmanager_handle;
	r.in.ServiceName = ServiceName;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_OpenServiceW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_OPENSERVICEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_OpenServiceW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_QueryServiceConfigW(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle,
					   uint8_t *query,
					   uint32_t buf_size,
					   uint32_t *bytes_needed,
					   WERROR *werror)
{
	struct svcctl_QueryServiceConfigW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_QueryServiceConfigW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_QUERYSERVICECONFIGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_QueryServiceConfigW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(query, r.out.query, r.in.buf_size);
	*bytes_needed = *r.out.bytes_needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_QueryServiceLockStatusW(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle,
					       uint32_t buf_size,
					       struct SERVICE_LOCK_STATUS *lock_status,
					       uint32_t *required_buf_size,
					       WERROR *werror)
{
	struct svcctl_QueryServiceLockStatusW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_QueryServiceLockStatusW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_QUERYSERVICELOCKSTATUSW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_QueryServiceLockStatusW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*lock_status = *r.out.lock_status;
	*required_buf_size = *r.out.required_buf_size;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_StartServiceW(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle,
				     uint32_t NumArgs,
				     const char *Arguments,
				     WERROR *werror)
{
	struct svcctl_StartServiceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.NumArgs = NumArgs;
	r.in.Arguments = Arguments;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_StartServiceW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_STARTSERVICEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_StartServiceW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_GetServiceDisplayNameW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *handle,
					      const char *service_name,
					      const char **display_name,
					      uint32_t *display_name_length,
					      WERROR *werror)
{
	struct svcctl_GetServiceDisplayNameW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.service_name = service_name;
	r.in.display_name_length = display_name_length;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_GetServiceDisplayNameW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_GETSERVICEDISPLAYNAMEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_GetServiceDisplayNameW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*display_name = *r.out.display_name;
	if (display_name_length && r.out.display_name_length) {
		*display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_GetServiceKeyNameW(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle,
					  const char *service_name,
					  const char **key_name,
					  uint32_t *display_name_length,
					  WERROR *werror)
{
	struct svcctl_GetServiceKeyNameW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.service_name = service_name;
	r.in.display_name_length = display_name_length;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_GetServiceKeyNameW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_GETSERVICEKEYNAMEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_GetServiceKeyNameW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*key_name = *r.out.key_name;
	if (display_name_length && r.out.display_name_length) {
		*display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_SCSetServiceBitsA(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle,
					 uint32_t bits,
					 uint32_t bitson,
					 uint32_t immediate,
					 WERROR *werror)
{
	struct svcctl_SCSetServiceBitsA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.bits = bits;
	r.in.bitson = bitson;
	r.in.immediate = immediate;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_SCSetServiceBitsA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_SCSETSERVICEBITSA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_SCSetServiceBitsA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_ChangeServiceConfigA(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle,
					    uint32_t type,
					    uint32_t start,
					    uint32_t error,
					    const char *binary_path,
					    const char *load_order_group,
					    uint32_t *tag_id,
					    const char *dependencies,
					    const char *service_start_name,
					    const char *password,
					    const char *display_name,
					    WERROR *werror)
{
	struct svcctl_ChangeServiceConfigA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.type = type;
	r.in.start = start;
	r.in.error = error;
	r.in.binary_path = binary_path;
	r.in.load_order_group = load_order_group;
	r.in.dependencies = dependencies;
	r.in.service_start_name = service_start_name;
	r.in.password = password;
	r.in.display_name = display_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_ChangeServiceConfigA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_CHANGESERVICECONFIGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_ChangeServiceConfigA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*tag_id = *r.out.tag_id;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_CreateServiceA(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle,
				      const char *ServiceName,
				      const char *DisplayName,
				      uint32_t desired_access,
				      uint32_t type,
				      uint32_t start_type,
				      uint32_t error_control,
				      const char *binary_path,
				      const char *LoadOrderGroupKey,
				      uint32_t *TagId,
				      const char *dependencies,
				      const char *service_start_name,
				      const char *password,
				      WERROR *werror)
{
	struct svcctl_CreateServiceA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.ServiceName = ServiceName;
	r.in.DisplayName = DisplayName;
	r.in.desired_access = desired_access;
	r.in.type = type;
	r.in.start_type = start_type;
	r.in.error_control = error_control;
	r.in.binary_path = binary_path;
	r.in.LoadOrderGroupKey = LoadOrderGroupKey;
	r.in.dependencies = dependencies;
	r.in.service_start_name = service_start_name;
	r.in.password = password;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_CreateServiceA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_CREATESERVICEA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_CreateServiceA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (TagId && r.out.TagId) {
		*TagId = *r.out.TagId;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_EnumDependentServicesA(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *service,
					      uint32_t state,
					      struct ENUM_SERVICE_STATUS *service_status,
					      uint32_t buf_size,
					      uint32_t *bytes_needed,
					      uint32_t *services_returned,
					      WERROR *werror)
{
	struct svcctl_EnumDependentServicesA r;
	NTSTATUS status;

	/* In parameters */
	r.in.service = service;
	r.in.state = state;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_EnumDependentServicesA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_ENUMDEPENDENTSERVICESA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_EnumDependentServicesA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (service_status && r.out.service_status) {
		*service_status = *r.out.service_status;
	}
	*bytes_needed = *r.out.bytes_needed;
	*services_returned = *r.out.services_returned;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_EnumServicesStatusA(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle,
					   uint32_t type,
					   uint32_t state,
					   uint32_t buf_size,
					   uint8_t *service,
					   uint32_t *bytes_needed,
					   uint32_t *services_returned,
					   uint32_t *resume_handle,
					   WERROR *werror)
{
	struct svcctl_EnumServicesStatusA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.type = type;
	r.in.state = state;
	r.in.buf_size = buf_size;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_EnumServicesStatusA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_ENUMSERVICESSTATUSA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_EnumServicesStatusA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(service, r.out.service, r.in.buf_size);
	*bytes_needed = *r.out.bytes_needed;
	*services_returned = *r.out.services_returned;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_OpenSCManagerA(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *MachineName,
				      const char *DatabaseName,
				      uint32_t access_mask,
				      struct policy_handle *handle,
				      WERROR *werror)
{
	struct svcctl_OpenSCManagerA r;
	NTSTATUS status;

	/* In parameters */
	r.in.MachineName = MachineName;
	r.in.DatabaseName = DatabaseName;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_OpenSCManagerA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_OPENSCMANAGERA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_OpenSCManagerA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_OpenServiceA(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *scmanager_handle,
				    const char *ServiceName,
				    uint32_t access_mask,
				    WERROR *werror)
{
	struct svcctl_OpenServiceA r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager_handle = scmanager_handle;
	r.in.ServiceName = ServiceName;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_OpenServiceA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_OPENSERVICEA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_OpenServiceA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_QueryServiceConfigA(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle,
					   uint8_t *query,
					   uint32_t buf_size,
					   uint32_t *bytes_needed,
					   WERROR *werror)
{
	struct svcctl_QueryServiceConfigA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_QueryServiceConfigA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_QUERYSERVICECONFIGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_QueryServiceConfigA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(query, r.out.query, r.in.buf_size);
	*bytes_needed = *r.out.bytes_needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_QueryServiceLockStatusA(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle,
					       uint32_t buf_size,
					       struct SERVICE_LOCK_STATUS *lock_status,
					       uint32_t *required_buf_size,
					       WERROR *werror)
{
	struct svcctl_QueryServiceLockStatusA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_QueryServiceLockStatusA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_QUERYSERVICELOCKSTATUSA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_QueryServiceLockStatusA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*lock_status = *r.out.lock_status;
	*required_buf_size = *r.out.required_buf_size;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_StartServiceA(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle,
				     uint32_t NumArgs,
				     const char *Arguments,
				     WERROR *werror)
{
	struct svcctl_StartServiceA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.NumArgs = NumArgs;
	r.in.Arguments = Arguments;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_StartServiceA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_STARTSERVICEA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_StartServiceA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_GetServiceDisplayNameA(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *handle,
					      const char *service_name,
					      const char **display_name,
					      uint32_t *display_name_length,
					      WERROR *werror)
{
	struct svcctl_GetServiceDisplayNameA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.service_name = service_name;
	r.in.display_name_length = display_name_length;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_GetServiceDisplayNameA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_GETSERVICEDISPLAYNAMEA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_GetServiceDisplayNameA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*display_name = *r.out.display_name;
	if (display_name_length && r.out.display_name_length) {
		*display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_GetServiceKeyNameA(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle,
					  const char *service_name,
					  const char **key_name,
					  uint32_t *display_name_length,
					  WERROR *werror)
{
	struct svcctl_GetServiceKeyNameA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.service_name = service_name;
	r.in.display_name_length = display_name_length;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_GetServiceKeyNameA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_GETSERVICEKEYNAMEA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_GetServiceKeyNameA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*key_name = *r.out.key_name;
	if (display_name_length && r.out.display_name_length) {
		*display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_GetCurrentGroupeStateW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror)
{
	struct svcctl_GetCurrentGroupeStateW r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_GetCurrentGroupeStateW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_GETCURRENTGROUPESTATEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_GetCurrentGroupeStateW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_EnumServiceGroupW(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct svcctl_EnumServiceGroupW r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_EnumServiceGroupW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_ENUMSERVICEGROUPW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_EnumServiceGroupW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_ChangeServiceConfig2A(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *handle,
					     uint32_t info_level,
					     uint8_t *info,
					     WERROR *werror)
{
	struct svcctl_ChangeServiceConfig2A r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.info_level = info_level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_ChangeServiceConfig2A, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_CHANGESERVICECONFIG2A,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_ChangeServiceConfig2A, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_ChangeServiceConfig2W(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *handle,
					     uint32_t info_level,
					     uint8_t *info,
					     WERROR *werror)
{
	struct svcctl_ChangeServiceConfig2W r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.info_level = info_level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_ChangeServiceConfig2W, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_CHANGESERVICECONFIG2W,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_ChangeServiceConfig2W, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_QueryServiceConfig2A(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle,
					    uint32_t info_level,
					    uint8_t *buffer,
					    uint32_t buf_size,
					    uint32_t *bytes_needed,
					    WERROR *werror)
{
	struct svcctl_QueryServiceConfig2A r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.info_level = info_level;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_QueryServiceConfig2A, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_QUERYSERVICECONFIG2A,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_QueryServiceConfig2A, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(buffer, r.out.buffer, r.in.buf_size);
	*bytes_needed = *r.out.bytes_needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_QueryServiceConfig2W(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle,
					    uint32_t info_level,
					    uint8_t *buffer,
					    uint32_t buf_size,
					    uint32_t *bytes_needed,
					    WERROR *werror)
{
	struct svcctl_QueryServiceConfig2W r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.info_level = info_level;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_QueryServiceConfig2W, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_QUERYSERVICECONFIG2W,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_QueryServiceConfig2W, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(buffer, r.out.buffer, r.in.buf_size);
	*bytes_needed = *r.out.bytes_needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_QueryServiceStatusEx(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle,
					    uint32_t info_level,
					    uint8_t *buffer,
					    uint32_t buf_size,
					    uint32_t *bytes_needed,
					    WERROR *werror)
{
	struct svcctl_QueryServiceStatusEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.info_level = info_level;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_QueryServiceStatusEx, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_QUERYSERVICESTATUSEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_QueryServiceStatusEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(buffer, r.out.buffer, r.in.buf_size);
	*bytes_needed = *r.out.bytes_needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EnumServicesStatusExA(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *scmanager,
				      uint32_t info_level,
				      uint32_t type,
				      uint32_t state,
				      uint8_t *services,
				      uint32_t buf_size,
				      uint32_t *bytes_needed,
				      uint32_t *service_returned,
				      uint32_t *resume_handle,
				      const char **group_name,
				      WERROR *werror)
{
	struct EnumServicesStatusExA r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager = scmanager;
	r.in.info_level = info_level;
	r.in.type = type;
	r.in.state = state;
	r.in.buf_size = buf_size;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EnumServicesStatusExA, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_ENUMSERVICESSTATUSEXA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EnumServicesStatusExA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(services, r.out.services, r.in.buf_size);
	*bytes_needed = *r.out.bytes_needed;
	*service_returned = *r.out.service_returned;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}
	*group_name = *r.out.group_name;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EnumServicesStatusExW(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *scmanager,
				      uint32_t info_level,
				      uint32_t type,
				      uint32_t state,
				      uint8_t *services,
				      uint32_t buf_size,
				      uint32_t *bytes_needed,
				      uint32_t *service_returned,
				      uint32_t *resume_handle,
				      const char **group_name,
				      WERROR *werror)
{
	struct EnumServicesStatusExW r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager = scmanager;
	r.in.info_level = info_level;
	r.in.type = type;
	r.in.state = state;
	r.in.buf_size = buf_size;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EnumServicesStatusExW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_ENUMSERVICESSTATUSEXW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EnumServicesStatusExW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(services, r.out.services, r.in.buf_size);
	*bytes_needed = *r.out.bytes_needed;
	*service_returned = *r.out.service_returned;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}
	*group_name = *r.out.group_name;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_svcctl_SCSendTSMessage(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       WERROR *werror)
{
	struct svcctl_SCSendTSMessage r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(svcctl_SCSendTSMessage, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SVCCTL,
				&ndr_table_svcctl,
				NDR_SVCCTL_SCSENDTSMESSAGE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(svcctl_SCSendTSMessage, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

