/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qlabel.h>
#include <ktextedit.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kcombobox.h> 
#include <kiconloader.h>
#include <kpushbutton.h> 
#include <klistbox.h>
#include <kdeversion.h>
#include <kled.h> 

#include "d_newsms.h"
#include "c_sms.h"
#include "d_smslist.h"
#include "d_pickphonebook.h"
// #include "alphabets.h"
extern bool is7BitChar( int c );

#include "gsm.h"
extern GSM* d_gsm;

#define curChar_i mainWidget->t_sms->text().at( i-1 )
#define curChar mainWidget->t_sms->text().at( mainWidget->t_sms->text().length() -1 )

#include <iostream>
using namespace std;

d_NewSMS::d_NewSMS(QWidget *parent, const char *name)
 : KDialogBase( parent, name, true, i18n("New SMS"), KDialogBase::User1 | KDialogBase::User2 | KDialogBase::Cancel )
{
	if( d_gsm->isPDU() ) maxlen=160; else maxlen=160;
	mainWidget= new ui_NewSMS(this);
	setMainWidget ( mainWidget );
	infoLabel= mainWidget->l_info->text();
	#if KDE_IS_VERSION(3,3,0)
	setButtonGuiItem( KDialogBase::User1, KGuiItem( i18n("Send SMS"), "mail_replyall") );
	setButtonGuiItem( KDialogBase::User2, KGuiItem( i18n("Store SMS"), "mail_get") );
	#else
	setButtonText( KDialogBase::User1, i18n("Send SMS") );
	setButtonText( KDialogBase::User2, i18n("Store SMS") );
	#endif
	mainWidget->b_pick->setIconSet( 
			QIconSet( KGlobal::iconLoader()->loadIcon( "korganizer" , KIcon::FirstGroup, KIcon::SizeSmall ) ) );
	mainWidget->b_add->setIconSet( 
			QIconSet( KGlobal::iconLoader()->loadIcon( "2rightarrow" , KIcon::FirstGroup, KIcon::SizeSmall ) ) );
	mainWidget->b_rem->setIconSet( 
			QIconSet( KGlobal::iconLoader()->loadIcon( "2leftarrow" , KIcon::FirstGroup, KIcon::SizeSmall ) ) );
	
	if ( QString ( name ).contains("L-") > 0) parentList= ( d_SMSList* ) parent; else parentList=NULL;
	connect( mainWidget->t_sms, SIGNAL(textChanged() ), this, SLOT(textChanged() ) );
	connect( mainWidget->b_add, SIGNAL(clicked() ), this, SLOT(addToList() ) );
	connect( mainWidget->b_rem, SIGNAL(clicked() ), this, SLOT(remFromList() ) );
	connect( mainWidget->b_pick, SIGNAL(clicked() ), this, SLOT( pickNumber() ) );
	resize( 540, 235 );
	textChanged();
	enableButton( KDialogBase::User1, false );
	enableButton( KDialogBase::User2, false );
	bits=7;
}


d_NewSMS::~d_NewSMS()
{
}


#include "d_newsms.moc"


void d_NewSMS::textChanged()
{
	if (mainWidget->t_sms->length() > maxlen) /// @todo implement SMS > maxlen chars
	{
		mainWidget->t_sms->setText( mainWidget->t_sms->text().left(maxlen) );
		mainWidget->t_sms->setCursorPosition(0,maxlen);
		KMessageBox::sorry(this, i18n("Currently only single %1 characters SMS are supported").arg(maxlen), i18n("Sorry") );
	}
I18N_NOOP("_n: Message length: %n character (%1 SMS)\nMessage length: %n characters (%1 SMS)");
	mainWidget->l_info->setText( 
		i18n("Message length: %n character (%1 SMS)","Message length: %n characters (%1 SMS)",mainWidget->t_sms->length())
		.arg( (( mainWidget->t_sms->length()-1) / maxlen) + 1 ) );
	if ( !mainWidget->t_sms->text().length() ) return;
	if( d_gsm->isPDU() && bits==7 )
	{
		if( !is7BitChar( curChar.unicode() ) )
		{
			bits=16;
			mainWidget->warn_size->setState(KLed::On);
			mainWidget->warn_length->setText( i18n("You are using non-standard charset. Maximum SMS size will be reduced.") );
			maxlen=70;
		}
	}
	if( d_gsm->isPDU() && bits>7 )
	{
		bool found=false;
		for( unsigned int i=mainWidget->t_sms->text().length(); i>0; i--)
		{
			if ( ! (is7BitChar( mainWidget->t_sms->text().at( i-1 ).unicode() ) ) )
			{
				found=true;
				break;
			}
		}
		if (!found) {
			bits=7;
			maxlen=160;
			mainWidget->warn_size->setState(KLed::Off);
			mainWidget->warn_length->setText( "" );
		}
	}
}

/** Directly Send sms */
void d_NewSMS::slotUser1()
{
    KMessageBox::information( this,
      i18n( "<qt>Directly sending SMS maybe not supported from your phone. If you receive an error message, try sending your SMS by clicking \"Store SMS\" and then saying \"Yes\" to send stored SMS.</qt>" ),
      i18n( "Send SMS" ), "directlySendSMS");

	if ( d_gsm->sendSMS( parseSMS() ) )
		KMessageBox::information ( this, i18n("Message sent correctly."), i18n("Message sent") );
	else
		KMessageBox::error( this, i18n("An error occurred while sending this SMS."), i18n("Error") );
}

/** Store SMS, and later can send it */
void d_NewSMS::slotUser2()
{
	QString numSMS= d_gsm->storeSMS( parseSMS() );
	if (numSMS=="ERROR" )
	{
		KMessageBox::error( this, i18n("An error occurred while storing this SMS."), i18n("Error") ); return;
	}
	if ( numSMS == "NF" )
	{
		KMessageBox::error( this,i18n
		("Message seems to be stored, but it could not be found on the SMS list. Check it manually."), i18n("Error") ); return;
	}
	if ( KMessageBox::questionYesNo ( 
	this, i18n("Message stored correctly.\nDo you want to send it?"), i18n("Message stored") ) == KMessageBox::No ) return;
	if( d_gsm->sendSMS( numSMS ) ) {
		KMessageBox::information ( this, i18n("Message sent correctly."), i18n("Message sent") ); return; }
	KMessageBox::error( this, i18n("An error occurred while sending this SMS."), i18n("Error") );
}

c_SMS* d_NewSMS::parseSMS()
{
	if ( mainWidget->lb_dest->count() ==0 ) return NULL;
	QStringList sl_numbers;
	for( unsigned int i=0; i< mainWidget->lb_dest->count() ; i++ ){ sl_numbers+= mainWidget->lb_dest->text(i); }
	c_SMS* sms= new c_SMS ( sl_numbers , QStringList( mainWidget->t_sms->text() ) );
	return sms;
}

void d_NewSMS::addToList()
{
	if ( mainWidget->cb_dest->currentText().length() <=0 ) return;
	mainWidget->lb_dest->insertItem ( mainWidget->cb_dest->currentText() );
	mainWidget->cb_dest->setCurrentText("");
	enableButton( KDialogBase::User1, true );
	enableButton( KDialogBase::User2, true );
}

void d_NewSMS::pickNumber()
{
// 	if( ! d_gsm->getAbInited() ) d_gsm->initPhoneBook("MT");
	d_PickPhoneBook* pick=new d_PickPhoneBook( this, "phonebook-sms" );
	pick->show();
}


/*!
    \fn d_NewSMS::remFromList()
 */
void d_NewSMS::remFromList()
{
	if ( mainWidget->lb_dest->selectedItem() == 0) return;
	mainWidget->lb_dest->removeItem ( mainWidget->lb_dest->index ( mainWidget->lb_dest->selectedItem() ) );
	if(mainWidget->lb_dest->count() >0 ) return;
	enableButton( KDialogBase::User1, false );
	enableButton( KDialogBase::User2, false );
}
