import org.kde.qt.*;
import org.kde.koala.*;

/**
 *  Class to test KProgress widget.
 *
 *  This is a translation to java from kprogresstest.cpp in the tests library
 *  of kdeui source.
 *
 * @see KProgress
 * @see KApplication
 *
 * @author orignal unknown, java translation Kenneth J. Pouncey, kjpou@hotmail.com
 * @version 0.1
 */

public class KProgressTest {

   static String description = "Java KProgress test program";
   static String[][] options = {   };
   static String VERSION = "0.1";

   public static void main(String[] cmdLineArgs) {

      KAboutData aboutData = new KAboutData( "kprogresstest", "KProgressTest",
         VERSION, description, KAboutData.License_GPL,
         "(c) 2002, Kenneth J. Pouncey");
      aboutData.addAuthor("Kenneth J. Pouncey",null, "kjpou@hotmail.com");
      KCmdLineArgs.init( cmdLineArgs, aboutData );
      KCmdLineArgs.addCmdLineOptions( options ); // Add our own options.

      KApplication app = new KApplication();

      // parse the args
      KCmdLineArgs args = KCmdLineArgs.parsedArgs();

      MyWidget mine = new MyWidget();

      mine.setCaption(description);

      app.setMainWidget(mine);
      mine.show();

      app.exec();

      return;
   }

   private static class MyWidget extends QWidget {

      private KProgress Progress;
      static int fwd = 0;
      static int back = 1;
      static int direction = fwd;

      public MyWidget () {
         super();
         setFixedSize(440, 80);
         Progress = new KProgress(this);
         Progress.resize(400, 40);
         Progress.move(20, 20);
         startTimer(50);
      }

      public void timerEvent(QTimerEvent timer) {

         if (direction == fwd)  {
            if (Progress.progress() == Progress.totalSteps())
                direction = back;
            else
                Progress.advance(1);
         }
         else {
            if (Progress.progress() == 0)  { /*Progress.minValue()*/
               direction = fwd;
            }
            else
               Progress.advance(-1);
        }
      }
   }

   static {
      qtjava.initialize();
      kdejava.initialize();
   }

}
